(*
 * Command lines.
 *
 * ----------------------------------------------------------------
 *
 * @begin[license]
 * Copyright (C) 2003 Mojave Group, Caltech
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Jason Hickey
 * @email{jyh@cs.caltech.edu}
 * @end[license]
 *)
open Lm_location

open Omake_node

(*
 * Command digest.
 *)
type command_digest = Digest.t option

(*
 * A command line is a string, together with come flags.
 *)
type command_flag =
   QuietFlag
 | AllowFailureFlag
 | AllowOutputFlag

(*
 * The command line has some flags,
 * and a string to be executed internally
 * or passed to the shell.
 *)
type ('exp, 'value) poly_command_inst =
   CommandEval of 'exp
 | CommandArgv of string list
 | CommandValues of 'value list

type ('venv, 'exp, 'value) poly_command_line =
   { command_loc    : loc;
     command_dir    : Dir.t;
     command_target : Node.t;
     command_flags  : command_flag list;
     command_venv   : 'venv;
     command_inst   : ('exp, 'value) poly_command_inst
   }

(*!
 * @docoff
 *
 * -*-
 * Local Variables:
 * Caml-master: "compile"
 * End:
 * -*-
 *)
