/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __OGMRIP_GCONF_H__
#define __OGMRIP_GCONF_H__

#include <gconf/gconf-client.h>

G_BEGIN_DECLS

#define OGMRIP_GCONF_ROOT            "/apps/ogmrip"

#define OGMRIP_GCONF_OUTPUT_DIR      OGMRIP_GCONF_ROOT "/output_dir"
#define OGMRIP_GCONF_TMP_DIR         OGMRIP_GCONF_ROOT "/tmp_dir"
#define OGMRIP_GCONF_FILENAME        OGMRIP_GCONF_ROOT "/filename"
#define OGMRIP_GCONF_TNUMBER         OGMRIP_GCONF_ROOT "/target_number"
#define OGMRIP_GCONF_TSIZE           OGMRIP_GCONF_ROOT "/target_size"
#define OGMRIP_GCONF_CONTAINER       OGMRIP_GCONF_ROOT "/container_format"
#define OGMRIP_GCONF_COPY_DVD        OGMRIP_GCONF_ROOT "/copy_dvd"
#define OGMRIP_GCONF_FOURCC          OGMRIP_GCONF_ROOT "/fourcc"
#define OGMRIP_GCONF_ENSURE_SYNC     OGMRIP_GCONF_ROOT "/ensure_sync"

#define OGMRIP_GCONF_VIDEO_FORMAT    OGMRIP_GCONF_ROOT "/video_format"
#define OGMRIP_GCONF_VIDEO_QUALITY   OGMRIP_GCONF_ROOT "/video_quality"
#define OGMRIP_GCONF_VIDEO_PASSES    OGMRIP_GCONF_ROOT "/passes"
#define OGMRIP_GCONF_VIDEO_SCALER    OGMRIP_GCONF_ROOT "/scaler"
#define OGMRIP_GCONF_VIDEO_TRELLIS   OGMRIP_GCONF_ROOT "/trellis"
#define OGMRIP_GCONF_VIDEO_TURBO     OGMRIP_GCONF_ROOT "/turbo"
#define OGMRIP_GCONF_VIDEO_QPEL      OGMRIP_GCONF_ROOT "/qpel"
#define OGMRIP_GCONF_VIDEO_DENOISE   OGMRIP_GCONF_ROOT "/denoise"

#define OGMRIP_GCONF_PREF_AUDIO      OGMRIP_GCONF_ROOT "/pref_audio"
#define OGMRIP_GCONF_AUDIO_FORMAT    OGMRIP_GCONF_ROOT "/audio_format"
#define OGMRIP_GCONF_AUDIO_QUALITY   OGMRIP_GCONF_ROOT "/audio_quality"
#define OGMRIP_GCONF_AUDIO_NORMALIZE OGMRIP_GCONF_ROOT "/normalize"

#define OGMRIP_GCONF_PREF_SUBP       OGMRIP_GCONF_ROOT "/pref_subp"
#define OGMRIP_GCONF_SUBP_FORMAT     OGMRIP_GCONF_ROOT "/subp_format"
#define OGMRIP_GCONF_SPELL_CHECK     OGMRIP_GCONF_ROOT "/spell_check"

#define OGMRIP_GCONF_KEEP_TEMP       OGMRIP_GCONF_ROOT "/keep_temp"
#define OGMRIP_GCONF_NOAUDIO         OGMRIP_GCONF_ROOT "/noaudio"

#define OGMRIP_DEFAULT_OUTPUT_DIR      g_get_home_dir ()
#define OGMRIP_DEFAULT_TMP_DIR         ogmrip_fs_get_tmp_dir ()
#define OGMRIP_DEFAULT_FILENAME        0
#define OGMRIP_DEFAULT_TNUMBER         1
#define OGMRIP_DEFAULT_TSIZE           700
#define OGMRIP_DEFAULT_CONTAINER       0
#define OGMRIP_DEFAULT_COPY_DVD        FALSE
#define OGMRIP_DEFAULT_FOURCC          0

#define OGMRIP_DEFAULT_VIDEO_FORMAT    0
#define OGMRIP_DEFAULT_VIDEO_QUALITY   0
#define OGMRIP_DEFAULT_VIDEO_PASSES    1
#define OGMRIP_DEFAULT_VIDEO_SCALER    7
#define OGMRIP_DEFAULT_VIDEO_TRELLIS   TRUE
#define OGMRIP_DEFAULT_VIDEO_TURBO     TRUE
#define OGMRIP_DEFAULT_VIDEO_QPEL      FALSE
#define OGMRIP_DEFAULT_VIDEO_DENOISE   TRUE

#define OGMRIP_DEFAULT_PREF_AUDIO      0
#define OGMRIP_DEFAULT_AUDIO_FORMAT    0
#define OGMRIP_DEFAULT_AUDIO_QUALITY   3
#define OGMRIP_DEFAULT_AUDIO_NORMALIZE TRUE

#define OGMRIP_DEFAULT_SPELL_CHECK     FALSE
#define OGMRIP_DEFAULT_SUBP_FORMAT     0
#define OGMRIP_DEFAULT_PREF_SUBP       0

#define OGMRIP_DEFAULT_NOAUDIO         FALSE
#define OGMRIP_DEFAULT_KEEP_TEMP       FALSE
#define OGMRIP_DEFAULT_ENSURE_SYNC     TRUE

G_END_DECLS

#endif /* __OGMRIP_GCONF_H__ */

