/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "ogmrip-dvdcpy.h"
#include "ogmrip-backend.h"

#include "ogmjob-enums.h"
#include "ogmjob-exec.h"

#include <string.h>
#include <unistd.h>

#include <glib/gstdio.h>

static gint ogmrip_dvdcpy_run (OGMJobSpawn *spawn);

G_DEFINE_TYPE (OGMRipDvdCpy, ogmrip_dvdcpy, OGMRIP_TYPE_CODEC)

static void
ogmrip_dvdcpy_class_init (OGMRipDvdCpyClass *klass)
{
  OGMJobSpawnClass *spawn_class;

  spawn_class = OGMJOB_SPAWN_CLASS (klass);

  spawn_class->run = ogmrip_dvdcpy_run;
}

static void
ogmrip_dvdcpy_init (OGMRipDvdCpy *dvdcpy)
{
}

static gint
ogmrip_dvdcpy_run (OGMJobSpawn *spawn)
{
  OGMJobSpawn *child;
  gchar **argv;
  gint result;

  argv = ogmrip_backend_dvdcpy_command (OGMRIP_DVDCPY (spawn), NULL, NULL);
  if (!argv)
    return OGMJOB_RESULT_ERROR;

  child = ogmjob_exec_newv (argv);
  ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_backend_dvdcpy_watch, spawn, TRUE, FALSE, FALSE);
  ogmjob_container_add (OGMJOB_CONTAINER (spawn), child);
  g_object_unref (child);

  result = OGMJOB_SPAWN_CLASS (ogmrip_dvdcpy_parent_class)->run (spawn);

  ogmjob_container_remove (OGMJOB_CONTAINER (spawn), child);

  return result;
}

OGMJobSpawn *
ogmrip_dvdcpy_new (OGMDvdTitle *title, const gchar *output)
{
  OGMJobSpawn *spawn;

  spawn = g_object_new (OGMRIP_TYPE_DVDCPY, NULL);
  ogmrip_codec_set_output (OGMRIP_CODEC (spawn), output);
  ogmrip_codec_set_input (OGMRIP_CODEC (spawn), title);

  return spawn;
}

