/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"

#include "ogmrip-backend.h"
#include "ogmrip-avi.h"

#include "ogmjob-exec.h"
#include "ogmjob-enums.h"
#include "ogmjob-queue.h"

#include <unistd.h>

#include <glib/gstdio.h>

static gint ogmrip_avi_run (OGMJobSpawn *spawn);

G_DEFINE_TYPE (OGMRipAvi, ogmrip_avi, OGMRIP_TYPE_CONTAINER)

static void
ogmrip_avi_class_init (OGMRipAviClass *klass)
{
  OGMJobSpawnClass *spawn_class;
  OGMRipContainerClass *container_class;

  spawn_class = OGMJOB_SPAWN_CLASS (klass);
  container_class = OGMRIP_CONTAINER_CLASS (klass);

  spawn_class->run = ogmrip_avi_run;
}

static void
ogmrip_avi_init (OGMRipAvi *avi)
{
}

static void
ogmrip_avi_foreach_subp (OGMRipContainer *avi, 
    OGMRipCodec *codec, guint demuxer, gint language, OGMJobContainer *queue)
{
  OGMJobSpawn *child;

  const gchar *filename;
  gchar *input, **argv = NULL;

  filename = ogmrip_codec_get_output (codec);

  if (demuxer == OGMRIP_SUBP_DEMUXER_VOBSUB)
    input = g_strconcat (filename, ".sub", NULL);
  else
    input = g_strdup (filename);

  argv = ogmrip_backend_copy_command (avi, input, NULL);
  if (argv)
  {
    child = ogmjob_exec_newv (argv);
    ogmjob_container_add (OGMJOB_CONTAINER (queue), child);
    g_object_unref (child);
  }
  g_free (input);

  if (demuxer == OGMRIP_SUBP_DEMUXER_VOBSUB)
  {
    input = g_strconcat (filename, ".idx", NULL);

    argv = ogmrip_backend_copy_command (avi, input, NULL);
    if (argv)
    {
      child = ogmjob_exec_newv (argv);
      ogmjob_container_add (OGMJOB_CONTAINER (queue), child);
      g_object_unref (child);
    }
    g_free (input);
  }
}

static gint
ogmrip_avi_run (OGMJobSpawn *spawn)
{
  OGMJobSpawn *queue, *child;
  gchar **argv;
  gint result;

  result = OGMJOB_RESULT_ERROR;

  queue = ogmjob_queue_new ();
  ogmjob_container_add (OGMJOB_CONTAINER (spawn), queue);
  g_object_unref (queue);

  argv = ogmrip_backend_avi_command (OGMRIP_CONTAINER (spawn));
  if (argv)
  {
    child = ogmjob_exec_newv (argv);
    ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_backend_avi_watch, spawn, TRUE, FALSE, FALSE);
    ogmjob_container_add (OGMJOB_CONTAINER (queue), child);
    g_object_unref (child);

    ogmrip_container_foreach_subp (OGMRIP_CONTAINER (spawn), 
        (OGMRipContainerFunc) ogmrip_avi_foreach_subp, queue);

    result = OGMJOB_SPAWN_CLASS (ogmrip_avi_parent_class)->run (spawn);
  }

  ogmjob_container_remove (OGMJOB_CONTAINER (spawn), queue);

  return result;
}

OGMJobSpawn *
ogmrip_avi_new (const gchar *output)
{
  OGMRipAvi *avi;

  g_return_val_if_fail (output && *output, NULL);

  avi = g_object_new (OGMRIP_TYPE_AVI, "overhead", 24, NULL);
  ogmrip_container_set_output (OGMRIP_CONTAINER (avi), output);

  return OGMJOB_SPAWN (avi);
}

