/* OGMDvd - A wrapper library around libdvdread
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMDVD_H__
#define __OGMDVD_H__

#include <glib.h>

G_BEGIN_DECLS

typedef enum
{
  OGMDVD_VIDEO_FORMAT_NTSC = 0,
  OGMDVD_VIDEO_FORMAT_PAL  = 1
} OGMDvdVideoFormat;

typedef enum
{
  OGMDVD_DISPLAY_ASPECT_4_3  = 0,
  OGMDVD_DISPLAY_ASPECT_16_9 = 1,
} OGMDvdDisplayAspect;

typedef enum
{
  OGMDVD_DISPLAY_FORMAT_PS_LETTER = 0,
  OGMDVD_DISPLAY_FORMAT_PAN_SCAN  = 1,
  OGMDVD_DISPLAY_FORMAT_LETTERBOX = 2,
} OGMDvdDisplayFormat;

typedef enum
{
  OGMDVD_AUDIO_FORMAT_AC3      = 0,
  OGMDVD_AUDIO_FORMAT_MPEG1    = 2,
  OGMDVD_AUDIO_FORMAT_MPEG2EXT = 3,
  OGMDVD_AUDIO_FORMAT_LPCM     = 4,
  OGMDVD_AUDIO_FORMAT_SDDS     = 5,
  OGMDVD_AUDIO_FORMAT_DTS      = 6
} OGMDvdAudioFormat;

typedef enum
{
  OGMDVD_AUDIO_CHANNELS_MONO      = 0,
  OGMDVD_AUDIO_CHANNELS_STEREO    = 1,
  OGMDVD_AUDIO_CHANNELS_SURROUND  = 3,
  OGMDVD_AUDIO_CHANNELS_5_1       = 5
} OGMDvdAudioChannels;

typedef enum
{
  OGMDVD_AUDIO_QUANTIZATION_16  = 0,
  OGMDVD_AUDIO_QUANTIZATION_20  = 1,
  OGMDVD_AUDIO_QUANTIZATION_24  = 2,
  OGMDVD_AUDIO_QUANTIZATION_DRC = 3
} OGMDvdAudioQuantization;

typedef enum
{
  OGMDVD_AUDIO_CONTENT_UNDEFINED = 0,
  OGMDVD_AUDIO_CONTENT_NORMAL    = 1,
  OGMDVD_AUDIO_CONTENT_IMPAIRED  = 2,
  OGMDVD_AUDIO_CONTENT_COMMENTS1 = 3,
  OGMDVD_AUDIO_CONTENT_COMMENTS2 = 4
} OGMDvdAudioContent;

typedef enum
{
  OGMDVD_SUBP_CONTENT_UNDEFINED,
  OGMDVD_SUBP_CONTENT_NORMAL,
  OGMDVD_SUBP_CONTENT_LARGE,
  OGMDVD_SUBP_CONTENT_CHILDREN,
  OGMDVD_SUBP_CONTENT_RESERVED1,
  OGMDVD_SUBP_CONTENT_NORMAL_CC,
  OGMDVD_SUBP_CONTENT_LARGE_CC,
  OGMDVD_SUBP_CONTENT_CHILDREN_CC,
  OGMDVD_SUBP_CONTENT_RESERVED2,
  OGMDVD_SUBP_CONTENT_FORCED,
  OGMDVD_SUBP_CONTENT_RESERVED3,
  OGMDVD_SUBP_CONTENT_RESERVED4,
  OGMDVD_SUBP_CONTENT_RESERVED5,
  OGMDVD_SUBP_CONTENT_DIRECTOR,
  OGMDVD_SUBP_CONTENT_LARGE_DIRECTOR,
  OGMDVD_SUBP_CONTENT_CHILDREN_DIRECTOR
} OGMDvdSubpContent;

enum
{
  OGMDVD_LANGUAGE_ISO639_1,
  OGMDVD_LANGUAGE_ISO639_2,
  OGMDVD_LANGUAGE_NAME
};

typedef struct
{
  guint hour;
  guint min;
  guint sec;
  guint frames;
} OGMDvdTime;

typedef enum
{
  OGMDVD_ERROR_NONE,
  OGMDVD_ERROR_UNKNOWN
} OGMDvdError;

typedef struct _OGMDvdDisc        OGMDvdDisc;
typedef struct _OGMDvdTitle       OGMDvdTitle;
typedef struct _OGMDvdAudioStream OGMDvdAudioStream;
typedef struct _OGMDvdSubpStream  OGMDvdSubpStream;

#define OGMDVD_ERROR ogmdvd_error_quark ()

GQuark    ogmdvd_error_quark  (void);

/*
 * DVD
 */

OGMDvdDisc *  ogmdvd_disc_open          (const gchar *dev,
                                         GError      **error);
void          ogmdvd_disc_ref           (OGMDvdDisc  *disc);
void          ogmdvd_disc_unref         (OGMDvdDisc  *disc);
gchar *       ogmdvd_disc_get_label     (OGMDvdDisc  *disc);
G_CONST_RETURN
gchar *       ogmdvd_disc_get_device    (OGMDvdDisc  *disc);
gint64        ogmdvd_disc_get_vmg_size  (OGMDvdDisc  *disc);
gint          ogmdvd_disc_get_n_titles  (OGMDvdDisc  *disc);
OGMDvdTitle * ogmdvd_disc_get_nth_title (OGMDvdDisc  *disc,
                                         guint       nr);
/*
GList *       ogmdvd_disc_get_titles    (OGMDvdDisc  *disc);
*/
/*
 * Video Streams
 */


void                ogmdvd_title_ref                  (OGMDvdTitle *title);
void                ogmdvd_title_unref                (OGMDvdTitle *title);
OGMDvdDisc *        ogmdvd_title_get_disc             (OGMDvdTitle *title);
gint64              ogmdvd_title_get_vts_size         (OGMDvdTitle *title);
gint                ogmdvd_title_get_nr               (OGMDvdTitle *title);
glong               ogmdvd_title_get_length           (OGMDvdTitle *title,
                                                       OGMDvdTime  *length);
glong               ogmdvd_title_get_chapters_length  (OGMDvdTitle *title, 
                                                       guint       start,
                                                       gint        end,
                                                       OGMDvdTime  *length);
void                ogmdvd_title_get_framerate        (OGMDvdTitle *title,
                                                       guint       *numerator,
                                                       guint       *denominator);
void                ogmdvd_title_get_size             (OGMDvdTitle *title,
                                                       guint       *width,
                                                       guint       *height);
gint                ogmdvd_title_get_video_format     (OGMDvdTitle *title);
gint                ogmdvd_title_get_display_aspect   (OGMDvdTitle *title);
gint                ogmdvd_title_get_display_format   (OGMDvdTitle *title);
G_CONST_RETURN
guint *             ogmdvd_title_get_palette          (OGMDvdTitle *title);
gint                ogmdvd_title_get_n_angles         (OGMDvdTitle *title);
gint                ogmdvd_title_get_n_chapters       (OGMDvdTitle *title);
gint                ogmdvd_title_get_n_audio_streams  (OGMDvdTitle *title);
OGMDvdAudioStream * ogmdvd_title_get_nth_audio_stream (OGMDvdTitle *title,
                                                       guint       nr);
/*
GList *             ogmdvd_title_get_audio_streams    (OGMDvdTitle *title);
*/
gint                ogmdvd_title_get_n_subp_streams   (OGMDvdTitle *title);
OGMDvdSubpStream *  ogmdvd_title_get_nth_subp_stream  (OGMDvdTitle *title,
                                                       guint       nr);
/*
GList *             ogmdvd_title_get_subp_streams     (OGMDvdTitle *title);
*/
void                ogmdvd_title_get_aspect_ratio     (OGMDvdTitle *video,
                                                       guint       *numerator,
                                                       guint       *denominator);

/*
 * Audio Streams
 */

void          ogmdvd_audio_stream_ref              (OGMDvdAudioStream *stream);
void          ogmdvd_audio_stream_unref            (OGMDvdAudioStream *stream);
OGMDvdTitle * ogmdvd_audio_stream_get_title        (OGMDvdAudioStream *stream);
gint          ogmdvd_audio_stream_get_nr           (OGMDvdAudioStream *stream);
/*
gint          ogmdvd_audio_stream_get_id           (OGMDvdAudioStream *stream);
*/
gint          ogmdvd_audio_stream_get_format       (OGMDvdAudioStream *stream);
gint          ogmdvd_audio_stream_get_channels     (OGMDvdAudioStream *stream);
gint          ogmdvd_audio_stream_get_language     (OGMDvdAudioStream *stream);
gint          ogmdvd_audio_stream_get_quantization (OGMDvdAudioStream *stream);
gint          ogmdvd_audio_stream_get_content      (OGMDvdAudioStream *stream);

/*
 * Subp Streams
 */

void          ogmdvd_subp_stream_ref          (OGMDvdSubpStream *stream);
void          ogmdvd_subp_stream_unref        (OGMDvdSubpStream *stream);
OGMDvdTitle * ogmdvd_subp_stream_get_title    (OGMDvdSubpStream *stream);
gint          ogmdvd_subp_stream_get_nr       (OGMDvdSubpStream *stream);
/*
gint          ogmdvd_subp_stream_get_id       (OGMDvdSubpStream *stream);
*/
gint          ogmdvd_subp_stream_get_language (OGMDvdSubpStream *stream);
gint          ogmdvd_subp_stream_get_content  (OGMDvdSubpStream *stream);

/*
 * Labels
 */

G_CONST_RETURN gchar * ogmdvd_get_video_format_label       (gint format);
G_CONST_RETURN gchar * ogmdvd_get_display_aspect_label     (gint aspect);
G_CONST_RETURN gchar * ogmdvd_get_audio_format_label       (gint format);
G_CONST_RETURN gchar * ogmdvd_get_audio_channels_label     (gint channels);
G_CONST_RETURN gchar * ogmdvd_get_audio_quantization_label (gint quantization);
G_CONST_RETURN gchar * ogmdvd_get_audio_content_label      (gint content);
G_CONST_RETURN gchar * ogmdvd_get_subp_content_label       (gint content);
G_CONST_RETURN gchar * ogmdvd_get_language_label           (gint lang);
G_CONST_RETURN gchar * ogmdvd_get_language_iso639_1        (gint lang);
G_CONST_RETURN gchar * ogmdvd_get_language_iso639_2        (gint lang);

/*
 * Dvd drive
 */
/*
gboolean ogmdvd_drive_has_valid_media (const gchar *device);
gboolean ogmdvd_drive_tray_is_open    (const gchar *device);
gboolean ogmdvd_drive_tray_open       (const gchar *device);
*/
G_END_DECLS

#endif /* __OGMDVD_H__ */

