/* OGMDvd - A wrapper library around libdvdread
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMDVD_SUBTITLE_CHOOSER_H__
#define __OGMDVD_SUBTITLE_CHOOSER_H__

#include <ogmdvd.h>

#include <gtk/gtkcombobox.h>

G_BEGIN_DECLS

#define OGMDVD_TYPE_SUBTITLE_CHOOSER            (ogmdvd_subtitle_chooser_get_type ())
#define OGMDVD_SUBTITLE_CHOOSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMDVD_TYPE_SUBTITLE_CHOOSER, OGMDvdSubtitleChooser))
#define OGMDVD_SUBTITLE_CHOOSER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), OGMDVD_TYPE_SUBTITLE_CHOOSER, OGMDvdSubtitleChooserClass))
#define OGMDVD_IS_SUBTITLE_CHOOSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, OGMDVD_TYPE_SUBTITLE_CHOOSER))
#define OGMDVD_IS_SUBTITLE_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMDVD_TYPE_SUBTITLE_CHOOSER))

typedef struct _OGMDvdSubtitleChooser      OGMDvdSubtitleChooser;
typedef struct _OGMDvdSubtitleChooserClass OGMDvdSubtitleChooserClass;
typedef struct _OGMDvdSubtitleChooserPriv  OGMDvdSubtitleChooserPriv;

struct _OGMDvdSubtitleChooser
{
  GtkComboBox widget;
  OGMDvdSubtitleChooserPriv *priv;
};

struct _OGMDvdSubtitleChooserClass
{
  GtkComboBoxClass parent_class;
};

GType              ogmdvd_subtitle_chooser_get_type   (void);
GtkWidget *        ogmdvd_subtitle_chooser_new        (void);
void               ogmdvd_subtitle_chooser_set_title  (OGMDvdSubtitleChooser *chooser,
                                                       OGMDvdTitle           *title,
                                                       gint                  pref);
OGMDvdTitle *      ogmdvd_subtitle_chooser_get_title  (OGMDvdSubtitleChooser *chooser);
OGMDvdSubpStream * ogmdvd_subtitle_chooser_get_active (OGMDvdSubtitleChooser *chooser);

G_END_DECLS

#endif /* __OGMDVD_SUBTITLE_CHOOSER_H__ */

