/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*-
 *
 * nautilus-burn-drive.h: easy to use cd burner software
 *
 * Copyright (C) 2002-2004 Red Hat, Inc.
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Alexander Larsson <alexl@redhat.com>
 *          Bastien Nocera <hadess@hadess.net>
 *          William Jon McCann <mccann@jhu.edu>
 */

#ifndef NAUTILUS_BURN_DRIVE_H
#define NAUTILUS_BURN_DRIVE_H

#include <glib-object.h>
#include <glib.h>

G_BEGIN_DECLS

#define NAUTILUS_BURN_TYPE_DRIVE            (nautilus_burn_drive_get_type ())
#define NAUTILUS_BURN_DRIVE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj),  NAUTILUS_BURN_TYPE_DRIVE, NautilusBurnDrive))
#define NAUTILUS_BURN_DRIVE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),   NAUTILUS_BURN_TYPE_DRIVE, NautilusBurnDriveClass))
#define NAUTILUS_BURN_IS_DRIVE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj),  NAUTILUS_BURN_TYPE_DRIVE))
#define NAUTILUS_BURN_IS_DRIVE_CLASS(klass) (G_TYPE_INSTANCE_GET_CLASS ((klass), NAUTILUS_BURN_TYPE_DRIVE))

#ifndef INVALID_HANDLE
#define INVALID_HANDLE (GINT_TO_POINTER(-1))
#endif

#define CD_ROM_SPEED 176

#define CDS_NO_INFO   0 /* if not implemented */
#define CDS_AUDIO   100
#define CDS_DATA_1  101
#define CDS_DATA_2  102
#define CDS_XA_2_1  103
#define CDS_XA_2_2  104
#define CDS_MIXED   105

typedef enum 
{
	NAUTILUS_BURN_MEDIA_TYPE_BUSY,
	NAUTILUS_BURN_MEDIA_TYPE_ERROR,
	NAUTILUS_BURN_MEDIA_TYPE_UNKNOWN,
	NAUTILUS_BURN_MEDIA_TYPE_CD,
	NAUTILUS_BURN_MEDIA_TYPE_CDR,
	NAUTILUS_BURN_MEDIA_TYPE_CDRW,
	NAUTILUS_BURN_MEDIA_TYPE_DVD,
	NAUTILUS_BURN_MEDIA_TYPE_DVDR,
	NAUTILUS_BURN_MEDIA_TYPE_DVDRW,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_RAM,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_PLUS_R,
	NAUTILUS_BURN_MEDIA_TYPE_DVD_PLUS_RW,
  NAUTILUS_BURN_MEDIA_TYPE_DVD_PLUS_R_DL,
} NautilusBurnMediaType;

typedef enum 
{
	NAUTILUS_BURN_DRIVE_TYPE_FILE                   = 1 << 0,
	NAUTILUS_BURN_DRIVE_TYPE_CD_RECORDER            = 1 << 1,
	NAUTILUS_BURN_DRIVE_TYPE_CDRW_RECORDER          = 1 << 2,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_RAM_RECORDER       = 1 << 3,
	/* Drives are usually DVD-R and DVD-RW */
	NAUTILUS_BURN_DRIVE_TYPE_DVD_RW_RECORDER        = 1 << 4,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_PLUS_R_RECORDER    = 1 << 5,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_PLUS_RW_RECORDER   = 1 << 6,
	NAUTILUS_BURN_DRIVE_TYPE_CD_DRIVE               = 1 << 7,
	NAUTILUS_BURN_DRIVE_TYPE_DVD_DRIVE              = 1 << 8,
  NAUTILUS_BURN_DRIVE_TYPE_DVD_PLUS_R_DL_RECORDER = 1 << 9,
} NautilusBurnDriveType;

typedef enum
{
  NAUTILUS_BURN_DRIVE_PROTOCOL_IDE,
  NAUTILUS_BURN_DRIVE_PROTOCOL_SCSI,
} NautilusBurnDriveProtocolType;

typedef struct _NautilusBurnDrive      NautilusBurnDrive;
typedef struct _NautilusBurnDriveClass NautilusBurnDriveClass;
typedef struct _NautilusBurnDrivePriv  NautilusBurnDrivePriv;

struct _NautilusBurnDrive
{
  GObject parent;

	NautilusBurnDriveType         type;
  NautilusBurnDriveProtocolType protocol;

	char *display_name;
	int  max_speed_write;
	int  max_speed_read;
	char *cdrecord_id;
	char *device;
  char *udi;

  NautilusBurnDriveType monitor_media_type;
  gboolean              monitor_tray_open;
  gboolean              monitor_enabled;
  guint                 poll_id;

  char *monitor_udi;
  void *ctx;
};


struct _NautilusBurnDriveClass
{
  GObjectClass parent_class;

  void (*media_added)   (NautilusBurnDrive *drive);
  void (*media_removed) (NautilusBurnDrive *drive);
};

GType                 nautilus_burn_drive_get_type                 (void);
GList *               nautilus_burn_drive_get_list                 (void);

NautilusBurnDrive *   nautilus_burn_drive_new                      (void);
NautilusBurnDrive *   nautilus_burn_drive_new_from_path            (const gchar       *device);

gboolean              nautilus_burn_drive_eject                    (NautilusBurnDrive *drive);
gboolean              nautilus_burn_drive_door_is_open             (NautilusBurnDrive *drive);
void                  nautilus_burn_drive_set_monitor_enabled      (NautilusBurnDrive *drive, 
                                                                    gboolean          enabled);
gboolean              nautilus_burn_drive_get_monitor_enabled      (NautilusBurnDrive *drive);
NautilusBurnMediaType nautilus_burn_drive_get_media_type           (NautilusBurnDrive *drive);

G_END_DECLS

#endif
