/* This program is licensed under the GNU General Public License, version 2
 * (c) 2002 krys <krys@cnedra.org>
 * (c) 2000-2001 Michael Smith <msmith@labyrinth.net.au>
 */

#include <stdio.h>
#include <unistd.h>
#include "vcedit.h"

#define TAGS 15
char* tags[TAGS]= { NULL, NULL, NULL, NULL, NULL, 
                    NULL, NULL, NULL, NULL, NULL,
                    NULL, NULL, NULL, NULL, NULL };
char* tags_n[TAGS]= { "artist", "description", "genre", "album", "tracknumber",  
                      "organization", "performer", "title", "version", "copyright", 
                      "date", "discid", "isrc", "location", "contact" };
char sw[TAGS]= { 'a', 'd', 'g', 'l', 'n', 'o', 'p', 't', 'v', 'C', 'D', 'H', 'I', 'L', 'M' };

vorbis_comment* vc;  
/* extract from vorbis documentation:
a ARTIST The artist generally considered responsible for the work. In popular music this is usually the performing band or singer. For classical music it would be the composer. For an audio book it would be the author of the original text. 
d DESCRIPTION A short text description of the contents 
g GENRE A short text indication of music genre 
l ALBUM The collection name to which this track belongs 
n TRACKNUMBER The track number of this piece if part of a specific larger collection or album 
o ORGANIZATION Name of the organization producing the track (i.e. the 'record label') 
p PERFORMER The artist(s) who performed the work. In classical music this would be the conductor, orchestra, soloists. In an audio book it would be the actor who did the reading. In popular music this is typically the same as the ARTIST and is omitted. 
t TITLE Track name 
v VERSION The version field may be used to differentiate multiple versions of the same track title in a single collection. (e.g. remix info) 
C COPYRIGHT Copyright and license information (e.g. '(c) 2001 Nobody's Band. All rights reserved' or '(c) 1999 Jack Moffit, distributed under the terms of the Open Audio License. see http://www.eff.org/IP/Open_licenses/eff_oal.html for details') 
D DATE Date the track was recorded 
H DISCID Table of contents hash from an associated disc, generally used to index the track in published music databases. See http://freedb.org/ for and example of such a hash.
I ISRC ISRC number for the track; see the ISRC intro page for more information on ISRC numbers. 
L LOCATION Location where track was recorded 
M CONTACT Contact information for the creators or distributors of the track. This could be a URL, an email address, the physical address of the producing label. 
*/

#define MAXTMPFIL 1024  
void Update (char* filename)
{ FILE *in, *out;
  char tmpfiles[MAXTMPFIL];
  vcedit_state* state;
  int i;

  if (filename== NULL) return;
  snprintf (tmpfiles, MAXTMPFIL, "%s.tmp", filename);
  tmpfiles[MAXTMPFIL- 1]= 0;
  if (strlen (tmpfiles)>= MAXTMPFIL- 1)
  { fprintf (stderr, "%s skipped\n", filename); 
    return;
  }
  
  rename (filename, tmpfiles);
  state= vcedit_new_state();
  in= fopen(tmpfiles, "rb");
  if (in== NULL)
  { fprintf (stderr, "Failed to open file %s\n", filename);
    return;
  }
  if (vcedit_open(state, in)< 0)
  { fprintf (stderr, "Failed to open file %s: %s\n", filename, vcedit_error(state));
    rename (tmpfiles, filename);
    fclose (in);
    return;
  }
  
  vc= vcedit_comments (state);
  vorbis_comment_clear (vc);
  vorbis_comment_init (vc);

  for (i= 0; i< TAGS; i++)
   if (tags[i]!= NULL)
    if (tags[i]!= 0)
     vorbis_comment_add_tag (vc, tags_n[i], tags[i]);

  out= fopen(filename, "wb");  
  if (vcedit_write(state, out)< 0)
  { fprintf (stderr, "Failed to write output file %s: %s\n", filename, vcedit_error(state));
    unlink (filename);
    rename (tmpfiles, filename);
    fclose (in);
    fclose (out);
    return;
  }
  
  vcedit_clear(state);
  fclose (out);
  fclose (in);  
  unlink (tmpfiles);  
  return;
}

void Usage (char* name)
{ fprintf (stderr, "%s v1.0, a teensy-weensy ogg tag editor\n\
Usage: %s [-a artist] [-d description] [-g genre] [-l album]\n\
              [-n track number] [-o organization] [-p performer] [-t title]\n\
              [-v version] [-C copyright] [-D date] [-H disc id]\n\
              [-I ISRC number] [-L location] [-M contact] <ogg files>\n", name, name);
  exit (0);
}

char** ParseOption (char* param)
{ int i;
  
  if (*param!= 0) 
   if (*(param+ 1)== 0)
    for (i= 0; i< TAGS; i++)
     if (sw[i]== *param) 
      return tags+ i;
  
  fprintf (stderr, "Unrecognized option -%s\n", param);
  exit (1);
}

int main (int argc, char** argv)
{ int i;
  char** str;
  
  if (argc== 1) Usage (argv[0]);
 
  for (i= 1; i< argc; i++) // for each file
   if (argv[i][0]== '-')
   { // we are reading an option
     str= ParseOption (argv[i]+ 1);
     i++;
     if (i< argc)
      *str= argv[i];
   }
   else 
     Update (argv[i]); // we are reading a file, update its tag
 
  return 0;
}
