(* $Id: rssgui_main.ml,v 1.1 2005/06/09 15:07:03 zoggy Exp $ *)

let usage = (Filename.basename Sys.argv.(0))^" [options] [files]\nOptions are:"

let main () =
  let _ = GMain.Main.init () in
  let files = ref [] in
  let set_locale s =
    ignore(Glib.Main.setlocale `CTYPE (Some s))
  in
  Arg.parse
    [
      "--locale", Arg.String set_locale,
      "<locale>\n\t\tset locale, for example fr_FR" ;
    ]
    (fun s -> files := !files @ [s])
    usage;

  let gui = new Rssgui.gui !files in
  GMain.Main.main ()

(*c==v=[Misc.safe_main]=1.0====*)
let safe_main main =
  try main ()
  with
    Failure s
  | Sys_error s ->
      prerr_endline s;
      exit 1
(*/c==v=[Misc.safe_main]=1.0====*)

let () = safe_main main
