(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

(* $Id: printval.mli,v 1.8 2000/03/25 18:55:44 xleroy Exp $ *)

(* Printing of values *)

open Types
open Format

val eval_path: Path.t -> Obj.t

val print_value: Env.t -> Obj.t -> formatter -> type_expr -> unit
val print_untyped_exception: formatter -> Obj.t -> unit

val install_printer : Path.t -> Types.type_expr -> (Obj.t -> unit) -> unit
val remove_printer : Path.t -> unit

val max_printer_depth: int ref
val max_printer_steps: int ref
