/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*          Damien Doligez, projet Moscova, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 2000 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License.         */
/*                                                                     */
/***********************************************************************/
/* $Id: gusistuff.cp,v 1.3 2000/04/17 20:01:37 doligez Exp $ */

#define GUSI_SOURCE
#include <GUSIConfig.h>
#include <GUSIBasics.h>

extern "C" {
#include "main.h"
#include <rotatecursor.h>
}

static void spin_hook_for_gusi (bool wait)
{
#pragma unused (wait)
  if (rotatecursor_flag){
    rotatecursor_rearm ();
    RotateCursor (32);
  }
}

/**************** B E G I N GUSI CONFIGURATION ****************************
 *
 * GUSI Configuration section generated by GUSI Configurator
 * last modified: Thu Mar 30 18:08:06 2000
 *
 * This section will be overwritten by the next run of Configurator.
 */

#define GUSI_SOURCE
#include <GUSIConfig.h>
#include <sys/cdefs.h>

/* Declarations of Socket Factories */

__BEGIN_DECLS
void GUSIwithInetSockets();
void GUSIwithLocalSockets();
void GUSIwithMTInetSockets();
void GUSIwithMTTcpSockets();
void GUSIwithMTUdpSockets();
void GUSIwithOTInetSockets();
void GUSIwithOTTcpSockets();
void GUSIwithOTUdpSockets();
void GUSIwithPPCSockets();
void GUSISetupFactories();
__END_DECLS

/* Configure Socket Factories */

void GUSISetupFactories()
{
#ifdef GUSISetupFactories_BeginHook
    GUSISetupFactories_BeginHook
#endif
    GUSIwithInetSockets();
    GUSIwithLocalSockets();
    GUSIwithPPCSockets();
#ifdef GUSISetupFactories_EndHook
    GUSISetupFactories_EndHook
#endif
    GUSISetHook (GUSI_SpinHook, (GUSIHook) spin_hook_for_gusi);
}

/* Declarations of File Devices */

__BEGIN_DECLS
void GUSIwithDConSockets();
void GUSIwithNullSockets();
void GUSISetupDevices();
__END_DECLS

/* Configure File Devices */

void GUSISetupDevices()
{
#ifdef GUSISetupDevices_BeginHook
    GUSISetupDevices_BeginHook
#endif
    GUSIwithNullSockets ();
#ifdef GUSISetupDevices_EndHook
    GUSISetupDevices_EndHook
#endif
    GUSISetHook (GUSI_SpinHook, (GUSIHook) spin_hook_for_gusi);
}

#ifndef __cplusplus
#error GUSISetupConfig() needs to be written in C++
#endif

GUSIConfiguration::FileSuffix   sSuffices[] = {
    ".ml"  , 'TEXT', 'Caml',
    ".mli" , 'TEXT', 'Caml',
    ""     , '????', '????',
};

extern "C" void GUSISetupConfig()
{
    GUSIConfiguration * config =
        GUSIConfiguration::CreateInstance(GUSIConfiguration::kNoResource);

    config->ConfigureSuffices(
        sizeof(sSuffices)/sizeof(GUSIConfiguration::FileSuffix)-1, sSuffices);
    config->ConfigureAutoInitGraf(false);
    config->ConfigureAutoSpin(false);
    config->ConfigureSigInt(false);
    config->ConfigureSigPipe(true);
    GUSISetHook (GUSI_SpinHook, (GUSIHook) spin_hook_for_gusi);
}

/**************** E N D GUSI CONFIGURATION *************************/
