/* options.c */

/*
    NUT nutrition software 
    Copyright (C) 1996-2007 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "options.h"
#include "util.h"
#include "db.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

struct opt options;

void initialize_options()
{
int c;
options.delopt = -1;
options.defanal = 0;
options.screen = 0;
options.custom = 0;
options.pcprotein = 0;
options.pccarb= 0;
options.pcsatfat = 0;
options.fatprotratio = 0;
options.protcalpergm = 4;
options.carbcalpergm = 4;
options.fatcalpergm = 9.2307692;
options.fattyacidfactor = 0.956;
options.next_recipe = 99000;
for (c=0; c < NUTRIENT_COUNT; c++)
 {
 options.locknuts[c] = 0;
 options.abnuts[c] = 0;
 }
if (mealdb_mealsperday > 0 && mealdb_mealsperday < 20) options.mealsperday = mealdb_mealsperday;
else options.mealsperday = 3;
options.grams = 0;
options.autocal = 0;
options.temp_meal_root = &meal_root;
}

void personal_cal()
{
float buf = 0;
int choice;
options.abnuts[FAMS] = 0;
header("NUT:  Set Personal Calorie Level");
printf("\nCalorie level is set to %0.0f.\n\n",DV[ENERC_KCAL]);
printf("\n1.  I will type a new calorie level.\n");
printf("\n2.  I want to return to the program default of 2000.\n");
printf("\n3.  I want NUT to automatically use my average calories, and when analyzing,\n");
printf("    to automatically select an analysis period that contains that average\n");
printf("    in order to even out day-to-day variation in the analysis.\n");
printf("\n4.  I will retain the current calorie level without automatic features.\n");
spacer(13);
printf("\nEnter your choice (just <enter> to retain current setting):  ");
choice = get_int();
switch (choice)
 {
 case 1 :
  header("NUT:  Set Personal Calorie Level");
  spacer(0);
  printf("\nCalorie level is set to %0.0f.  Type new level (just <enter> for default):  ",DV[ENERC_KCAL]);
  get_cals(&buf);
  if (buf <= 0) options.locknuts[ENERC_KCAL] = 0;
  else
   {
   options.locknuts[ENERC_KCAL] = 1;
   options.abnuts[ENERC_KCAL] = buf;
   }
  options.abnuts[FAT] = 0;
  options.abnuts[FAMS] = 0;
  options.autocal = 0;
  break;
 case 3 :
  options.locknuts[ENERC_KCAL] = 0;
  options.abnuts[ENERC_KCAL] = 0;
  options.locknuts[FAT] = 0;
  options.abnuts[FAT] = 0;
  options.locknuts[FAMS] = 0;
  options.abnuts[FAMS] = 0;
  options.autocal = 1;
  break;
 case 4 :
  options.autocal = 0;
  options.locknuts[ENERC_KCAL] = 1;
  break;
 case 2 :
  options.locknuts[ENERC_KCAL] = 0;
  options.abnuts[ENERC_KCAL] = 0;
  options.abnuts[FAT] = 0;
  options.abnuts[FAMS] = 0;
  options.autocal = 0;
  break;
 default :
  buf = options.abnuts[ENERC_KCAL];
  break;
  }
auto_cal(&buf,0);
header("NUT:  Set Personal Calorie Level");
new_nut_levels();
}
   
void efa_method()
{
char buf[128];
float temp, lastsetting;
lastsetting = options.abnuts[FAPU];
header("NUT:  Essential Fats Absolute Amount");
spacer(0);
options.n6hufaspec = 0;
printf("\nEnter absolute amount of EFAs in grams (just <enter> for default):  ");
get_string(buf,127);
options.abnuts[FAPU] = atof(buf);
options.locknuts[FAPU] = 1;
if ( options.abnuts[FAPU] < 0 ) 
 {
 if (options.abnuts[FAPU] == -1) options.n6hufaspec = 1;
 options.abnuts[FAPU] = 0;
 options.locknuts[FAPU] = 0;
 }
options.abnuts[FAT] = 0;
options.abnuts[FAMS] = 0;
if (options.abnuts[FAPU] == 0) 
 {
 options.locknuts[FAPU] = 0;
 options.abnuts[OMEGA6] = 0; options.locknuts[OMEGA6] = 0;
 options.abnuts[LA] = 0; options.locknuts[LA] = 0;
 options.abnuts[AA] = 0; options.locknuts[AA] = 0;
 options.abnuts[OMEGA3] = 0; options.locknuts[OMEGA3] = 0;
 options.abnuts[ALA] = 0; options.locknuts[ALA] = 0;
 options.abnuts[EPA] = 0; options.locknuts[EPA] = 0;
 options.abnuts[DHA] = 0; options.locknuts[DHA] = 0;
 }
if ( options.abnuts[FAPU] > 0 && lastsetting <= 0)
 {
 temp = options.abnuts[FAPU] / DVBase[FAPU];
 options.abnuts[OMEGA6] = temp * DVBase[OMEGA6]; options.locknuts[OMEGA6] = 1;
 options.abnuts[LA] = temp * DVBase[LA]; options.locknuts[LA] = 1;
 options.abnuts[AA] = temp * DVBase[AA]; options.locknuts[AA] = 1;
 options.abnuts[OMEGA3] = temp * DVBase[OMEGA3]; options.locknuts[OMEGA3] = 1;
 options.abnuts[ALA] = temp * DVBase[ALA]; options.locknuts[ALA] = 1;
 options.abnuts[EPA] = temp * DVBase[EPA]; options.locknuts[EPA] = 1;
 options.abnuts[DHA] = temp * DVBase[DHA]; options.locknuts[DHA] = 1;
 }
if ( options.abnuts[FAPU] > 0 && lastsetting >  0)
 {
 temp = options.abnuts[FAPU] / lastsetting;
 options.abnuts[OMEGA6] = temp * options.abnuts[OMEGA6]; options.locknuts[OMEGA6] = 1;
 options.abnuts[LA] = temp * options.abnuts[LA]; options.locknuts[LA] = 1;
 options.abnuts[AA] = temp * options.abnuts[AA]; options.locknuts[AA] = 1;
 options.abnuts[OMEGA3] = temp * options.abnuts[OMEGA3]; options.locknuts[OMEGA3] = 1;
 options.abnuts[ALA] = temp * options.abnuts[ALA]; options.locknuts[ALA] = 1;
 options.abnuts[EPA] = temp * options.abnuts[EPA]; options.locknuts[EPA] = 1;
 options.abnuts[DHA] = temp * options.abnuts[DHA]; options.locknuts[DHA] = 1;
 }
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Essential Fats Absolute Amounts");
new_nut_levels();
}

void protein_percent()
{
char buf[128];
header("NUT:  Protein Percentage");
spacer(0);
printf("\nEnter percentage of protein (just <enter> for default):  ");
get_string(buf,127);
options.pcprotein = atof(buf);
if ( options.pcprotein <= 0 || (options.pcprotein + options.pccarb) > 90 )
 {
 options.pcprotein = 0;
 if (options.fatprotratio == 0 && options.abnuts[PROCNT] == 0) options.locknuts[PROCNT] = 0;
 }
if ( options.pcprotein > 0 )
 {
 options.abnuts[PROCNT] = 0;
 options.locknuts[PROCNT] = 1;
 }
if ( options.pcprotein > 0 && (options.pccarb > 0 || options.abnuts[CHOCDF] > 0)) options.fatprotratio = 0;
options.abnuts[FAT] = 0;
options.locknuts[FAT] = 0;
options.abnuts[FAMS] = 0;
options.locknuts[FAMS] = 0;
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Protein Percentage");
new_nut_levels();
}

void fatprot_ratio()
{
char buf[128];
header("NUT:  Fat to Protein Ratio");
spacer(0);
printf("\nEnter ratio of fat to protein calories (just <enter> for default):  ");
get_string(buf,127);
options.fatprotratio = atof(buf);
if ( options.fatprotratio <= 0 ) options.fatprotratio = 0;
if ( options.fatprotratio == 0 && options.pcprotein == 0 && options.abnuts[PROCNT] == 0 ) options.locknuts[PROCNT] = 0;
if ( (options.pcprotein > 0 || options.abnuts[PROCNT] > 0) && (options.pccarb > 0 || options.abnuts[CHOCDF] > 0) ) options.fatprotratio = 0;
if ( options.fatprotratio > 0 ) 
 {
 options.locknuts[PROCNT] = 1; 
 if (options.abnuts[PROCNT] > 0 || options.pcprotein > 0)
  {
  options.pccarb = 0;
  options.abnuts[CHOCDF] = 0;
  options.locknuts[CHOCDF] = 0;
  }
 else if (options.abnuts[CHOCDF] == 0 && options.pccarb == 0) options.pcprotein = 30 / options.fatprotratio;
 }
options.abnuts[FAT] = 0;
options.locknuts[FAT] = 0;
options.abnuts[FAMS] = 0;
options.locknuts[FAMS] = 0;
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Fat to Protein Ratio");
new_nut_levels();
}

void carb_percent()
{
char buf[128];
header("NUT:  Carbohydrate Percentage");
spacer(0);
printf("\nEnter percentage of carbohydrate (just <enter> for default):  ");
get_string(buf,127);
options.pccarb = atof(buf);
options.locknuts[CHOCDF] = 1;
if ( options.pccarb <= 0 || (options.pcprotein + options.pccarb) > 90 )
 {
 options.pccarb = 0;
 options.locknuts[CHOCDF] = 0;
 }
if ( options.pccarb > 0 ) options.abnuts[CHOCDF] = 0;
if ( options.pccarb > 0 && (options.pcprotein > 0 || options.abnuts[PROCNT] > 0)) options.fatprotratio = 0;
options.abnuts[FAT] = 0;
options.locknuts[FAT] = 0;
options.abnuts[FAMS] = 0;
options.locknuts[FAMS] = 0;
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Carbohydrate Percentage");
new_nut_levels();
}

void satfat_percent()
{
char buf[128];
header("NUT:  Saturated Fat Percentage");
spacer(0);
printf("\nEnter percentage of saturated fat (just <enter> for default):  ");
get_string(buf,127);
options.pcsatfat = atof(buf);
options.locknuts[FASAT] = 1;
if ( options.pcsatfat <= 0  || options.pcsatfat > 90 )
 {
 options.pcsatfat = 0;
 options.locknuts[FASAT] = 0;
 options.abnuts[FASAT] = 0;
 }
options.abnuts[FAT] = 0;
options.abnuts[FAMS] = 0;
options.locknuts[FAMS] = 0;
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Saturated Fat Percentage");
new_nut_levels();
}

void protein_absolute()
{
char buf[128];
header("NUT:  Protein Absolute Amount");
spacer(0);
printf("\nEnter grams of protein (just <enter> for default):  ");
get_string(buf,127);
options.abnuts[PROCNT] = atof(buf);
if ( options.abnuts[PROCNT] <= 0 )
 {
 options.abnuts[PROCNT] = 0;
 if (options.pcprotein == 0 && options.fatprotratio == 0) options.locknuts[PROCNT] = 0;
 }
if ( options.abnuts[PROCNT] > 0 )
 {
 options.pcprotein = 0;
 if (options.abnuts[CHOCDF] != 0) options.fatprotratio = 0;
 options.locknuts[PROCNT] = 1;
 }
options.abnuts[FAT] = 0;
options.locknuts[FAT] = 0;
options.abnuts[FAMS] = 0;
options.locknuts[FAMS] = 0;
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Protein Absolute Amount");
new_nut_levels();
}

void carb_absolute()
{
char buf[128];
header("NUT:  Carbohydrate Absolute Amount");
spacer(0);
printf("\nEnter grams of carbohydrate (just <enter> for default):  ");
get_string(buf,127);
options.abnuts[CHOCDF] = atof(buf);
options.locknuts[CHOCDF] = 0;
if ( options.abnuts[CHOCDF] <= 0 ) options.abnuts[CHOCDF] = 0;
if ( options.abnuts[CHOCDF] > 0 )
 {
 options.pccarb = 0;
 options.locknuts[CHOCDF] = 1;
 }
if (options.abnuts[CHOCDF] > 0 && (options.pcprotein > 0 || options.abnuts[PROCNT] > 0)) options.fatprotratio = 0;
options.abnuts[FAT] = 0;
options.locknuts[FAT] = 0;
options.abnuts[FAMS] = 0;
options.locknuts[FAMS] = 0;
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Carbohydrate Absolute Amount");
new_nut_levels();
}

void fiber_absolute()
{
char buf[128];
header("NUT:  Fiber Absolute Amount");
spacer(0);
printf("\nEnter grams of fiber (just <enter> for default):  ");
get_string(buf,127);
options.abnuts[FIBTG] = atof(buf);
options.locknuts[FIBTG] = 1;
if ( options.abnuts[FIBTG] < 1 || options.abnuts[FIBTG] > 999 )
 {
 options.abnuts[FIBTG] = 0;
 options.locknuts[FIBTG] = 0;
 }
auto_cal(&DV[ENERC_KCAL],0);
header("NUT:  Fiber Absolute Amount");
new_nut_levels();
}

void screen(void)
{
options.screen++;
options.screen %= MaxScreen;
write_OPTIONS();
}

void screen_previous(void)
{
    if (--options.screen < 0) {
        options.screen = MaxScreen - 1;
    }
    write_OPTIONS();
}

void get_cals(float *cals)
{
char buff[128];
fgets(buff,128,stdin);
*cals = (float) atof(buff);
}

void auto_cal(float *bufptr, int analflag)
{
float buf = *bufptr, temp = 0;
int i;
if (options.autocal) buf = average_cals(analflag);
if (analflag)
 {
 if (food_work.nutrient[PROT_KCAL] > 0 && food_work.nutrient[PROCNT] > 0) options.protcalpergm = food_work.nutrient[PROT_KCAL] / food_work.nutrient[PROCNT];
 if (food_work.nutrient[CHO_KCAL] > 0 && food_work.nutrient[CHOCDF] > 0) options.carbcalpergm = food_work.nutrient[CHO_KCAL] / food_work.nutrient[CHOCDF];
 if (food_work.nutrient[FAT_KCAL] > 0 && food_work.nutrient[FAT] > 0) options.fatcalpergm = food_work.nutrient[FAT_KCAL] / food_work.nutrient[FAT];
 if (food_work.nutrient[FAT] > 0 && food_work.nutrient[FASAT] + food_work.nutrient[FAMS] + food_work.nutrient[FAPU] > 0) options.fattyacidfactor = (food_work.nutrient[FASAT] + food_work.nutrient[FAMS] + food_work.nutrient[FAPU]) / food_work.nutrient[FAT];
 }
for (i = 1 ; i <= *ScreenMap[0] ; i++) DV[ScreenMap[0][i]] = DVBase[ScreenMap[0][i]];
if (buf <= 0) 
 {
 buf = 2000;
 if (!options.locknuts[ENERC_KCAL]) options.abnuts[ENERC_KCAL] = DVBase[ENERC_KCAL];
 if (options.locknuts[ENERC_KCAL]) buf = options.abnuts[ENERC_KCAL];
 }
else if (buf > 0 && buf <= 100) buf = 100;
else if (buf > 9999) buf = 9999;
buf /= DVBase[ENERC_KCAL];
DV[ENERC_KCAL] = buf * DVBase[ENERC_KCAL];
if (buf != 1)
 {
 DV[PROCNT] = buf * DVBase[PROCNT] * 4 / options.protcalpergm;
 DV[FAT] = buf * DVBase[FAT] * 9.2307692 / options.fatcalpergm;
 DV[CHOCDF] = buf * DVBase[CHOCDF] * 4 / options.carbcalpergm;
 }
if (buf == 1)
 {
 DV[PROCNT] = DVBase[PROCNT];
 DV[FAT] = DVBase[FAT];
 DV[CHOCDF] = DVBase[CHOCDF];
 options.protcalpergm = 4;
 options.carbcalpergm = 4;
 options.fatcalpergm = 9.2307692;
 }
DV[FIBTG] = buf * DVBase[FIBTG];
DV[FASAT] = buf * DVBase[FASAT];
DV[FAPU] = buf * DVBase[FAPU];
DV[FAMS] = options.fattyacidfactor * DV[FAT] - DV[FASAT] - DV[FAPU];
DV[OMEGA6] = buf * DVBase[OMEGA6];
DV[LA] = buf * DVBase[LA];
DV[AA] = buf * DVBase[AA];
DV[OMEGA3] = buf * DVBase[OMEGA3];
DV[ALA] = buf * DVBase[ALA];
DV[EPA] = buf * DVBase[EPA];
DV[DHA] = buf * DVBase[DHA];
if (options.locknuts[ENERC_KCAL]) DV[ENERC_KCAL] = options.abnuts[ENERC_KCAL];
if (!options.locknuts[ENERC_KCAL]) options.abnuts[ENERC_KCAL] = DV[ENERC_KCAL];
if (options.abnuts[FIBTG] > 0) DV[FIBTG] = options.abnuts[FIBTG];
if (options.pcprotein > 0) DV[PROCNT] = options.pcprotein / 100 * DV[ENERC_KCAL] / options.protcalpergm;
if (options.abnuts[PROCNT] > 0) DV[PROCNT] = options.abnuts[PROCNT];
if (options.pccarb > 0) DV[CHOCDF] = options.pccarb / 100 * DV[ENERC_KCAL] / options.carbcalpergm;
if (options.abnuts[CHOCDF] > 0) DV[CHOCDF] = options.abnuts[CHOCDF];
if (options.fatprotratio > 0 && options.abnuts[PROCNT] <= 0 && options.pcprotein <= 0)
 {
 temp = 1 - (DV[CHOCDF] * options.carbcalpergm) / DV[ENERC_KCAL];
 DV[PROCNT] = temp * DV[ENERC_KCAL] / (options.fatprotratio + 1) / options.protcalpergm;
 DV[FAT] = DV[PROCNT] * options.fatprotratio / (options.fatcalpergm / options.protcalpergm) ;
 }
if (options.fatprotratio > 0 && (options.abnuts[PROCNT] > 0 || options.pcprotein > 0))
 {
 DV[FAT] = DV[PROCNT] * options.fatprotratio / (options.fatcalpergm / options.protcalpergm) ;
 temp = 1 - (DV[PROCNT] * options.protcalpergm + DV[FAT] * options.fatcalpergm) / DV[ENERC_KCAL];
 DV[CHOCDF] = temp * DV[ENERC_KCAL] / options.carbcalpergm;
 }
if (options.fatprotratio <= 0 && (DV[PROCNT] != DVBase[PROCNT] || DV[CHOCDF] != DVBase[CHOCDF]))
 {
 temp = 1 - (DV[PROCNT] * options.protcalpergm + DV[CHOCDF] * options.carbcalpergm) / DV[ENERC_KCAL];
 DV[FAT] = temp * DV[ENERC_KCAL] / options.fatcalpergm;
 }
DV[FAMS] = options.fattyacidfactor * DV[FAT] - DV[FASAT] - DV[FAPU];
if (analflag && options.abnuts[FAPU] == 0) efa_dynamics();
if (options.abnuts[FAPU] > 0)
 {
 DV[FAMS] = DV[FAMS] - options.abnuts[FAPU] + DV[FAPU];
 DV[FAPU] = options.abnuts[FAPU];
 if (options.abnuts[OMEGA6] > 0) DV[OMEGA6] = options.abnuts[OMEGA6];
 if (options.abnuts[LA] > 0) DV[LA] = options.abnuts[LA];
 if (options.abnuts[AA] > 0) DV[AA] = options.abnuts[AA];
 if (options.abnuts[OMEGA3] > 0) DV[OMEGA3] = options.abnuts[OMEGA3];
 if (options.abnuts[ALA] > 0) DV[ALA] = options.abnuts[ALA];
 if (options.abnuts[EPA] > 0) DV[EPA] = options.abnuts[EPA];
 if (options.abnuts[DHA] > 0) DV[DHA] = options.abnuts[DHA];
 }
if (options.abnuts[FAPU] == 0)
 {
 if (options.abnuts[OMEGA6] != 0) DV[OMEGA6] = options.abnuts[OMEGA6];
 if (options.abnuts[LA] != 0) DV[LA] = options.abnuts[LA];
 if (options.abnuts[AA] != 0) DV[AA] = options.abnuts[AA];
 if (options.abnuts[OMEGA3] != 0) DV[OMEGA3] = options.abnuts[OMEGA3];
 if (options.abnuts[ALA] != 0) DV[ALA] = options.abnuts[ALA];
 if (options.abnuts[EPA] != 0) DV[EPA] = options.abnuts[EPA];
 if (options.abnuts[DHA] != 0) DV[DHA] = options.abnuts[DHA];
 temp = DV[OMEGA6] + DV[OMEGA3] - DV[FAPU];
 DV[FAPU] += temp;
 DV[FAMS] -= temp;
 }
if (options.pcsatfat > 0)
 {
 temp = DV[FASAT] + DV[FAMS];
 DV[FASAT] = DVBase[FASAT] * buf * options.pcsatfat * .1;
 DV[FAMS] = temp - DV[FASAT];
 }
if (options.abnuts[CHOCDF] > 0 && options.abnuts[PROCNT] > 0 && options.abnuts[FAT] > 0) DV[FAT] = options.abnuts[FAT];
if (options.abnuts[CHOCDF] > 0 && options.abnuts[PROCNT] > 0 && options.abnuts[FAMS] > 0) DV[FAMS] = options.abnuts[FAMS];
if (options.abnuts[CHOLE] > 0) DV[CHOLE] = options.abnuts[CHOLE]; 
if (options.abnuts[VITA_IU] > 0) DV[VITA_IU] = options.abnuts[VITA_IU]; 
if (options.abnuts[THIA] > 0) DV[THIA] = options.abnuts[THIA]; 
if (options.abnuts[RIBF] > 0) DV[RIBF] = options.abnuts[RIBF]; 
if (options.abnuts[NIA] > 0) DV[NIA] = options.abnuts[NIA]; 
if (options.abnuts[PANTAC] > 0) DV[PANTAC] = options.abnuts[PANTAC]; 
if (options.abnuts[VITB6A] > 0) DV[VITB6A] = options.abnuts[VITB6A]; 
if (options.abnuts[FOL] > 0) DV[FOL] = options.abnuts[FOL]; 
if (options.abnuts[VITB12] > 0) DV[VITB12] = options.abnuts[VITB12]; 
if (options.abnuts[VITC] > 0) DV[VITC] = options.abnuts[VITC]; 
if (options.abnuts[VITD] > 0) DV[VITD] = options.abnuts[VITD]; 
if (options.abnuts[VITE] > 0) DV[VITE] = options.abnuts[VITE]; 
if (options.abnuts[VITK] > 0) DV[VITK] = options.abnuts[VITK]; 
if (options.abnuts[CA] > 0) DV[CA] = options.abnuts[CA]; 
if (options.abnuts[CU] > 0) DV[CU] = options.abnuts[CU]; 
if (options.abnuts[FE] > 0) DV[FE] = options.abnuts[FE]; 
if (options.abnuts[MG] > 0) DV[MG] = options.abnuts[MG]; 
if (options.abnuts[MN] > 0) DV[MN] = options.abnuts[MN]; 
if (options.abnuts[P] > 0) DV[P] = options.abnuts[P]; 
if (options.abnuts[K] > 0) DV[K] = options.abnuts[K]; 
if (options.abnuts[SE] > 0) DV[SE] = options.abnuts[SE]; 
if (options.abnuts[NA] > 0) DV[NA] = options.abnuts[NA]; 
if (options.abnuts[ZN] > 0) DV[ZN] = options.abnuts[ZN]; 
if (! options.abnuts[CHO_NONFIB]) DV[CHO_NONFIB] = DV[CHOCDF] - DV[FIBTG] < 0 ? 0 : DV[CHOCDF] - DV[FIBTG];
else DV[CHO_NONFIB] = options.abnuts[CHO_NONFIB];
temp = 1 - (DV[PROCNT] * options.protcalpergm + DV[CHOCDF] * options.carbcalpergm) / DV[ENERC_KCAL];
if (temp > .32 && options.pcsatfat <= 0 && options.abnuts[FASAT] <= 0 && options.abnuts[FAMS] <= 0) 
 {
 temp = (DV[FASAT] * temp / .3) - DV[FASAT];
 DV[FASAT] += temp;
 DV[FAMS] -= temp;
 if (analflag && food_work.nutrient[FASAT] < DV[FASAT])
  {
  temp = (DV[FASAT] + DV[FAMS]) / (food_work.nutrient[FASAT] + food_work.nutrient[FAMS]);
  DV[FASAT] = food_work.nutrient[FASAT] * temp;
  DV[FAMS] = food_work.nutrient[FAMS] * temp;
  }
 }
if ( options.pcsatfat > 0 || options.pcprotein > 0 || options.pccarb > 0 || options.fatprotratio || options.abnuts[PROCNT] > 0 || options.abnuts[CHOCDF] > 0 || options.abnuts[FIBTG] > 0 || options.abnuts[VITE]) options.custom = 1;
else options.custom = 0;
write_OPTIONS();
}

void auto_del()
{
char buf[128];
int junk;
header("NUT:  Automatic Deletion of Meals");
spacer(0);
printf("\nDo you want to have meals deleted automatically from database?  (y/n):  ");
junk = get_char();
if (junk != 'Y' && junk != 'y' && junk != 'N' && junk != 'n') return;
if (junk != 'Y' && junk != 'y')
 {
 header("NUT:  Automatic Deletion of Meals");
 spacer(0);
 options.delopt = -1;
 write_OPTIONS();
 printf("\nMeals will not be deleted automatically.  Press <enter> to continue...");
 junk = get_int();
 return;
 }
junk = 0;
header("NUT:  Automatic Deletion of Meals");
spacer(0);
printf("\nHow many meals should be kept in database?  "); 
while (junk < 1)
 {
 get_string(buf,127);
 junk = atoi(buf);
 if (junk > 0)
  {
  options.delopt = junk;
  write_OPTIONS();
  delete_meals(options.delopt);
  write_meal_db();
  header("NUT:  Automatic Deletion of Meals");
  spacer(0);
  if (junk == 1) printf("\n%d meal will be kept in database.  Press <enter> to continue...",junk); 
  else printf("\n%d meals will be kept in database.  Press <enter> to continue...",junk); 
  junk = get_int();
  return;
  }
 header("NUT:  Automatic Deletion of Meals");
 spacer(0);
 printf("\nMust keep at least one meal in database.  How many?  ");
 }
}

void new_nut_levels()
{
int junk;
printf("\n      New Nutrient Levels:    %-15s %6.1f %-s\n",Nutrient[ENERC_KCAL],DV[ENERC_KCAL],Unit[ENERC_KCAL]);
printf("                              %-15s %6.1f %-s\n",Nutrient[FAT],DV[FAT],Unit[FAT]);
printf("                              %-15s %6.1f %-s\n",Nutrient[FASAT],DV[FASAT],Unit[FASAT]);
printf("                              %-15s %6.1f %-s\n",Nutrient[FAMS],DV[FAMS],Unit[FAMS]);
printf("                              %-15s %6.1f %-s\n",Nutrient[FAPU],DV[FAPU],Unit[FAPU]);
printf("                              %-15s %6.1f %-s\n",Nutrient[OMEGA6],DV[OMEGA6],Unit[OMEGA6]);
printf("                              %-15s %6.1f %-s\n",Nutrient[LA],DV[LA],Unit[LA]);
printf("                              %-15s %6.1f %-s\n",Nutrient[AA],DV[AA],Unit[AA]);
printf("                              %-15s %6.1f %-s\n",Nutrient[OMEGA3],DV[OMEGA3],Unit[OMEGA3]);
printf("                              %-15s %6.1f %-s\n",Nutrient[ALA],DV[ALA],Unit[ALA]);
printf("                              %-15s %6.1f %-s\n",Nutrient[EPA],DV[EPA],Unit[EPA]);
printf("                              %-15s %6.1f %-s\n",Nutrient[DHA],DV[DHA],Unit[DHA]);
printf("                              %-15s %6.1f %-s\n",Nutrient[CHOCDF],DV[CHOCDF],Unit[CHOCDF]);
printf("                              %-15s %6.1f %-s\n",Nutrient[FIBTG],DV[FIBTG],Unit[FIBTG]);
printf("                              %-15s %6.1f %-s\n",Nutrient[CHO_NONFIB],DV[CHO_NONFIB],Unit[CHO_NONFIB]);
printf("                              %-15s %6.1f %-s\n",Nutrient[PROCNT],DV[PROCNT],Unit[PROCNT]);
spacer(17);
printf("\nPress <enter> to continue...");
junk = get_int();
}

void restore_defaults(int removelock)
{
int i;
if ( removelock ) for ( i = 0; i < NUTRIENT_COUNT ; i++ ) options.locknuts[i] = 0;
if ( !options.locknuts[PROCNT] ) options.pcprotein = 0;
if ( !options.locknuts[PROCNT] ) options.fatprotratio = 0;
if ( !options.locknuts[CHOCDF] ) options.pccarb = 0;
if ( !options.locknuts[FASAT] ) options.pcsatfat = 0;
if ( removelock ) options.autocal = 0;
if ( removelock ) options.n6hufaspec = 0;
for ( i = 0; i < NUTRIENT_COUNT ; i++ ) if ( !options.locknuts[i] ) options.abnuts[i] = 0;
if ( !options.locknuts[ENERC_KCAL] ) auto_cal(&DVBase[ENERC_KCAL],removelock ? 0 : 1);
else auto_cal(&options.abnuts[ENERC_KCAL],removelock ? 0 : 1);
}

void set_defanal()
{
struct meal *meal_ptr = options.temp_meal_root;
int count = 0;
char lastdate[9];
int lastmeal;
float thisresult = -1, lastresult;
int lastresultcount = 0;
float sum = 0, testthis, testlast;
if (!options.autocal) return;
auto_cal(&DV[ENERC_KCAL],0);
if (meal_count(meal_ptr) < options.mealsperday * 5) return;
if (meal_ptr->next == NULL) return;
strcpy(lastdate,meal_ptr->next->meal_date);
lastmeal = meal_ptr->next->meal;
count = 0;
while (meal_ptr->next != NULL)
 {
 meal_ptr = meal_ptr->next;
 sum += meal_ptr->grams / 100 * FoodIndex[meal_ptr->food_no]->nutrient[ENERC_KCAL];
 if (meal_ptr->next != NULL) if (strcmp(lastdate,meal_ptr->next->meal_date) != 0 || lastmeal != meal_ptr->next->meal)
  {
  count++;
  strcpy(lastdate,meal_ptr->next->meal_date);
  lastmeal = meal_ptr->next->meal;
  if (count % options.mealsperday == 0 && count >= options.mealsperday * 5)
   {
   lastresult = thisresult;
   lastresultcount = count - options.mealsperday;
   thisresult = (sum / count * options.mealsperday / DV[ENERC_KCAL]) - 1;
   if (lastresult == -1)
    {
    lastresult = thisresult;
    lastresultcount = count;
    }
   else
    {
    if ((lastresult <= 0.0 && thisresult >= 0.0) || (lastresult >= 0.0 && thisresult <= 0.0))
     {
     testthis = thisresult < 0 ? thisresult * -1.0 : thisresult;
     testlast = lastresult < 0 ? lastresult * -1.0 : lastresult;
     options.defanal = testthis > testlast ? lastresultcount : count;
     return;
     }
    }
   }
  }
 if (meal_ptr->next == NULL)
  {
  count++;
  if (count % options.mealsperday == 0 && count >= options.mealsperday * 5)
   {
   lastresult = thisresult;
   lastresultcount = count - options.mealsperday;
   thisresult = (sum / count * options.mealsperday / DV[ENERC_KCAL]) - 1;
   if (lastresult == -1)
    {
    lastresult = thisresult;
    lastresultcount = count;
    }
   else
    {
    if ((lastresult <= 0.0 && thisresult >= 0.0) || (lastresult >= 0.0 && thisresult <= 0.0))
     {
     testthis = thisresult < 0 ? thisresult * -1.0 : thisresult;
     testlast = lastresult < 0 ? lastresult * -1.0 : lastresult;
     options.defanal = testthis > testlast ? lastresultcount : count;
     return;
     }
    }
   }
  }
 }
options.defanal = count - count % options.mealsperday;
}

void efa_dynamics()
{
int i;
float temp, temp_la = 0, temp_aa = 0, hufapct, p3, h3, h6, p6, o;
float target = 61, epadhalimit, extra_ala;

epadhalimit = DV[ENERC_KCAL] * .0077 / 9.02;

if (options.n6hufa != 0)
 {
 if (options.n6hufa < 15) options.n6hufa = 15;
 if (options.n6hufa > 90) options.n6hufa = 90;
 }

options.abnuts[AA] = food_work.nutrient[AA];
options.abnuts[LA] = food_work.nutrient[LA];
options.abnuts[ALA] = DV[ALA];
extra_ala = DV[ALA] - food_work.nutrient[ALA];
p3 = 902 * (food_work.nutrient[SHORT3] + extra_ala) / food_work.nutrient[ENERC_KCAL];
p6 = 902 * food_work.nutrient[SHORT6] / food_work.nutrient[ENERC_KCAL];
h6 = 902 * food_work.nutrient[LONG6] / food_work.nutrient[ENERC_KCAL];
o  = 902 * food_work.nutrient[FAT] * options.fattyacidfactor / food_work.nutrient[ENERC_KCAL] - food_work.nutrient[SHORT6] - food_work.nutrient[LONG6] - food_work.nutrient[SHORT3] - food_work.nutrient[LONG3];

if (food_work.nutrient[EPA] > .02 || food_work.nutrient[DHA] > .02 || food_work.nutrient[AA] > .02) for (i = 1; i < 200000; i++)
 {
 temp = i * .001;
 h3 = 902 * temp / food_work.nutrient[ENERC_KCAL];
 hufapct = n6hufa(p3,p6,h3,h6,o);

 if (options.n6hufa <= 0 && hufapct > target) continue;
 if (options.n6hufa > 0 && hufapct > options.n6hufa) continue;

 options.abnuts[OMEGA6] = food_work.nutrient[SHORT6] + food_work.nutrient[LONG6];
 options.abnuts[OMEGA3] = food_work.nutrient[SHORT3] + extra_ala + temp;
 temp -= food_work.nutrient[LONG3] - food_work.nutrient[EPA] - food_work.nutrient[DHA];
 if (food_work.nutrient[EPA] > 0 || food_work.nutrient[DHA] > 0) temp = temp / (food_work.nutrient[EPA] + food_work.nutrient[DHA]);
 options.abnuts[EPA] = food_work.nutrient[EPA] * temp;
 options.abnuts[DHA] = food_work.nutrient[DHA] * temp;
 if (options.abnuts[EPA] + options.abnuts[DHA] > epadhalimit)
  {
  temp = options.abnuts[EPA] + options.abnuts[DHA] - epadhalimit;
  options.abnuts[EPA] -= options.abnuts[EPA] / (options.abnuts[EPA] + options.abnuts[DHA]) * temp;
  options.abnuts[DHA] -= options.abnuts[DHA] / (options.abnuts[EPA] + options.abnuts[DHA]) * temp;
  options.abnuts[OMEGA3] -= temp;
  h3 -= 902 * temp / food_work.nutrient[ENERC_KCAL];
  for (i = 1; i < 200000; i++)
   {
   temp_la = p6 * i * .00001;
   temp_aa = h6 * i * .00001;
   hufapct = n6hufa(p3,p6-temp_la,h3,h6-temp_aa,o);
   if (options.n6hufa <= 0 && hufapct < target) break;
   if (options.n6hufa > 0 && hufapct < options.n6hufa) break;
   }
  options.abnuts[LA] -= temp_la / 902 * food_work.nutrient[ENERC_KCAL];
  options.abnuts[AA] -= temp_aa / 902 * food_work.nutrient[ENERC_KCAL];
  options.abnuts[OMEGA6] -= (temp_la + temp_aa) / 902 * food_work.nutrient[ENERC_KCAL];
  }
 if (options.abnuts[OMEGA6] <= 0) options.abnuts[OMEGA6] = .01;
 if (options.abnuts[LA] <= 0) options.abnuts[LA] = .01;
 if (options.abnuts[AA] <= 0) options.abnuts[AA] = .01;
 if (options.abnuts[OMEGA3] <= 0) options.abnuts[OMEGA3] = .01;
 if (options.abnuts[EPA] <= 0) options.abnuts[EPA] = .01;
 if (options.abnuts[DHA] <= 0) options.abnuts[DHA] = .01;
 return;
 }
else
 {
 h3 = 902 * food_work.nutrient[LONG3] / food_work.nutrient[ENERC_KCAL];
 for (i = 1; i < 200000; i++)
  {
  temp = i * .001;

  p3 = 902 * temp / food_work.nutrient[ENERC_KCAL];
  o  = 902 * (food_work.nutrient[FASAT] + food_work.nutrient[FAMS]) / food_work.nutrient[ENERC_KCAL];
  hufapct = n6hufa(p3,p6,h3,h6,o);

  if (options.n6hufa <= 0 && hufapct > target) continue;
  if (options.n6hufa > 0 && hufapct > options.n6hufa) continue;
  options.abnuts[OMEGA6] = food_work.nutrient[SHORT6] + food_work.nutrient[LONG6];
  options.abnuts[OMEGA3] = food_work.nutrient[LONG3] + temp;
  temp -= food_work.nutrient[SHORT3] - food_work.nutrient[ALA];
  options.abnuts[ALA] = temp;
  options.abnuts[EPA] = .01;
  options.abnuts[DHA] = .01;
  if (options.abnuts[OMEGA6] <= 0) options.abnuts[OMEGA6] = .01;
  if (options.abnuts[LA] <= 0) options.abnuts[LA] = .01;
  if (options.abnuts[AA] <= 0) options.abnuts[AA] = .01;
  if (options.abnuts[OMEGA3] <= 0) options.abnuts[OMEGA3] = .01;
  if (options.abnuts[ALA] <= 0) options.abnuts[ALA] = .01;
  if (options.abnuts[EPA] <= 0) options.abnuts[EPA] = .01;
  if (options.abnuts[DHA] <= 0) options.abnuts[DHA] = .01;
  return;
  }
 }
}
