/*  mge-ellipse.h - monitor MGE UPS for NUT with SHUT protocol 
 *                  (like Ellipse models)
 * 
 *  Copyright (C) 2001-2002 Philippe Marzouk <philm@users.sourceforge.net>
 *  some parts are Copyright (C) Russell Kroll <rkroll@exploits.org>
 *  some parts are Copyright (C) Canon driver developpers for Gphoto
 *         see http://www.gphoto.org for details
 *  All rights reserved.
 *  
 * $Id: mge-ellipse.h,v 1.3 2002/03/02 18:35:07 phil Exp phil $
 */

/*
 *		       GNU GENERAL PUBLIC LICENSE
 *			  Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *            59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#define INFOMAX 17

#define DEFAULT_TIMEOUT 1000

typedef enum {
	PRESENT_STATUS,
	BATT_CAPACITY,
	SET_SHUTDOWN_DELAY,
	GET_SHUTDOWN_DELAY,
	SET_LOWBATT_LEVEL,
	GET_LOWBATT_LEVEL,
	PERCENT_LOAD,
	SET_STARTUP_DELAY,
	GET_STARTUP_DELAY,
	IPRODUCT,
	GET_USB_DESCRIPTOR,
	GET_HID_DESCRIPTOR
} shutdataType;

struct shutdata
{
	unsigned char cmd_type1;
	unsigned char cmd_type2;
	unsigned char reqid;
};

extern const struct shutdata commands[];

/* Ellipse command set */
#define PING "\x16"
#define L_PING 1

/* functions
 * for Ellipse */
void instcmd(int cmd, int datalen, char *data);
int e_request_ups (void);
int e_ups_start(void);
int e_identify_ups(void);
void e_ups_status(unsigned char *pkt);
void e_ups_load(unsigned char *pkt);
void e_autonomy(unsigned char *pkt);
int e_set_autorestart(void);
int e_get_autorestart(void);
int e_set_lowbatt (void);
int e_get_lowbatt (void);
int e_wait_ack (void);
int e_packet_recv(int command, unsigned char *pkt);
int e_packet_send (int command, unsigned char *data, int datalen);
void setline(int set);
int serial_read(int read_timeout);
int serial_send(char *buf, int len);
void dump_hex(const char *msg, const unsigned char *buf, int len);

