/* upsconf.c - code for handling ups.conf ini-style parsing

   Copyright (C) 2001  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "upsconf.h"
#include "common.h"
#include "parseconf.h"

	static	char	*ups_section;

/* handle arguments separated by parseconf */
void conf_args(int numargs, char **arg)
{
	char	*ep;

	if (numargs < 1)
		return;

	/* look for section headers - [upsname] */
	if ((arg[0][0] == '[') && (arg[0][strlen(arg[0])-1] == ']')) {
		
		if (ups_section)
			free(ups_section);

		arg[0][strlen(arg[0])-1] = '\0';
		ups_section = xstrdup(&arg[0][1]);
		return;
	}

	/* handle 'foo=bar' (compressed form) */
	ep = strchr(arg[0], '=');
	if (ep) {
		*ep = '\0';

		do_upsconf_args(ups_section, arg[0], ep+1);
		return;
	}

	/* handle 'foo' (flag) */
	if (numargs == 1) {
		do_upsconf_args(ups_section, arg[0], NULL);
		return;
	}

	if (numargs < 3)
		return;

	/* handle 'foo = bar' (split form) */
	if (!strcmp(arg[1], "=")) {
		do_upsconf_args(ups_section, arg[0], arg[2]);
		return;
	}
}

void conf_err(int linenum, char *errtxt)
{
	if (linenum == 0)
		upslogx(LOG_ERR, "ups.conf: %s", errtxt);
	else
		upslogx(LOG_ERR, "ups.conf line %d: %s", errtxt);
}

/* open the ups.conf, parse it, and call back do_upsconf_args() */
void read_upsconf(int required)
{
	int	ret;
	char	fn[SMALLBUF];

	snprintf(fn, sizeof(fn), "%s/ups.conf", CONFPATH);

	ups_section = NULL;

	ret = parseconf(fn, conf_args, conf_err);

	if ((ret != 0) && (required))
		fatalx("ups.conf parsing failed");

	if (ups_section)
		free(ups_section);
}
