/* shared.h - shared data structures for upsd and model-specific modules */

/* itype - holds info (variable name, variable value) */

/* size of the values stored within the array */
#define VALSIZE 32

/* used in an array and stored in shared memory or to state file */
typedef struct {
	int	type;
	char	value[VALSIZE];
	int	flags;			/* see FLAGS_* below 		*/
	int	auxdata;		/* length, # entries, enumtype	*/
}	itype;

/* these values are only used between processes on the same host... */

#define INFO_MEMBERS	0x0000		/* number of info entries 	*/
#define INFO_MFR	0x0001		/* manufacturer string		*/
#define INFO_MODEL	0x0002		/* model string			*/
#define INFO_SERIAL	0x0003		/* serial number		*/
#define INFO_UTILITY	0x0004		/* incoming utility voltage	*/
#define INFO_BATTPCT	0x0005		/* battery charge (percent)	*/
#define INFO_STATUS	0x0006		/* status (OL, OB, LB, etc.)	*/
#define INFO_UPSTEMP	0x0007		/* temperature (degrees C)	*/
#define INFO_ACFREQ	0x0008		/* AC frequency (Hz)		*/
#define INFO_LOADPCT	0x0009		/* load on UPS (percent)	*/
#define INFO_LOWXFER	0x000A		/* low transfer voltage		*/
#define INFO_HIGHXFER	0x000B		/* high transfer voltage	*/
#define INFO_AMBHUMID	0x000C		/* ambient humidity (percent)	*/
#define INFO_AMBTEMP	0x000D		/* ambient temperature (deg C)	*/
#define INFO_CONTACTS   0x000F		/* dry contacts                 */
#define INFO_UPSIDENT	0x0010		/* ups identification (string)  */
#define INFO_WAKEDELAY	0x0011		/* seconds to delay at poweron	*/
#define INFO_LINESENS	0x0012		/* line sensitivity		*/
#define INFO_BATTVOLT   0x0013		/* Battery Voltage		*/
#define INFO_OUTVOLT    0x0014		/* Output Voltage		*/
#define INFO_WAKETHRSH	0x0015		/* battery threshold for poweron*/
#define INFO_REQVOLT	0x0016		/* Requested output voltage	*/
#define INFO_LOBATTIME	0x0017		/* run time when lo-bat starts	*/
#define INFO_PDNGRACE	0x0018		/* grace from cmd and powerdown	*/
#define INFO_ALRMDELAY	0x0019		/* delay before OB warning	*/
#define INFO_SLFTSTINT	0x001A		/* intervals between self tests	*/
#define INFO_FIRMREV	0x001B		/* Firmware revision		*/
#define INFO_REG1	0x001C		/* Register 1			*/
#define INFO_REG2	0x001D		/* Register 2			*/
#define INFO_REG3	0x001E		/* Register 3			*/
#define INFO_LINEQUAL	0x001F		/* Line quality			*/
#define INFO_BATTPACKS	0x0020		/* Installed battery packs	*/
#define INFO_XFERWHY	0x0021		/* Reason for last transfer	*/
#define INFO_MAXUTIL	0x0022		/* Max utility voltage seen	*/
#define INFO_MINUTIL	0x0023		/* Min utility voltage seen	*/
#define INFO_SLFTSTRES	0x0024		/* Last self test result	*/
#define INFO_RUNTIME	0x0025		/* Predicted runtime on batt	*/
#define INFO_MFRDATE	0x0026		/* Manufacturing date		*/
#define INFO_BATTDATE	0x0027		/* last battery change date	*/
#define INFO_TEMPMAX	0x0028		/* Max temperature setting 	*/
#define INFO_TEMPMIN	0x0029		/* Min temperature setting 	*/
#define INFO_HUMDMAX	0x002A		/* Max humidity setting 	*/
#define INFO_HUMDMIN	0x002B		/* Min humidity setting 	*/
#define INFO_FIRMREV1	0x002C		/* Firmware revision (more)	*/
#define INFO_NOMBATVLT	0x002D		/* Nominal battery voltage 	*/
#define INFO_COPYRIGHT	0x002E		/* UPS F/W Copyright Info	*/
#define INFO_FIRMREV2	0x002F		/* Firmware revision (aux device)*/
#define INFO_DIPSWCH	0x0030		/* DIP switch settings		*/
#define INFO_OUTVLTSEL	0x0031		/* Output voltage selection	*/
#define INFO_CURRENT	0x0032		/* Output Current		*/
#define INFO_LOADPWR	0x0033		/* Load power percentage	*/
#define INFO_LANGUAGE	0x0034		/* Front panel language		*/
#define INFO_BADPACKS	0x0035		/* Bad battery packs installed	*/
#define INFO_ALRMENA	0x0036		/* Alarm enable                 */
#define INFO_ALRMSTAT	0x0037		/* Alarm status			*/
#define INFO_AMBTEMP2	0x0038		/* Ambient temperature 2 	*/
#define INFO_AMBHUMID2	0x0039		/* Ambient Humidity 2		*/

#define	INFO_SYSMASK	0xF000		/* mask for system level INFOs  */
#define INFO_INSTCMD	0xFFFB		/* supported instant command	*/
#define INFO_ENUM	0xFFFC		/* holder for an ENUM value	*/
#define	INFO_MSGID	0xFFFD		/* message queue ID             */
#define INFO_SHMID	0xFFFE		/* shared memory struct ID      */
#define INFO_UNUSED	0xFFFF		/* this entry is not being used */

/* message queue identifiers */

#define UPSMSG_TOUPSD	0x1000		/* message to upsd from model   */
#define UPSMSG_TOMODEL	0x1001		/* message from upsd to model   */
#define UPSMSG_MAXLEN	128		/* maximum length permitted	*/

/* message queue struct commands */

#define UPSMSG_CMDMASK	0xA100		/* command mask			*/
#define UPSMSG_CMDSDD	0xA101		/* dead, replaced by instcmd    */
#define UPSMSG_CMDSET	0xA102		/* set variable to value	*/
#define UPSMSG_INSTCMD	0xA103		/* do an instant command	*/

#define UPSMSG_REPMASK	0xAE00		/* reply mask			*/
#define UPSMSG_REPOK	0xAE01		/* command completed OK		*/
#define UPSMSG_REPAGAIN 0xAE02		/* try command again		*/

#define UPSMSG_ERRMASK	0xAF00		/* error mask			*/
#define UPSMSG_ERRNI	0xAF01		/* error: cmd not implemented	*/
#define UPSMSG_ERRRO	0xAF02		/* error: read-only variable	*/
#define UPSMSG_ERRCF	0xAF03		/* error: command failed	*/

typedef struct {
	int	cmdtype;
	int	auxcmd;
	int	dlen;
	char	data;		/* up to dlen bytes long */
}	msgtype;

/* flags from the info array */
#define FLAG_RW		0x0001		/* variable is read/write	  */
#define FLAG_ENUM	0x0002		/* variable is an enumerated type */
#define FLAG_STRING	0x0004		/* variable is a string           */

/* instant commands that models may support */
#define CMD_OFF		0x2000		/* turn the UPS load off	  */
#define CMD_ON		0x2001		/* turn the UPS load on		  */
#define CMD_SDRET	0x2002		/* shutdown+return in auxdata min */
#define CMD_BTEST0	0x2003		/* stop battery test		  */
#define CMD_BTEST1	0x2004		/* start battery test		  */
#define CMD_CAL0	0x2005		/* stop runtime calibration	  */
#define CMD_CAL1	0x2006		/* start runtime calibration	  */
#define CMD_FPTEST	0x2007		/* test the front panel		  */
#define CMD_DUMB	0x2008		/* Turn dumb			  */
#define CMD_SIMPWF	0x2009		/* Simulate power failure	  */
#define CMD_SOFTDOWN	0x200A		/* Soft shutdown		  */
#define CMD_SHUTDOWN	0x200B		/* Shutdown after grace period	  */
#define CMD_BYPASS	0x200C		/* Switch to bypass mode	  */
