/* upsset - CGI program to manage read/write variables

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>

#include "common.h"
#include "upsfetch.h"
#include "version.h"
#include "cgilib.h"
#include "config.h"
#include "proto.h"

	int	fd;
	char	*ups, *host, *username, *password, *function, *upscommand;

typedef struct {
	char	*var;
	char	*value;
	void	*next;
}	uvtype;

	uvtype	*firstuv = NULL;

void parsearg (char *var, char *value)
{
	char	*ptr;
	uvtype	*last, *tmp = NULL;

	if (!strncmp(var, "UPSVAR_", 7)) {
		ptr = strchr (var, '_');

		if (!ptr)		/* sanity check */
			return;

		ptr++;

		tmp = last = firstuv;
		while (tmp) {
			last = tmp;
			tmp = tmp->next;
		}

		tmp = malloc (sizeof(uvtype));
		tmp->var = strdup(ptr);
		tmp->value = strdup(value);
		tmp->next = NULL;

		if (last)
			last->next = tmp;
		else
			firstuv = tmp;

		fflush (stdout);

		return;
	}

	if (!strcmp(var, "username"))
		username = strdup (value);

	if (!strcmp(var, "password"))
		password = strdup (value);

	if (!strcmp(var, "function"))
		function = strdup (value);

	if (!strcmp(var, "ups"))
		ups = strdup (value);

	if (!strcmp(var, "upscommand"))
		upscommand = strdup (value);
}

void do_enum (char *varname)
{
	char	out[SMALLBUF], temp[SMALLBUF], *val, *sel, *ptr;

	snprintf (out, sizeof(out), "ENUM %s\n", varname);	
	upssendraw (fd, out);

	upsreadraw (fd, temp, sizeof(temp));
	if (strncmp(temp, "ENUM", 4) != 0) {
		printf ("Bogus reply from server for %s\n", varname);
		return;
	}

	printf ("<SELECT NAME=\"UPSVAR_%s\">\n", varname);

	upsreadraw (fd, temp, sizeof(temp));

	while (strcmp(temp, "END") != 0) {

		/* split into value and selected */
		val = strchr (temp, '"');
		val++;
		sel = strchr (val, ' ');
		if (sel)
			sel++;
		ptr = strchr (val, '"');
		val [ptr - val] = '\0';
			
		printf ("<OPTION VALUE=\"%s\" ", val);
			
		if ((sel != NULL) && (!strcmp(sel, "SELECTED")))
			printf ("SELECTED");

		printf (">%s</OPTION>\n", val);	
		upsreadraw (fd, temp, sizeof(temp));
	}
	printf ("</SELECT>\n");
}

void do_string (char *upsname, char *varname, int typelen)
{
	char	temp[SMALLBUF];

	getupsvarfd (fd, upsname, varname, temp, sizeof(temp));
	printf ("<INPUT TYPE=\"TEXT\" NAME=\"UPSVAR_%s\" VALUE=\"%s\" SIZE=\"%i\">\n",
	        varname, temp, typelen);
}

void do_header(char *title)
{
	printf ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\n");
	printf ("	\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n");
	printf ("<HTML>\n");
	printf ("<HEAD><TITLE>upsset: %s</TITLE></HEAD>\n", title);

	printf ("<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\" LINK=\"#0000EE\" VLINK=\"#551A8B\">\n"); 

	printf ("<TABLE BGCOLOR=\"#50A0A0\" ALIGN=\"CENTER\">\n");
	printf ("<TR><TD>\n");

}

void start_table()
{
	printf ("<TABLE CELLPADDING=\"5\" CELLSPACING=\"0\" ALIGN=\"CENTER\" WIDTH=\"100%%\">\n");
	printf ("<TR><TH COLSPAN=2 BGCOLOR=\"#60B0B0\">\n");
	printf ("<FONT SIZE=\"+2\">Network UPS Tools upsset %s</FONT>\n", 
	         UPS_VERSION);
	printf ("</TH></TR>\n");
}

void do_hidden(char *next)
{
	printf ("<INPUT TYPE=\"HIDDEN\" NAME=\"username\" VALUE=\"%s\">\n",
	        username);
	printf ("<INPUT TYPE=\"HIDDEN\" NAME=\"password\" VALUE=\"%s\">\n",
	        password);

	if (next)
		printf ("<INPUT TYPE=\"HIDDEN\" NAME=\"function\" VALUE=\"%s\">\n", 
		        next);
}

void do_pickups(char *currups, char *currfunc)
{
	FILE	*hosts;
	char	buf[SMALLBUF], hostfn[SMALLBUF], addr[64], *rest, *ptr;
	int	ofs;

	snprintf (hostfn, sizeof(hostfn), "%s/hosts.conf", CONFPATH);
	hosts = fopen (hostfn, "r");

	/* errorpage calls pickups, so we can't use it here */

	if (!hosts) {
		printf ("Configuration error: Can't open hosts file\n");
		exit (1);
	}

	printf ("<FORM METHOD=\"POST\" ACTION=\"upsset.cgi\">\n");

	printf ("Select UPS and function:\n<BR>\n");
	printf ("<SELECT NAME=\"ups\">\n");

	while (fgets(buf, sizeof(buf), hosts)) {
		if (!strncmp(buf, "MONITOR", 7)) {
			sscanf (buf, "%*s %s %n", addr, &ofs);
			rest = buf + ofs + 1;
			ptr = strchr (rest, '"');
			if (ptr)
				*ptr = '\0';

			printf ("<OPTION VALUE=\"%s\"", addr);

			if (currups)
				if (!strcmp(currups, rest))
					printf (" SELECTED");

			printf (">%s</OPTION>\n", rest);
		}
	}

	fclose (hosts);

	printf ("</SELECT>\n");

	printf ("<SELECT NAME=\"function\">\n");

	/* FUTURE */
	/*	printf ("<OPTION VALUE=\"showstatus\">Status</OPTION>\n");  */

	/* TODO: clean this up */

	if (!strcmp(currfunc, "showsettings"))
		printf ("<OPTION VALUE=\"showsettings\" SELECTED>Settings</OPTION>\n");
	else
		printf ("<OPTION VALUE=\"showsettings\">Settings</OPTION>\n");

	if (!strcmp(currfunc, "showcmds"))
		printf ("<OPTION VALUE=\"showcmds\" SELECTED>Commands</OPTION>\n");
	else
		printf ("<OPTION VALUE=\"showcmds\">Commands</OPTION>\n");

	printf ("</SELECT>\n");
	do_hidden(NULL);

	printf ("<INPUT TYPE=\"SUBMIT\" VALUE=\"View\">\n");
	printf ("</FORM>\n");
}

void errorpage (char *title, char *msg, char *func)
{
	do_header(title);
	start_table();
	printf ("<TR><TH COLSPAN=2 BGCOLOR=\"#60B0B0\">\n");
	printf ("%s\n", msg);
	printf ("</TH></TR>\n");

	printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
	do_pickups(NULL, func);
	printf ("</TD></TR>\n");

	printf ("</TABLE>\n");
	printf ("</TD></TR></TABLE>\n");
	printf ("</BODY></HTML>\n");
	exit (0);
}

void loginscreen()	/* HTML 4.0 transitional checked */
{
	do_header("Login");
	printf ("<FORM METHOD=\"POST\" ACTION=\"upsset.cgi\">\n");
	start_table();

	printf ("<TR BGCOLOR=\"#60B0B0\">\n");
	printf ("<TH>Username</TH>\n");
	printf ("<TD><INPUT TYPE=\"TEXT\" NAME=\"username\" VALUE=\"\"></TD>\n");
	printf ("</TR>\n");

	printf ("<TR BGCOLOR=\"#60B0B0\">\n");
	printf ("<TH>Password</TH>\n");
	printf ("<TD><INPUT TYPE=\"PASSWORD\" NAME=\"password\" VALUE=\"\"></TD>\n");
	printf ("</TR>\n");

	printf ("<TR><TD COLSPAN=2 ALIGN=\"CENTER\">\n");
	printf ("<INPUT TYPE=\"HIDDEN\" NAME=\"function\" VALUE=\"pickups\">\n");
	printf ("<INPUT TYPE=\"SUBMIT\" VALUE=\"Login\">\n");
	printf ("<INPUT TYPE=\"RESET\" VALUE=\"Reset fields\">\n");
	printf ("</TD></TR></TABLE>\n");
	printf ("</FORM>\n");
	printf ("</TD></TR></TABLE>\n");
	printf ("</BODY></HTML>\n");
	exit (0);
}

void checkauth ()
{
	FILE	*pwf;
	char	pwfn[SMALLBUF], buf[SMALLBUF], tusr[32], tpw[32];

	if ((!username) || (!password))
		loginscreen();

	snprintf (pwfn, sizeof(pwfn), "%s/upsset.passwd", CONFPATH);
	pwf = fopen (pwfn, "r");

	if (!pwf)
		errorpage ("Configuration error", "Password file missing",
			   "");

	/* SYSTEM <system> <password> */
	/* USER <username> <password> */

	while (fgets(buf, sizeof(buf), pwf)) {
		if (buf[0] == '#')	/* ignore comments */
			continue;

		if (!strncmp(buf, "USER", 4)) {
			sscanf (buf, "%*s %s %s", tusr, tpw);
			if (!strcmp(tusr, username)) {
				fclose (pwf);
				if (!strcmp(tpw, password))
					return;		/* login OK */
				else
					loginscreen();	/* pw mismatch */
				/* notreached */
			}
		}
	}

	fclose (pwf);
	loginscreen();		/* user not found */
}

void showcmds()
{
	char	*desc, *upstmp, *ptr, *upsname, cmds[SMALLBUF], temp[SMALLBUF], *tmp;

	if (!checkhost (ups, &desc))
		errorpage ("Access denied",
		           "Access to that host is not authorized",
		           "showsettings");

	upstmp = strdup (ups);
	ptr = strchr (upstmp, '@');
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = upstmp;
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = upstmp;
	}

	fd = upsconnect (host);
	if (fd < 0) {
		char	ebuf[SMALLBUF];
		snprintf (ebuf, sizeof(ebuf), 
		          "Unable to connect to %s - %s", host,
		          upsstrerror(upserror));
		errorpage ("Connect failure", ebuf, "showsettings");
	}

	if (upsname != NULL) {
		snprintf (temp, sizeof(temp), "LISTINSTCMD %s\n", upsname);
		upssendraw (fd, temp);
	}
	else
		upssendraw (fd, "LISTINSTCMD\n");
	
	if (upsreadraw (fd, cmds, sizeof(cmds)) < 0) {
		char	ebuf[SMALLBUF];

		snprintf (ebuf, sizeof(ebuf),
		         "Unable to get list of commands - %s\n",
		         upsstrerror(upserror));
		errorpage ("Protocol failure", ebuf, "showcmds");
	}

	if (strncmp("INSTCMDS", cmds, 7))
		errorpage ("Invalid response from server",
		           "Server did not return INSTCMDS reply",
		           "showcmds");

	ptr = strchr (cmds, ' ');
	if (!ptr)
		errorpage ("No instant commands supported",
		           "This UPS doesn't support any instant commands.",
		           "showcmds");

	ptr++;

	/* possibly skip '@ups' */
	if (ptr[0] == '@') {
		ptr = strchr (ptr, ' ');
		if (!ptr)
			errorpage ("No instant commands supported",
			           "This UPS doesn't support any instant commands.",
			           "showcmds");
		ptr++;
	}

	do_header("Instant commands");
	printf ("<FORM ACTION=\"upsset.cgi\" METHOD=\"POST\">\n");
	start_table();

	/* include the description from checkhost() if present */
	if (desc)
		printf ("<TR><TH BGCOLOR=\"#60B0B0\"COLSPAN=2>%s</TH></TR>\n",
		        desc);

	printf ("<TR BGCOLOR=\"#60B0B0\" ALIGN=\"CENTER\">\n");
	printf ("<TD>Instant commands</TD>\n");

	printf ("<TD>\n");
	printf ("<SELECT NAME=\"upscommand\">\n");

	/* provide a dummy do-nothing default choice */
	printf ("<OPTION VALUE=\"\" SELECTED></OPTION>\n");

	while (ptr) {
		char	buf[SMALLBUF], *q, *desc;

		tmp = ptr;
		ptr = strchr (tmp, ' ');
		if (ptr) {
			*ptr = '\0';
			ptr++;
		}

		/* get a description for this command from the server */
		snprintf (buf, sizeof(buf), "INSTCMDDESC %s\n", tmp);
		upssendraw (fd, buf);

		/* if description retrieval fails, go with the cmd name */
		if (upsreadraw (fd, buf, sizeof(buf)) < 0) {
			printf ("<OPTION VALUE=\"%s\">%s</OPTION>\n", tmp, tmp);
			continue;
		}
		q = strchr (buf, '"');

		if (!q)	{	/* invalid/missing description, use cmd name */
			printf ("<OPTION VALUE=\"%s\">%s</OPTION>\n", tmp, tmp);
			continue;
		}

		desc = ++q;
		
		q = strchr (desc, '"');
		if (!q)	{	/* missing second quote - don't use it */
			printf ("<OPTION VALUE=\"%s\">%s</OPTION>\n", tmp, tmp);
			continue;
		}

		*q = '\0';
		printf ("<OPTION VALUE=\"%s\">%s</OPTION>\n", tmp, desc);
	}

	printf ("</SELECT>\n");
	printf ("</TD></TR>\n");

	printf ("<TR BGCOLOR=\"#60B0B0\">\n");
	printf ("<TD COLSPAN=\"2\" ALIGN=\"CENTER\">\n");
	do_hidden("docmd");
	printf ("<INPUT TYPE=\"HIDDEN\" NAME=\"ups\" VALUE=\"%s\">\n", ups);
	printf ("<INPUT TYPE=\"SUBMIT\" VALUE=\"Issue command\">\n");
	printf ("<INPUT TYPE=\"RESET\" VALUE=\"Reset\">\n");
	printf ("</TD></TR>\n");
	printf ("</TABLE>\n");
	printf ("</FORM>\n");

	printf ("<TR><TD ALIGN=\"CENTER\">\n");
	do_pickups(desc, "showcmds");
	printf ("</TD></TR>\n");

	printf ("</TABLE>\n");
	printf ("</BODY></HTML>\n");

	exit (0);
}

void docmd(void)
{
	char	*desc, *upstmp, *ptr, *upsname, pwfn[SMALLBUF], *upspw, buf[SMALLBUF],
		upsn[64], tmppw[64];
	FILE	*pwf;

	if (!checkhost (ups, &desc))
		errorpage ("Access denied",
		           "Access to that host is not authorized",
		           "showsettings");

	upstmp = strdup (ups);
	ptr = strchr (upstmp, '@');
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = upstmp;
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = upstmp;
	}

	fd = upsconnect (host);
	if (fd < 0) {
		char	ebuf[SMALLBUF];
		snprintf (ebuf, sizeof(ebuf), 
		          "Unable to connect to %s - %s", host,
		          upsstrerror(upserror));
		errorpage ("Connect failure", ebuf, "showsettings");
	}

	/* get the right SYSTEM line from the .passwd file */

	snprintf (pwfn, sizeof(pwfn), "%s/upsset.passwd", CONFPATH);
	pwf = fopen (pwfn, "r");

	if (!pwf)
		errorpage ("Configuration error", "Password file missing",
			   "showsettings");

	upspw = NULL;
	while (fgets(buf, sizeof(buf), pwf)) {
		buf [strlen(buf) - 1] = '\0';

		if (buf[0] == '#')	/* ignore comments */
			continue;

		if (!strncmp(buf, "SYSTEM", 6)) {
			sscanf (buf, "%*s %s %s", upsn, tmppw);
			if (!strcmp(upsn, ups)) {
				upspw = strdup (tmppw);
				break;
			}
		}
	}

	fclose (pwf);

	if (!upspw) {
		char	ebuf[SMALLBUF];

		snprintf (ebuf, sizeof(ebuf), "SYSTEM entry for UPS %s not found, check your upsset.passwd",
		          ups);
		errorpage ("Configuration error", ebuf, "showsettings");
	}

	do_header("Issuing commands");
	start_table();

	/* log into server */
	snprintf (buf, sizeof(buf), "PASSWORD %s\n", upspw);
	upssendraw (fd, buf);

	/* eat the response */
	upsreadraw (fd, buf, sizeof(buf));

	/* send command, get response, show it */
	if (upsname)
		snprintf (buf, sizeof(buf), "INSTCMD %s@%s\n", upscommand,
		          upsname);
	else
		snprintf (buf, sizeof(buf), "INSTCMD %s\n", upscommand);

	upssendraw (fd, buf);
	upsreadraw (fd, buf, sizeof(buf));		

	printf ("<TR><TD><PRE>\n");
	printf ("Sending command: %s\n", upscommand);
	printf ("Response: %s\n", buf);
	printf ("</PRE></TD></TR>\n");

	printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
	do_pickups(desc, "showcmds");
	printf ("</TD></TR>\n");

	printf ("</TABLE>\n");
	printf ("</TD></TR></TABLE>\n");
	printf ("</BODY></HTML>\n");

	exit (0);
}

void showsettings()	/* HTML 4.0/transitional checked (main path) */
{
	char	*host, vars[SMALLBUF], temp[SMALLBUF], out[SMALLBUF], *v, *upsname, *upstmp,
		*type, *ptr, *desc, *vptr;
	int	typelen;

	if (!checkhost (ups, &desc))
		errorpage ("Access denied",
		           "Access to that host is not authorized",
		           "showsettings");

	upstmp = strdup (ups);
	ptr = strchr (upstmp, '@');
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = upstmp;
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = upstmp;
	}

	fd = upsconnect (host);

	if (fd < 0) {
		char	ebuf[SMALLBUF];
		snprintf (ebuf, sizeof(ebuf), 
		          "Unable to connect to %s - %s", host,
		          upsstrerror(upserror));
		errorpage ("Connect failure", ebuf, "showsettings");
	}

	if (upsname != NULL) {
		snprintf (temp, sizeof(temp), "LISTRW %s\n", upsname);
		upssendraw (fd, temp);
	}
	else
		upssendraw (fd, "LISTRW\n");
	
	if (upsreadraw (fd, vars, sizeof(vars)) < 0) {
		char	ebuf[SMALLBUF];
		snprintf (ebuf, sizeof(ebuf), 
		         "Unable to get variable list - %s\n",
		         upsstrerror(upserror));
		errorpage ("Server protocol error", ebuf, "showsettings");
	}

	do_header("Current settings");
	printf ("<FORM ACTION=\"upsset.cgi\" METHOD=\"POST\">\n");
	start_table();

	/* include the description from checkhost() if present */
	if (desc)
		printf ("<TR><TH BGCOLOR=\"#60B0B0\"COLSPAN=2>%s</TH></TR>\n",
		        desc);

	v = vars;
	ptr = strchr (v, ' ');

	if (!ptr) {		/* no spaces = seriously broken string */
		printf ("<TR BGCOLOR=\"#60B0B0\">\n");
		printf ("<TD COLSPAN=2 ALIGN=\"CENTER\">Server is spewing garbage to LISTRW command.</TD></TR>\n");
		printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
		do_pickups(desc, "showsettings");
		printf ("</TD></TR>\n");
		printf ("</TABLE></TD></TR></TABLE>\n");
		exit (0);
	}

	/* skip over 'RW' */
	*ptr++ = '\0';
	v = ptr;

	if (!v) {	/* no spaces found = no variables for default */
		printf ("<TR BGCOLOR=\"#60B0B0\">\n");
		printf ("<TD COLSPAN=2 ALIGN=\"CENTER\">No r/w variable supported on this UPS.</TD></TR>\n");
		printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
		do_pickups(desc, "showsettings");
		printf ("</TD></TR>\n");
		printf ("</TABLE></TD></TR></TABLE>\n");
		exit (0);
	}

	/* v may be pointing at '@upsname' right now, if so, skip it */
	if (v[0] == '@') {
		ptr = strchr (v, ' ');
		if (ptr)
			*ptr++ = '\0';
		v = ptr;
	}

	if (!ptr) {	/* no r/w variables supported */
		printf ("<TR BGCOLOR=\"#60B0B0\">\n");
		printf ("<TD COLSPAN=2 ALIGN=\"CENTER\">No r/w variable supported on this UPS.</TD></TR>\n");
		printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
		do_pickups(desc, "showsettings");
		printf ("</TD></TR>\n");
		printf ("</TABLE></TD></TR></TABLE>\n");
		exit (0);
	}

	printf ("<TR BGCOLOR=\"#60B0B0\">\n");
	printf ("<TH>Setting</TH>\n");
	printf ("<TH>Value</TH></TR>\n");

	while (v != NULL) {
		vptr = strchr (v, ' ');
		if (vptr)
			*vptr++ = '\0';

		/* get description */
		snprintf (out, sizeof(out), "VARDESC %s\n", v);
		upssendraw (fd, out);
		upsreadraw (fd, temp, sizeof(temp));
		printf ("<TR BGCOLOR=\"#60B0B0\" ALIGN=\"CENTER\">\n");

		/* strip off leading/trailing quotes */
		ptr = strchr (temp, '"');
		if (ptr != NULL) {
			char	*ptr2;

			ptr++;
			ptr2 = strchr (ptr, '"');

			if (ptr2)
				*ptr2 = '\0';
			else {
				printf ("Unbalanced quotes from server\n");
				exit (0);
			}
		}

		printf ("<TD>%s</TD>\n", ptr);

		/* now get variable type */
		snprintf (out, sizeof(out), "VARTYPE %s\n", v);
		upssendraw (fd, out);
		upsreadraw (fd, temp, sizeof(temp));

		type = NULL;
		typelen = 0;

		ptr = strchr (temp, ' ');
		if (ptr) {
			*ptr++ = '\0';
			type = ptr;
			ptr = strchr (type, ' ');
			if (ptr) {
				*ptr++ = '\0';
				typelen = strtol (ptr, (char **) NULL, 10);
			}
		}

		if (type) {
			printf ("<TD>\n");

			if (!strcmp(type, "ENUM"))
				do_enum (v);

			if (!strcmp(type, "STRING"))
				do_string (upsname, v, typelen);
		}
		else
			printf ("Broken type received from server\n");

		printf ("</TD></TR>\n");

		v = vptr;		
	}

	printf ("<TR BGCOLOR=\"#60B0B0\">\n");
	printf ("<TD COLSPAN=\"2\" ALIGN=\"CENTER\">\n");
	do_hidden("savesettings");
	printf ("<INPUT TYPE=\"HIDDEN\" NAME=\"ups\" VALUE=\"%s\">\n", ups);
	printf ("<INPUT TYPE=\"SUBMIT\" VALUE=\"Save changes\">\n");
	printf ("<INPUT TYPE=\"RESET\" VALUE=\"Reset\">\n");
	printf ("</TD></TR>\n");
	printf ("</TABLE>\n");
	printf ("</FORM>\n");

	printf ("<TR><TD ALIGN=\"CENTER\">\n");
	do_pickups(desc, "showsettings");
	printf ("</TD></TR>\n");

	printf ("</TABLE>\n");
	printf ("</BODY></HTML>\n");

	exit (0);
}

void savesettings()	/* HTML 4.0/transitional checked (main loop) */
{
	char	*desc, *upstmp, *ptr, *upsname, buf[SMALLBUF], upsn[64], tmppw[64],
		*upspw, pwfn[SMALLBUF];
	uvtype	*upsvar;
	FILE	*pwf;

	if (!checkhost (ups, &desc)) 
		errorpage ("Access denied",
		           "Access to that host is not authorized",
		           "showsettings");

	upstmp = strdup (ups);
	ptr = strchr (upstmp, '@');
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = upstmp;
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = upstmp;
	}

	fd = upsconnect (host);
	if (fd < 0) {
		char	ebuf[SMALLBUF];
		snprintf (ebuf, sizeof(ebuf), 
		          "Unable to connect to %s - %s", host,
		          upsstrerror(upserror));
		errorpage ("Connect failure", ebuf, "showsettings");
	}

	/* get the right SYSTEM line from the .passwd file */

	snprintf (pwfn, sizeof(pwfn), "%s/upsset.passwd", CONFPATH);
	pwf = fopen (pwfn, "r");

	if (!pwf)
		errorpage ("Configuration error", "Password file missing",
			   "showsettings");

	upspw = NULL;
	while (fgets(buf, sizeof(buf), pwf)) {
		buf [strlen(buf) - 1] = '\0';

		if (buf[0] == '#')	/* ignore comments */
			continue;

		if (!strncmp(buf, "SYSTEM", 6)) {
			sscanf (buf, "%*s %s %s", upsn, tmppw);
			if (!strcmp(upsn, ups)) {
				upspw = strdup (tmppw);
				break;
			}
		}
	}

	fclose (pwf);

	if (!upspw) {
		char	ebuf[SMALLBUF];

		snprintf (ebuf, sizeof(ebuf), "SYSTEM entry for UPS %s not found, check your upsset.passwd",
		          ups);
		errorpage ("Configuration error", ebuf, "showsettings");
	}

	do_header("Saving settings");
	start_table();
	upsvar = firstuv;

	snprintf (buf, sizeof(buf), "PASSWORD %s\n", upspw);
	upssendraw (fd, buf);

	/* eat the response */
	upsreadraw (fd, buf, sizeof(buf));

	printf ("<TR><TD><PRE>\n");

	while (upsvar) {
		getupsvarfd(fd, upsname, upsvar->var, buf, sizeof(buf));

		if (strcmp(upsvar->value, buf)) {
			printf ("set %s to %s (now %s)\n", upsvar->var, 
			         upsvar->value, buf);

			if (upsname)
				snprintf (buf, sizeof(buf), "SET %s@%s %s\n", 
				          upsvar->var, upsname, upsvar->value);
			else
				snprintf (buf, sizeof(buf), "SET %s %s\n", 
				          upsvar->var, upsvar->value);

			upssendraw (fd, buf);
			upsreadraw (fd, buf, sizeof(buf));

			/* TODO: clean this up */
			printf ("response: %s\n", buf);
		}

		upsvar = upsvar->next;
	}

	printf ("</PRE></TD></TR>\n");

	printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
	do_pickups(desc, "showsettings");
	printf ("</TD></TR>\n");

	printf ("</TABLE>\n");
	printf ("</TD></TR></TABLE>\n");
	printf ("</BODY></HTML>\n");

	exit (0);
}

void initial_pickups (void)
{
	do_header("Select a UPS");
	start_table();

	printf ("<TR><TD ALIGN=\"CENTER\" COLSPAN=2>\n");
	do_pickups(NULL, "");
	printf ("</TD></TR>\n");

	printf ("</TABLE>\n");
	printf ("</TD></TR></TABLE>\n");
	printf ("</BODY></HTML>\n");
	exit (0);
}

int main (int argc, char **argv)
{
	username = password = function = ups = NULL;

	printf ("Content-type: text/html\n\n");

	extractpostargs();

	checkauth();

	if (!strcmp(function, "pickups"))
		initial_pickups();

	if (!strcmp(function, "showsettings"))
		showsettings();

	if (!strcmp(function, "savesettings"))
		savesettings();

#if 0		/* FUTURE */
	if (!strcmp(function, "showstatus"))
		showstatus();
#endif

	if (!strcmp(function, "showcmds"))
		showcmds();

	if (!strcmp(function, "docmd"))
		docmd();

	printf ("Error: Unhandled function name [%s]\n", function);
	
	return (0);
}
