/* upsmon.h - headers and other useful things for upsmon.h

   Copyright (C) 2000  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

/* flags for ups->status */

#define ST_ONLINE       0x01
#define ST_ONBATT       0x02
#define ST_LOWBATT      0x04  
#define ST_FSD		0x08
#define ST_MASTER       0x10
#define ST_ALIVE        0x20
#define ST_LOGIN        0x40  
#define ST_FIRST	0x80

/* required contents of flag file */
#define SDMAGIC "upsmon-shutdown-file"  

/* UPS tracking structure */

typedef struct {
	int     fd;   
	char    *sys;
	char    *upsname;
	char    *host; 
	int     pv;
	char    *pw;  
	int     status;
	time_t	lastpoll;
	time_t	lastrbwarn;
	void    *next;
}	utype;

/* notify identifiers */

#define NOTIFY_ONLINE	0
#define NOTIFY_ONBATT	1
#define NOTIFY_LOWBATT	2
#define NOTIFY_FSD	3
#define NOTIFY_COMMOK	4
#define NOTIFY_COMMBAD	5
#define NOTIFY_SHUTDOWN	6
#define NOTIFY_REPLBATT	7

/* notify flag values */

#define NOTIFY_IGNORE	1		/* don't do anything		    */
#define NOTIFY_SYSLOG	2		/* send the msg to the syslog	    */
#define NOTIFY_WALL	4		/* send the msg to all users	    */
#define NOTIFY_EXEC	8		/* send the msg to NOTIFYCMD script */

struct {
	int	type;
	char	*name;
	char	*msg;
	int	flags;
}	notifylist[] =
{
	{ NOTIFY_ONLINE, "ONLINE", "UPS %s on line power", 0 },
	{ NOTIFY_ONBATT, "ONBATT", "UPS %s on battery", 0 },
	{ NOTIFY_LOWBATT, "LOWBATT", "UPS %s battery is critical", 0 },
	{ NOTIFY_FSD, "FSD", "UPS %s: forced shutdown in progress", 0 },
	{ NOTIFY_COMMOK, "COMMOK", "Communications with UPS %s established", 0 },
	{ NOTIFY_COMMBAD, "COMMBAD", "Communications with UPS %s lost", 0 },
	{ NOTIFY_SHUTDOWN, "SHUTDOWN", "Auto logout and shutdown proceeding", 0},
	{ NOTIFY_REPLBATT, "REPLBATT", "UPS %s battery needs to be replaced", 0 },
	{ 0, NULL, NULL, 0 }
};
