/* upsct - simple "client" to test read/write variable access

   Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              
*/

#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "common.h"
#include "upsfetch.h"
#include "proto.h"

	int	fd;

void do_enum (char *varname)
{
	char	out[SMALLBUF], temp[SMALLBUF];

	snprintf (out, sizeof(out), "ENUM %s\n", varname);
	upssendraw (fd, out);

	upsreadraw (fd, temp, sizeof(temp));
	if (strncmp(temp, "ENUM", 4) != 0) {
		printf ("Bogus reply from server for %s\n", varname);
		return;
	}

	upsreadraw (fd, temp, sizeof(temp));

	while (strcmp(temp, "END") != 0) {
		printf ("Option: %s\n", strstr(temp, "\""));
		upsreadraw (fd, temp, sizeof(temp));
	}
}

void usage (char *prog)
{
	printf ("usage: %s [-s <varname>] <ups>\n", prog);
	exit (1);
}

void do_setvar (char *varname, int fd, char *upsname, char *pw)
{
	char	newval[SMALLBUF], temp[SMALLBUF];
	char *ptr;

	if (pw == NULL)
		pw = getpass ("Password: " );


	/* Check if varname is in VAR=VALUE form */
	if ((ptr = strchr(varname, '=')) != NULL) {
		*ptr++ = 0;
		strcpy(newval, ptr);
	} else {
		printf ("Enter new value for %s: ", varname);
		fflush (stdout);
		fgets (newval, sizeof(newval), stdin);
		newval[strlen(newval) - 1] = '\0';
	}

	snprintf (temp, sizeof(temp), "PASSWORD %s\n", pw);
	upssendraw (fd, temp);
	if (upsreadraw (fd, temp, sizeof(temp)) < 0) {
		printf ("Set password failed: %s\n", upsstrerror(upserror));
		exit (1);
	}

	snprintf (temp, sizeof(temp), "SET %s %s\n", varname, newval);
	upssendraw (fd, temp);
	if (upsreadraw (fd, temp, sizeof(temp)) < 0) {
		printf ("Set variable failed: %s\n", upsstrerror(upserror));
		exit (1);
	}

	exit (0);
}	

int main (int argc, char **argv)
{
	char	*upsname, *ptr, *host, vars[SMALLBUF], temp[SMALLBUF], out[SMALLBUF], *v,
		type[16], *setvar, *prog, *pw;
	int	typelen, i;

	setvar = NULL;
	pw = NULL;
	prog = argv[0];

	while ((i = getopt(argc, argv, "+s:p:")) != EOF) {
		switch (i) {
		case 's':
			setvar = strdup(optarg);
			break;
		case 'p':
			pw = strdup(optarg);
			break;
		default:
			usage (prog);
			break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc < 1)
		usage(prog);

	/* handle upsname@hostname syntax and split up parts */
	ptr = strstr (argv[0], "@");
	if (ptr != NULL) {
		ptr[0] = 0;
		upsname = argv[0];
		host = ptr + 1;
	}
	else {
		upsname = NULL;
		host = argv[0];
	}

	fd = upsconnect (host);
	if (fd < 0) {
		printf ("Unable to connect to %s - %s\n", host,
		        upsstrerror(upserror));
		exit (1);
	}

	if (setvar)
		do_setvar (setvar, fd, upsname, pw);

	printf ("host: %s\n", host);

	if (upsname) {
		char	buf[SMALLBUF];

		snprintf (buf, sizeof(buf), "LISTRW %s\n", upsname);
		upssendraw (fd, buf);
	}
	else
		upssendraw (fd, "LISTRW\n");
	
	if (upsreadraw (fd, vars, sizeof(vars)) < 0) {
		printf ("Unable to get variable list - %s\n",
		        upsstrerror(upserror));
		exit (1);
	}

	v = vars;
	ptr = strchr (v, ' ');
	if (!ptr) {
		printf ("Broken string from server: %s\n", vars);
		exit (1);
	}

	*ptr++ = '\0';
	v = ptr;

	/* possibly skip '@ups' */
	if (ptr[0] == '@') {
		ptr = strchr (ptr, ' ');
		if (!ptr) {
			printf ("No R/W variables available on this UPS.\n");
			exit (0);
		}
		ptr++;
		v = ptr;
	}

	while (v != NULL) {
		ptr = strchr (v, ' ');
		if (ptr)
			*ptr++ = '\0';

		/* get description */
		snprintf (out, sizeof(out), "VARDESC %s\n", v);
		upssendraw (fd, out);
		upsreadraw (fd, temp, sizeof(temp));
		printf ("[%s] %s ", v, strstr(temp, "\""));

		/* now get type */
		snprintf (out, sizeof(out), "VARTYPE %s\n", v);
		upssendraw (fd, out);
		upsreadraw (fd, temp, sizeof(temp));
		sscanf (temp, "%*s %s %i", type, &typelen); 
		printf ("(%s:%i)\n", type, typelen);

		if (!strcmp(type, "ENUM"))
			do_enum (v);

		if (!strcmp(type, "STRING")) {
			getupsvarfd (fd, upsname, v, temp, sizeof(temp));
			printf ("Value: %s\n", temp);
		}
		
		v = ptr;
	}
	
	return (0);
}
