/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include<string.h>
#include<stdio.h>
#include "ds.h"

int insert_char_into_str(string, chr, posn, maxlen)
char *string, *chr;
int posn, maxlen;
{
    int i, len;
    if (posn < 0) {
	debug("Attempt to insert char into -ve string posn (%d)\n",
		posn);
	return 0;
    }
    if (posn > MAX_LINE_LEN) {
	debug("Attempt to insert char into too large a string posn (%d)\n",
		posn);
	return 0;
    }
    printf("string before: >%s<", string);
    len = strlen(string);
    if (len == 0) {
	string[0] = chr[0];
	string[1] = '\0';
    } else if (len == maxlen) {
	for (i = len - 2; i >= posn; i--) {
	    string[i + 1] = string[i];
	}
	string[posn] = chr[0];
	string[maxlen - 1] = '\0';
    } else {
	for (i = len - 1; i >= posn; i--) {
	    string[i + 1] = string[i];
	}
	string[posn] = chr[0];
	for (i = len + 1; i < maxlen; i++) {
	    string[i] = '\0';
	}
    }
    printf("string after: >%s<", string);
    return (strlen(string));
}

int delete_char_from_str(string, posn)
char *string;
int posn;
{
    int i, len;
    len = strlen(string);
    if (len < posn) {
	debug("incorrect attempt to delete char from string\n");
	return 1;
    } else {
	for (i = posn; i < len; i++) {
	    string[i] = string[i + 1];
	}
	string[len - 1] = '\0';
    }
    return (strlen(string));
}
