#define UNUSED(x) (x=x)

#include "nt.h"
#include "ds.h"
#include "protocol.h"
#include "participants.h"
#include "sliding_key.h"
#include "missing.h"
#include "www_prototypes.h"
#include "recent.h"
#include <search.h>
#include <stdlib.h>

#ifndef WIN32
/* compiler warning fix*/
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#else
extern int gethostname(char*,int);
#endif
#endif

/* jim fix for main.c compiler warnings.*/
extern int Set_Key(const char*);
extern int rx_sock_init(char* dhost, int videoserverport, int t_flag);
extern int tx_sock_init(char* dhost, int videoserverport,int  t_flag);
extern int ui_init(int, char**, char*);
extern void init_bitmaps();
extern int ui_create_interface(int rx_fd,int participants);
extern int count_participants_packets(struct in_addr addr);

/*iohandler.c*/
void linksocket(int fd, int mask, Tcl_FileProc* callback);

/*crypt/random.c*/
#ifndef WIN32
void lbl_srandom(int seed);

#endif

int lbl_random(void);

/*crypt/crypt.c*/
u_char* Encrypt(u_char*, int*);
int Decrypt( const u_char*, u_char*, int);
int Null_Key();

/*bitmaps.c*/
void init_bitmap();

/*time.c*/
void get_cur_time(struct timeval *t);
void clock_sync(struct timeval *t);
int newer(struct timeval *t1, struct timeval *t2);
void time_copy(struct timeval *t1, struct timeval *t2);
void htontime(struct timeval *t1, struct timeval *t2);
void ntohtime(struct timeval *t1, struct timeval *t2);
unsigned int subtract_time(struct timeval *t1, struct timeval *t2);
void add_time(struct timeval *t1, struct timeval *t2, struct timeval *tr);
void diff_time(struct timeval *t1, struct timeval *t2, struct timeval *tr);

/*sliding_key.c*/
void init_key(sliding_key *skey, u_int16 *lkey);
u_int16 get_key();
void reset_sliding_key(sliding_key *skey, int conf_size);
void init_rtx_token(sliding_key *skey);
void send_rtx_token();
void slide_rtx_key(sliding_key *skey);
void seen_another_sliding_key(struct timeval *t);
void hold_key();
int get_conf_size();

/*participants.c*/
void init_participant_list(p_list *pl, u_int8 col);
void add_receiver_to_participants(user_data *ud, char name[], u_int8 col,
				  struct timeval *t);
void rm_receiver_from_participants(user_data *ud);
void timeout_participants();
void reset_participants();
participant *get_participant(user_data *ud, p_list *pl);
participant *get_participant_by_number(int num, p_list *pl);
int get_participant_number(user_data *ud, p_list *pl);
void add_participant(user_data *ud, char *name, u_int8 col,
		     struct timeval *t, p_list *pl);
void rm_participant(participant *pt, p_list *pl);
int keep_userlist(int flag);
void save_participants(FILE *file, p_list *pl);

/*user_fns.c*/
void user_copy(user_data *src, user_data *dst);
void ntohuser(user_data *src, user_data *dst);
void htonuser(user_data *src, user_data *dst);
int user_cmp(user_data *src, user_data *dst);
void init_local_user(user_data *me);
int is_a_null_name(user_data *name);
void set_null_name(user_data *name);


/*ids.c*/
void generate_id(char *id);
void generate_pointer_id(char *id, char *type);
void htonid(char *idstr, netid *nid);
void ntohid(netid *nid, char *idstr);

/*recent.c*/
void send_recent_list(int fd);
void init_recent_list(recent_list *rl);
void add_to_recent_list(char *id, struct timeval *t, int type);
int is_in_recent_list(char *id);
int posn_in_recent_list(char *id);
int find_oldest_recent_entry();

/*missing.c*/
void init_missing_list(missing_list *ml);
void add_to_missing_list(char *id, int type);
void rm_from_missing_list(char *id);
int number_missing();
int is_in_missing_list(char *id);
int posn_in_missing_list(char *id);
char *get_missing_id(int index);

/*jip.c*/
int joinipgroup(int sock, char *group, char *interfac);

/*init.c*/
document *init_document();
page *init_page(struct timeval *t, page *prev, page *next);
block *init_block(char *blockid,
		  u_int8 status,
		  u_int8 x,
		  u_int16 y,
		  struct timeval *t,
		  block *prev, block *next,
		  user_data *originator, user_data *modifier,
		  typeface *tface);
line *init_line(char *lineid, int lnum, struct timeval *t, 
		line *prev, char *previd, line *next, char *nextid);
int init_ds();

/*network_setup.c*/
unsigned short getlocalport(int tx_fd);

/*network_write.c*/
int xsocksend(int fd, ntheader *header, unsigned char * buf, int len);

/*network_read*/
int xsockrecv();

/*parse_packet.c*/
int parse_line(netline *nl, struct timeval *t);
int parse_block(netblock *nb, struct timeval *t);
int parse_rtx_advert(netrtxadvert *nrtxa,
		 struct in_addr *remote_addr,
		 struct timeval *t);

int parse_rtx_request(netrtxrequest *nrtxr, struct timeval *t);
int parse_rtx_specific_request(netrtxspecificrequest *nrtxr);
int parse_page_request(netpagerequest *nrtxr);
int parse_session_message(netsession *sm);
int parse_leave_message(netsession *sm);
int parse_pointer(netpointer *np);
int parse_recent_list(netrecentadvert *nra);
/* + new checksum functions*/
int parse_page_info(netpageinfo *npi);
int parse_blockinfo_request(netblockinforequest *nbir);
int parse_blockinfo_request2(void);
int parse_blockinfo(netblockinfo *nbi);
int parse_blockrtx_request(netblockrtxrequest *nbrr);

/*protocol.c*/
int send_queued_packet();
void init_header(ntheader *header, unsigned char type, struct timeval *t);
void init_queue(queue *q);
int send_line(int fd, line *l, block *b);
int send_block(int fd, block *b);
int send_pointer(int fd, pointer *p);
int packets_queued(queue *q);
int in_queue(queue *q, char *id);
int print_queue(queue *q);
void add_to_queue(queue *q,
		  char *id,
		  void *buf,
		  int type);
void *get_from_queue(queue *q,
		     int *type,
		     char *id);
void delete_from_queue(queue *q,
		       char *id);
void queue_packet_for_sending(int fd, void *l, char *id, queue *q, int type);
void send_rtx_request(struct in_addr *remote_addr, struct timeval *t);
void send_specific_rtx_request(struct in_addr *remote_addr);
void send_page_request(struct in_addr *remote_addr);
void send_session_message();
void send_jim_rtx();
void send_leave_message();
/* + extra checksum functions*/
void send_blockinfo_request(block *b, struct in_addr *target);
void send_blockinfo(block *b);
void send_blockinfo_request2(struct in_addr *target);		/* new to checksum version 2 */
void send_block_rtx_request(char id[ID_LEN], struct in_addr *source);
void send_page_info();


/*rtx.c*/
void send_retransmissions(struct timeval *after_time);
void send_specific_retransmission(char *id);
int print_ds();

/*ui_fns.c*/
int uigetustimeofday();
int ui_new_block(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_new_line(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_line(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_delete_line(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_delete_block(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_undelete_block(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_find_line_len(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_find_block_len(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_findblock(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_load_text_file(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_save_text_file(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_generate_id(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_block_colour(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_block_font(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_block_posn(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_get_creator(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_get_modifier(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_get_modification_time(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_get_lock_status(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_get_my_lock_status(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_lock_mode(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_send_shared_pointer(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_my_colour(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_keep_userlist(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_save_struct_file(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_load_struct_file(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_quit();
int ui_get_participant_by_number(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_encryption_key(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_reset_participants(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
/*int ui_cut_block(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);*/
int ui_copy_block(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_paste_block();
int ui_get_block_length(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_get_max_block_size(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_set_checksum_status(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
int ui_active_block(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

/*ds_fns.c*/
void get_last_mod_time(page *p, struct timeval *t);
block *find_block_by_id(page *p, char *blockid);
line *find_line_by_id(char *lineid, block *b);
line *find_last_line(block *b);
int count_lines(block *b);
void find_best_place_for_line(block *b,
			 u_int16 lnum,
			 line **prevlp, line **nextlp);
void delete_line(line *l, block *b);
int print_blocks(page *p);
void calc_line_checksum(line *l);
void calc_block_checksum(block *b);
void calc_page_checksum(page *p);

/*text_pane.c*/
int ds_to_text(page_text *text, page *p);
line *find_line(block *b, int y);
u_int16 find_line_num(block *b, char *lineid);
u_int8 find_line_len(block *b, int y);
u_int16 find_block_len(block *b);
block *findblock(char *blockid,
		 page *p,
		 u_int8 x,
		 u_int16 y);
void redisplay_block(block *b);
int renumber_block(block *b);
void delayed_redisplay_block(block *b);

/*typeface_fns.c*/
void typeface_copy(typeface *src, typeface *dst);

/*save_struct*/
int save_struct_file(FILE *file, page *p);
int load_struct_file(FILE *file);

/* debug.c*/
void debug(const char *fmt, ...);

#ifdef SUNOS4
int printf();
int fprintf();
int sscanf();
ENTRY *hsearch(ENTRY item, ACTION action);
int setsockopt(int s, int level, int optname,
          const char *optval, int optlen);
void perror(const char *s);
int select();
int fclose(FILE *stream);
int fflush(FILE *stream);
int hcreate (size_t mekments);
int recvfrom();
struct hostent *gethostbyname(const char *name);
int socket(int domain, int type, int protocol);
int bind();
int connect();
int gethostname(char *name, int namelen);
#endif

