/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <string.h>
#include <search.h>
#include "prototypes.h"
#ifdef WIN32
#include "global.h"
#include "md5.h"
#else
#include "global.h"
#include "md5.h"
#include <stdlib.h>
#endif

#define PARANOIA
/*#define ABORT */
extern void abort();

void get_last_mod_time(p, t)
page *p;
struct timeval *t;
{
    time_copy(&(p->last_mod), t);
}

block *find_block_by_id(p, blockid)
page *p;
char *blockid;
{
    block *b;
    static char cacheblockid[ID_LEN];
    static block *cacheblock = NULL;
#ifdef PARANOIA
    ENTRY *item, searchitem;
#endif
    /*keep a one block cache to speed this up somewhat */
    if (strncmp(cacheblockid, blockid, ID_LEN) == 0) {
	return cacheblock;
    }
    if (p->first_block == NULL)
	return NULL;
    else
	b = p->first_block;
    while (strncmp(b->blockid, blockid, ID_LEN) != 0) {
	if (b->next_block == NULL) {
	    debug("no block called >%s<\n", blockid);
#ifdef ABORT
	    if (strcmp(blockid, "NULL") == 0)
		abort();
#endif
	    return NULL;
	} else
	    b = b->next_block;
    }
#ifdef PARANOIA
    searchitem.key = blockid;
    item = hsearch(searchitem, FIND);
    if ((item != NULL) && ((block *) (item->data) != (block *) b)) {
	if (strcmp(((block *) (item->data))->blockid, b->blockid) == 0) {
	    fprintf(stderr, "Paranoia check in ds_fns.c - got a duplicated block\n %s != %s\n", ((block *) (item->data))->blockid, b->blockid);

	    fprintf(stderr,"paranoia in ds_fns.c failed\n");
	    fprintf(stderr,"*item->data information :\n");
	    fprintf(stderr,"~first Line : %s\n", ((block *) (item->data))->first_line->lineid);
	    fprintf(stderr,"~x,y : %d,%d\n", ((block *) (item->data))->xpos, ((block *) (item->data))->ypos);
	    fprintf(stderr,"~status %d\n", ((block *) (item->data))->status);
	    fprintf(stderr,"no of lines %d\n", ((block *) (item->data))->no_of_lines);
	    fprintf(stderr,"*b information :\n");
	    fprintf(stderr,"~first line : %s\n", ((block *) b)->first_line->lineid);
	    fprintf(stderr,"~x,y : %d,%d\n", ((block *) b)->xpos, ((block *) b)->ypos);
	    fprintf(stderr,"~status %d\n", ((block *) b)->status);
	    fprintf(stderr,"~no of lines %d\n", ((block *) b)->no_of_lines);
	    if (newer(&((block *) (item->data))->last_mod, &((block *) b)->last_mod)) {
		fprintf(stderr,"~hashed is later than linked list timeval\n");
	    } else {
		fprintf(stderr,"~linked list is later than hashed timeval\n");
	    }			/* end if/else */
		fprintf(stderr,"\n\nPlease mail this error message and, if possible, an explanation\nof what user-action caused it to nte@cs.ucl.ac.uk.\n");
	    abort();
	} else {
	    printf("Hash failed with block id >%s<\n", blockid);
#ifdef ABORT
	    abort();
#endif
	}
    }
#endif
    cacheblock = b;
    strncpy(cacheblockid, blockid, ID_LEN);

    return b;
}

line *find_line_by_id(lineid, b)
char *lineid;
block *b;
{
    line *l;
    static char cachelineid[ID_LEN];
    static line *cacheline = NULL;

    /*keep a one line cache to speed up repeated accesses */
    if (strncmp(cachelineid, lineid, ID_LEN) == 0) {
#ifdef NOTDEF
	printf("find_line_by_id returning cache entry %x\n", cacheline);
#endif
	return cacheline;
    }
    if (b == NULL) {
	printf("Trying to find line in null block\n");
	return NULL;
    }
    if (b->first_line == NULL)
	return NULL;
    else
	l = b->first_line;
    while (strncmp(l->lineid, lineid, ID_LEN) != 0) {
	if (l->next_line == NULL)
	    return NULL;
	else
	    l = l->next_line;
    }
    cacheline = l;
    strncpy(cachelineid, lineid, ID_LEN);
    return l;
}


line *find_last_line(b)
block *b;
{
    line *l;
    if (b == NULL) {
	printf("Trying to find line in null block\n");
	return NULL;
    }
    if (b->first_line == NULL)
	return NULL;
    else
	l = b->first_line;
    while ((l->next_line) != NULL) {
	l = l->next_line;
    }
    return l;
}

int count_lines(block * b)
{
    line *l;
    int lines = 0;
    if (b == NULL) {
	printf("Trying to find line in null block\n");
	return 0;
    }
    if (b->first_line == NULL)
	return 0;
    else {
	l = b->first_line;
    }

    while (l != NULL) {
	if (l->linenum != LINE_DELETED)
	    lines++;		/* don't count deleted lines. */
	l = l->next_line;
    }

    return lines;
}

void find_best_place_for_line(block * b, u_int16 lnum, line ** prevlp,
			      line ** nextlp)
{

    line *l;

    debug("Trying to find the best place for a line\n");
    if (b == NULL) {
	debug("Trying to find line in null block\n");	/* no block, no answer */
	*prevlp = NULL;
	*nextlp = NULL;
	return;
    }
    if (b->first_line == NULL) {
	debug("No previous lines\n");	/* no other lines in block */
	*prevlp = NULL;
	*nextlp = NULL;
	return;
    } else {
	l = b->first_line;
    }

    while (1) {
	if ((l->linenum != LOCAL_LINE) & (l->linenum > lnum)) {
	    /*we've gone one past where we wanted to be */
	    if (l->prev_line == NULL) {
		*prevlp = NULL;
		debug("best place for line is start\n");
	    } else {
		/* I am assuming that this code is designed to insert the line before l as this */
		/*  is what the rest of the code suggests - but the debug message confuses things */
		debug("uh oh bit - best place for line is after line %x\n", l->lineid);
		*prevlp = l->prev_line;
/******* WRONG - unless insertion before l*/
	    }
	    *nextlp = l;
/******* WRONG - unless insertion before l*/
	    return;
	}
	if (l->next_line != NULL)
	    l = l->next_line;	/* we're going to check out the next line in this block */
	else {

	    /* we've reached the end of the block, so stick the line at the end of it. */
	    debug("best place for line is end\n");
	    *prevlp = l;
	    *nextlp = NULL;	/* this looks ok. */
	    return;
	}

    }				/* end while(1) */
}

void delete_line(l, b)
line *l;
block *b;
{
    /*this doesn't actually delete anything - it just moves the line to
       the end of the block's list to get it out of the way */
    line *last, *prev, *next;	/* local pointers to last line in block plus the */
    /*    previous and next lines of the current line. */

    if (l == NULL)
	return;			/* if the line to del and block to del from are null */
    if (b == NULL)
	return;			/*     return straight away */

    debug("deleting line - just moving it to the end of the block..\n");

    last = find_last_line(b);	/* last points at the last line of b */

    if (last == l) {		/* if this is the last line - job's done */

	if (b->no_of_lines == 0) {
	    debug("delete line2 - b->no_of_lines = 0 already\n");
	} else {
	    b->no_of_lines--;	/* and decrease the number of lines in b */
	}


	if (l->linenum != LINE_DELETED)
	    debug(" last line del - line number = %s\n", l->linenum);
	else
	    debug(" last line del\n");
	return;
    }
    prev = l->prev_line;	/* store l's next and previous line pointers */
    next = l->next_line;
    last->next_line = l;	/* add l to end of block and amend correct pointers */
    l->prev_line = last;
    l->next_line = NULL;

    if (prev != NULL)
	prev->next_line = next;	/* splice l out of the list structure */
    if (next != NULL)
	next->prev_line = prev;


    if (b->no_of_lines == 0) {
	debug("delete line2 - b->no_of_lines = 0 already\n");
    } else {
	b->no_of_lines--;	/* and decrease the number of lines in b */
    }



    if (l->linenum != LINE_DELETED)
	debug("deleted line has line number = %s\n", l->linenum);
    else
	debug(" line del\n");
}

int print_blocks(page * p)
{
    block *b;
    b = p->first_block;
    while (b != NULL) {
	if (b->first_line == NULL) {
	    debug(" *** oooh,, nooo,   print_blocks -> no first line ***\n");
	    debug(" *** in block %s from originator %s ***\n", b->blockid, b->originator.username);
	} else {

	}
	if (b->status == DELETED)
	    debug(" < Block is a deleted block >\n");
	else
	    debug(" < Block is not a deleted block >\n");

	b = b->next_block;
    }
    return 0;
}

/* All new, improved, Jim functions to calculate checksums of line, block and page 
   each function calculates the appropriate checksum of the data item and stores
   it in the data item's checksum field */

void calc_line_checksum(line * l)
{

    char hash[20];
    MD5_CTX context;

    if (l == NULL) {
	debug("line checksum calculation - using a null line, so not bothering.\n");
	return;
    }				/* end if */
    MD5Init(&context);		/* create our context */

    if (l->line_data != NULL)
	MD5Update(&context, (u_char *) l->line_data, strlen(l->line_data));

    MD5Final((u_char *) hash, &context);

    strncpy(l->checksum, hash, 18);	/* this line's checksum - only need first 16 chars, but */
    /* store 18 anyway. */

    debug("calculated line checksum for line %s = %s\n", l->lineid, l->checksum);

    /* NOTE - will possibly use status instead of linenum to store linedeleted soon, so will */
    /*    need to store status then - NOTE this won't happen because this would remove */
    /*    compatibility with previous versions of nte. */

}

void calc_block_checksum(block * b)
{

    char hash[20];
    MD5_CTX context;
    char buffer1[20];
    char buffer2[20];
    char buffer3[20];
    line *l;

    if (b == NULL) {
	debug("calc block checksum - received a null block pointer, so not bothering\n");
	return;
    }
    MD5Init(&context);		/* create our context */

    b->rtx_status = NORMAL_RTX;

    /* checksums of all lines in it, block status, x&y pos */
    l = b->first_line;

    /* for checksum version 2, I have decided not to use deleted lines in the checksum
       We are only worried about the visible part of the block. I also made the decision
       to ignore deleted lines because I have no assurances of their order in the block 
       (i.e. depends on the order in which they are deleted which can vary from block to 
       block */

    while ((l != NULL) && (l->linenum != LINE_DELETED)) {
	calc_line_checksum(l);
	MD5Update(&context, (u_char *) l->checksum, 16);
	debug("calc_block_checksum - added line with checksum %s and strlen %d\n", l->checksum, strlen(l->checksum));
	l = l->next_line;
    }

    sprintf(buffer1, "%d", b->xpos);
    sprintf(buffer2, "%d", b->ypos);
    sprintf(buffer3, "%d", b->status);

    debug("x,y,status:%s,%s,%s:\n", buffer1, buffer2, buffer3);

    MD5Update(&context, (u_char *) buffer1, strlen(buffer1));
    MD5Update(&context, (u_char *) buffer2, strlen(buffer2));
    MD5Update(&context, (u_char *) buffer3, strlen(buffer3));

    MD5Final((u_char *) hash, &context);

    strncpy(b->checksum, hash, 18);

    debug("calculated checksum for block %s as %s\n", b->blockid, b->checksum);
}


void calc_page_checksum(page * p)
{				/* updated for version 2 */

    block *b;
    char hash[20];
    MD5_CTX context;

    MD5Init(&context);

    b = p->first_block;

    /* parse blocks in order.. */
    /* CODE MISSING HERE TO ENSURE ORDERING-DON'T CHANGE ORDER OF BLOCKS (it affects hashing ), 
       JUST THE ORDER IN WHICH WE INTERPRET THEM */

    while (b != NULL) {
	calc_block_checksum(b);

	MD5Update(&context, (u_char *) b->checksum, 16);
	debug("calc_page_checksum adding block %s with csum %s\n", b->blockid, b->checksum);
	b = b->next_block;
    }
    MD5Final((u_char *) hash, &context);

    strncpy(p->checksum, hash, 16);
    debug("calculated page's checksum as %s\n", p->checksum);
/* end of take 1 */
}
