/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disc cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#ifdef HAVE_FNMATCH
#include <fnmatch.h>
#else
#include "fnmatch.h"
#endif

#include "nls.h"
#include "apassign.h"
#include "gprop.h"
#include "gui_tools.h"
#include "nscache.h"

#include "pixmaps/stock_append.xpm"
#include "pixmaps/stock_close.xpm"
#include "pixmaps/stock_delete.xpm"
#include "pixmaps/stock_modify.xpm"
#include "pixmaps/stock_ok.xpm"

static GtkWidget *alist,*mentry,*aentry,*uentry;
static GtkWidget *apassign_window = NULL;

static apassign default_viewers[] = {
	{"text/plain", "gless %f", "gnome-moz-remote \'%u\'"} ,
	{"text/plain", "xterm -e more %f", "xterm -e lynx \'%u\'"} ,
	{"text/html", "gnome-moz-remote %f", "gnome-moz-remote \'%u\'"} ,
	{"text/html", "xterm -e lynx %f", "xterm -e lynx \'%u\'"} ,
	{"image/*", "gqview %f", "gnome-moz-remote \'%u\'"} ,
	{"image/*", "ee %f", "netscape \'%u\'"} ,
	{"*/*", "gnome-moz-remote %f", "gnome-moz-remote \'%u\'"} ,
	{"*/*", "netscape %f", "netscape \'%u\'"} ,
	{"*/*", "xterm -e lynx %f", "xterm -e lynx \'%u\'"} ,
	{NULL, NULL, NULL} ,
};

GSList *apassign_data;

GSList *apassign_get_matching_viewers(mtype)
char *mtype;
{
	GSList *rv = NULL;
	GSList *ptr;

	for (ptr = apassign_data; ptr; ptr = ptr->next)
	{
		apassign *ve = ptr->data;

		if (!fnmatch(ve->mimetype, mtype, 0))
			rv = g_slist_append(rv, ve);
	}

	return rv;
}

static void fill_list()
{
	GSList *ptr;

	gtk_clist_freeze(GTK_CLIST(alist));

	ptr = apassign_data;
	while(ptr)
	{
		apassign *ad = (apassign *)ptr->data;
		char *p[3];

		p[0] = ad->mimetype;
		p[1] = ad->fapplication;
		p[2] = ad->uapplication;

		gtk_clist_append(GTK_CLIST(alist) , p);
		ptr = ptr->next;
	}

	gtk_clist_thaw(GTK_CLIST(alist));
}

static void Ok(w, data)
GtkWidget *w;
gpointer data;
{
	guint i;

	while(apassign_data)
	{
		apassign *ad = (apassign *)apassign_data->data;

		g_free(ad->mimetype);
		g_free(ad->fapplication);
		g_free(ad->uapplication);
		g_free(ad);

		apassign_data = g_slist_remove_link(apassign_data, apassign_data);
	}

	for (i = 0 ; i < GTK_CLIST(alist)->rows; i++)
	{
		char *p;
		apassign *ad = (apassign *)g_malloc(sizeof(apassign));

		p = NULL;
		gtk_clist_get_text(GTK_CLIST(alist), i, 0, &p);
		ad->mimetype = g_strdup(p);
		p = NULL;
		gtk_clist_get_text(GTK_CLIST(alist), i, 1, &p);
		ad->fapplication = g_strdup(p);
		p = NULL;
		gtk_clist_get_text(GTK_CLIST(alist), i, 2, &p);
		ad->uapplication = g_strdup(p);
		
		apassign_data = g_slist_append(apassign_data, ad);
	}

	save_rc();

	AdjustMenu();

	gtk_widget_destroy(GTK_WIDGET(data));
}

static void Append(w, data)
GtkWidget *w;
gpointer data;
{
	char *p[3];

	p[0] = gtk_entry_get_text(GTK_ENTRY(mentry));
	p[1] = gtk_entry_get_text(GTK_ENTRY(aentry));
	p[2] = gtk_entry_get_text(GTK_ENTRY(uentry));

	if (!*p[0]) p[0] = NULL;
	if (!*p[1]) p[1] = NULL;
	if (!*p[2]) p[2] = NULL;

	if (p[0] && (p[1] || p[2]))
	{
		gtk_clist_append(GTK_CLIST(alist) , p);
	}
	else
	{
		gdk_beep();
	}
}

static void Modify(w, data)
GtkWidget *w;
gpointer data;
{
	char *p[3];

	if (!GTK_CLIST(alist)->selection)
		return;

	p[0] = gtk_entry_get_text(GTK_ENTRY(mentry));
	p[1] = gtk_entry_get_text(GTK_ENTRY(aentry));
	p[2] = gtk_entry_get_text(GTK_ENTRY(uentry));

	if (!*p[0]) p[0] = NULL;
	if (!*p[1]) p[1] = NULL;
	if (!*p[2]) p[2] = NULL;

	if (p[0] && (p[1] || p[2]))
	{
		guint row;

		row = GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data);

		gtk_clist_set_text(GTK_CLIST(alist) , row , 0 , p[0]); 
		gtk_clist_set_text(GTK_CLIST(alist) , row , 1 , p[1]); 
		gtk_clist_set_text(GTK_CLIST(alist) , row , 2 , p[2]); 
	}
	else
	{
		gdk_beep();
	}
}

static void Delete(w, data)
GtkWidget *w;
gpointer data;
{
	gtk_clist_freeze(GTK_CLIST(alist));

	while(GTK_CLIST(alist)->selection)
	{
		gtk_clist_remove (GTK_CLIST(alist) , 
			GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data));
	}

	gtk_clist_thaw(GTK_CLIST(alist));
}

static void ListClick(w, data)
GtkWidget *w;
gpointer data;
{
	gchar *p;

	p = NULL;
	gtk_clist_get_text(GTK_CLIST(alist) ,
		GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data), 0 , &p);
	gtk_entry_set_text(GTK_ENTRY(mentry) , p);

	p = NULL;
	gtk_clist_get_text(GTK_CLIST(alist) ,
		GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data), 1 , &p);
	if (p) gtk_entry_set_text(GTK_ENTRY(aentry) , p);
	else gtk_entry_set_text(GTK_ENTRY(aentry) , p);

	p = NULL;
	gtk_clist_get_text(GTK_CLIST(alist) ,
		GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data), 2 , &p);
	if (p) gtk_entry_set_text(GTK_ENTRY(uentry) , p);
	else gtk_entry_set_text(GTK_ENTRY(uentry) , "");
}

void apassign_run()
{
	if (!apassign_window)
	{
		GtkWidget *tbox,*frame,*box,*swin,*pbox,*button,*sep;
		GList *ptr;

		apassign_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_container_set_border_width(GTK_CONTAINER(apassign_window), 4);
		gtk_window_set_title(GTK_WINDOW(apassign_window) , gettext("NScache: assign applications to MIME types"));
		gtk_widget_realize(apassign_window);

		gtk_signal_connect(GTK_OBJECT (apassign_window), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &apassign_window);

		tbox = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(apassign_window), tbox);
		gtk_widget_show(tbox);

		frame = gtk_frame_new(NULL);
		gtk_box_pack_start(GTK_BOX(tbox) , frame , TRUE , TRUE , 1);
		gtk_widget_show(frame);

		box = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(box);

		swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_widget_show(swin);
		gtk_widget_set_usize(swin, -1, 180);
		gtk_box_pack_start(GTK_BOX(box) , swin , TRUE , TRUE , 1);

		alist = gtk_clist_new(3);
		gtk_clist_set_selection_mode(GTK_CLIST(alist), GTK_SELECTION_SINGLE);
		gtk_clist_set_reorderable(GTK_CLIST(alist), TRUE);
		gtk_clist_set_column_title(GTK_CLIST(alist), 0 , gettext("MIME type"));
		gtk_clist_set_column_title(GTK_CLIST(alist), 1 , gettext("File viewer"));
		gtk_clist_set_column_title(GTK_CLIST(alist), 2 , gettext("URL viewer"));
		gtk_clist_column_titles_show(GTK_CLIST(alist));
		gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 0 , TRUE);
		gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 1 , TRUE);
		gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 2 , TRUE);
		gtk_container_add(GTK_CONTAINER(swin), alist);
		gtk_widget_show(alist);
		fill_list();

		gtk_signal_connect(GTK_OBJECT(alist) , "select_row" ,
			GTK_SIGNAL_FUNC(ListClick) , NULL);

		pbox = gtk_table_new(2, 3, FALSE);
		gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, FALSE, 2);
		gtk_widget_show(pbox);

		ptr = search_get_available_types();
		mentry = guitl_tab_add_combo(pbox, gettext("MIME type: "),
			ptr, 0, 0, TRUE);
		mentry = GTK_COMBO(mentry)->entry;
		_free_list(ptr);

		gtk_signal_connect(GTK_OBJECT(mentry) , "activate" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		aentry = guitl_tab_add_entry(pbox,
			gettext("File viewer application: "), 0, 1, FALSE);

		gtk_signal_connect(GTK_OBJECT(aentry) , "activate" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		uentry = guitl_tab_add_entry(pbox,
			gettext("URL viewer application: "), 0, 2, FALSE);

		gtk_signal_connect(GTK_OBJECT(aentry) , "activate" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		sep = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(box), sep, FALSE, FALSE, 2);
		gtk_widget_show(sep);

		pbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(pbox), GTK_BUTTONBOX_SPREAD);
		gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, FALSE, 2);
 		gtk_widget_show(pbox);

		button = guitl_pixmap_button(stock_append_xpm, gettext("Append"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		button = guitl_pixmap_button(stock_modify_xpm, gettext("Modify"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Modify) , NULL);

		button = guitl_pixmap_button(stock_delete_xpm, gettext("Delete"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Delete) , NULL);

		pbox = gtk_hbutton_box_new();
		gtk_box_pack_start(GTK_BOX(tbox), pbox, FALSE, FALSE, 2);
 		gtk_widget_show(pbox);

		button = guitl_pixmap_button(stock_ok_xpm, gettext("Ok"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Ok) , apassign_window);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		gtk_widget_show(button);

		button = guitl_pixmap_button(stock_close_xpm, gettext("Cancel"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(guitl_CloseWin), apassign_window);

	}
	gtk_widget_show(apassign_window);
	gdk_window_raise(apassign_window->window);
}

int apassign_cmp(ap, mt)
apassign *ap;
char *mt;
{
	return strcasecmp(ap->mimetype , mt);
}

static int check_program(prog)
char *prog;
{
	int rv = FALSE;
	char *p;

	p = g_getenv("PATH");
	if (p)
	{
		int i;
		char **vec = g_strsplit(p, ":", 100);

		for (i = 0; vec && vec[i]; i++)
		{
			p = g_strconcat(vec[i], "/", prog, NULL);
			rv = !access(p, X_OK);
			g_free(p);
			if (rv)
				break;
		}
		g_strfreev(vec);
	}
	return rv;
}

void assign_default_viewers()
{
	int i;

	for (i = 0; default_viewers[i].mimetype; i++)
	{
		if (!g_slist_find_custom(apassign_data,
			default_viewers[i].mimetype,(GCompareFunc)apassign_cmp))
		{
			char *fap,*uap;

			fap = g_strndup(default_viewers[i].fapplication,
				strcspn(default_viewers[i].fapplication, " "));

			uap = g_strndup(default_viewers[i].uapplication,
				strcspn(default_viewers[i].uapplication, " "));

			if (check_program(fap) && check_program(uap))
			{
				apassign *na;

				na = g_malloc(sizeof(apassign));
				na->mimetype = g_strdup(default_viewers[i].mimetype);
				na->fapplication = g_strdup(default_viewers[i].fapplication);
				na->uapplication = g_strdup(default_viewers[i].uapplication);

				apassign_data = g_slist_append(apassign_data, na);
			}
		}
	}

	gprop_set_bool("have_viewers", TRUE);
}

