#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "nls.h"
#include "apassign.h"

static GtkWidget *alist,*mentry,*aentry,*uentry;
static GtkWidget *apassign_window = NULL;

GSList *apassign_data;

extern void gui_err(char *);
extern void save_rc();

GtkWidget *pixmap_button(pm, label)
char **pm;
char *label;
{
	GtkWidget *btn;

	if (pm)
	{
		GtkWidget *pixmap=NULL;
		GdkPixmap *pmp;
		GdkBitmap *mask;
		GtkWidget *box;
		GtkWidget *lbl;

		btn = gtk_button_new();

		pmp = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(btn)->window , &mask , NULL , pm);

		if (pmp)
			pixmap = gtk_pixmap_new(pmp , mask);

		box = gtk_hbox_new(FALSE , 1);
		gtk_container_add(GTK_CONTAINER(btn) , box);
		gtk_widget_show(box);

		gtk_box_pack_start(GTK_BOX(box) , pixmap , TRUE , TRUE , 0);
		gtk_misc_set_alignment(GTK_MISC(pixmap) , 1.0 , 0.5);
		gtk_widget_show(pixmap);

		lbl = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(lbl) , 0.0 , 0.5);
		gtk_box_pack_start(GTK_BOX(box) , lbl , TRUE , TRUE , 0);
		gtk_widget_show(lbl);
                
	}
	else
	{
		btn = gtk_button_new_with_label(label);
	}

	return btn;
}

static void fill_list()
{
	GSList *ptr;

	gtk_clist_freeze(GTK_CLIST(alist));

	ptr = apassign_data;
	while(ptr)
	{
		apassign *ad = (apassign *)ptr->data;
		char *p[3];

		p[0] = ad->mimetype;
		p[1] = ad->fapplication;
		p[2] = ad->uapplication;

		gtk_clist_append(GTK_CLIST(alist) , p);
		ptr = ptr->next;
	}

	gtk_clist_thaw(GTK_CLIST(alist));
}

static void CloseWin(w, data)
GtkWidget *w;
gpointer data;
{
	gtk_widget_hide(GTK_WIDGET(data));
}

static void Ok(w, data)
GtkWidget *w;
gpointer data;
{
	guint i;

	while(apassign_data)
	{
		apassign *ad = (apassign *)apassign_data->data;

		g_free(ad->mimetype);
		g_free(ad->fapplication);
		g_free(ad->uapplication);
		g_free(ad);

		apassign_data = g_slist_remove_link(apassign_data, apassign_data);
	}

	for (i = 0 ; i < GTK_CLIST(alist)->rows; i++)
	{
		char *p;
		apassign *ad = (apassign *)g_malloc(sizeof(apassign));

		gtk_clist_get_text(GTK_CLIST(alist), i, 0, &p);
		ad->mimetype = g_strdup(p);
		gtk_clist_get_text(GTK_CLIST(alist), i, 1, &p);
		ad->fapplication = g_strdup(p);
		gtk_clist_get_text(GTK_CLIST(alist), i, 2, &p);
		ad->uapplication = g_strdup(p);
		
		apassign_data = g_slist_append(apassign_data, ad);
	}

	save_rc();

	gtk_widget_hide(GTK_WIDGET(data));
}

static void Append(w, data)
GtkWidget *w;
gpointer data;
{
	char *p[3];

	p[0] = gtk_entry_get_text(GTK_ENTRY(mentry));
	p[1] = gtk_entry_get_text(GTK_ENTRY(aentry));
	p[2] = gtk_entry_get_text(GTK_ENTRY(uentry));

	if (!*p[0]) p[0] = NULL;
	if (!*p[1]) p[1] = NULL;
	if (!*p[2]) p[2] = NULL;

	if (p[0] && (p[1] || p[2]))
	{
		gtk_clist_append(GTK_CLIST(alist) , p);
	}
	else
	{
		gdk_beep();
	}
}

static void Modify(w, data)
GtkWidget *w;
gpointer data;
{
	char *p[3];

	p[0] = gtk_entry_get_text(GTK_ENTRY(mentry));
	p[1] = gtk_entry_get_text(GTK_ENTRY(aentry));
	p[2] = gtk_entry_get_text(GTK_ENTRY(uentry));

	if (!*p[0]) p[0] = NULL;
	if (!*p[1]) p[1] = NULL;
	if (!*p[2]) p[2] = NULL;

	if (p[0] && (p[1] || p[2]))
	{
		guint row;

		row = GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data);

		gtk_clist_set_text(GTK_CLIST(alist) , row , 0 , p[0]); 
		gtk_clist_set_text(GTK_CLIST(alist) , row , 1 , p[1]); 
		gtk_clist_set_text(GTK_CLIST(alist) , row , 2 , p[2]); 
	}
	else
	{
		gdk_beep();
	}
}

static void Delete(w, data)
GtkWidget *w;
gpointer data;
{
	gtk_clist_freeze(GTK_CLIST(alist));

	while(GTK_CLIST(alist)->selection)
	{
		gtk_clist_remove (GTK_CLIST(alist) , 
			GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data));
	}

	gtk_clist_thaw(GTK_CLIST(alist));
}

static void ListClick(w, data)
GtkWidget *w;
gpointer data;
{
	gchar *p;

	gtk_clist_get_text(GTK_CLIST(alist) ,
		GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data), 0 , &p);
	gtk_entry_set_text(GTK_ENTRY(mentry) , p);

	gtk_clist_get_text(GTK_CLIST(alist) ,
		GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data), 1 , &p);
	gtk_entry_set_text(GTK_ENTRY(aentry) , p);

	gtk_clist_get_text(GTK_CLIST(alist) ,
		GPOINTER_TO_INT(GTK_CLIST(alist)->selection->data), 2 , &p);
	gtk_entry_set_text(GTK_ENTRY(uentry) , p);
}

void apassign_run()
{
	if (!apassign_window)
	{
		GtkWidget *tbox,*frame,*box,*swin,*pbox,*label,*button;

		apassign_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(apassign_window) , gettext("NScache: assign applications to MIME types"));
		gtk_widget_realize(apassign_window);

		gtk_signal_connect(GTK_OBJECT (apassign_window), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), apassign_window);

		tbox = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(apassign_window), tbox);
		gtk_widget_show(tbox);

		frame = gtk_frame_new(NULL);
		gtk_box_pack_start(GTK_BOX(tbox) , frame , TRUE , TRUE , 1);
		gtk_widget_show(frame);

		box = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(frame), box);
		gtk_widget_show(box);

		swin = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_widget_show(swin);
		gtk_widget_set_usize(swin, -1, 180);
		gtk_box_pack_start(GTK_BOX(box) , swin , TRUE , TRUE , 1);

		alist = gtk_clist_new(3);
		gtk_clist_set_selection_mode(GTK_CLIST(alist) , GTK_SELECTION_SINGLE);
		gtk_clist_set_column_title(GTK_CLIST(alist), 0 , gettext("MIME type"));
		gtk_clist_set_column_title(GTK_CLIST(alist), 1 , gettext("File viewer"));
		gtk_clist_set_column_title(GTK_CLIST(alist), 2 , gettext("URL viewer"));
		gtk_clist_column_titles_show(GTK_CLIST(alist));
		gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 0 , TRUE);
		gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 1 , TRUE);
		gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 2 , TRUE);
		gtk_container_add(GTK_CONTAINER(swin), alist);
		gtk_widget_show(alist);
		fill_list();

		gtk_signal_connect(GTK_OBJECT(alist) , "select_row" ,
			GTK_SIGNAL_FUNC(ListClick) , NULL);

		pbox = gtk_hbox_new(FALSE , 3);
		gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, FALSE, 2);
		gtk_widget_show(pbox);

		label = gtk_label_new(gettext("MIME type: "));
		gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, FALSE, 2);
		gtk_widget_show(label);

		mentry = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(pbox), mentry, TRUE, TRUE, 2);
		gtk_widget_show(mentry);

		gtk_signal_connect(GTK_OBJECT(mentry) , "activate" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		pbox = gtk_hbox_new(FALSE , 3);
		gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, FALSE, 2);
		gtk_widget_show(pbox);

		label = gtk_label_new(gettext("File viewer application: "));
		gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, FALSE, 2);
		gtk_widget_show(label);

		aentry = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(pbox), aentry, TRUE, TRUE, 2);
		gtk_widget_show(aentry);

		gtk_signal_connect(GTK_OBJECT(aentry) , "activate" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		pbox = gtk_hbox_new(FALSE , 3);
		gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, FALSE, 2);
		gtk_widget_show(pbox);

		label = gtk_label_new(gettext("URL viewer application: "));
		gtk_box_pack_start(GTK_BOX(pbox), label, FALSE, FALSE, 2);
		gtk_widget_show(label);

		uentry = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(pbox), uentry, TRUE, TRUE, 2);
		gtk_widget_show(uentry);

		gtk_signal_connect(GTK_OBJECT(aentry) , "activate" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		pbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(pbox), GTK_BUTTONBOX_SPREAD);
		gtk_box_pack_start(GTK_BOX(box), pbox, FALSE, FALSE, 2);
 		gtk_widget_show(pbox);

		button = pixmap_button(NULL ,gettext("Append"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Append) , NULL);

		button = pixmap_button(NULL,gettext("Modify"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Modify) , NULL);

		button = pixmap_button(NULL,gettext("Delete"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Delete) , NULL);

		pbox = gtk_hbutton_box_new();
		gtk_button_box_set_layout(GTK_BUTTON_BOX(pbox), GTK_BUTTONBOX_SPREAD);
		gtk_box_pack_start(GTK_BOX(tbox), pbox, FALSE, FALSE, 2);
 		gtk_widget_show(pbox);

		button = pixmap_button(NULL,gettext("Ok"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(Ok) , apassign_window);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		gtk_widget_show(button);

		button = pixmap_button(NULL,gettext("Cancel"));
		gtk_container_border_width(GTK_CONTAINER(button), 0);
		gtk_container_add(GTK_CONTAINER(pbox), button);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_show(button);

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" ,
				GTK_SIGNAL_FUNC(CloseWin) , apassign_window);

	}
	gtk_widget_show(apassign_window);
	gdk_window_raise(apassign_window->window);
}

int apassign_cmp(ap, mt)
apassign *ap;
char *mt;
{
	return strcasecmp(ap->mimetype , mt);
}

