#
# tcl/ex/newmcast/cmcast-200.tcl
#
# Copyright (C) 1997 by USC/ISI
# All rights reserved.                                            
#                                                                
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation, advertising
# materials, and other materials related to such distribution and use
# acknowledge that the software was developed by the University of
# Southern California, Information Sciences Institute.  The name of the
# University may not be used to endorse or promote products derived from
# this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# Contributed by Polly Huang (USC/ISI), http://www-scf.usc.edu/~bhuang
# 
#
# Generated by sgb2nsctr, sgb2nsctr created by Polly Huang
# GRAPH (#nodes #edges id uu vv ww xx yy zz):
# 200 7986 geo(0,{200,100,3,0.200,0.250,75.000}) 100 

set verbose 1
set ns [new Simulator]
Simulator set EnableMcast_ 1
Simulator set NumberInterfaces_ 1
Node expandaddr
set g [Node allocaddr]

if {$verbose} { puts "creating 200 nodes..." }
for {set i 0} {$i < 200} {incr i} {
	set n($i) [$ns node]
}

# EDGES (from-node to-node length a b):
if {$verbose} { puts -nonewline "Creating links 0..."; flush stdout }
$ns duplex-link $n(0) $n(191) 1.5Mb 320ms DropTail
$ns duplex-link $n(0) $n(190) 1.5Mb 680ms DropTail
$ns duplex-link $n(0) $n(185) 1.5Mb 340ms DropTail
$ns duplex-link $n(0) $n(183) 1.5Mb 600ms DropTail
$ns duplex-link $n(0) $n(179) 1.5Mb 350ms DropTail
$ns duplex-link $n(0) $n(178) 1.5Mb 190ms DropTail
$ns duplex-link $n(0) $n(176) 1.5Mb 370ms DropTail
$ns duplex-link $n(0) $n(175) 1.5Mb 520ms DropTail
$ns duplex-link $n(0) $n(172) 1.5Mb 570ms DropTail
$ns duplex-link $n(0) $n(167) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "10..."; flush stdout }
$ns duplex-link $n(0) $n(162) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(155) 1.5Mb 370ms DropTail
$ns duplex-link $n(0) $n(150) 1.5Mb 400ms DropTail
$ns duplex-link $n(0) $n(148) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(139) 1.5Mb 360ms DropTail
$ns duplex-link $n(0) $n(134) 1.5Mb 420ms DropTail
$ns duplex-link $n(0) $n(132) 1.5Mb 210ms DropTail
$ns duplex-link $n(0) $n(130) 1.5Mb 560ms DropTail
$ns duplex-link $n(0) $n(116) 1.5Mb 600ms DropTail
$ns duplex-link $n(0) $n(114) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "20..."; flush stdout }
$ns duplex-link $n(0) $n(100) 1.5Mb 260ms DropTail
$ns duplex-link $n(0) $n(95) 1.5Mb 410ms DropTail
$ns duplex-link $n(0) $n(89) 1.5Mb 480ms DropTail
$ns duplex-link $n(0) $n(78) 1.5Mb 390ms DropTail
$ns duplex-link $n(0) $n(76) 1.5Mb 280ms DropTail
$ns duplex-link $n(0) $n(72) 1.5Mb 180ms DropTail
$ns duplex-link $n(0) $n(66) 1.5Mb 230ms DropTail
$ns duplex-link $n(0) $n(64) 1.5Mb 530ms DropTail
$ns duplex-link $n(0) $n(59) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(58) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "30..."; flush stdout }
$ns duplex-link $n(0) $n(51) 1.5Mb 640ms DropTail
$ns duplex-link $n(0) $n(13) 1.5Mb 470ms DropTail
$ns duplex-link $n(0) $n(7) 1.5Mb 480ms DropTail
$ns duplex-link $n(1) $n(195) 1.5Mb 840ms DropTail
$ns duplex-link $n(1) $n(183) 1.5Mb 320ms DropTail
$ns duplex-link $n(1) $n(180) 1.5Mb 840ms DropTail
$ns duplex-link $n(1) $n(177) 1.5Mb 1010ms DropTail
$ns duplex-link $n(1) $n(173) 1.5Mb 870ms DropTail
$ns duplex-link $n(1) $n(159) 1.5Mb 620ms DropTail
$ns duplex-link $n(1) $n(156) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "40..."; flush stdout }
$ns duplex-link $n(1) $n(147) 1.5Mb 640ms DropTail
$ns duplex-link $n(1) $n(138) 1.5Mb 510ms DropTail
$ns duplex-link $n(1) $n(119) 1.5Mb 750ms DropTail
$ns duplex-link $n(1) $n(115) 1.5Mb 240ms DropTail
$ns duplex-link $n(1) $n(111) 1.5Mb 210ms DropTail
$ns duplex-link $n(1) $n(96) 1.5Mb 520ms DropTail
$ns duplex-link $n(1) $n(92) 1.5Mb 600ms DropTail
$ns duplex-link $n(1) $n(88) 1.5Mb 600ms DropTail
$ns duplex-link $n(1) $n(87) 1.5Mb 350ms DropTail
$ns duplex-link $n(1) $n(74) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "50..."; flush stdout }
$ns duplex-link $n(1) $n(73) 1.5Mb 820ms DropTail
$ns duplex-link $n(1) $n(71) 1.5Mb 700ms DropTail
$ns duplex-link $n(1) $n(63) 1.5Mb 820ms DropTail
$ns duplex-link $n(1) $n(61) 1.5Mb 320ms DropTail
$ns duplex-link $n(1) $n(51) 1.5Mb 80ms DropTail
$ns duplex-link $n(1) $n(48) 1.5Mb 720ms DropTail
$ns duplex-link $n(1) $n(38) 1.5Mb 790ms DropTail
$ns duplex-link $n(1) $n(36) 1.5Mb 870ms DropTail
$ns duplex-link $n(1) $n(35) 1.5Mb 940ms DropTail
$ns duplex-link $n(1) $n(12) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "60..."; flush stdout }
$ns duplex-link $n(1) $n(8) 1.5Mb 700ms DropTail
$ns duplex-link $n(2) $n(197) 1.5Mb 740ms DropTail
$ns duplex-link $n(2) $n(195) 1.5Mb 720ms DropTail
$ns duplex-link $n(2) $n(182) 1.5Mb 740ms DropTail
$ns duplex-link $n(2) $n(172) 1.5Mb 500ms DropTail
$ns duplex-link $n(2) $n(168) 1.5Mb 970ms DropTail
$ns duplex-link $n(2) $n(163) 1.5Mb 470ms DropTail
$ns duplex-link $n(2) $n(162) 1.5Mb 720ms DropTail
$ns duplex-link $n(2) $n(161) 1.5Mb 1020ms DropTail
$ns duplex-link $n(2) $n(145) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "70..."; flush stdout }
$ns duplex-link $n(2) $n(140) 1.5Mb 220ms DropTail
$ns duplex-link $n(2) $n(133) 1.5Mb 770ms DropTail
$ns duplex-link $n(2) $n(127) 1.5Mb 760ms DropTail
$ns duplex-link $n(2) $n(122) 1.5Mb 290ms DropTail
$ns duplex-link $n(2) $n(116) 1.5Mb 130ms DropTail
$ns duplex-link $n(2) $n(112) 1.5Mb 390ms DropTail
$ns duplex-link $n(2) $n(105) 1.5Mb 830ms DropTail
$ns duplex-link $n(2) $n(102) 1.5Mb 490ms DropTail
$ns duplex-link $n(2) $n(101) 1.5Mb 160ms DropTail
$ns duplex-link $n(2) $n(95) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "80..."; flush stdout }
$ns duplex-link $n(2) $n(93) 1.5Mb 980ms DropTail
$ns duplex-link $n(2) $n(92) 1.5Mb 780ms DropTail
$ns duplex-link $n(2) $n(78) 1.5Mb 750ms DropTail
$ns duplex-link $n(2) $n(74) 1.5Mb 900ms DropTail
$ns duplex-link $n(2) $n(49) 1.5Mb 470ms DropTail
$ns duplex-link $n(2) $n(48) 1.5Mb 370ms DropTail
$ns duplex-link $n(2) $n(45) 1.5Mb 930ms DropTail
$ns duplex-link $n(2) $n(37) 1.5Mb 540ms DropTail
$ns duplex-link $n(2) $n(34) 1.5Mb 680ms DropTail
$ns duplex-link $n(2) $n(32) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "90..."; flush stdout }
$ns duplex-link $n(2) $n(30) 1.5Mb 1120ms DropTail
$ns duplex-link $n(2) $n(27) 1.5Mb 910ms DropTail
$ns duplex-link $n(2) $n(26) 1.5Mb 990ms DropTail
$ns duplex-link $n(2) $n(18) 1.5Mb 660ms DropTail
$ns duplex-link $n(2) $n(12) 1.5Mb 470ms DropTail
$ns duplex-link $n(2) $n(11) 1.5Mb 840ms DropTail
$ns duplex-link $n(2) $n(6) 1.5Mb 710ms DropTail
$ns duplex-link $n(3) $n(197) 1.5Mb 870ms DropTail
$ns duplex-link $n(3) $n(195) 1.5Mb 890ms DropTail
$ns duplex-link $n(3) $n(193) 1.5Mb 1020ms DropTail
if {$verbose} { puts -nonewline "100..."; flush stdout }
$ns duplex-link $n(3) $n(191) 1.5Mb 860ms DropTail
$ns duplex-link $n(3) $n(172) 1.5Mb 110ms DropTail
$ns duplex-link $n(3) $n(170) 1.5Mb 670ms DropTail
$ns duplex-link $n(3) $n(169) 1.5Mb 810ms DropTail
$ns duplex-link $n(3) $n(164) 1.5Mb 790ms DropTail
$ns duplex-link $n(3) $n(159) 1.5Mb 840ms DropTail
$ns duplex-link $n(3) $n(158) 1.5Mb 720ms DropTail
$ns duplex-link $n(3) $n(150) 1.5Mb 610ms DropTail
$ns duplex-link $n(3) $n(149) 1.5Mb 270ms DropTail
$ns duplex-link $n(3) $n(138) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "110..."; flush stdout }
$ns duplex-link $n(3) $n(132) 1.5Mb 400ms DropTail
$ns duplex-link $n(3) $n(126) 1.5Mb 870ms DropTail
$ns duplex-link $n(3) $n(123) 1.5Mb 120ms DropTail
$ns duplex-link $n(3) $n(113) 1.5Mb 570ms DropTail
$ns duplex-link $n(3) $n(108) 1.5Mb 410ms DropTail
$ns duplex-link $n(3) $n(94) 1.5Mb 350ms DropTail
$ns duplex-link $n(3) $n(81) 1.5Mb 390ms DropTail
$ns duplex-link $n(3) $n(79) 1.5Mb 400ms DropTail
$ns duplex-link $n(3) $n(78) 1.5Mb 940ms DropTail
$ns duplex-link $n(3) $n(73) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "120..."; flush stdout }
$ns duplex-link $n(3) $n(65) 1.5Mb 550ms DropTail
$ns duplex-link $n(3) $n(64) 1.5Mb 170ms DropTail
$ns duplex-link $n(3) $n(63) 1.5Mb 900ms DropTail
$ns duplex-link $n(3) $n(61) 1.5Mb 680ms DropTail
$ns duplex-link $n(3) $n(56) 1.5Mb 640ms DropTail
$ns duplex-link $n(3) $n(53) 1.5Mb 670ms DropTail
$ns duplex-link $n(3) $n(51) 1.5Mb 640ms DropTail
$ns duplex-link $n(3) $n(48) 1.5Mb 300ms DropTail
$ns duplex-link $n(3) $n(45) 1.5Mb 630ms DropTail
$ns duplex-link $n(3) $n(43) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "130..."; flush stdout }
$ns duplex-link $n(3) $n(28) 1.5Mb 570ms DropTail
$ns duplex-link $n(3) $n(25) 1.5Mb 420ms DropTail
$ns duplex-link $n(3) $n(23) 1.5Mb 710ms DropTail
$ns duplex-link $n(3) $n(21) 1.5Mb 670ms DropTail
$ns duplex-link $n(3) $n(18) 1.5Mb 480ms DropTail
$ns duplex-link $n(4) $n(192) 1.5Mb 260ms DropTail
$ns duplex-link $n(4) $n(189) 1.5Mb 710ms DropTail
$ns duplex-link $n(4) $n(160) 1.5Mb 190ms DropTail
$ns duplex-link $n(4) $n(157) 1.5Mb 60ms DropTail
$ns duplex-link $n(4) $n(154) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "140..."; flush stdout }
$ns duplex-link $n(4) $n(151) 1.5Mb 500ms DropTail
$ns duplex-link $n(4) $n(150) 1.5Mb 770ms DropTail
$ns duplex-link $n(4) $n(144) 1.5Mb 560ms DropTail
$ns duplex-link $n(4) $n(143) 1.5Mb 580ms DropTail
$ns duplex-link $n(4) $n(132) 1.5Mb 230ms DropTail
$ns duplex-link $n(4) $n(127) 1.5Mb 290ms DropTail
$ns duplex-link $n(4) $n(126) 1.5Mb 470ms DropTail
$ns duplex-link $n(4) $n(121) 1.5Mb 80ms DropTail
$ns duplex-link $n(4) $n(116) 1.5Mb 930ms DropTail
$ns duplex-link $n(4) $n(107) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "150..."; flush stdout }
$ns duplex-link $n(4) $n(96) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(88) 1.5Mb 320ms DropTail
$ns duplex-link $n(4) $n(85) 1.5Mb 130ms DropTail
$ns duplex-link $n(4) $n(84) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(83) 1.5Mb 640ms DropTail
$ns duplex-link $n(4) $n(70) 1.5Mb 380ms DropTail
$ns duplex-link $n(4) $n(62) 1.5Mb 220ms DropTail
$ns duplex-link $n(4) $n(61) 1.5Mb 160ms DropTail
$ns duplex-link $n(4) $n(60) 1.5Mb 550ms DropTail
$ns duplex-link $n(4) $n(59) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "160..."; flush stdout }
$ns duplex-link $n(4) $n(55) 1.5Mb 40ms DropTail
$ns duplex-link $n(4) $n(54) 1.5Mb 300ms DropTail
$ns duplex-link $n(4) $n(52) 1.5Mb 440ms DropTail
$ns duplex-link $n(4) $n(42) 1.5Mb 320ms DropTail
$ns duplex-link $n(4) $n(34) 1.5Mb 550ms DropTail
$ns duplex-link $n(4) $n(30) 1.5Mb 320ms DropTail
$ns duplex-link $n(4) $n(28) 1.5Mb 810ms DropTail
$ns duplex-link $n(4) $n(27) 1.5Mb 280ms DropTail
$ns duplex-link $n(4) $n(26) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(23) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "170..."; flush stdout }
$ns duplex-link $n(4) $n(21) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(14) 1.5Mb 490ms DropTail
$ns duplex-link $n(4) $n(12) 1.5Mb 360ms DropTail
$ns duplex-link $n(4) $n(11) 1.5Mb 260ms DropTail
$ns duplex-link $n(4) $n(6) 1.5Mb 90ms DropTail
$ns duplex-link $n(5) $n(194) 1.5Mb 160ms DropTail
$ns duplex-link $n(5) $n(181) 1.5Mb 240ms DropTail
$ns duplex-link $n(5) $n(178) 1.5Mb 250ms DropTail
$ns duplex-link $n(5) $n(172) 1.5Mb 200ms DropTail
$ns duplex-link $n(5) $n(167) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "180..."; flush stdout }
$ns duplex-link $n(5) $n(164) 1.5Mb 620ms DropTail
$ns duplex-link $n(5) $n(161) 1.5Mb 710ms DropTail
$ns duplex-link $n(5) $n(160) 1.5Mb 560ms DropTail
$ns duplex-link $n(5) $n(154) 1.5Mb 490ms DropTail
$ns duplex-link $n(5) $n(149) 1.5Mb 420ms DropTail
$ns duplex-link $n(5) $n(146) 1.5Mb 520ms DropTail
$ns duplex-link $n(5) $n(143) 1.5Mb 720ms DropTail
$ns duplex-link $n(5) $n(139) 1.5Mb 60ms DropTail
$ns duplex-link $n(5) $n(124) 1.5Mb 700ms DropTail
$ns duplex-link $n(5) $n(118) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "190..."; flush stdout }
$ns duplex-link $n(5) $n(117) 1.5Mb 140ms DropTail
$ns duplex-link $n(5) $n(110) 1.5Mb 490ms DropTail
$ns duplex-link $n(5) $n(104) 1.5Mb 340ms DropTail
$ns duplex-link $n(5) $n(103) 1.5Mb 840ms DropTail
$ns duplex-link $n(5) $n(101) 1.5Mb 220ms DropTail
$ns duplex-link $n(5) $n(96) 1.5Mb 280ms DropTail
$ns duplex-link $n(5) $n(88) 1.5Mb 230ms DropTail
$ns duplex-link $n(5) $n(84) 1.5Mb 730ms DropTail
$ns duplex-link $n(5) $n(76) 1.5Mb 650ms DropTail
$ns duplex-link $n(5) $n(73) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "200..."; flush stdout }
$ns duplex-link $n(5) $n(69) 1.5Mb 380ms DropTail
$ns duplex-link $n(5) $n(65) 1.5Mb 350ms DropTail
$ns duplex-link $n(5) $n(62) 1.5Mb 710ms DropTail
$ns duplex-link $n(5) $n(54) 1.5Mb 230ms DropTail
$ns duplex-link $n(5) $n(40) 1.5Mb 230ms DropTail
$ns duplex-link $n(5) $n(14) 1.5Mb 750ms DropTail
$ns duplex-link $n(5) $n(8) 1.5Mb 110ms DropTail
$ns duplex-link $n(6) $n(197) 1.5Mb 500ms DropTail
$ns duplex-link $n(6) $n(189) 1.5Mb 620ms DropTail
$ns duplex-link $n(6) $n(185) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "210..."; flush stdout }
$ns duplex-link $n(6) $n(183) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(178) 1.5Mb 210ms DropTail
$ns duplex-link $n(6) $n(177) 1.5Mb 620ms DropTail
$ns duplex-link $n(6) $n(172) 1.5Mb 560ms DropTail
$ns duplex-link $n(6) $n(171) 1.5Mb 330ms DropTail
$ns duplex-link $n(6) $n(163) 1.5Mb 240ms DropTail
$ns duplex-link $n(6) $n(159) 1.5Mb 400ms DropTail
$ns duplex-link $n(6) $n(154) 1.5Mb 530ms DropTail
$ns duplex-link $n(6) $n(153) 1.5Mb 690ms DropTail
$ns duplex-link $n(6) $n(149) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "220..."; flush stdout }
$ns duplex-link $n(6) $n(148) 1.5Mb 80ms DropTail
$ns duplex-link $n(6) $n(147) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(141) 1.5Mb 280ms DropTail
$ns duplex-link $n(6) $n(134) 1.5Mb 590ms DropTail
$ns duplex-link $n(6) $n(133) 1.5Mb 430ms DropTail
$ns duplex-link $n(6) $n(132) 1.5Mb 140ms DropTail
$ns duplex-link $n(6) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(6) $n(130) 1.5Mb 260ms DropTail
$ns duplex-link $n(6) $n(126) 1.5Mb 440ms DropTail
$ns duplex-link $n(6) $n(114) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "230..."; flush stdout }
$ns duplex-link $n(6) $n(113) 1.5Mb 590ms DropTail
$ns duplex-link $n(6) $n(112) 1.5Mb 330ms DropTail
$ns duplex-link $n(6) $n(111) 1.5Mb 280ms DropTail
$ns duplex-link $n(6) $n(110) 1.5Mb 210ms DropTail
$ns duplex-link $n(6) $n(102) 1.5Mb 220ms DropTail
$ns duplex-link $n(6) $n(84) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(76) 1.5Mb 460ms DropTail
$ns duplex-link $n(6) $n(69) 1.5Mb 160ms DropTail
$ns duplex-link $n(6) $n(68) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(60) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "240..."; flush stdout }
$ns duplex-link $n(6) $n(46) 1.5Mb 550ms DropTail
$ns duplex-link $n(6) $n(42) 1.5Mb 400ms DropTail
$ns duplex-link $n(6) $n(40) 1.5Mb 420ms DropTail
$ns duplex-link $n(6) $n(39) 1.5Mb 400ms DropTail
$ns duplex-link $n(6) $n(38) 1.5Mb 470ms DropTail
$ns duplex-link $n(6) $n(35) 1.5Mb 580ms DropTail
$ns duplex-link $n(6) $n(30) 1.5Mb 410ms DropTail
$ns duplex-link $n(6) $n(28) 1.5Mb 720ms DropTail
$ns duplex-link $n(6) $n(26) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(17) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "250..."; flush stdout }
$ns duplex-link $n(7) $n(181) 1.5Mb 770ms DropTail
$ns duplex-link $n(7) $n(164) 1.5Mb 610ms DropTail
$ns duplex-link $n(7) $n(161) 1.5Mb 180ms DropTail
$ns duplex-link $n(7) $n(160) 1.5Mb 270ms DropTail
$ns duplex-link $n(7) $n(159) 1.5Mb 500ms DropTail
$ns duplex-link $n(7) $n(153) 1.5Mb 810ms DropTail
$ns duplex-link $n(7) $n(151) 1.5Mb 550ms DropTail
$ns duplex-link $n(7) $n(148) 1.5Mb 200ms DropTail
$ns duplex-link $n(7) $n(147) 1.5Mb 410ms DropTail
$ns duplex-link $n(7) $n(146) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "260..."; flush stdout }
$ns duplex-link $n(7) $n(141) 1.5Mb 130ms DropTail
$ns duplex-link $n(7) $n(140) 1.5Mb 710ms DropTail
$ns duplex-link $n(7) $n(138) 1.5Mb 340ms DropTail
$ns duplex-link $n(7) $n(136) 1.5Mb 40ms DropTail
$ns duplex-link $n(7) $n(128) 1.5Mb 640ms DropTail
$ns duplex-link $n(7) $n(123) 1.5Mb 550ms DropTail
$ns duplex-link $n(7) $n(121) 1.5Mb 160ms DropTail
$ns duplex-link $n(7) $n(119) 1.5Mb 620ms DropTail
$ns duplex-link $n(7) $n(103) 1.5Mb 310ms DropTail
$ns duplex-link $n(7) $n(100) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "270..."; flush stdout }
$ns duplex-link $n(7) $n(99) 1.5Mb 800ms DropTail
$ns duplex-link $n(7) $n(86) 1.5Mb 590ms DropTail
$ns duplex-link $n(7) $n(85) 1.5Mb 180ms DropTail
$ns duplex-link $n(7) $n(84) 1.5Mb 270ms DropTail
$ns duplex-link $n(7) $n(80) 1.5Mb 440ms DropTail
$ns duplex-link $n(7) $n(72) 1.5Mb 420ms DropTail
$ns duplex-link $n(7) $n(64) 1.5Mb 640ms DropTail
$ns duplex-link $n(7) $n(60) 1.5Mb 600ms DropTail
$ns duplex-link $n(7) $n(59) 1.5Mb 480ms DropTail
$ns duplex-link $n(7) $n(55) 1.5Mb 80ms DropTail
if {$verbose} { puts -nonewline "280..."; flush stdout }
$ns duplex-link $n(7) $n(51) 1.5Mb 170ms DropTail
$ns duplex-link $n(7) $n(48) 1.5Mb 490ms DropTail
$ns duplex-link $n(7) $n(47) 1.5Mb 410ms DropTail
$ns duplex-link $n(7) $n(44) 1.5Mb 80ms DropTail
$ns duplex-link $n(7) $n(43) 1.5Mb 680ms DropTail
$ns duplex-link $n(7) $n(41) 1.5Mb 580ms DropTail
$ns duplex-link $n(7) $n(32) 1.5Mb 830ms DropTail
$ns duplex-link $n(7) $n(26) 1.5Mb 260ms DropTail
$ns duplex-link $n(7) $n(19) 1.5Mb 350ms DropTail
$ns duplex-link $n(7) $n(15) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "290..."; flush stdout }
$ns duplex-link $n(7) $n(11) 1.5Mb 200ms DropTail
$ns duplex-link $n(7) $n(8) 1.5Mb 480ms DropTail
$ns duplex-link $n(8) $n(193) 1.5Mb 910ms DropTail
$ns duplex-link $n(8) $n(168) 1.5Mb 580ms DropTail
$ns duplex-link $n(8) $n(166) 1.5Mb 860ms DropTail
$ns duplex-link $n(8) $n(164) 1.5Mb 690ms DropTail
$ns duplex-link $n(8) $n(154) 1.5Mb 580ms DropTail
$ns duplex-link $n(8) $n(151) 1.5Mb 290ms DropTail
$ns duplex-link $n(8) $n(150) 1.5Mb 520ms DropTail
$ns duplex-link $n(8) $n(148) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "300..."; flush stdout }
$ns duplex-link $n(8) $n(134) 1.5Mb 860ms DropTail
$ns duplex-link $n(8) $n(132) 1.5Mb 320ms DropTail
$ns duplex-link $n(8) $n(130) 1.5Mb 620ms DropTail
$ns duplex-link $n(8) $n(128) 1.5Mb 170ms DropTail
$ns duplex-link $n(8) $n(123) 1.5Mb 70ms DropTail
$ns duplex-link $n(8) $n(121) 1.5Mb 460ms DropTail
$ns duplex-link $n(8) $n(120) 1.5Mb 130ms DropTail
$ns duplex-link $n(8) $n(119) 1.5Mb 350ms DropTail
$ns duplex-link $n(8) $n(108) 1.5Mb 310ms DropTail
$ns duplex-link $n(8) $n(106) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "310..."; flush stdout }
$ns duplex-link $n(8) $n(97) 1.5Mb 480ms DropTail
$ns duplex-link $n(8) $n(85) 1.5Mb 370ms DropTail
$ns duplex-link $n(8) $n(82) 1.5Mb 780ms DropTail
$ns duplex-link $n(8) $n(78) 1.5Mb 830ms DropTail
$ns duplex-link $n(8) $n(76) 1.5Mb 710ms DropTail
$ns duplex-link $n(8) $n(75) 1.5Mb 690ms DropTail
$ns duplex-link $n(8) $n(72) 1.5Mb 560ms DropTail
$ns duplex-link $n(8) $n(70) 1.5Mb 720ms DropTail
$ns duplex-link $n(8) $n(68) 1.5Mb 700ms DropTail
$ns duplex-link $n(8) $n(66) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "320..."; flush stdout }
$ns duplex-link $n(8) $n(65) 1.5Mb 450ms DropTail
$ns duplex-link $n(8) $n(64) 1.5Mb 160ms DropTail
$ns duplex-link $n(8) $n(60) 1.5Mb 320ms DropTail
$ns duplex-link $n(8) $n(52) 1.5Mb 670ms DropTail
$ns duplex-link $n(8) $n(51) 1.5Mb 620ms DropTail
$ns duplex-link $n(8) $n(50) 1.5Mb 200ms DropTail
$ns duplex-link $n(8) $n(44) 1.5Mb 510ms DropTail
$ns duplex-link $n(8) $n(38) 1.5Mb 700ms DropTail
$ns duplex-link $n(8) $n(37) 1.5Mb 710ms DropTail
$ns duplex-link $n(8) $n(34) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "330..."; flush stdout }
$ns duplex-link $n(8) $n(33) 1.5Mb 210ms DropTail
$ns duplex-link $n(8) $n(31) 1.5Mb 410ms DropTail
$ns duplex-link $n(8) $n(28) 1.5Mb 500ms DropTail
$ns duplex-link $n(9) $n(199) 1.5Mb 1070ms DropTail
$ns duplex-link $n(9) $n(193) 1.5Mb 1090ms DropTail
$ns duplex-link $n(9) $n(186) 1.5Mb 170ms DropTail
$ns duplex-link $n(9) $n(184) 1.5Mb 300ms DropTail
$ns duplex-link $n(9) $n(170) 1.5Mb 620ms DropTail
$ns duplex-link $n(9) $n(169) 1.5Mb 680ms DropTail
$ns duplex-link $n(9) $n(167) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "340..."; flush stdout }
$ns duplex-link $n(9) $n(164) 1.5Mb 850ms DropTail
$ns duplex-link $n(9) $n(161) 1.5Mb 480ms DropTail
$ns duplex-link $n(9) $n(159) 1.5Mb 810ms DropTail
$ns duplex-link $n(9) $n(155) 1.5Mb 330ms DropTail
$ns duplex-link $n(9) $n(151) 1.5Mb 590ms DropTail
$ns duplex-link $n(9) $n(149) 1.5Mb 40ms DropTail
$ns duplex-link $n(9) $n(148) 1.5Mb 370ms DropTail
$ns duplex-link $n(9) $n(147) 1.5Mb 370ms DropTail
$ns duplex-link $n(9) $n(142) 1.5Mb 230ms DropTail
$ns duplex-link $n(9) $n(137) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "350..."; flush stdout }
$ns duplex-link $n(9) $n(134) 1.5Mb 1000ms DropTail
$ns duplex-link $n(9) $n(131) 1.5Mb 910ms DropTail
$ns duplex-link $n(9) $n(128) 1.5Mb 510ms DropTail
$ns duplex-link $n(9) $n(127) 1.5Mb 120ms DropTail
$ns duplex-link $n(9) $n(124) 1.5Mb 590ms DropTail
$ns duplex-link $n(9) $n(123) 1.5Mb 410ms DropTail
$ns duplex-link $n(9) $n(114) 1.5Mb 950ms DropTail
$ns duplex-link $n(9) $n(109) 1.5Mb 680ms DropTail
$ns duplex-link $n(9) $n(91) 1.5Mb 780ms DropTail
$ns duplex-link $n(9) $n(87) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "360..."; flush stdout }
$ns duplex-link $n(9) $n(84) 1.5Mb 610ms DropTail
$ns duplex-link $n(9) $n(82) 1.5Mb 980ms DropTail
$ns duplex-link $n(9) $n(78) 1.5Mb 980ms DropTail
$ns duplex-link $n(9) $n(76) 1.5Mb 850ms DropTail
$ns duplex-link $n(9) $n(68) 1.5Mb 710ms DropTail
$ns duplex-link $n(9) $n(61) 1.5Mb 550ms DropTail
$ns duplex-link $n(9) $n(57) 1.5Mb 850ms DropTail
$ns duplex-link $n(9) $n(56) 1.5Mb 690ms DropTail
$ns duplex-link $n(9) $n(51) 1.5Mb 390ms DropTail
$ns duplex-link $n(9) $n(50) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "370..."; flush stdout }
$ns duplex-link $n(9) $n(47) 1.5Mb 200ms DropTail
$ns duplex-link $n(9) $n(39) 1.5Mb 380ms DropTail
$ns duplex-link $n(9) $n(35) 1.5Mb 920ms DropTail
$ns duplex-link $n(9) $n(34) 1.5Mb 890ms DropTail
$ns duplex-link $n(9) $n(11) 1.5Mb 150ms DropTail
$ns duplex-link $n(10) $n(191) 1.5Mb 940ms DropTail
$ns duplex-link $n(10) $n(190) 1.5Mb 400ms DropTail
$ns duplex-link $n(10) $n(189) 1.5Mb 390ms DropTail
$ns duplex-link $n(10) $n(182) 1.5Mb 930ms DropTail
$ns duplex-link $n(10) $n(180) 1.5Mb 60ms DropTail
if {$verbose} { puts -nonewline "380..."; flush stdout }
$ns duplex-link $n(10) $n(175) 1.5Mb 450ms DropTail
$ns duplex-link $n(10) $n(174) 1.5Mb 290ms DropTail
$ns duplex-link $n(10) $n(172) 1.5Mb 70ms DropTail
$ns duplex-link $n(10) $n(171) 1.5Mb 930ms DropTail
$ns duplex-link $n(10) $n(162) 1.5Mb 680ms DropTail
$ns duplex-link $n(10) $n(161) 1.5Mb 870ms DropTail
$ns duplex-link $n(10) $n(158) 1.5Mb 890ms DropTail
$ns duplex-link $n(10) $n(142) 1.5Mb 680ms DropTail
$ns duplex-link $n(10) $n(139) 1.5Mb 280ms DropTail
$ns duplex-link $n(10) $n(138) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "390..."; flush stdout }
$ns duplex-link $n(10) $n(137) 1.5Mb 410ms DropTail
$ns duplex-link $n(10) $n(124) 1.5Mb 900ms DropTail
$ns duplex-link $n(10) $n(122) 1.5Mb 370ms DropTail
$ns duplex-link $n(10) $n(121) 1.5Mb 680ms DropTail
$ns duplex-link $n(10) $n(118) 1.5Mb 590ms DropTail
$ns duplex-link $n(10) $n(115) 1.5Mb 660ms DropTail
$ns duplex-link $n(10) $n(114) 1.5Mb 1000ms DropTail
$ns duplex-link $n(10) $n(113) 1.5Mb 550ms DropTail
$ns duplex-link $n(10) $n(108) 1.5Mb 530ms DropTail
$ns duplex-link $n(10) $n(99) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "400..."; flush stdout }
$ns duplex-link $n(10) $n(98) 1.5Mb 600ms DropTail
$ns duplex-link $n(10) $n(94) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(80) 1.5Mb 280ms DropTail
$ns duplex-link $n(10) $n(79) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(73) 1.5Mb 600ms DropTail
$ns duplex-link $n(10) $n(65) 1.5Mb 570ms DropTail
$ns duplex-link $n(10) $n(62) 1.5Mb 910ms DropTail
$ns duplex-link $n(10) $n(54) 1.5Mb 400ms DropTail
$ns duplex-link $n(10) $n(46) 1.5Mb 550ms DropTail
$ns duplex-link $n(10) $n(45) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "410..."; flush stdout }
$ns duplex-link $n(10) $n(43) 1.5Mb 730ms DropTail
$ns duplex-link $n(10) $n(41) 1.5Mb 990ms DropTail
$ns duplex-link $n(10) $n(40) 1.5Mb 460ms DropTail
$ns duplex-link $n(10) $n(21) 1.5Mb 850ms DropTail
$ns duplex-link $n(11) $n(195) 1.5Mb 840ms DropTail
$ns duplex-link $n(11) $n(188) 1.5Mb 470ms DropTail
$ns duplex-link $n(11) $n(184) 1.5Mb 160ms DropTail
$ns duplex-link $n(11) $n(183) 1.5Mb 30ms DropTail
$ns duplex-link $n(11) $n(176) 1.5Mb 240ms DropTail
$ns duplex-link $n(11) $n(175) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "420..."; flush stdout }
$ns duplex-link $n(11) $n(174) 1.5Mb 320ms DropTail
$ns duplex-link $n(11) $n(171) 1.5Mb 410ms DropTail
$ns duplex-link $n(11) $n(166) 1.5Mb 870ms DropTail
$ns duplex-link $n(11) $n(157) 1.5Mb 300ms DropTail
$ns duplex-link $n(11) $n(154) 1.5Mb 770ms DropTail
$ns duplex-link $n(11) $n(153) 1.5Mb 760ms DropTail
$ns duplex-link $n(11) $n(150) 1.5Mb 840ms DropTail
$ns duplex-link $n(11) $n(149) 1.5Mb 170ms DropTail
$ns duplex-link $n(11) $n(141) 1.5Mb 270ms DropTail
$ns duplex-link $n(11) $n(140) 1.5Mb 750ms DropTail
if {$verbose} { puts -nonewline "430..."; flush stdout }
$ns duplex-link $n(11) $n(139) 1.5Mb 420ms DropTail
$ns duplex-link $n(11) $n(138) 1.5Mb 180ms DropTail
$ns duplex-link $n(11) $n(129) 1.5Mb 380ms DropTail
$ns duplex-link $n(11) $n(128) 1.5Mb 560ms DropTail
$ns duplex-link $n(11) $n(125) 1.5Mb 440ms DropTail
$ns duplex-link $n(11) $n(122) 1.5Mb 550ms DropTail
$ns duplex-link $n(11) $n(115) 1.5Mb 120ms DropTail
$ns duplex-link $n(11) $n(107) 1.5Mb 410ms DropTail
$ns duplex-link $n(11) $n(96) 1.5Mb 330ms DropTail
$ns duplex-link $n(11) $n(94) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "440..."; flush stdout }
$ns duplex-link $n(11) $n(87) 1.5Mb 390ms DropTail
$ns duplex-link $n(11) $n(82) 1.5Mb 890ms DropTail
$ns duplex-link $n(11) $n(80) 1.5Mb 370ms DropTail
$ns duplex-link $n(11) $n(75) 1.5Mb 770ms DropTail
$ns duplex-link $n(11) $n(70) 1.5Mb 640ms DropTail
$ns duplex-link $n(11) $n(69) 1.5Mb 430ms DropTail
$ns duplex-link $n(11) $n(63) 1.5Mb 830ms DropTail
$ns duplex-link $n(11) $n(60) 1.5Mb 610ms DropTail
$ns duplex-link $n(11) $n(54) 1.5Mb 250ms DropTail
$ns duplex-link $n(11) $n(45) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "450..."; flush stdout }
$ns duplex-link $n(11) $n(42) 1.5Mb 490ms DropTail
$ns duplex-link $n(11) $n(35) 1.5Mb 850ms DropTail
$ns duplex-link $n(11) $n(33) 1.5Mb 600ms DropTail
$ns duplex-link $n(11) $n(21) 1.5Mb 290ms DropTail
$ns duplex-link $n(11) $n(19) 1.5Mb 410ms DropTail
$ns duplex-link $n(12) $n(195) 1.5Mb 620ms DropTail
$ns duplex-link $n(12) $n(193) 1.5Mb 750ms DropTail
$ns duplex-link $n(12) $n(189) 1.5Mb 370ms DropTail
$ns duplex-link $n(12) $n(186) 1.5Mb 330ms DropTail
$ns duplex-link $n(12) $n(185) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "460..."; flush stdout }
$ns duplex-link $n(12) $n(180) 1.5Mb 330ms DropTail
$ns duplex-link $n(12) $n(172) 1.5Mb 320ms DropTail
$ns duplex-link $n(12) $n(169) 1.5Mb 590ms DropTail
$ns duplex-link $n(12) $n(157) 1.5Mb 420ms DropTail
$ns duplex-link $n(12) $n(149) 1.5Mb 380ms DropTail
$ns duplex-link $n(12) $n(146) 1.5Mb 360ms DropTail
$ns duplex-link $n(12) $n(143) 1.5Mb 610ms DropTail
$ns duplex-link $n(12) $n(138) 1.5Mb 290ms DropTail
$ns duplex-link $n(12) $n(126) 1.5Mb 600ms DropTail
$ns duplex-link $n(12) $n(119) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "470..."; flush stdout }
$ns duplex-link $n(12) $n(98) 1.5Mb 340ms DropTail
$ns duplex-link $n(12) $n(97) 1.5Mb 310ms DropTail
$ns duplex-link $n(12) $n(96) 1.5Mb 120ms DropTail
$ns duplex-link $n(12) $n(91) 1.5Mb 390ms DropTail
$ns duplex-link $n(12) $n(87) 1.5Mb 410ms DropTail
$ns duplex-link $n(12) $n(86) 1.5Mb 630ms DropTail
$ns duplex-link $n(12) $n(84) 1.5Mb 580ms DropTail
$ns duplex-link $n(12) $n(81) 1.5Mb 140ms DropTail
$ns duplex-link $n(12) $n(79) 1.5Mb 130ms DropTail
$ns duplex-link $n(12) $n(75) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "480..."; flush stdout }
$ns duplex-link $n(12) $n(70) 1.5Mb 550ms DropTail
$ns duplex-link $n(12) $n(69) 1.5Mb 240ms DropTail
$ns duplex-link $n(12) $n(65) 1.5Mb 330ms DropTail
$ns duplex-link $n(12) $n(64) 1.5Mb 300ms DropTail
$ns duplex-link $n(12) $n(63) 1.5Mb 620ms DropTail
$ns duplex-link $n(12) $n(57) 1.5Mb 450ms DropTail
$ns duplex-link $n(12) $n(54) 1.5Mb 130ms DropTail
$ns duplex-link $n(12) $n(53) 1.5Mb 540ms DropTail
$ns duplex-link $n(12) $n(39) 1.5Mb 140ms DropTail
$ns duplex-link $n(12) $n(32) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "490..."; flush stdout }
$ns duplex-link $n(12) $n(30) 1.5Mb 660ms DropTail
$ns duplex-link $n(12) $n(23) 1.5Mb 500ms DropTail
$ns duplex-link $n(12) $n(21) 1.5Mb 570ms DropTail
$ns duplex-link $n(12) $n(20) 1.5Mb 580ms DropTail
$ns duplex-link $n(12) $n(19) 1.5Mb 150ms DropTail
$ns duplex-link $n(12) $n(18) 1.5Mb 250ms DropTail
$ns duplex-link $n(13) $n(197) 1.5Mb 610ms DropTail
$ns duplex-link $n(13) $n(195) 1.5Mb 670ms DropTail
$ns duplex-link $n(13) $n(194) 1.5Mb 650ms DropTail
$ns duplex-link $n(13) $n(192) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "500..."; flush stdout }
$ns duplex-link $n(13) $n(188) 1.5Mb 580ms DropTail
$ns duplex-link $n(13) $n(187) 1.5Mb 530ms DropTail
$ns duplex-link $n(13) $n(186) 1.5Mb 210ms DropTail
$ns duplex-link $n(13) $n(182) 1.5Mb 550ms DropTail
$ns duplex-link $n(13) $n(165) 1.5Mb 300ms DropTail
$ns duplex-link $n(13) $n(148) 1.5Mb 210ms DropTail
$ns duplex-link $n(13) $n(145) 1.5Mb 450ms DropTail
$ns duplex-link $n(13) $n(140) 1.5Mb 710ms DropTail
$ns duplex-link $n(13) $n(137) 1.5Mb 330ms DropTail
$ns duplex-link $n(13) $n(136) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "510..."; flush stdout }
$ns duplex-link $n(13) $n(133) 1.5Mb 420ms DropTail
$ns duplex-link $n(13) $n(131) 1.5Mb 760ms DropTail
$ns duplex-link $n(13) $n(122) 1.5Mb 570ms DropTail
$ns duplex-link $n(13) $n(119) 1.5Mb 640ms DropTail
$ns duplex-link $n(13) $n(113) 1.5Mb 740ms DropTail
$ns duplex-link $n(13) $n(112) 1.5Mb 480ms DropTail
$ns duplex-link $n(13) $n(108) 1.5Mb 320ms DropTail
$ns duplex-link $n(13) $n(95) 1.5Mb 60ms DropTail
$ns duplex-link $n(13) $n(94) 1.5Mb 310ms DropTail
$ns duplex-link $n(13) $n(91) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "520..."; flush stdout }
$ns duplex-link $n(13) $n(87) 1.5Mb 180ms DropTail
$ns duplex-link $n(13) $n(84) 1.5Mb 250ms DropTail
$ns duplex-link $n(13) $n(83) 1.5Mb 710ms DropTail
$ns duplex-link $n(13) $n(75) 1.5Mb 630ms DropTail
$ns duplex-link $n(13) $n(73) 1.5Mb 590ms DropTail
$ns duplex-link $n(13) $n(69) 1.5Mb 320ms DropTail
$ns duplex-link $n(13) $n(56) 1.5Mb 460ms DropTail
$ns duplex-link $n(13) $n(54) 1.5Mb 320ms DropTail
$ns duplex-link $n(13) $n(52) 1.5Mb 510ms DropTail
$ns duplex-link $n(13) $n(51) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "530..."; flush stdout }
$ns duplex-link $n(13) $n(35) 1.5Mb 730ms DropTail
$ns duplex-link $n(13) $n(31) 1.5Mb 760ms DropTail
$ns duplex-link $n(13) $n(16) 1.5Mb 420ms DropTail
$ns duplex-link $n(13) $n(15) 1.5Mb 680ms DropTail
$ns duplex-link $n(14) $n(192) 1.5Mb 520ms DropTail
$ns duplex-link $n(14) $n(187) 1.5Mb 290ms DropTail
$ns duplex-link $n(14) $n(180) 1.5Mb 940ms DropTail
$ns duplex-link $n(14) $n(165) 1.5Mb 660ms DropTail
$ns duplex-link $n(14) $n(156) 1.5Mb 520ms DropTail
$ns duplex-link $n(14) $n(154) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "540..."; flush stdout }
$ns duplex-link $n(14) $n(150) 1.5Mb 740ms DropTail
$ns duplex-link $n(14) $n(147) 1.5Mb 670ms DropTail
$ns duplex-link $n(14) $n(145) 1.5Mb 100ms DropTail
$ns duplex-link $n(14) $n(144) 1.5Mb 100ms DropTail
$ns duplex-link $n(14) $n(143) 1.5Mb 170ms DropTail
$ns duplex-link $n(14) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(14) $n(140) 1.5Mb 610ms DropTail
$ns duplex-link $n(14) $n(133) 1.5Mb 890ms DropTail
$ns duplex-link $n(14) $n(131) 1.5Mb 500ms DropTail
$ns duplex-link $n(14) $n(126) 1.5Mb 20ms DropTail
if {$verbose} { puts -nonewline "550..."; flush stdout }
$ns duplex-link $n(14) $n(118) 1.5Mb 660ms DropTail
$ns duplex-link $n(14) $n(116) 1.5Mb 970ms DropTail
$ns duplex-link $n(14) $n(105) 1.5Mb 740ms DropTail
$ns duplex-link $n(14) $n(93) 1.5Mb 370ms DropTail
$ns duplex-link $n(14) $n(79) 1.5Mb 530ms DropTail
$ns duplex-link $n(14) $n(78) 1.5Mb 210ms DropTail
$ns duplex-link $n(14) $n(74) 1.5Mb 740ms DropTail
$ns duplex-link $n(14) $n(72) 1.5Mb 230ms DropTail
$ns duplex-link $n(14) $n(69) 1.5Mb 380ms DropTail
$ns duplex-link $n(14) $n(67) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "560..."; flush stdout }
$ns duplex-link $n(14) $n(63) 1.5Mb 170ms DropTail
$ns duplex-link $n(14) $n(54) 1.5Mb 660ms DropTail
$ns duplex-link $n(14) $n(50) 1.5Mb 820ms DropTail
$ns duplex-link $n(14) $n(47) 1.5Mb 830ms DropTail
$ns duplex-link $n(14) $n(44) 1.5Mb 490ms DropTail
$ns duplex-link $n(14) $n(39) 1.5Mb 760ms DropTail
$ns duplex-link $n(14) $n(35) 1.5Mb 400ms DropTail
$ns duplex-link $n(14) $n(31) 1.5Mb 760ms DropTail
$ns duplex-link $n(14) $n(29) 1.5Mb 780ms DropTail
$ns duplex-link $n(14) $n(27) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "570..."; flush stdout }
$ns duplex-link $n(14) $n(25) 1.5Mb 570ms DropTail
$ns duplex-link $n(14) $n(18) 1.5Mb 430ms DropTail
$ns duplex-link $n(15) $n(192) 1.5Mb 910ms DropTail
$ns duplex-link $n(15) $n(191) 1.5Mb 980ms DropTail
$ns duplex-link $n(15) $n(186) 1.5Mb 490ms DropTail
$ns duplex-link $n(15) $n(184) 1.5Mb 590ms DropTail
$ns duplex-link $n(15) $n(180) 1.5Mb 100ms DropTail
$ns duplex-link $n(15) $n(174) 1.5Mb 210ms DropTail
$ns duplex-link $n(15) $n(158) 1.5Mb 860ms DropTail
$ns duplex-link $n(15) $n(146) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "580..."; flush stdout }
$ns duplex-link $n(15) $n(138) 1.5Mb 330ms DropTail
$ns duplex-link $n(15) $n(133) 1.5Mb 320ms DropTail
$ns duplex-link $n(15) $n(131) 1.5Mb 850ms DropTail
$ns duplex-link $n(15) $n(130) 1.5Mb 800ms DropTail
$ns duplex-link $n(15) $n(115) 1.5Mb 610ms DropTail
$ns duplex-link $n(15) $n(111) 1.5Mb 630ms DropTail
$ns duplex-link $n(15) $n(105) 1.5Mb 510ms DropTail
$ns duplex-link $n(15) $n(104) 1.5Mb 590ms DropTail
$ns duplex-link $n(15) $n(103) 1.5Mb 960ms DropTail
$ns duplex-link $n(15) $n(95) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "590..."; flush stdout }
$ns duplex-link $n(15) $n(85) 1.5Mb 580ms DropTail
$ns duplex-link $n(15) $n(77) 1.5Mb 880ms DropTail
$ns duplex-link $n(15) $n(70) 1.5Mb 950ms DropTail
$ns duplex-link $n(15) $n(69) 1.5Mb 640ms DropTail
$ns duplex-link $n(15) $n(44) 1.5Mb 700ms DropTail
$ns duplex-link $n(15) $n(38) 1.5Mb 930ms DropTail
$ns duplex-link $n(15) $n(37) 1.5Mb 920ms DropTail
$ns duplex-link $n(15) $n(36) 1.5Mb 430ms DropTail
$ns duplex-link $n(15) $n(34) 1.5Mb 960ms DropTail
$ns duplex-link $n(15) $n(32) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "600..."; flush stdout }
$ns duplex-link $n(15) $n(29) 1.5Mb 470ms DropTail
$ns duplex-link $n(15) $n(22) 1.5Mb 390ms DropTail
$ns duplex-link $n(15) $n(20) 1.5Mb 640ms DropTail
$ns duplex-link $n(16) $n(196) 1.5Mb 140ms DropTail
$ns duplex-link $n(16) $n(195) 1.5Mb 920ms DropTail
$ns duplex-link $n(16) $n(193) 1.5Mb 1060ms DropTail
$ns duplex-link $n(16) $n(192) 1.5Mb 650ms DropTail
$ns duplex-link $n(16) $n(184) 1.5Mb 340ms DropTail
$ns duplex-link $n(16) $n(183) 1.5Mb 240ms DropTail
$ns duplex-link $n(16) $n(177) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "610..."; flush stdout }
$ns duplex-link $n(16) $n(174) 1.5Mb 90ms DropTail
$ns duplex-link $n(16) $n(171) 1.5Mb 630ms DropTail
$ns duplex-link $n(16) $n(169) 1.5Mb 730ms DropTail
$ns duplex-link $n(16) $n(165) 1.5Mb 660ms DropTail
$ns duplex-link $n(16) $n(152) 1.5Mb 510ms DropTail
$ns duplex-link $n(16) $n(148) 1.5Mb 360ms DropTail
$ns duplex-link $n(16) $n(147) 1.5Mb 290ms DropTail
$ns duplex-link $n(16) $n(145) 1.5Mb 790ms DropTail
$ns duplex-link $n(16) $n(143) 1.5Mb 910ms DropTail
$ns duplex-link $n(16) $n(131) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "620..."; flush stdout }
$ns duplex-link $n(16) $n(127) 1.5Mb 150ms DropTail
$ns duplex-link $n(16) $n(126) 1.5Mb 850ms DropTail
$ns duplex-link $n(16) $n(112) 1.5Mb 520ms DropTail
$ns duplex-link $n(16) $n(111) 1.5Mb 350ms DropTail
$ns duplex-link $n(16) $n(106) 1.5Mb 610ms DropTail
$ns duplex-link $n(16) $n(104) 1.5Mb 470ms DropTail
$ns duplex-link $n(16) $n(90) 1.5Mb 220ms DropTail
$ns duplex-link $n(16) $n(89) 1.5Mb 510ms DropTail
$ns duplex-link $n(16) $n(85) 1.5Mb 390ms DropTail
$ns duplex-link $n(16) $n(69) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "630..."; flush stdout }
$ns duplex-link $n(16) $n(68) 1.5Mb 730ms DropTail
$ns duplex-link $n(16) $n(64) 1.5Mb 370ms DropTail
$ns duplex-link $n(16) $n(62) 1.5Mb 650ms DropTail
$ns duplex-link $n(16) $n(61) 1.5Mb 590ms DropTail
$ns duplex-link $n(16) $n(46) 1.5Mb 680ms DropTail
$ns duplex-link $n(16) $n(39) 1.5Mb 280ms DropTail
$ns duplex-link $n(16) $n(36) 1.5Mb 510ms DropTail
$ns duplex-link $n(16) $n(34) 1.5Mb 860ms DropTail
$ns duplex-link $n(16) $n(31) 1.5Mb 650ms DropTail
$ns duplex-link $n(16) $n(26) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "640..."; flush stdout }
$ns duplex-link $n(17) $n(199) 1.5Mb 1020ms DropTail
$ns duplex-link $n(17) $n(176) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(175) 1.5Mb 230ms DropTail
$ns duplex-link $n(17) $n(160) 1.5Mb 500ms DropTail
$ns duplex-link $n(17) $n(154) 1.5Mb 870ms DropTail
$ns duplex-link $n(17) $n(149) 1.5Mb 250ms DropTail
$ns duplex-link $n(17) $n(148) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(147) 1.5Mb 480ms DropTail
$ns duplex-link $n(17) $n(145) 1.5Mb 690ms DropTail
$ns duplex-link $n(17) $n(143) 1.5Mb 880ms DropTail
if {$verbose} { puts -nonewline "650..."; flush stdout }
$ns duplex-link $n(17) $n(141) 1.5Mb 230ms DropTail
$ns duplex-link $n(17) $n(123) 1.5Mb 570ms DropTail
$ns duplex-link $n(17) $n(120) 1.5Mb 370ms DropTail
$ns duplex-link $n(17) $n(105) 1.5Mb 130ms DropTail
$ns duplex-link $n(17) $n(102) 1.5Mb 530ms DropTail
$ns duplex-link $n(17) $n(100) 1.5Mb 840ms DropTail
$ns duplex-link $n(17) $n(94) 1.5Mb 440ms DropTail
$ns duplex-link $n(17) $n(85) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(80) 1.5Mb 490ms DropTail
$ns duplex-link $n(17) $n(74) 1.5Mb 60ms DropTail
if {$verbose} { puts -nonewline "660..."; flush stdout }
$ns duplex-link $n(17) $n(72) 1.5Mb 630ms DropTail
$ns duplex-link $n(17) $n(65) 1.5Mb 800ms DropTail
$ns duplex-link $n(17) $n(64) 1.5Mb 660ms DropTail
$ns duplex-link $n(17) $n(58) 1.5Mb 430ms DropTail
$ns duplex-link $n(17) $n(47) 1.5Mb 380ms DropTail
$ns duplex-link $n(17) $n(45) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(40) 1.5Mb 700ms DropTail
$ns duplex-link $n(17) $n(29) 1.5Mb 150ms DropTail
$ns duplex-link $n(17) $n(22) 1.5Mb 370ms DropTail
$ns duplex-link $n(18) $n(198) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "670..."; flush stdout }
$ns duplex-link $n(18) $n(185) 1.5Mb 400ms DropTail
$ns duplex-link $n(18) $n(179) 1.5Mb 470ms DropTail
$ns duplex-link $n(18) $n(174) 1.5Mb 510ms DropTail
$ns duplex-link $n(18) $n(170) 1.5Mb 190ms DropTail
$ns duplex-link $n(18) $n(169) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(165) 1.5Mb 490ms DropTail
$ns duplex-link $n(18) $n(154) 1.5Mb 470ms DropTail
$ns duplex-link $n(18) $n(151) 1.5Mb 360ms DropTail
$ns duplex-link $n(18) $n(145) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(140) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "680..."; flush stdout }
$ns duplex-link $n(18) $n(138) 1.5Mb 380ms DropTail
$ns duplex-link $n(18) $n(135) 1.5Mb 250ms DropTail
$ns duplex-link $n(18) $n(113) 1.5Mb 530ms DropTail
$ns duplex-link $n(18) $n(105) 1.5Mb 330ms DropTail
$ns duplex-link $n(18) $n(102) 1.5Mb 170ms DropTail
$ns duplex-link $n(18) $n(97) 1.5Mb 130ms DropTail
$ns duplex-link $n(18) $n(93) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(92) 1.5Mb 520ms DropTail
$ns duplex-link $n(18) $n(91) 1.5Mb 420ms DropTail
$ns duplex-link $n(18) $n(89) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "690..."; flush stdout }
$ns duplex-link $n(18) $n(85) 1.5Mb 60ms DropTail
$ns duplex-link $n(18) $n(84) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(83) 1.5Mb 490ms DropTail
$ns duplex-link $n(18) $n(54) 1.5Mb 240ms DropTail
$ns duplex-link $n(18) $n(40) 1.5Mb 370ms DropTail
$ns duplex-link $n(18) $n(35) 1.5Mb 520ms DropTail
$ns duplex-link $n(18) $n(20) 1.5Mb 770ms DropTail
$ns duplex-link $n(19) $n(186) 1.5Mb 360ms DropTail
$ns duplex-link $n(19) $n(175) 1.5Mb 360ms DropTail
$ns duplex-link $n(19) $n(172) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "700..."; flush stdout }
$ns duplex-link $n(19) $n(164) 1.5Mb 380ms DropTail
$ns duplex-link $n(19) $n(163) 1.5Mb 80ms DropTail
$ns duplex-link $n(19) $n(145) 1.5Mb 410ms DropTail
$ns duplex-link $n(19) $n(144) 1.5Mb 490ms DropTail
$ns duplex-link $n(19) $n(137) 1.5Mb 360ms DropTail
$ns duplex-link $n(19) $n(136) 1.5Mb 320ms DropTail
$ns duplex-link $n(19) $n(135) 1.5Mb 390ms DropTail
$ns duplex-link $n(19) $n(133) 1.5Mb 470ms DropTail
$ns duplex-link $n(19) $n(130) 1.5Mb 460ms DropTail
$ns duplex-link $n(19) $n(127) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "710..."; flush stdout }
$ns duplex-link $n(19) $n(126) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(125) 1.5Mb 450ms DropTail
$ns duplex-link $n(19) $n(121) 1.5Mb 230ms DropTail
$ns duplex-link $n(19) $n(108) 1.5Mb 30ms DropTail
$ns duplex-link $n(19) $n(101) 1.5Mb 390ms DropTail
$ns duplex-link $n(19) $n(88) 1.5Mb 60ms DropTail
$ns duplex-link $n(19) $n(84) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(80) 1.5Mb 260ms DropTail
$ns duplex-link $n(19) $n(73) 1.5Mb 250ms DropTail
$ns duplex-link $n(19) $n(66) 1.5Mb 70ms DropTail
if {$verbose} { puts -nonewline "720..."; flush stdout }
$ns duplex-link $n(19) $n(62) 1.5Mb 440ms DropTail
$ns duplex-link $n(19) $n(55) 1.5Mb 270ms DropTail
$ns duplex-link $n(19) $n(53) 1.5Mb 550ms DropTail
$ns duplex-link $n(19) $n(49) 1.5Mb 320ms DropTail
$ns duplex-link $n(19) $n(43) 1.5Mb 350ms DropTail
$ns duplex-link $n(19) $n(35) 1.5Mb 440ms DropTail
$ns duplex-link $n(19) $n(34) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(31) 1.5Mb 420ms DropTail
$ns duplex-link $n(19) $n(29) 1.5Mb 420ms DropTail
$ns duplex-link $n(20) $n(196) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "730..."; flush stdout }
$ns duplex-link $n(20) $n(194) 1.5Mb 480ms DropTail
$ns duplex-link $n(20) $n(187) 1.5Mb 650ms DropTail
$ns duplex-link $n(20) $n(174) 1.5Mb 780ms DropTail
$ns duplex-link $n(20) $n(173) 1.5Mb 330ms DropTail
$ns duplex-link $n(20) $n(168) 1.5Mb 1080ms DropTail
$ns duplex-link $n(20) $n(166) 1.5Mb 920ms DropTail
$ns duplex-link $n(20) $n(161) 1.5Mb 1130ms DropTail
$ns duplex-link $n(20) $n(156) 1.5Mb 910ms DropTail
$ns duplex-link $n(20) $n(153) 1.5Mb 210ms DropTail
$ns duplex-link $n(20) $n(150) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "740..."; flush stdout }
$ns duplex-link $n(20) $n(148) 1.5Mb 760ms DropTail
$ns duplex-link $n(20) $n(142) 1.5Mb 1040ms DropTail
$ns duplex-link $n(20) $n(141) 1.5Mb 1090ms DropTail
$ns duplex-link $n(20) $n(139) 1.5Mb 520ms DropTail
$ns duplex-link $n(20) $n(134) 1.5Mb 890ms DropTail
$ns duplex-link $n(20) $n(119) 1.5Mb 860ms DropTail
$ns duplex-link $n(20) $n(113) 1.5Mb 280ms DropTail
$ns duplex-link $n(20) $n(104) 1.5Mb 670ms DropTail
$ns duplex-link $n(20) $n(96) 1.5Mb 670ms DropTail
$ns duplex-link $n(20) $n(94) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "750..."; flush stdout }
$ns duplex-link $n(20) $n(87) 1.5Mb 930ms DropTail
$ns duplex-link $n(20) $n(83) 1.5Mb 450ms DropTail
$ns duplex-link $n(20) $n(82) 1.5Mb 720ms DropTail
$ns duplex-link $n(20) $n(65) 1.5Mb 390ms DropTail
$ns duplex-link $n(20) $n(61) 1.5Mb 990ms DropTail
$ns duplex-link $n(20) $n(60) 1.5Mb 370ms DropTail
$ns duplex-link $n(20) $n(56) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(51) 1.5Mb 1120ms DropTail
$ns duplex-link $n(20) $n(42) 1.5Mb 1210ms DropTail
$ns duplex-link $n(20) $n(40) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "760..."; flush stdout }
$ns duplex-link $n(20) $n(31) 1.5Mb 210ms DropTail
$ns duplex-link $n(20) $n(26) 1.5Mb 1110ms DropTail
$ns duplex-link $n(21) $n(197) 1.5Mb 740ms DropTail
$ns duplex-link $n(21) $n(187) 1.5Mb 690ms DropTail
$ns duplex-link $n(21) $n(180) 1.5Mb 790ms DropTail
$ns duplex-link $n(21) $n(177) 1.5Mb 950ms DropTail
$ns duplex-link $n(21) $n(174) 1.5Mb 610ms DropTail
$ns duplex-link $n(21) $n(171) 1.5Mb 150ms DropTail
$ns duplex-link $n(21) $n(169) 1.5Mb 360ms DropTail
$ns duplex-link $n(21) $n(167) 1.5Mb 990ms DropTail
if {$verbose} { puts -nonewline "770..."; flush stdout }
$ns duplex-link $n(21) $n(160) 1.5Mb 380ms DropTail
$ns duplex-link $n(21) $n(149) 1.5Mb 460ms DropTail
$ns duplex-link $n(21) $n(142) 1.5Mb 200ms DropTail
$ns duplex-link $n(21) $n(138) 1.5Mb 470ms DropTail
$ns duplex-link $n(21) $n(127) 1.5Mb 380ms DropTail
$ns duplex-link $n(21) $n(117) 1.5Mb 720ms DropTail
$ns duplex-link $n(21) $n(104) 1.5Mb 490ms DropTail
$ns duplex-link $n(21) $n(85) 1.5Mb 360ms DropTail
$ns duplex-link $n(21) $n(75) 1.5Mb 770ms DropTail
$ns duplex-link $n(21) $n(71) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "780..."; flush stdout }
$ns duplex-link $n(21) $n(67) 1.5Mb 120ms DropTail
$ns duplex-link $n(21) $n(58) 1.5Mb 250ms DropTail
$ns duplex-link $n(21) $n(55) 1.5Mb 260ms DropTail
$ns duplex-link $n(21) $n(51) 1.5Mb 40ms DropTail
$ns duplex-link $n(21) $n(50) 1.5Mb 500ms DropTail
$ns duplex-link $n(21) $n(49) 1.5Mb 660ms DropTail
$ns duplex-link $n(21) $n(45) 1.5Mb 130ms DropTail
$ns duplex-link $n(21) $n(42) 1.5Mb 220ms DropTail
$ns duplex-link $n(21) $n(40) 1.5Mb 750ms DropTail
$ns duplex-link $n(21) $n(37) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "790..."; flush stdout }
$ns duplex-link $n(21) $n(36) 1.5Mb 810ms DropTail
$ns duplex-link $n(21) $n(34) 1.5Mb 750ms DropTail
$ns duplex-link $n(22) $n(195) 1.5Mb 690ms DropTail
$ns duplex-link $n(22) $n(186) 1.5Mb 210ms DropTail
$ns duplex-link $n(22) $n(185) 1.5Mb 260ms DropTail
$ns duplex-link $n(22) $n(184) 1.5Mb 220ms DropTail
$ns duplex-link $n(22) $n(172) 1.5Mb 330ms DropTail
$ns duplex-link $n(22) $n(165) 1.5Mb 610ms DropTail
$ns duplex-link $n(22) $n(162) 1.5Mb 280ms DropTail
$ns duplex-link $n(22) $n(161) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "800..."; flush stdout }
$ns duplex-link $n(22) $n(158) 1.5Mb 490ms DropTail
$ns duplex-link $n(22) $n(150) 1.5Mb 590ms DropTail
$ns duplex-link $n(22) $n(146) 1.5Mb 330ms DropTail
$ns duplex-link $n(22) $n(145) 1.5Mb 580ms DropTail
$ns duplex-link $n(22) $n(144) 1.5Mb 690ms DropTail
$ns duplex-link $n(22) $n(134) 1.5Mb 750ms DropTail
$ns duplex-link $n(22) $n(125) 1.5Mb 500ms DropTail
$ns duplex-link $n(22) $n(123) 1.5Mb 260ms DropTail
$ns duplex-link $n(22) $n(114) 1.5Mb 700ms DropTail
$ns duplex-link $n(22) $n(108) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "810..."; flush stdout }
$ns duplex-link $n(22) $n(106) 1.5Mb 380ms DropTail
$ns duplex-link $n(22) $n(101) 1.5Mb 430ms DropTail
$ns duplex-link $n(22) $n(100) 1.5Mb 480ms DropTail
$ns duplex-link $n(22) $n(86) 1.5Mb 670ms DropTail
$ns duplex-link $n(22) $n(83) 1.5Mb 560ms DropTail
$ns duplex-link $n(22) $n(81) 1.5Mb 150ms DropTail
$ns duplex-link $n(22) $n(77) 1.5Mb 490ms DropTail
$ns duplex-link $n(22) $n(63) 1.5Mb 690ms DropTail
$ns duplex-link $n(22) $n(61) 1.5Mb 430ms DropTail
$ns duplex-link $n(22) $n(50) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "820..."; flush stdout }
$ns duplex-link $n(22) $n(48) 1.5Mb 220ms DropTail
$ns duplex-link $n(22) $n(47) 1.5Mb 180ms DropTail
$ns duplex-link $n(22) $n(42) 1.5Mb 600ms DropTail
$ns duplex-link $n(22) $n(41) 1.5Mb 650ms DropTail
$ns duplex-link $n(22) $n(36) 1.5Mb 360ms DropTail
$ns duplex-link $n(22) $n(24) 1.5Mb 190ms DropTail
$ns duplex-link $n(23) $n(198) 1.5Mb 940ms DropTail
$ns duplex-link $n(23) $n(197) 1.5Mb 480ms DropTail
$ns duplex-link $n(23) $n(189) 1.5Mb 340ms DropTail
$ns duplex-link $n(23) $n(178) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "830..."; flush stdout }
$ns duplex-link $n(23) $n(177) 1.5Mb 210ms DropTail
$ns duplex-link $n(23) $n(172) 1.5Mb 690ms DropTail
$ns duplex-link $n(23) $n(164) 1.5Mb 380ms DropTail
$ns duplex-link $n(23) $n(163) 1.5Mb 460ms DropTail
$ns duplex-link $n(23) $n(162) 1.5Mb 630ms DropTail
$ns duplex-link $n(23) $n(154) 1.5Mb 140ms DropTail
$ns duplex-link $n(23) $n(152) 1.5Mb 350ms DropTail
$ns duplex-link $n(23) $n(146) 1.5Mb 670ms DropTail
$ns duplex-link $n(23) $n(144) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(142) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "840..."; flush stdout }
$ns duplex-link $n(23) $n(138) 1.5Mb 790ms DropTail
$ns duplex-link $n(23) $n(132) 1.5Mb 520ms DropTail
$ns duplex-link $n(23) $n(131) 1.5Mb 110ms DropTail
$ns duplex-link $n(23) $n(129) 1.5Mb 500ms DropTail
$ns duplex-link $n(23) $n(116) 1.5Mb 410ms DropTail
$ns duplex-link $n(23) $n(115) 1.5Mb 850ms DropTail
$ns duplex-link $n(23) $n(112) 1.5Mb 330ms DropTail
$ns duplex-link $n(23) $n(106) 1.5Mb 440ms DropTail
$ns duplex-link $n(23) $n(104) 1.5Mb 480ms DropTail
$ns duplex-link $n(23) $n(99) 1.5Mb 20ms DropTail
if {$verbose} { puts -nonewline "850..."; flush stdout }
$ns duplex-link $n(23) $n(82) 1.5Mb 340ms DropTail
$ns duplex-link $n(23) $n(78) 1.5Mb 470ms DropTail
$ns duplex-link $n(23) $n(69) 1.5Mb 480ms DropTail
$ns duplex-link $n(23) $n(67) 1.5Mb 850ms DropTail
$ns duplex-link $n(23) $n(64) 1.5Mb 610ms DropTail
$ns duplex-link $n(23) $n(57) 1.5Mb 80ms DropTail
$ns duplex-link $n(23) $n(56) 1.5Mb 390ms DropTail
$ns duplex-link $n(23) $n(55) 1.5Mb 720ms DropTail
$ns duplex-link $n(23) $n(35) 1.5Mb 210ms DropTail
$ns duplex-link $n(23) $n(34) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "860..."; flush stdout }
$ns duplex-link $n(23) $n(27) 1.5Mb 740ms DropTail
$ns duplex-link $n(23) $n(26) 1.5Mb 870ms DropTail
$ns duplex-link $n(23) $n(25) 1.5Mb 310ms DropTail
$ns duplex-link $n(23) $n(24) 1.5Mb 560ms DropTail
$ns duplex-link $n(24) $n(194) 1.5Mb 160ms DropTail
$ns duplex-link $n(24) $n(192) 1.5Mb 730ms DropTail
$ns duplex-link $n(24) $n(190) 1.5Mb 370ms DropTail
$ns duplex-link $n(24) $n(189) 1.5Mb 330ms DropTail
$ns duplex-link $n(24) $n(182) 1.5Mb 690ms DropTail
$ns duplex-link $n(24) $n(180) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "870..."; flush stdout }
$ns duplex-link $n(24) $n(179) 1.5Mb 740ms DropTail
$ns duplex-link $n(24) $n(174) 1.5Mb 280ms DropTail
$ns duplex-link $n(24) $n(163) 1.5Mb 210ms DropTail
$ns duplex-link $n(24) $n(157) 1.5Mb 530ms DropTail
$ns duplex-link $n(24) $n(151) 1.5Mb 240ms DropTail
$ns duplex-link $n(24) $n(149) 1.5Mb 360ms DropTail
$ns duplex-link $n(24) $n(148) 1.5Mb 320ms DropTail
$ns duplex-link $n(24) $n(137) 1.5Mb 270ms DropTail
$ns duplex-link $n(24) $n(129) 1.5Mb 320ms DropTail
$ns duplex-link $n(24) $n(122) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "880..."; flush stdout }
$ns duplex-link $n(24) $n(117) 1.5Mb 180ms DropTail
$ns duplex-link $n(24) $n(114) 1.5Mb 770ms DropTail
$ns duplex-link $n(24) $n(104) 1.5Mb 340ms DropTail
$ns duplex-link $n(24) $n(103) 1.5Mb 800ms DropTail
$ns duplex-link $n(24) $n(97) 1.5Mb 450ms DropTail
$ns duplex-link $n(24) $n(89) 1.5Mb 240ms DropTail
$ns duplex-link $n(24) $n(84) 1.5Mb 710ms DropTail
$ns duplex-link $n(24) $n(80) 1.5Mb 50ms DropTail
$ns duplex-link $n(24) $n(79) 1.5Mb 240ms DropTail
$ns duplex-link $n(24) $n(74) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "890..."; flush stdout }
$ns duplex-link $n(24) $n(71) 1.5Mb 450ms DropTail
$ns duplex-link $n(24) $n(68) 1.5Mb 680ms DropTail
$ns duplex-link $n(24) $n(57) 1.5Mb 490ms DropTail
$ns duplex-link $n(24) $n(46) 1.5Mb 400ms DropTail
$ns duplex-link $n(24) $n(30) 1.5Mb 750ms DropTail
$ns duplex-link $n(25) $n(197) 1.5Mb 510ms DropTail
$ns duplex-link $n(25) $n(196) 1.5Mb 410ms DropTail
$ns duplex-link $n(25) $n(194) 1.5Mb 360ms DropTail
$ns duplex-link $n(25) $n(192) 1.5Mb 720ms DropTail
$ns duplex-link $n(25) $n(187) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "900..."; flush stdout }
$ns duplex-link $n(25) $n(171) 1.5Mb 710ms DropTail
$ns duplex-link $n(25) $n(170) 1.5Mb 440ms DropTail
$ns duplex-link $n(25) $n(160) 1.5Mb 460ms DropTail
$ns duplex-link $n(25) $n(155) 1.5Mb 400ms DropTail
$ns duplex-link $n(25) $n(153) 1.5Mb 340ms DropTail
$ns duplex-link $n(25) $n(144) 1.5Mb 560ms DropTail
$ns duplex-link $n(25) $n(137) 1.5Mb 460ms DropTail
$ns duplex-link $n(25) $n(127) 1.5Mb 490ms DropTail
$ns duplex-link $n(25) $n(120) 1.5Mb 400ms DropTail
$ns duplex-link $n(25) $n(116) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "910..."; flush stdout }
$ns duplex-link $n(25) $n(111) 1.5Mb 620ms DropTail
$ns duplex-link $n(25) $n(105) 1.5Mb 550ms DropTail
$ns duplex-link $n(25) $n(102) 1.5Mb 160ms DropTail
$ns duplex-link $n(25) $n(97) 1.5Mb 310ms DropTail
$ns duplex-link $n(25) $n(85) 1.5Mb 350ms DropTail
$ns duplex-link $n(25) $n(84) 1.5Mb 660ms DropTail
$ns duplex-link $n(25) $n(82) 1.5Mb 490ms DropTail
$ns duplex-link $n(25) $n(81) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(80) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(76) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "920..."; flush stdout }
$ns duplex-link $n(25) $n(75) 1.5Mb 410ms DropTail
$ns duplex-link $n(25) $n(73) 1.5Mb 140ms DropTail
$ns duplex-link $n(25) $n(65) 1.5Mb 140ms DropTail
$ns duplex-link $n(25) $n(61) 1.5Mb 550ms DropTail
$ns duplex-link $n(25) $n(60) 1.5Mb 70ms DropTail
$ns duplex-link $n(25) $n(59) 1.5Mb 150ms DropTail
$ns duplex-link $n(25) $n(55) 1.5Mb 450ms DropTail
$ns duplex-link $n(25) $n(54) 1.5Mb 320ms DropTail
$ns duplex-link $n(25) $n(52) 1.5Mb 430ms DropTail
$ns duplex-link $n(25) $n(47) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "930..."; flush stdout }
$ns duplex-link $n(25) $n(43) 1.5Mb 280ms DropTail
$ns duplex-link $n(25) $n(40) 1.5Mb 40ms DropTail
$ns duplex-link $n(26) $n(194) 1.5Mb 870ms DropTail
$ns duplex-link $n(26) $n(188) 1.5Mb 790ms DropTail
$ns duplex-link $n(26) $n(179) 1.5Mb 550ms DropTail
$ns duplex-link $n(26) $n(172) 1.5Mb 860ms DropTail
$ns duplex-link $n(26) $n(170) 1.5Mb 270ms DropTail
$ns duplex-link $n(26) $n(167) 1.5Mb 880ms DropTail
$ns duplex-link $n(26) $n(153) 1.5Mb 990ms DropTail
$ns duplex-link $n(26) $n(140) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "940..."; flush stdout }
$ns duplex-link $n(26) $n(139) 1.5Mb 690ms DropTail
$ns duplex-link $n(26) $n(136) 1.5Mb 290ms DropTail
$ns duplex-link $n(26) $n(129) 1.5Mb 430ms DropTail
$ns duplex-link $n(26) $n(120) 1.5Mb 640ms DropTail
$ns duplex-link $n(26) $n(115) 1.5Mb 340ms DropTail
$ns duplex-link $n(26) $n(108) 1.5Mb 470ms DropTail
$ns duplex-link $n(26) $n(107) 1.5Mb 650ms DropTail
$ns duplex-link $n(26) $n(101) 1.5Mb 880ms DropTail
$ns duplex-link $n(26) $n(98) 1.5Mb 380ms DropTail
$ns duplex-link $n(26) $n(97) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "950..."; flush stdout }
$ns duplex-link $n(26) $n(91) 1.5Mb 700ms DropTail
$ns duplex-link $n(26) $n(78) 1.5Mb 630ms DropTail
$ns duplex-link $n(26) $n(74) 1.5Mb 420ms DropTail
$ns duplex-link $n(26) $n(71) 1.5Mb 530ms DropTail
$ns duplex-link $n(26) $n(65) 1.5Mb 740ms DropTail
$ns duplex-link $n(26) $n(59) 1.5Mb 670ms DropTail
$ns duplex-link $n(26) $n(56) 1.5Mb 480ms DropTail
$ns duplex-link $n(26) $n(55) 1.5Mb 280ms DropTail
$ns duplex-link $n(26) $n(52) 1.5Mb 460ms DropTail
$ns duplex-link $n(26) $n(50) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "960..."; flush stdout }
$ns duplex-link $n(26) $n(43) 1.5Mb 710ms DropTail
$ns duplex-link $n(26) $n(41) 1.5Mb 450ms DropTail
$ns duplex-link $n(26) $n(37) 1.5Mb 720ms DropTail
$ns duplex-link $n(26) $n(27) 1.5Mb 160ms DropTail
$ns duplex-link $n(27) $n(194) 1.5Mb 850ms DropTail
$ns duplex-link $n(27) $n(192) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(189) 1.5Mb 850ms DropTail
$ns duplex-link $n(27) $n(188) 1.5Mb 770ms DropTail
$ns duplex-link $n(27) $n(184) 1.5Mb 380ms DropTail
$ns duplex-link $n(27) $n(181) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "970..."; flush stdout }
$ns duplex-link $n(27) $n(180) 1.5Mb 870ms DropTail
$ns duplex-link $n(27) $n(178) 1.5Mb 460ms DropTail
$ns duplex-link $n(27) $n(177) 1.5Mb 810ms DropTail
$ns duplex-link $n(27) $n(176) 1.5Mb 530ms DropTail
$ns duplex-link $n(27) $n(166) 1.5Mb 420ms DropTail
$ns duplex-link $n(27) $n(164) 1.5Mb 420ms DropTail
$ns duplex-link $n(27) $n(162) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(159) 1.5Mb 210ms DropTail
$ns duplex-link $n(27) $n(145) 1.5Mb 170ms DropTail
$ns duplex-link $n(27) $n(129) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "980..."; flush stdout }
$ns duplex-link $n(27) $n(126) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(124) 1.5Mb 130ms DropTail
$ns duplex-link $n(27) $n(123) 1.5Mb 770ms DropTail
$ns duplex-link $n(27) $n(109) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(104) 1.5Mb 370ms DropTail
$ns duplex-link $n(27) $n(102) 1.5Mb 450ms DropTail
$ns duplex-link $n(27) $n(101) 1.5Mb 810ms DropTail
$ns duplex-link $n(27) $n(82) 1.5Mb 560ms DropTail
$ns duplex-link $n(27) $n(80) 1.5Mb 650ms DropTail
$ns duplex-link $n(27) $n(75) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "990..."; flush stdout }
$ns duplex-link $n(27) $n(71) 1.5Mb 420ms DropTail
$ns duplex-link $n(27) $n(70) 1.5Mb 160ms DropTail
$ns duplex-link $n(27) $n(68) 1.5Mb 70ms DropTail
$ns duplex-link $n(27) $n(65) 1.5Mb 640ms DropTail
$ns duplex-link $n(27) $n(63) 1.5Mb 420ms DropTail
$ns duplex-link $n(27) $n(46) 1.5Mb 720ms DropTail
$ns duplex-link $n(27) $n(44) 1.5Mb 270ms DropTail
$ns duplex-link $n(27) $n(33) 1.5Mb 860ms DropTail
$ns duplex-link $n(27) $n(30) 1.5Mb 410ms DropTail
$ns duplex-link $n(28) $n(198) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "1000..."; flush stdout }
$ns duplex-link $n(28) $n(185) 1.5Mb 350ms DropTail
$ns duplex-link $n(28) $n(182) 1.5Mb 750ms DropTail
$ns duplex-link $n(28) $n(177) 1.5Mb 120ms DropTail
$ns duplex-link $n(28) $n(172) 1.5Mb 500ms DropTail
$ns duplex-link $n(28) $n(166) 1.5Mb 830ms DropTail
$ns duplex-link $n(28) $n(165) 1.5Mb 1160ms DropTail
$ns duplex-link $n(28) $n(160) 1.5Mb 790ms DropTail
$ns duplex-link $n(28) $n(158) 1.5Mb 1010ms DropTail
$ns duplex-link $n(28) $n(155) 1.5Mb 730ms DropTail
$ns duplex-link $n(28) $n(151) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "1010..."; flush stdout }
$ns duplex-link $n(28) $n(143) 1.5Mb 730ms DropTail
$ns duplex-link $n(28) $n(141) 1.5Mb 990ms DropTail
$ns duplex-link $n(28) $n(138) 1.5Mb 720ms DropTail
$ns duplex-link $n(28) $n(132) 1.5Mb 580ms DropTail
$ns duplex-link $n(28) $n(129) 1.5Mb 590ms DropTail
$ns duplex-link $n(28) $n(123) 1.5Mb 450ms DropTail
$ns duplex-link $n(28) $n(114) 1.5Mb 770ms DropTail
$ns duplex-link $n(28) $n(108) 1.5Mb 550ms DropTail
$ns duplex-link $n(28) $n(104) 1.5Mb 570ms DropTail
$ns duplex-link $n(28) $n(103) 1.5Mb 1150ms DropTail
if {$verbose} { puts -nonewline "1020..."; flush stdout }
$ns duplex-link $n(28) $n(99) 1.5Mb 290ms DropTail
$ns duplex-link $n(28) $n(85) 1.5Mb 690ms DropTail
$ns duplex-link $n(28) $n(80) 1.5Mb 490ms DropTail
$ns duplex-link $n(28) $n(74) 1.5Mb 910ms DropTail
$ns duplex-link $n(28) $n(71) 1.5Mb 520ms DropTail
$ns duplex-link $n(28) $n(69) 1.5Mb 600ms DropTail
$ns duplex-link $n(28) $n(68) 1.5Mb 880ms DropTail
$ns duplex-link $n(28) $n(67) 1.5Mb 940ms DropTail
$ns duplex-link $n(28) $n(58) 1.5Mb 940ms DropTail
$ns duplex-link $n(28) $n(49) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "1030..."; flush stdout }
$ns duplex-link $n(28) $n(43) 1.5Mb 430ms DropTail
$ns duplex-link $n(28) $n(34) 1.5Mb 690ms DropTail
$ns duplex-link $n(28) $n(31) 1.5Mb 110ms DropTail
$ns duplex-link $n(29) $n(197) 1.5Mb 820ms DropTail
$ns duplex-link $n(29) $n(190) 1.5Mb 200ms DropTail
$ns duplex-link $n(29) $n(185) 1.5Mb 480ms DropTail
$ns duplex-link $n(29) $n(181) 1.5Mb 650ms DropTail
$ns duplex-link $n(29) $n(175) 1.5Mb 80ms DropTail
$ns duplex-link $n(29) $n(172) 1.5Mb 460ms DropTail
$ns duplex-link $n(29) $n(166) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "1040..."; flush stdout }
$ns duplex-link $n(29) $n(164) 1.5Mb 770ms DropTail
$ns duplex-link $n(29) $n(163) 1.5Mb 400ms DropTail
$ns duplex-link $n(29) $n(161) 1.5Mb 390ms DropTail
$ns duplex-link $n(29) $n(154) 1.5Mb 780ms DropTail
$ns duplex-link $n(29) $n(151) 1.5Mb 560ms DropTail
$ns duplex-link $n(29) $n(150) 1.5Mb 830ms DropTail
$ns duplex-link $n(29) $n(146) 1.5Mb 400ms DropTail
$ns duplex-link $n(29) $n(140) 1.5Mb 740ms DropTail
$ns duplex-link $n(29) $n(139) 1.5Mb 390ms DropTail
$ns duplex-link $n(29) $n(132) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "1050..."; flush stdout }
$ns duplex-link $n(29) $n(131) 1.5Mb 860ms DropTail
$ns duplex-link $n(29) $n(130) 1.5Mb 360ms DropTail
$ns duplex-link $n(29) $n(113) 1.5Mb 760ms DropTail
$ns duplex-link $n(29) $n(111) 1.5Mb 170ms DropTail
$ns duplex-link $n(29) $n(110) 1.5Mb 160ms DropTail
$ns duplex-link $n(29) $n(106) 1.5Mb 550ms DropTail
$ns duplex-link $n(29) $n(103) 1.5Mb 510ms DropTail
$ns duplex-link $n(29) $n(100) 1.5Mb 720ms DropTail
$ns duplex-link $n(29) $n(99) 1.5Mb 850ms DropTail
$ns duplex-link $n(29) $n(94) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1060..."; flush stdout }
$ns duplex-link $n(29) $n(92) 1.5Mb 220ms DropTail
$ns duplex-link $n(29) $n(86) 1.5Mb 800ms DropTail
$ns duplex-link $n(29) $n(77) 1.5Mb 550ms DropTail
$ns duplex-link $n(29) $n(75) 1.5Mb 790ms DropTail
$ns duplex-link $n(29) $n(72) 1.5Mb 590ms DropTail
$ns duplex-link $n(29) $n(64) 1.5Mb 510ms DropTail
$ns duplex-link $n(29) $n(62) 1.5Mb 500ms DropTail
$ns duplex-link $n(29) $n(60) 1.5Mb 600ms DropTail
$ns duplex-link $n(29) $n(56) 1.5Mb 620ms DropTail
$ns duplex-link $n(29) $n(51) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "1070..."; flush stdout }
$ns duplex-link $n(29) $n(46) 1.5Mb 720ms DropTail
$ns duplex-link $n(29) $n(43) 1.5Mb 770ms DropTail
$ns duplex-link $n(29) $n(38) 1.5Mb 780ms DropTail
$ns duplex-link $n(29) $n(35) 1.5Mb 860ms DropTail
$ns duplex-link $n(30) $n(190) 1.5Mb 620ms DropTail
$ns duplex-link $n(30) $n(189) 1.5Mb 1030ms DropTail
$ns duplex-link $n(30) $n(184) 1.5Mb 340ms DropTail
$ns duplex-link $n(30) $n(172) 1.5Mb 870ms DropTail
$ns duplex-link $n(30) $n(170) 1.5Mb 480ms DropTail
$ns duplex-link $n(30) $n(168) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1080..."; flush stdout }
$ns duplex-link $n(30) $n(165) 1.5Mb 60ms DropTail
$ns duplex-link $n(30) $n(162) 1.5Mb 420ms DropTail
$ns duplex-link $n(30) $n(161) 1.5Mb 100ms DropTail
$ns duplex-link $n(30) $n(160) 1.5Mb 430ms DropTail
$ns duplex-link $n(30) $n(157) 1.5Mb 270ms DropTail
$ns duplex-link $n(30) $n(155) 1.5Mb 400ms DropTail
$ns duplex-link $n(30) $n(141) 1.5Mb 140ms DropTail
$ns duplex-link $n(30) $n(139) 1.5Mb 740ms DropTail
$ns duplex-link $n(30) $n(138) 1.5Mb 560ms DropTail
$ns duplex-link $n(30) $n(128) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "1090..."; flush stdout }
$ns duplex-link $n(30) $n(125) 1.5Mb 250ms DropTail
$ns duplex-link $n(30) $n(123) 1.5Mb 810ms DropTail
$ns duplex-link $n(30) $n(114) 1.5Mb 820ms DropTail
$ns duplex-link $n(30) $n(104) 1.5Mb 570ms DropTail
$ns duplex-link $n(30) $n(100) 1.5Mb 950ms DropTail
$ns duplex-link $n(30) $n(97) 1.5Mb 560ms DropTail
$ns duplex-link $n(30) $n(90) 1.5Mb 650ms DropTail
$ns duplex-link $n(30) $n(89) 1.5Mb 990ms DropTail
$ns duplex-link $n(30) $n(83) 1.5Mb 950ms DropTail
$ns duplex-link $n(30) $n(78) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "1100..."; flush stdout }
$ns duplex-link $n(30) $n(77) 1.5Mb 410ms DropTail
$ns duplex-link $n(30) $n(76) 1.5Mb 760ms DropTail
$ns duplex-link $n(30) $n(70) 1.5Mb 560ms DropTail
$ns duplex-link $n(30) $n(64) 1.5Mb 900ms DropTail
$ns duplex-link $n(30) $n(60) 1.5Mb 860ms DropTail
$ns duplex-link $n(30) $n(58) 1.5Mb 280ms DropTail
$ns duplex-link $n(30) $n(56) 1.5Mb 680ms DropTail
$ns duplex-link $n(30) $n(49) 1.5Mb 750ms DropTail
$ns duplex-link $n(30) $n(48) 1.5Mb 760ms DropTail
$ns duplex-link $n(30) $n(47) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "1110..."; flush stdout }
$ns duplex-link $n(30) $n(43) 1.5Mb 900ms DropTail
$ns duplex-link $n(30) $n(41) 1.5Mb 700ms DropTail
$ns duplex-link $n(30) $n(36) 1.5Mb 900ms DropTail
$ns duplex-link $n(31) $n(194) 1.5Mb 360ms DropTail
$ns duplex-link $n(31) $n(187) 1.5Mb 480ms DropTail
$ns duplex-link $n(31) $n(186) 1.5Mb 700ms DropTail
$ns duplex-link $n(31) $n(175) 1.5Mb 660ms DropTail
$ns duplex-link $n(31) $n(168) 1.5Mb 870ms DropTail
$ns duplex-link $n(31) $n(166) 1.5Mb 760ms DropTail
$ns duplex-link $n(31) $n(149) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1120..."; flush stdout }
$ns duplex-link $n(31) $n(143) 1.5Mb 660ms DropTail
$ns duplex-link $n(31) $n(139) 1.5Mb 350ms DropTail
$ns duplex-link $n(31) $n(137) 1.5Mb 630ms DropTail
$ns duplex-link $n(31) $n(125) 1.5Mb 870ms DropTail
$ns duplex-link $n(31) $n(124) 1.5Mb 860ms DropTail
$ns duplex-link $n(31) $n(122) 1.5Mb 200ms DropTail
$ns duplex-link $n(31) $n(120) 1.5Mb 530ms DropTail
$ns duplex-link $n(31) $n(113) 1.5Mb 120ms DropTail
$ns duplex-link $n(31) $n(105) 1.5Mb 740ms DropTail
$ns duplex-link $n(31) $n(98) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1130..."; flush stdout }
$ns duplex-link $n(31) $n(95) 1.5Mb 700ms DropTail
$ns duplex-link $n(31) $n(93) 1.5Mb 890ms DropTail
$ns duplex-link $n(31) $n(89) 1.5Mb 210ms DropTail
$ns duplex-link $n(31) $n(88) 1.5Mb 390ms DropTail
$ns duplex-link $n(31) $n(65) 1.5Mb 210ms DropTail
$ns duplex-link $n(31) $n(64) 1.5Mb 350ms DropTail
$ns duplex-link $n(31) $n(63) 1.5Mb 680ms DropTail
$ns duplex-link $n(31) $n(58) 1.5Mb 840ms DropTail
$ns duplex-link $n(31) $n(56) 1.5Mb 500ms DropTail
$ns duplex-link $n(31) $n(52) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "1140..."; flush stdout }
$ns duplex-link $n(31) $n(37) 1.5Mb 490ms DropTail
$ns duplex-link $n(31) $n(35) 1.5Mb 460ms DropTail
$ns duplex-link $n(31) $n(34) 1.5Mb 620ms DropTail
$ns duplex-link $n(32) $n(193) 1.5Mb 610ms DropTail
$ns duplex-link $n(32) $n(192) 1.5Mb 1000ms DropTail
$ns duplex-link $n(32) $n(190) 1.5Mb 870ms DropTail
$ns duplex-link $n(32) $n(177) 1.5Mb 100ms DropTail
$ns duplex-link $n(32) $n(170) 1.5Mb 680ms DropTail
$ns duplex-link $n(32) $n(165) 1.5Mb 1110ms DropTail
$ns duplex-link $n(32) $n(152) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "1150..."; flush stdout }
$ns duplex-link $n(32) $n(149) 1.5Mb 850ms DropTail
$ns duplex-link $n(32) $n(127) 1.5Mb 790ms DropTail
$ns duplex-link $n(32) $n(123) 1.5Mb 530ms DropTail
$ns duplex-link $n(32) $n(121) 1.5Mb 700ms DropTail
$ns duplex-link $n(32) $n(120) 1.5Mb 670ms DropTail
$ns duplex-link $n(32) $n(114) 1.5Mb 620ms DropTail
$ns duplex-link $n(32) $n(105) 1.5Mb 850ms DropTail
$ns duplex-link $n(32) $n(101) 1.5Mb 260ms DropTail
$ns duplex-link $n(32) $n(100) 1.5Mb 140ms DropTail
$ns duplex-link $n(32) $n(88) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "1160..."; flush stdout }
$ns duplex-link $n(32) $n(83) 1.5Mb 220ms DropTail
$ns duplex-link $n(32) $n(67) 1.5Mb 890ms DropTail
$ns duplex-link $n(32) $n(59) 1.5Mb 420ms DropTail
$ns duplex-link $n(32) $n(44) 1.5Mb 800ms DropTail
$ns duplex-link $n(32) $n(40) 1.5Mb 270ms DropTail
$ns duplex-link $n(32) $n(38) 1.5Mb 520ms DropTail
$ns duplex-link $n(33) $n(191) 1.5Mb 800ms DropTail
$ns duplex-link $n(33) $n(188) 1.5Mb 130ms DropTail
$ns duplex-link $n(33) $n(184) 1.5Mb 600ms DropTail
$ns duplex-link $n(33) $n(178) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1170..."; flush stdout }
$ns duplex-link $n(33) $n(171) 1.5Mb 900ms DropTail
$ns duplex-link $n(33) $n(166) 1.5Mb 920ms DropTail
$ns duplex-link $n(33) $n(165) 1.5Mb 990ms DropTail
$ns duplex-link $n(33) $n(140) 1.5Mb 400ms DropTail
$ns duplex-link $n(33) $n(133) 1.5Mb 480ms DropTail
$ns duplex-link $n(33) $n(124) 1.5Mb 850ms DropTail
$ns duplex-link $n(33) $n(122) 1.5Mb 220ms DropTail
$ns duplex-link $n(33) $n(119) 1.5Mb 480ms DropTail
$ns duplex-link $n(33) $n(117) 1.5Mb 230ms DropTail
$ns duplex-link $n(33) $n(116) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "1180..."; flush stdout }
$ns duplex-link $n(33) $n(113) 1.5Mb 370ms DropTail
$ns duplex-link $n(33) $n(110) 1.5Mb 640ms DropTail
$ns duplex-link $n(33) $n(102) 1.5Mb 410ms DropTail
$ns duplex-link $n(33) $n(101) 1.5Mb 170ms DropTail
$ns duplex-link $n(33) $n(94) 1.5Mb 410ms DropTail
$ns duplex-link $n(33) $n(78) 1.5Mb 870ms DropTail
$ns duplex-link $n(33) $n(76) 1.5Mb 770ms DropTail
$ns duplex-link $n(33) $n(74) 1.5Mb 670ms DropTail
$ns duplex-link $n(33) $n(63) 1.5Mb 840ms DropTail
$ns duplex-link $n(33) $n(58) 1.5Mb 830ms DropTail
if {$verbose} { puts -nonewline "1190..."; flush stdout }
$ns duplex-link $n(33) $n(54) 1.5Mb 380ms DropTail
$ns duplex-link $n(33) $n(53) 1.5Mb 440ms DropTail
$ns duplex-link $n(33) $n(43) 1.5Mb 570ms DropTail
$ns duplex-link $n(33) $n(40) 1.5Mb 300ms DropTail
$ns duplex-link $n(34) $n(198) 1.5Mb 1060ms DropTail
$ns duplex-link $n(34) $n(195) 1.5Mb 60ms DropTail
$ns duplex-link $n(34) $n(185) 1.5Mb 630ms DropTail
$ns duplex-link $n(34) $n(180) 1.5Mb 870ms DropTail
$ns duplex-link $n(34) $n(179) 1.5Mb 60ms DropTail
$ns duplex-link $n(34) $n(174) 1.5Mb 910ms DropTail
if {$verbose} { puts -nonewline "1200..."; flush stdout }
$ns duplex-link $n(34) $n(173) 1.5Mb 560ms DropTail
$ns duplex-link $n(34) $n(169) 1.5Mb 470ms DropTail
$ns duplex-link $n(34) $n(162) 1.5Mb 450ms DropTail
$ns duplex-link $n(34) $n(153) 1.5Mb 770ms DropTail
$ns duplex-link $n(34) $n(148) 1.5Mb 520ms DropTail
$ns duplex-link $n(34) $n(144) 1.5Mb 110ms DropTail
$ns duplex-link $n(34) $n(143) 1.5Mb 40ms DropTail
$ns duplex-link $n(34) $n(135) 1.5Mb 580ms DropTail
$ns duplex-link $n(34) $n(130) 1.5Mb 660ms DropTail
$ns duplex-link $n(34) $n(128) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "1210..."; flush stdout }
$ns duplex-link $n(34) $n(123) 1.5Mb 770ms DropTail
$ns duplex-link $n(34) $n(120) 1.5Mb 760ms DropTail
$ns duplex-link $n(34) $n(112) 1.5Mb 410ms DropTail
$ns duplex-link $n(34) $n(109) 1.5Mb 220ms DropTail
$ns duplex-link $n(34) $n(107) 1.5Mb 600ms DropTail
$ns duplex-link $n(34) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(34) $n(95) 1.5Mb 570ms DropTail
$ns duplex-link $n(34) $n(85) 1.5Mb 500ms DropTail
$ns duplex-link $n(34) $n(76) 1.5Mb 40ms DropTail
$ns duplex-link $n(34) $n(73) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1220..."; flush stdout }
$ns duplex-link $n(34) $n(65) 1.5Mb 410ms DropTail
$ns duplex-link $n(34) $n(61) 1.5Mb 480ms DropTail
$ns duplex-link $n(34) $n(53) 1.5Mb 630ms DropTail
$ns duplex-link $n(34) $n(50) 1.5Mb 810ms DropTail
$ns duplex-link $n(34) $n(48) 1.5Mb 560ms DropTail
$ns duplex-link $n(34) $n(46) 1.5Mb 480ms DropTail
$ns duplex-link $n(34) $n(42) 1.5Mb 670ms DropTail
$ns duplex-link $n(35) $n(196) 1.5Mb 740ms DropTail
$ns duplex-link $n(35) $n(188) 1.5Mb 690ms DropTail
$ns duplex-link $n(35) $n(184) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "1230..."; flush stdout }
$ns duplex-link $n(35) $n(178) 1.5Mb 470ms DropTail
$ns duplex-link $n(35) $n(176) 1.5Mb 650ms DropTail
$ns duplex-link $n(35) $n(175) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(166) 1.5Mb 340ms DropTail
$ns duplex-link $n(35) $n(158) 1.5Mb 790ms DropTail
$ns duplex-link $n(35) $n(155) 1.5Mb 640ms DropTail
$ns duplex-link $n(35) $n(142) 1.5Mb 900ms DropTail
$ns duplex-link $n(35) $n(135) 1.5Mb 720ms DropTail
$ns duplex-link $n(35) $n(130) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(110) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "1240..."; flush stdout }
$ns duplex-link $n(35) $n(101) 1.5Mb 520ms DropTail
$ns duplex-link $n(35) $n(100) 1.5Mb 300ms DropTail
$ns duplex-link $n(35) $n(95) 1.5Mb 670ms DropTail
$ns duplex-link $n(35) $n(87) 1.5Mb 590ms DropTail
$ns duplex-link $n(35) $n(86) 1.5Mb 390ms DropTail
$ns duplex-link $n(35) $n(85) 1.5Mb 570ms DropTail
$ns duplex-link $n(35) $n(84) 1.5Mb 730ms DropTail
$ns duplex-link $n(35) $n(81) 1.5Mb 520ms DropTail
$ns duplex-link $n(35) $n(79) 1.5Mb 410ms DropTail
$ns duplex-link $n(35) $n(73) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "1250..."; flush stdout }
$ns duplex-link $n(35) $n(65) 1.5Mb 270ms DropTail
$ns duplex-link $n(35) $n(62) 1.5Mb 700ms DropTail
$ns duplex-link $n(35) $n(52) 1.5Mb 290ms DropTail
$ns duplex-link $n(35) $n(43) 1.5Mb 110ms DropTail
$ns duplex-link $n(35) $n(40) 1.5Mb 380ms DropTail
$ns duplex-link $n(35) $n(37) 1.5Mb 40ms DropTail
$ns duplex-link $n(35) $n(36) 1.5Mb 490ms DropTail
$ns duplex-link $n(36) $n(196) 1.5Mb 440ms DropTail
$ns duplex-link $n(36) $n(181) 1.5Mb 240ms DropTail
$ns duplex-link $n(36) $n(167) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1260..."; flush stdout }
$ns duplex-link $n(36) $n(147) 1.5Mb 250ms DropTail
$ns duplex-link $n(36) $n(146) 1.5Mb 570ms DropTail
$ns duplex-link $n(36) $n(145) 1.5Mb 700ms DropTail
$ns duplex-link $n(36) $n(131) 1.5Mb 420ms DropTail
$ns duplex-link $n(36) $n(129) 1.5Mb 370ms DropTail
$ns duplex-link $n(36) $n(124) 1.5Mb 750ms DropTail
$ns duplex-link $n(36) $n(121) 1.5Mb 540ms DropTail
$ns duplex-link $n(36) $n(120) 1.5Mb 390ms DropTail
$ns duplex-link $n(36) $n(100) 1.5Mb 210ms DropTail
$ns duplex-link $n(36) $n(98) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "1270..."; flush stdout }
$ns duplex-link $n(36) $n(85) 1.5Mb 460ms DropTail
$ns duplex-link $n(36) $n(83) 1.5Mb 350ms DropTail
$ns duplex-link $n(36) $n(74) 1.5Mb 670ms DropTail
$ns duplex-link $n(36) $n(71) 1.5Mb 380ms DropTail
$ns duplex-link $n(36) $n(70) 1.5Mb 690ms DropTail
$ns duplex-link $n(36) $n(62) 1.5Mb 760ms DropTail
$ns duplex-link $n(36) $n(54) 1.5Mb 360ms DropTail
$ns duplex-link $n(36) $n(53) 1.5Mb 320ms DropTail
$ns duplex-link $n(36) $n(47) 1.5Mb 420ms DropTail
$ns duplex-link $n(36) $n(43) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "1280..."; flush stdout }
$ns duplex-link $n(36) $n(39) 1.5Mb 230ms DropTail
$ns duplex-link $n(36) $n(37) 1.5Mb 520ms DropTail
$ns duplex-link $n(37) $n(196) 1.5Mb 750ms DropTail
$ns duplex-link $n(37) $n(191) 1.5Mb 170ms DropTail
$ns duplex-link $n(37) $n(184) 1.5Mb 710ms DropTail
$ns duplex-link $n(37) $n(180) 1.5Mb 820ms DropTail
$ns duplex-link $n(37) $n(173) 1.5Mb 470ms DropTail
$ns duplex-link $n(37) $n(170) 1.5Mb 450ms DropTail
$ns duplex-link $n(37) $n(169) 1.5Mb 630ms DropTail
$ns duplex-link $n(37) $n(167) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "1290..."; flush stdout }
$ns duplex-link $n(37) $n(163) 1.5Mb 490ms DropTail
$ns duplex-link $n(37) $n(154) 1.5Mb 150ms DropTail
$ns duplex-link $n(37) $n(150) 1.5Mb 430ms DropTail
$ns duplex-link $n(37) $n(148) 1.5Mb 580ms DropTail
$ns duplex-link $n(37) $n(142) 1.5Mb 900ms DropTail
$ns duplex-link $n(37) $n(135) 1.5Mb 710ms DropTail
$ns duplex-link $n(37) $n(131) 1.5Mb 140ms DropTail
$ns duplex-link $n(37) $n(129) 1.5Mb 470ms DropTail
$ns duplex-link $n(37) $n(125) 1.5Mb 700ms DropTail
$ns duplex-link $n(37) $n(120) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "1300..."; flush stdout }
$ns duplex-link $n(37) $n(115) 1.5Mb 800ms DropTail
$ns duplex-link $n(37) $n(106) 1.5Mb 330ms DropTail
$ns duplex-link $n(37) $n(103) 1.5Mb 900ms DropTail
$ns duplex-link $n(37) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(37) $n(98) 1.5Mb 770ms DropTail
$ns duplex-link $n(37) $n(94) 1.5Mb 520ms DropTail
$ns duplex-link $n(37) $n(91) 1.5Mb 200ms DropTail
$ns duplex-link $n(37) $n(90) 1.5Mb 680ms DropTail
$ns duplex-link $n(37) $n(89) 1.5Mb 670ms DropTail
$ns duplex-link $n(37) $n(88) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "1310..."; flush stdout }
$ns duplex-link $n(37) $n(86) 1.5Mb 350ms DropTail
$ns duplex-link $n(37) $n(84) 1.5Mb 710ms DropTail
$ns duplex-link $n(37) $n(82) 1.5Mb 90ms DropTail
$ns duplex-link $n(37) $n(80) 1.5Mb 650ms DropTail
$ns duplex-link $n(37) $n(72) 1.5Mb 320ms DropTail
$ns duplex-link $n(37) $n(71) 1.5Mb 250ms DropTail
$ns duplex-link $n(37) $n(65) 1.5Mb 300ms DropTail
$ns duplex-link $n(37) $n(61) 1.5Mb 620ms DropTail
$ns duplex-link $n(37) $n(55) 1.5Mb 650ms DropTail
$ns duplex-link $n(37) $n(42) 1.5Mb 830ms DropTail
if {$verbose} { puts -nonewline "1320..."; flush stdout }
$ns duplex-link $n(38) $n(195) 1.5Mb 90ms DropTail
$ns duplex-link $n(38) $n(191) 1.5Mb 60ms DropTail
$ns duplex-link $n(38) $n(190) 1.5Mb 920ms DropTail
$ns duplex-link $n(38) $n(185) 1.5Mb 600ms DropTail
$ns duplex-link $n(38) $n(183) 1.5Mb 780ms DropTail
$ns duplex-link $n(38) $n(179) 1.5Mb 90ms DropTail
$ns duplex-link $n(38) $n(177) 1.5Mb 540ms DropTail
$ns duplex-link $n(38) $n(174) 1.5Mb 880ms DropTail
$ns duplex-link $n(38) $n(170) 1.5Mb 310ms DropTail
$ns duplex-link $n(38) $n(155) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "1330..."; flush stdout }
$ns duplex-link $n(38) $n(148) 1.5Mb 500ms DropTail
$ns duplex-link $n(38) $n(142) 1.5Mb 790ms DropTail
$ns duplex-link $n(38) $n(141) 1.5Mb 690ms DropTail
$ns duplex-link $n(38) $n(139) 1.5Mb 620ms DropTail
$ns duplex-link $n(38) $n(138) 1.5Mb 780ms DropTail
$ns duplex-link $n(38) $n(136) 1.5Mb 600ms DropTail
$ns duplex-link $n(38) $n(134) 1.5Mb 160ms DropTail
$ns duplex-link $n(38) $n(133) 1.5Mb 860ms DropTail
$ns duplex-link $n(38) $n(128) 1.5Mb 740ms DropTail
$ns duplex-link $n(38) $n(127) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1340..."; flush stdout }
$ns duplex-link $n(38) $n(125) 1.5Mb 550ms DropTail
$ns duplex-link $n(38) $n(124) 1.5Mb 520ms DropTail
$ns duplex-link $n(38) $n(121) 1.5Mb 460ms DropTail
$ns duplex-link $n(38) $n(119) 1.5Mb 1030ms DropTail
$ns duplex-link $n(38) $n(118) 1.5Mb 680ms DropTail
$ns duplex-link $n(38) $n(109) 1.5Mb 200ms DropTail
$ns duplex-link $n(38) $n(107) 1.5Mb 570ms DropTail
$ns duplex-link $n(38) $n(100) 1.5Mb 430ms DropTail
$ns duplex-link $n(38) $n(97) 1.5Mb 290ms DropTail
$ns duplex-link $n(38) $n(93) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "1350..."; flush stdout }
$ns duplex-link $n(38) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(38) $n(74) 1.5Mb 770ms DropTail
$ns duplex-link $n(38) $n(63) 1.5Mb 90ms DropTail
$ns duplex-link $n(38) $n(45) 1.5Mb 610ms DropTail
$ns duplex-link $n(39) $n(197) 1.5Mb 730ms DropTail
$ns duplex-link $n(39) $n(191) 1.5Mb 720ms DropTail
$ns duplex-link $n(39) $n(188) 1.5Mb 80ms DropTail
$ns duplex-link $n(39) $n(185) 1.5Mb 120ms DropTail
$ns duplex-link $n(39) $n(183) 1.5Mb 440ms DropTail
$ns duplex-link $n(39) $n(179) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1360..."; flush stdout }
$ns duplex-link $n(39) $n(173) 1.5Mb 270ms DropTail
$ns duplex-link $n(39) $n(172) 1.5Mb 180ms DropTail
$ns duplex-link $n(39) $n(164) 1.5Mb 650ms DropTail
$ns duplex-link $n(39) $n(161) 1.5Mb 670ms DropTail
$ns duplex-link $n(39) $n(157) 1.5Mb 530ms DropTail
$ns duplex-link $n(39) $n(155) 1.5Mb 360ms DropTail
$ns duplex-link $n(39) $n(151) 1.5Mb 250ms DropTail
$ns duplex-link $n(39) $n(149) 1.5Mb 350ms DropTail
$ns duplex-link $n(39) $n(142) 1.5Mb 520ms DropTail
$ns duplex-link $n(39) $n(128) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1370..."; flush stdout }
$ns duplex-link $n(39) $n(123) 1.5Mb 80ms DropTail
$ns duplex-link $n(39) $n(120) 1.5Mb 160ms DropTail
$ns duplex-link $n(39) $n(118) 1.5Mb 400ms DropTail
$ns duplex-link $n(39) $n(104) 1.5Mb 340ms DropTail
$ns duplex-link $n(39) $n(103) 1.5Mb 790ms DropTail
$ns duplex-link $n(39) $n(101) 1.5Mb 290ms DropTail
$ns duplex-link $n(39) $n(100) 1.5Mb 410ms DropTail
$ns duplex-link $n(39) $n(97) 1.5Mb 450ms DropTail
$ns duplex-link $n(39) $n(95) 1.5Mb 450ms DropTail
$ns duplex-link $n(39) $n(84) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "1380..."; flush stdout }
$ns duplex-link $n(39) $n(79) 1.5Mb 250ms DropTail
$ns duplex-link $n(39) $n(75) 1.5Mb 650ms DropTail
$ns duplex-link $n(39) $n(73) 1.5Mb 410ms DropTail
$ns duplex-link $n(39) $n(63) 1.5Mb 760ms DropTail
$ns duplex-link $n(39) $n(59) 1.5Mb 110ms DropTail
$ns duplex-link $n(39) $n(54) 1.5Mb 180ms DropTail
$ns duplex-link $n(39) $n(53) 1.5Mb 550ms DropTail
$ns duplex-link $n(39) $n(50) 1.5Mb 240ms DropTail
$ns duplex-link $n(39) $n(43) 1.5Mb 540ms DropTail
$ns duplex-link $n(40) $n(197) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "1390..."; flush stdout }
$ns duplex-link $n(40) $n(193) 1.5Mb 620ms DropTail
$ns duplex-link $n(40) $n(189) 1.5Mb 220ms DropTail
$ns duplex-link $n(40) $n(188) 1.5Mb 310ms DropTail
$ns duplex-link $n(40) $n(181) 1.5Mb 370ms DropTail
$ns duplex-link $n(40) $n(171) 1.5Mb 750ms DropTail
$ns duplex-link $n(40) $n(169) 1.5Mb 680ms DropTail
$ns duplex-link $n(40) $n(162) 1.5Mb 430ms DropTail
$ns duplex-link $n(40) $n(158) 1.5Mb 710ms DropTail
$ns duplex-link $n(40) $n(149) 1.5Mb 590ms DropTail
$ns duplex-link $n(40) $n(146) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "1400..."; flush stdout }
$ns duplex-link $n(40) $n(145) 1.5Mb 570ms DropTail
$ns duplex-link $n(40) $n(133) 1.5Mb 580ms DropTail
$ns duplex-link $n(40) $n(128) 1.5Mb 310ms DropTail
$ns duplex-link $n(40) $n(127) 1.5Mb 520ms DropTail
$ns duplex-link $n(40) $n(117) 1.5Mb 90ms DropTail
$ns duplex-link $n(40) $n(115) 1.5Mb 600ms DropTail
$ns duplex-link $n(40) $n(114) 1.5Mb 560ms DropTail
$ns duplex-link $n(40) $n(112) 1.5Mb 100ms DropTail
$ns duplex-link $n(40) $n(110) 1.5Mb 570ms DropTail
$ns duplex-link $n(40) $n(109) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "1410..."; flush stdout }
$ns duplex-link $n(40) $n(105) 1.5Mb 580ms DropTail
$ns duplex-link $n(40) $n(104) 1.5Mb 270ms DropTail
$ns duplex-link $n(40) $n(101) 1.5Mb 190ms DropTail
$ns duplex-link $n(40) $n(100) 1.5Mb 140ms DropTail
$ns duplex-link $n(40) $n(96) 1.5Mb 280ms DropTail
$ns duplex-link $n(40) $n(95) 1.5Mb 510ms DropTail
$ns duplex-link $n(40) $n(88) 1.5Mb 200ms DropTail
$ns duplex-link $n(40) $n(85) 1.5Mb 390ms DropTail
$ns duplex-link $n(40) $n(78) 1.5Mb 560ms DropTail
$ns duplex-link $n(40) $n(74) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "1420..."; flush stdout }
$ns duplex-link $n(40) $n(72) 1.5Mb 380ms DropTail
$ns duplex-link $n(40) $n(65) 1.5Mb 120ms DropTail
$ns duplex-link $n(40) $n(59) 1.5Mb 170ms DropTail
$ns duplex-link $n(40) $n(49) 1.5Mb 310ms DropTail
$ns duplex-link $n(40) $n(45) 1.5Mb 640ms DropTail
$ns duplex-link $n(40) $n(43) 1.5Mb 270ms DropTail
$ns duplex-link $n(41) $n(195) 1.5Mb 170ms DropTail
$ns duplex-link $n(41) $n(173) 1.5Mb 670ms DropTail
$ns duplex-link $n(41) $n(170) 1.5Mb 260ms DropTail
$ns duplex-link $n(41) $n(164) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "1430..."; flush stdout }
$ns duplex-link $n(41) $n(151) 1.5Mb 600ms DropTail
$ns duplex-link $n(41) $n(147) 1.5Mb 670ms DropTail
$ns duplex-link $n(41) $n(145) 1.5Mb 120ms DropTail
$ns duplex-link $n(41) $n(143) 1.5Mb 150ms DropTail
$ns duplex-link $n(41) $n(140) 1.5Mb 600ms DropTail
$ns duplex-link $n(41) $n(138) 1.5Mb 810ms DropTail
$ns duplex-link $n(41) $n(133) 1.5Mb 890ms DropTail
$ns duplex-link $n(41) $n(125) 1.5Mb 440ms DropTail
$ns duplex-link $n(41) $n(120) 1.5Mb 790ms DropTail
$ns duplex-link $n(41) $n(119) 1.5Mb 1090ms DropTail
if {$verbose} { puts -nonewline "1440..."; flush stdout }
$ns duplex-link $n(41) $n(117) 1.5Mb 640ms DropTail
$ns duplex-link $n(41) $n(110) 1.5Mb 650ms DropTail
$ns duplex-link $n(41) $n(105) 1.5Mb 750ms DropTail
$ns duplex-link $n(41) $n(104) 1.5Mb 420ms DropTail
$ns duplex-link $n(41) $n(100) 1.5Mb 590ms DropTail
$ns duplex-link $n(41) $n(91) 1.5Mb 450ms DropTail
$ns duplex-link $n(41) $n(89) 1.5Mb 860ms DropTail
$ns duplex-link $n(41) $n(86) 1.5Mb 10ms DropTail
$ns duplex-link $n(41) $n(77) 1.5Mb 290ms DropTail
$ns duplex-link $n(41) $n(76) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "1450..."; flush stdout }
$ns duplex-link $n(41) $n(66) 1.5Mb 500ms DropTail
$ns duplex-link $n(41) $n(60) 1.5Mb 620ms DropTail
$ns duplex-link $n(41) $n(56) 1.5Mb 260ms DropTail
$ns duplex-link $n(41) $n(54) 1.5Mb 670ms DropTail
$ns duplex-link $n(41) $n(42) 1.5Mb 550ms DropTail
$ns duplex-link $n(42) $n(199) 1.5Mb 790ms DropTail
$ns duplex-link $n(42) $n(197) 1.5Mb 650ms DropTail
$ns duplex-link $n(42) $n(195) 1.5Mb 710ms DropTail
$ns duplex-link $n(42) $n(193) 1.5Mb 850ms DropTail
$ns duplex-link $n(42) $n(180) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "1460..."; flush stdout }
$ns duplex-link $n(42) $n(174) 1.5Mb 800ms DropTail
$ns duplex-link $n(42) $n(172) 1.5Mb 930ms DropTail
$ns duplex-link $n(42) $n(164) 1.5Mb 680ms DropTail
$ns duplex-link $n(42) $n(158) 1.5Mb 110ms DropTail
$ns duplex-link $n(42) $n(155) 1.5Mb 430ms DropTail
$ns duplex-link $n(42) $n(152) 1.5Mb 690ms DropTail
$ns duplex-link $n(42) $n(147) 1.5Mb 700ms DropTail
$ns duplex-link $n(42) $n(140) 1.5Mb 920ms DropTail
$ns duplex-link $n(42) $n(139) 1.5Mb 770ms DropTail
$ns duplex-link $n(42) $n(135) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "1470..."; flush stdout }
$ns duplex-link $n(42) $n(133) 1.5Mb 700ms DropTail
$ns duplex-link $n(42) $n(129) 1.5Mb 530ms DropTail
$ns duplex-link $n(42) $n(124) 1.5Mb 160ms DropTail
$ns duplex-link $n(42) $n(120) 1.5Mb 700ms DropTail
$ns duplex-link $n(42) $n(117) 1.5Mb 810ms DropTail
$ns duplex-link $n(42) $n(115) 1.5Mb 370ms DropTail
$ns duplex-link $n(42) $n(112) 1.5Mb 710ms DropTail
$ns duplex-link $n(42) $n(108) 1.5Mb 560ms DropTail
$ns duplex-link $n(42) $n(97) 1.5Mb 490ms DropTail
$ns duplex-link $n(42) $n(91) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "1480..."; flush stdout }
$ns duplex-link $n(42) $n(85) 1.5Mb 440ms DropTail
$ns duplex-link $n(42) $n(76) 1.5Mb 640ms DropTail
$ns duplex-link $n(42) $n(73) 1.5Mb 790ms DropTail
$ns duplex-link $n(42) $n(63) 1.5Mb 680ms DropTail
$ns duplex-link $n(42) $n(62) 1.5Mb 160ms DropTail
$ns duplex-link $n(42) $n(56) 1.5Mb 590ms DropTail
$ns duplex-link $n(42) $n(55) 1.5Mb 350ms DropTail
$ns duplex-link $n(43) $n(189) 1.5Mb 420ms DropTail
$ns duplex-link $n(43) $n(180) 1.5Mb 690ms DropTail
$ns duplex-link $n(43) $n(177) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "1490..."; flush stdout }
$ns duplex-link $n(43) $n(163) 1.5Mb 380ms DropTail
$ns duplex-link $n(43) $n(158) 1.5Mb 750ms DropTail
$ns duplex-link $n(43) $n(156) 1.5Mb 620ms DropTail
$ns duplex-link $n(43) $n(151) 1.5Mb 300ms DropTail
$ns duplex-link $n(43) $n(140) 1.5Mb 200ms DropTail
$ns duplex-link $n(43) $n(132) 1.5Mb 410ms DropTail
$ns duplex-link $n(43) $n(122) 1.5Mb 360ms DropTail
$ns duplex-link $n(43) $n(112) 1.5Mb 250ms DropTail
$ns duplex-link $n(43) $n(111) 1.5Mb 790ms DropTail
$ns duplex-link $n(43) $n(98) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "1500..."; flush stdout }
$ns duplex-link $n(43) $n(93) 1.5Mb 680ms DropTail
$ns duplex-link $n(43) $n(87) 1.5Mb 550ms DropTail
$ns duplex-link $n(43) $n(82) 1.5Mb 220ms DropTail
$ns duplex-link $n(43) $n(76) 1.5Mb 280ms DropTail
$ns duplex-link $n(43) $n(75) 1.5Mb 190ms DropTail
$ns duplex-link $n(43) $n(63) 1.5Mb 320ms DropTail
$ns duplex-link $n(43) $n(62) 1.5Mb 670ms DropTail
$ns duplex-link $n(43) $n(55) 1.5Mb 590ms DropTail
$ns duplex-link $n(43) $n(54) 1.5Mb 560ms DropTail
$ns duplex-link $n(43) $n(53) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "1510..."; flush stdout }
$ns duplex-link $n(43) $n(51) 1.5Mb 840ms DropTail
$ns duplex-link $n(43) $n(49) 1.5Mb 570ms DropTail
$ns duplex-link $n(43) $n(48) 1.5Mb 390ms DropTail
$ns duplex-link $n(43) $n(47) 1.5Mb 700ms DropTail
$ns duplex-link $n(43) $n(45) 1.5Mb 710ms DropTail
$ns duplex-link $n(44) $n(195) 1.5Mb 610ms DropTail
$ns duplex-link $n(44) $n(182) 1.5Mb 500ms DropTail
$ns duplex-link $n(44) $n(180) 1.5Mb 660ms DropTail
$ns duplex-link $n(44) $n(170) 1.5Mb 250ms DropTail
$ns duplex-link $n(44) $n(160) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "1520..."; flush stdout }
$ns duplex-link $n(44) $n(157) 1.5Mb 30ms DropTail
$ns duplex-link $n(44) $n(156) 1.5Mb 50ms DropTail
$ns duplex-link $n(44) $n(154) 1.5Mb 640ms DropTail
$ns duplex-link $n(44) $n(150) 1.5Mb 800ms DropTail
$ns duplex-link $n(44) $n(149) 1.5Mb 430ms DropTail
$ns duplex-link $n(44) $n(147) 1.5Mb 420ms DropTail
$ns duplex-link $n(44) $n(146) 1.5Mb 110ms DropTail
$ns duplex-link $n(44) $n(141) 1.5Mb 160ms DropTail
$ns duplex-link $n(44) $n(130) 1.5Mb 140ms DropTail
$ns duplex-link $n(44) $n(129) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "1530..."; flush stdout }
$ns duplex-link $n(44) $n(106) 1.5Mb 340ms DropTail
$ns duplex-link $n(44) $n(94) 1.5Mb 300ms DropTail
$ns duplex-link $n(44) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(44) $n(77) 1.5Mb 230ms DropTail
$ns duplex-link $n(44) $n(73) 1.5Mb 560ms DropTail
$ns duplex-link $n(44) $n(66) 1.5Mb 270ms DropTail
$ns duplex-link $n(44) $n(65) 1.5Mb 610ms DropTail
$ns duplex-link $n(44) $n(61) 1.5Mb 140ms DropTail
$ns duplex-link $n(44) $n(57) 1.5Mb 740ms DropTail
$ns duplex-link $n(44) $n(54) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "1540..."; flush stdout }
$ns duplex-link $n(44) $n(50) 1.5Mb 420ms DropTail
$ns duplex-link $n(44) $n(47) 1.5Mb 460ms DropTail
$ns duplex-link $n(45) $n(198) 1.5Mb 740ms DropTail
$ns duplex-link $n(45) $n(194) 1.5Mb 740ms DropTail
$ns duplex-link $n(45) $n(192) 1.5Mb 140ms DropTail
$ns duplex-link $n(45) $n(175) 1.5Mb 380ms DropTail
$ns duplex-link $n(45) $n(172) 1.5Mb 730ms DropTail
$ns duplex-link $n(45) $n(169) 1.5Mb 250ms DropTail
$ns duplex-link $n(45) $n(168) 1.5Mb 100ms DropTail
$ns duplex-link $n(45) $n(166) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "1550..."; flush stdout }
$ns duplex-link $n(45) $n(162) 1.5Mb 220ms DropTail
$ns duplex-link $n(45) $n(157) 1.5Mb 80ms DropTail
$ns duplex-link $n(45) $n(153) 1.5Mb 900ms DropTail
$ns duplex-link $n(45) $n(149) 1.5Mb 470ms DropTail
$ns duplex-link $n(45) $n(148) 1.5Mb 280ms DropTail
$ns duplex-link $n(45) $n(145) 1.5Mb 420ms DropTail
$ns duplex-link $n(45) $n(140) 1.5Mb 770ms DropTail
$ns duplex-link $n(45) $n(137) 1.5Mb 420ms DropTail
$ns duplex-link $n(45) $n(135) 1.5Mb 40ms DropTail
$ns duplex-link $n(45) $n(133) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "1560..."; flush stdout }
$ns duplex-link $n(45) $n(128) 1.5Mb 740ms DropTail
$ns duplex-link $n(45) $n(127) 1.5Mb 360ms DropTail
$ns duplex-link $n(45) $n(124) 1.5Mb 160ms DropTail
$ns duplex-link $n(45) $n(114) 1.5Mb 660ms DropTail
$ns duplex-link $n(45) $n(93) 1.5Mb 220ms DropTail
$ns duplex-link $n(45) $n(83) 1.5Mb 760ms DropTail
$ns duplex-link $n(45) $n(74) 1.5Mb 260ms DropTail
$ns duplex-link $n(45) $n(62) 1.5Mb 160ms DropTail
$ns duplex-link $n(45) $n(57) 1.5Mb 830ms DropTail
$ns duplex-link $n(45) $n(56) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1570..."; flush stdout }
$ns duplex-link $n(45) $n(53) 1.5Mb 970ms DropTail
$ns duplex-link $n(45) $n(50) 1.5Mb 480ms DropTail
$ns duplex-link $n(45) $n(46) 1.5Mb 770ms DropTail
$ns duplex-link $n(46) $n(198) 1.5Mb 780ms DropTail
$ns duplex-link $n(46) $n(197) 1.5Mb 530ms DropTail
$ns duplex-link $n(46) $n(196) 1.5Mb 580ms DropTail
$ns duplex-link $n(46) $n(185) 1.5Mb 290ms DropTail
$ns duplex-link $n(46) $n(180) 1.5Mb 520ms DropTail
$ns duplex-link $n(46) $n(176) 1.5Mb 490ms DropTail
$ns duplex-link $n(46) $n(170) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "1580..."; flush stdout }
$ns duplex-link $n(46) $n(169) 1.5Mb 770ms DropTail
$ns duplex-link $n(46) $n(159) 1.5Mb 620ms DropTail
$ns duplex-link $n(46) $n(153) 1.5Mb 300ms DropTail
$ns duplex-link $n(46) $n(146) 1.5Mb 600ms DropTail
$ns duplex-link $n(46) $n(140) 1.5Mb 30ms DropTail
$ns duplex-link $n(46) $n(136) 1.5Mb 670ms DropTail
$ns duplex-link $n(46) $n(129) 1.5Mb 410ms DropTail
$ns duplex-link $n(46) $n(128) 1.5Mb 380ms DropTail
$ns duplex-link $n(46) $n(118) 1.5Mb 690ms DropTail
$ns duplex-link $n(46) $n(116) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1590..."; flush stdout }
$ns duplex-link $n(46) $n(115) 1.5Mb 730ms DropTail
$ns duplex-link $n(46) $n(113) 1.5Mb 40ms DropTail
$ns duplex-link $n(46) $n(107) 1.5Mb 340ms DropTail
$ns duplex-link $n(46) $n(101) 1.5Mb 200ms DropTail
$ns duplex-link $n(46) $n(86) 1.5Mb 620ms DropTail
$ns duplex-link $n(46) $n(80) 1.5Mb 420ms DropTail
$ns duplex-link $n(46) $n(76) 1.5Mb 480ms DropTail
$ns duplex-link $n(46) $n(74) 1.5Mb 780ms DropTail
$ns duplex-link $n(46) $n(69) 1.5Mb 400ms DropTail
$ns duplex-link $n(46) $n(66) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1600..."; flush stdout }
$ns duplex-link $n(46) $n(64) 1.5Mb 440ms DropTail
$ns duplex-link $n(47) $n(198) 1.5Mb 260ms DropTail
$ns duplex-link $n(47) $n(197) 1.5Mb 830ms DropTail
$ns duplex-link $n(47) $n(193) 1.5Mb 1000ms DropTail
$ns duplex-link $n(47) $n(190) 1.5Mb 170ms DropTail
$ns duplex-link $n(47) $n(185) 1.5Mb 310ms DropTail
$ns duplex-link $n(47) $n(173) 1.5Mb 460ms DropTail
$ns duplex-link $n(47) $n(161) 1.5Mb 590ms DropTail
$ns duplex-link $n(47) $n(152) 1.5Mb 430ms DropTail
$ns duplex-link $n(47) $n(140) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "1610..."; flush stdout }
$ns duplex-link $n(47) $n(132) 1.5Mb 350ms DropTail
$ns duplex-link $n(47) $n(130) 1.5Mb 550ms DropTail
$ns duplex-link $n(47) $n(128) 1.5Mb 310ms DropTail
$ns duplex-link $n(47) $n(127) 1.5Mb 180ms DropTail
$ns duplex-link $n(47) $n(124) 1.5Mb 640ms DropTail
$ns duplex-link $n(47) $n(123) 1.5Mb 210ms DropTail
$ns duplex-link $n(47) $n(118) 1.5Mb 300ms DropTail
$ns duplex-link $n(47) $n(116) 1.5Mb 720ms DropTail
$ns duplex-link $n(47) $n(112) 1.5Mb 440ms DropTail
$ns duplex-link $n(47) $n(106) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "1620..."; flush stdout }
$ns duplex-link $n(47) $n(103) 1.5Mb 710ms DropTail
$ns duplex-link $n(47) $n(98) 1.5Mb 310ms DropTail
$ns duplex-link $n(47) $n(97) 1.5Mb 520ms DropTail
$ns duplex-link $n(47) $n(96) 1.5Mb 310ms DropTail
$ns duplex-link $n(47) $n(89) 1.5Mb 420ms DropTail
$ns duplex-link $n(47) $n(88) 1.5Mb 330ms DropTail
$ns duplex-link $n(47) $n(76) 1.5Mb 780ms DropTail
$ns duplex-link $n(47) $n(75) 1.5Mb 770ms DropTail
$ns duplex-link $n(47) $n(73) 1.5Mb 570ms DropTail
$ns duplex-link $n(47) $n(70) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1630..."; flush stdout }
$ns duplex-link $n(47) $n(67) 1.5Mb 500ms DropTail
$ns duplex-link $n(47) $n(66) 1.5Mb 340ms DropTail
$ns duplex-link $n(47) $n(62) 1.5Mb 650ms DropTail
$ns duplex-link $n(47) $n(58) 1.5Mb 620ms DropTail
$ns duplex-link $n(47) $n(54) 1.5Mb 170ms DropTail
$ns duplex-link $n(47) $n(49) 1.5Mb 170ms DropTail
$ns duplex-link $n(47) $n(48) 1.5Mb 320ms DropTail
$ns duplex-link $n(48) $n(195) 1.5Mb 610ms DropTail
$ns duplex-link $n(48) $n(171) 1.5Mb 690ms DropTail
$ns duplex-link $n(48) $n(164) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "1640..."; flush stdout }
$ns duplex-link $n(48) $n(145) 1.5Mb 600ms DropTail
$ns duplex-link $n(48) $n(142) 1.5Mb 570ms DropTail
$ns duplex-link $n(48) $n(140) 1.5Mb 290ms DropTail
$ns duplex-link $n(48) $n(139) 1.5Mb 110ms DropTail
$ns duplex-link $n(48) $n(137) 1.5Mb 360ms DropTail
$ns duplex-link $n(48) $n(133) 1.5Mb 440ms DropTail
$ns duplex-link $n(48) $n(131) 1.5Mb 460ms DropTail
$ns duplex-link $n(48) $n(130) 1.5Mb 620ms DropTail
$ns duplex-link $n(48) $n(129) 1.5Mb 240ms DropTail
$ns duplex-link $n(48) $n(125) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "1650..."; flush stdout }
$ns duplex-link $n(48) $n(113) 1.5Mb 300ms DropTail
$ns duplex-link $n(48) $n(110) 1.5Mb 470ms DropTail
$ns duplex-link $n(48) $n(108) 1.5Mb 200ms DropTail
$ns duplex-link $n(48) $n(106) 1.5Mb 350ms DropTail
$ns duplex-link $n(48) $n(101) 1.5Mb 220ms DropTail
$ns duplex-link $n(48) $n(87) 1.5Mb 490ms DropTail
$ns duplex-link $n(48) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(48) $n(75) 1.5Mb 510ms DropTail
$ns duplex-link $n(48) $n(72) 1.5Mb 410ms DropTail
$ns duplex-link $n(48) $n(70) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "1660..."; flush stdout }
$ns duplex-link $n(48) $n(69) 1.5Mb 280ms DropTail
$ns duplex-link $n(48) $n(62) 1.5Mb 630ms DropTail
$ns duplex-link $n(48) $n(61) 1.5Mb 550ms DropTail
$ns duplex-link $n(48) $n(53) 1.5Mb 440ms DropTail
$ns duplex-link $n(48) $n(51) 1.5Mb 650ms DropTail
$ns duplex-link $n(48) $n(50) 1.5Mb 350ms DropTail
$ns duplex-link $n(49) $n(199) 1.5Mb 900ms DropTail
$ns duplex-link $n(49) $n(197) 1.5Mb 760ms DropTail
$ns duplex-link $n(49) $n(187) 1.5Mb 560ms DropTail
$ns duplex-link $n(49) $n(182) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1670..."; flush stdout }
$ns duplex-link $n(49) $n(174) 1.5Mb 250ms DropTail
$ns duplex-link $n(49) $n(167) 1.5Mb 630ms DropTail
$ns duplex-link $n(49) $n(166) 1.5Mb 850ms DropTail
$ns duplex-link $n(49) $n(165) 1.5Mb 800ms DropTail
$ns duplex-link $n(49) $n(160) 1.5Mb 570ms DropTail
$ns duplex-link $n(49) $n(159) 1.5Mb 740ms DropTail
$ns duplex-link $n(49) $n(157) 1.5Mb 540ms DropTail
$ns duplex-link $n(49) $n(155) 1.5Mb 370ms DropTail
$ns duplex-link $n(49) $n(152) 1.5Mb 320ms DropTail
$ns duplex-link $n(49) $n(148) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "1680..."; flush stdout }
$ns duplex-link $n(49) $n(144) 1.5Mb 800ms DropTail
$ns duplex-link $n(49) $n(135) 1.5Mb 590ms DropTail
$ns duplex-link $n(49) $n(130) 1.5Mb 630ms DropTail
$ns duplex-link $n(49) $n(126) 1.5Mb 770ms DropTail
$ns duplex-link $n(49) $n(117) 1.5Mb 220ms DropTail
$ns duplex-link $n(49) $n(116) 1.5Mb 550ms DropTail
$ns duplex-link $n(49) $n(113) 1.5Mb 450ms DropTail
$ns duplex-link $n(49) $n(101) 1.5Mb 300ms DropTail
$ns duplex-link $n(49) $n(86) 1.5Mb 790ms DropTail
$ns duplex-link $n(49) $n(84) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1690..."; flush stdout }
$ns duplex-link $n(49) $n(83) 1.5Mb 560ms DropTail
$ns duplex-link $n(49) $n(76) 1.5Mb 700ms DropTail
$ns duplex-link $n(49) $n(65) 1.5Mb 430ms DropTail
$ns duplex-link $n(50) $n(197) 1.5Mb 830ms DropTail
$ns duplex-link $n(50) $n(188) 1.5Mb 280ms DropTail
$ns duplex-link $n(50) $n(186) 1.5Mb 200ms DropTail
$ns duplex-link $n(50) $n(180) 1.5Mb 300ms DropTail
$ns duplex-link $n(50) $n(177) 1.5Mb 650ms DropTail
$ns duplex-link $n(50) $n(175) 1.5Mb 100ms DropTail
$ns duplex-link $n(50) $n(169) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "1700..."; flush stdout }
$ns duplex-link $n(50) $n(168) 1.5Mb 440ms DropTail
$ns duplex-link $n(50) $n(167) 1.5Mb 810ms DropTail
$ns duplex-link $n(50) $n(166) 1.5Mb 920ms DropTail
$ns duplex-link $n(50) $n(158) 1.5Mb 570ms DropTail
$ns duplex-link $n(50) $n(153) 1.5Mb 580ms DropTail
$ns duplex-link $n(50) $n(143) 1.5Mb 850ms DropTail
$ns duplex-link $n(50) $n(140) 1.5Mb 640ms DropTail
$ns duplex-link $n(50) $n(138) 1.5Mb 40ms DropTail
$ns duplex-link $n(50) $n(134) 1.5Mb 930ms DropTail
$ns duplex-link $n(50) $n(133) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "1710..."; flush stdout }
$ns duplex-link $n(50) $n(124) 1.5Mb 610ms DropTail
$ns duplex-link $n(50) $n(122) 1.5Mb 420ms DropTail
$ns duplex-link $n(50) $n(100) 1.5Mb 630ms DropTail
$ns duplex-link $n(50) $n(91) 1.5Mb 660ms DropTail
$ns duplex-link $n(50) $n(90) 1.5Mb 160ms DropTail
$ns duplex-link $n(50) $n(88) 1.5Mb 340ms DropTail
$ns duplex-link $n(50) $n(87) 1.5Mb 510ms DropTail
$ns duplex-link $n(50) $n(81) 1.5Mb 330ms DropTail
$ns duplex-link $n(50) $n(79) 1.5Mb 410ms DropTail
$ns duplex-link $n(50) $n(70) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "1720..."; flush stdout }
$ns duplex-link $n(50) $n(68) 1.5Mb 690ms DropTail
$ns duplex-link $n(50) $n(66) 1.5Mb 330ms DropTail
$ns duplex-link $n(50) $n(52) 1.5Mb 720ms DropTail
$ns duplex-link $n(50) $n(51) 1.5Mb 470ms DropTail
$ns duplex-link $n(51) $n(192) 1.5Mb 210ms DropTail
$ns duplex-link $n(51) $n(188) 1.5Mb 700ms DropTail
$ns duplex-link $n(51) $n(186) 1.5Mb 270ms DropTail
$ns duplex-link $n(51) $n(176) 1.5Mb 440ms DropTail
$ns duplex-link $n(51) $n(154) 1.5Mb 850ms DropTail
$ns duplex-link $n(51) $n(151) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1730..."; flush stdout }
$ns duplex-link $n(51) $n(149) 1.5Mb 420ms DropTail
$ns duplex-link $n(51) $n(141) 1.5Mb 60ms DropTail
$ns duplex-link $n(51) $n(139) 1.5Mb 620ms DropTail
$ns duplex-link $n(51) $n(133) 1.5Mb 470ms DropTail
$ns duplex-link $n(51) $n(127) 1.5Mb 340ms DropTail
$ns duplex-link $n(51) $n(122) 1.5Mb 720ms DropTail
$ns duplex-link $n(51) $n(113) 1.5Mb 910ms DropTail
$ns duplex-link $n(51) $n(110) 1.5Mb 190ms DropTail
$ns duplex-link $n(51) $n(108) 1.5Mb 490ms DropTail
$ns duplex-link $n(51) $n(104) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1740..."; flush stdout }
$ns duplex-link $n(51) $n(100) 1.5Mb 860ms DropTail
$ns duplex-link $n(51) $n(99) 1.5Mb 960ms DropTail
$ns duplex-link $n(51) $n(84) 1.5Mb 280ms DropTail
$ns duplex-link $n(51) $n(76) 1.5Mb 730ms DropTail
$ns duplex-link $n(51) $n(75) 1.5Mb 780ms DropTail
$ns duplex-link $n(51) $n(73) 1.5Mb 760ms DropTail
$ns duplex-link $n(51) $n(68) 1.5Mb 470ms DropTail
$ns duplex-link $n(51) $n(65) 1.5Mb 810ms DropTail
$ns duplex-link $n(51) $n(59) 1.5Mb 640ms DropTail
$ns duplex-link $n(51) $n(54) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "1750..."; flush stdout }
$ns duplex-link $n(52) $n(198) 1.5Mb 980ms DropTail
$ns duplex-link $n(52) $n(197) 1.5Mb 110ms DropTail
$ns duplex-link $n(52) $n(193) 1.5Mb 310ms DropTail
$ns duplex-link $n(52) $n(187) 1.5Mb 150ms DropTail
$ns duplex-link $n(52) $n(186) 1.5Mb 640ms DropTail
$ns duplex-link $n(52) $n(181) 1.5Mb 810ms DropTail
$ns duplex-link $n(52) $n(158) 1.5Mb 520ms DropTail
$ns duplex-link $n(52) $n(153) 1.5Mb 760ms DropTail
$ns duplex-link $n(52) $n(151) 1.5Mb 470ms DropTail
$ns duplex-link $n(52) $n(150) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "1760..."; flush stdout }
$ns duplex-link $n(52) $n(149) 1.5Mb 790ms DropTail
$ns duplex-link $n(52) $n(137) 1.5Mb 690ms DropTail
$ns duplex-link $n(52) $n(135) 1.5Mb 470ms DropTail
$ns duplex-link $n(52) $n(134) 1.5Mb 210ms DropTail
$ns duplex-link $n(52) $n(128) 1.5Mb 730ms DropTail
$ns duplex-link $n(52) $n(121) 1.5Mb 370ms DropTail
$ns duplex-link $n(52) $n(118) 1.5Mb 600ms DropTail
$ns duplex-link $n(52) $n(115) 1.5Mb 600ms DropTail
$ns duplex-link $n(52) $n(106) 1.5Mb 170ms DropTail
$ns duplex-link $n(52) $n(86) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "1770..."; flush stdout }
$ns duplex-link $n(52) $n(79) 1.5Mb 400ms DropTail
$ns duplex-link $n(52) $n(77) 1.5Mb 290ms DropTail
$ns duplex-link $n(52) $n(74) 1.5Mb 690ms DropTail
$ns duplex-link $n(52) $n(65) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(64) 1.5Mb 770ms DropTail
$ns duplex-link $n(52) $n(62) 1.5Mb 420ms DropTail
$ns duplex-link $n(52) $n(58) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(57) 1.5Mb 490ms DropTail
$ns duplex-link $n(52) $n(54) 1.5Mb 560ms DropTail
$ns duplex-link $n(53) $n(197) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "1780..."; flush stdout }
$ns duplex-link $n(53) $n(192) 1.5Mb 1070ms DropTail
$ns duplex-link $n(53) $n(181) 1.5Mb 440ms DropTail
$ns duplex-link $n(53) $n(180) 1.5Mb 610ms DropTail
$ns duplex-link $n(53) $n(179) 1.5Mb 690ms DropTail
$ns duplex-link $n(53) $n(169) 1.5Mb 960ms DropTail
$ns duplex-link $n(53) $n(166) 1.5Mb 760ms DropTail
$ns duplex-link $n(53) $n(163) 1.5Mb 520ms DropTail
$ns duplex-link $n(53) $n(159) 1.5Mb 790ms DropTail
$ns duplex-link $n(53) $n(156) 1.5Mb 850ms DropTail
$ns duplex-link $n(53) $n(152) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1790..."; flush stdout }
$ns duplex-link $n(53) $n(140) 1.5Mb 200ms DropTail
$ns duplex-link $n(53) $n(138) 1.5Mb 810ms DropTail
$ns duplex-link $n(53) $n(127) 1.5Mb 840ms DropTail
$ns duplex-link $n(53) $n(124) 1.5Mb 960ms DropTail
$ns duplex-link $n(53) $n(101) 1.5Mb 270ms DropTail
$ns duplex-link $n(53) $n(100) 1.5Mb 210ms DropTail
$ns duplex-link $n(53) $n(99) 1.5Mb 190ms DropTail
$ns duplex-link $n(53) $n(93) 1.5Mb 990ms DropTail
$ns duplex-link $n(53) $n(88) 1.5Mb 530ms DropTail
$ns duplex-link $n(53) $n(85) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1800..."; flush stdout }
$ns duplex-link $n(53) $n(72) 1.5Mb 640ms DropTail
$ns duplex-link $n(53) $n(70) 1.5Mb 810ms DropTail
$ns duplex-link $n(53) $n(60) 1.5Mb 310ms DropTail
$ns duplex-link $n(53) $n(56) 1.5Mb 560ms DropTail
$ns duplex-link $n(53) $n(54) 1.5Mb 670ms DropTail
$ns duplex-link $n(54) $n(199) 1.5Mb 830ms DropTail
$ns duplex-link $n(54) $n(194) 1.5Mb 340ms DropTail
$ns duplex-link $n(54) $n(189) 1.5Mb 490ms DropTail
$ns duplex-link $n(54) $n(184) 1.5Mb 230ms DropTail
$ns duplex-link $n(54) $n(182) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "1810..."; flush stdout }
$ns duplex-link $n(54) $n(181) 1.5Mb 470ms DropTail
$ns duplex-link $n(54) $n(178) 1.5Mb 180ms DropTail
$ns duplex-link $n(54) $n(174) 1.5Mb 270ms DropTail
$ns duplex-link $n(54) $n(170) 1.5Mb 440ms DropTail
$ns duplex-link $n(54) $n(168) 1.5Mb 410ms DropTail
$ns duplex-link $n(54) $n(166) 1.5Mb 760ms DropTail
$ns duplex-link $n(54) $n(164) 1.5Mb 600ms DropTail
$ns duplex-link $n(54) $n(158) 1.5Mb 500ms DropTail
$ns duplex-link $n(54) $n(154) 1.5Mb 560ms DropTail
$ns duplex-link $n(54) $n(153) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "1820..."; flush stdout }
$ns duplex-link $n(54) $n(144) 1.5Mb 700ms DropTail
$ns duplex-link $n(54) $n(142) 1.5Mb 350ms DropTail
$ns duplex-link $n(54) $n(138) 1.5Mb 170ms DropTail
$ns duplex-link $n(54) $n(137) 1.5Mb 150ms DropTail
$ns duplex-link $n(54) $n(129) 1.5Mb 220ms DropTail
$ns duplex-link $n(54) $n(116) 1.5Mb 700ms DropTail
$ns duplex-link $n(54) $n(115) 1.5Mb 290ms DropTail
$ns duplex-link $n(54) $n(106) 1.5Mb 390ms DropTail
$ns duplex-link $n(54) $n(99) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(92) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "1830..."; flush stdout }
$ns duplex-link $n(54) $n(91) 1.5Mb 510ms DropTail
$ns duplex-link $n(54) $n(89) 1.5Mb 420ms DropTail
$ns duplex-link $n(54) $n(87) 1.5Mb 390ms DropTail
$ns duplex-link $n(54) $n(86) 1.5Mb 680ms DropTail
$ns duplex-link $n(54) $n(80) 1.5Mb 140ms DropTail
$ns duplex-link $n(54) $n(76) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(74) 1.5Mb 310ms DropTail
$ns duplex-link $n(54) $n(73) 1.5Mb 440ms DropTail
$ns duplex-link $n(55) $n(198) 1.5Mb 630ms DropTail
$ns duplex-link $n(55) $n(194) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "1840..."; flush stdout }
$ns duplex-link $n(55) $n(190) 1.5Mb 460ms DropTail
$ns duplex-link $n(55) $n(167) 1.5Mb 740ms DropTail
$ns duplex-link $n(55) $n(150) 1.5Mb 740ms DropTail
$ns duplex-link $n(55) $n(141) 1.5Mb 200ms DropTail
$ns duplex-link $n(55) $n(139) 1.5Mb 420ms DropTail
$ns duplex-link $n(55) $n(138) 1.5Mb 330ms DropTail
$ns duplex-link $n(55) $n(133) 1.5Mb 400ms DropTail
$ns duplex-link $n(55) $n(130) 1.5Mb 200ms DropTail
$ns duplex-link $n(55) $n(126) 1.5Mb 490ms DropTail
$ns duplex-link $n(55) $n(124) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "1850..."; flush stdout }
$ns duplex-link $n(55) $n(123) 1.5Mb 510ms DropTail
$ns duplex-link $n(55) $n(118) 1.5Mb 150ms DropTail
$ns duplex-link $n(55) $n(111) 1.5Mb 200ms DropTail
$ns duplex-link $n(55) $n(100) 1.5Mb 610ms DropTail
$ns duplex-link $n(55) $n(98) 1.5Mb 140ms DropTail
$ns duplex-link $n(55) $n(79) 1.5Mb 370ms DropTail
$ns duplex-link $n(55) $n(76) 1.5Mb 530ms DropTail
$ns duplex-link $n(55) $n(73) 1.5Mb 520ms DropTail
$ns duplex-link $n(55) $n(71) 1.5Mb 410ms DropTail
$ns duplex-link $n(55) $n(70) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1860..."; flush stdout }
$ns duplex-link $n(55) $n(64) 1.5Mb 590ms DropTail
$ns duplex-link $n(55) $n(58) 1.5Mb 230ms DropTail
$ns duplex-link $n(55) $n(57) 1.5Mb 690ms DropTail
$ns duplex-link $n(56) $n(195) 1.5Mb 250ms DropTail
$ns duplex-link $n(56) $n(184) 1.5Mb 450ms DropTail
$ns duplex-link $n(56) $n(178) 1.5Mb 270ms DropTail
$ns duplex-link $n(56) $n(176) 1.5Mb 440ms DropTail
$ns duplex-link $n(56) $n(172) 1.5Mb 680ms DropTail
$ns duplex-link $n(56) $n(171) 1.5Mb 560ms DropTail
$ns duplex-link $n(56) $n(170) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "1870..."; flush stdout }
$ns duplex-link $n(56) $n(169) 1.5Mb 410ms DropTail
$ns duplex-link $n(56) $n(164) 1.5Mb 160ms DropTail
$ns duplex-link $n(56) $n(162) 1.5Mb 280ms DropTail
$ns duplex-link $n(56) $n(157) 1.5Mb 410ms DropTail
$ns duplex-link $n(56) $n(154) 1.5Mb 250ms DropTail
$ns duplex-link $n(56) $n(147) 1.5Mb 430ms DropTail
$ns duplex-link $n(56) $n(146) 1.5Mb 300ms DropTail
$ns duplex-link $n(56) $n(144) 1.5Mb 270ms DropTail
$ns duplex-link $n(56) $n(143) 1.5Mb 240ms DropTail
$ns duplex-link $n(56) $n(133) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "1880..."; flush stdout }
$ns duplex-link $n(56) $n(131) 1.5Mb 320ms DropTail
$ns duplex-link $n(56) $n(123) 1.5Mb 580ms DropTail
$ns duplex-link $n(56) $n(119) 1.5Mb 860ms DropTail
$ns duplex-link $n(56) $n(117) 1.5Mb 380ms DropTail
$ns duplex-link $n(56) $n(110) 1.5Mb 520ms DropTail
$ns duplex-link $n(56) $n(108) 1.5Mb 250ms DropTail
$ns duplex-link $n(56) $n(98) 1.5Mb 520ms DropTail
$ns duplex-link $n(56) $n(96) 1.5Mb 300ms DropTail
$ns duplex-link $n(56) $n(81) 1.5Mb 290ms DropTail
$ns duplex-link $n(56) $n(78) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "1890..."; flush stdout }
$ns duplex-link $n(56) $n(75) 1.5Mb 170ms DropTail
$ns duplex-link $n(56) $n(70) 1.5Mb 250ms DropTail
$ns duplex-link $n(56) $n(69) 1.5Mb 170ms DropTail
$ns duplex-link $n(56) $n(60) 1.5Mb 360ms DropTail
$ns duplex-link $n(56) $n(59) 1.5Mb 400ms DropTail
$ns duplex-link $n(56) $n(58) 1.5Mb 420ms DropTail
$ns duplex-link $n(57) $n(196) 1.5Mb 670ms DropTail
$ns duplex-link $n(57) $n(187) 1.5Mb 350ms DropTail
$ns duplex-link $n(57) $n(186) 1.5Mb 770ms DropTail
$ns duplex-link $n(57) $n(168) 1.5Mb 890ms DropTail
if {$verbose} { puts -nonewline "1900..."; flush stdout }
$ns duplex-link $n(57) $n(155) 1.5Mb 650ms DropTail
$ns duplex-link $n(57) $n(145) 1.5Mb 650ms DropTail
$ns duplex-link $n(57) $n(127) 1.5Mb 750ms DropTail
$ns duplex-link $n(57) $n(123) 1.5Mb 530ms DropTail
$ns duplex-link $n(57) $n(114) 1.5Mb 540ms DropTail
$ns duplex-link $n(57) $n(112) 1.5Mb 290ms DropTail
$ns duplex-link $n(57) $n(111) 1.5Mb 870ms DropTail
$ns duplex-link $n(57) $n(105) 1.5Mb 810ms DropTail
$ns duplex-link $n(57) $n(104) 1.5Mb 450ms DropTail
$ns duplex-link $n(57) $n(96) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1910..."; flush stdout }
$ns duplex-link $n(57) $n(77) 1.5Mb 710ms DropTail
$ns duplex-link $n(57) $n(70) 1.5Mb 640ms DropTail
$ns duplex-link $n(57) $n(67) 1.5Mb 830ms DropTail
$ns duplex-link $n(57) $n(64) 1.5Mb 530ms DropTail
$ns duplex-link $n(58) $n(199) 1.5Mb 660ms DropTail
$ns duplex-link $n(58) $n(195) 1.5Mb 560ms DropTail
$ns duplex-link $n(58) $n(194) 1.5Mb 810ms DropTail
$ns duplex-link $n(58) $n(190) 1.5Mb 670ms DropTail
$ns duplex-link $n(58) $n(186) 1.5Mb 410ms DropTail
$ns duplex-link $n(58) $n(183) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "1920..."; flush stdout }
$ns duplex-link $n(58) $n(173) 1.5Mb 720ms DropTail
$ns duplex-link $n(58) $n(168) 1.5Mb 240ms DropTail
$ns duplex-link $n(58) $n(164) 1.5Mb 520ms DropTail
$ns duplex-link $n(58) $n(162) 1.5Mb 210ms DropTail
$ns duplex-link $n(58) $n(153) 1.5Mb 930ms DropTail
$ns duplex-link $n(58) $n(149) 1.5Mb 590ms DropTail
$ns duplex-link $n(58) $n(143) 1.5Mb 540ms DropTail
$ns duplex-link $n(58) $n(137) 1.5Mb 530ms DropTail
$ns duplex-link $n(58) $n(136) 1.5Mb 250ms DropTail
$ns duplex-link $n(58) $n(135) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "1930..."; flush stdout }
$ns duplex-link $n(58) $n(134) 1.5Mb 580ms DropTail
$ns duplex-link $n(58) $n(133) 1.5Mb 620ms DropTail
$ns duplex-link $n(58) $n(130) 1.5Mb 160ms DropTail
$ns duplex-link $n(58) $n(125) 1.5Mb 40ms DropTail
$ns duplex-link $n(58) $n(110) 1.5Mb 320ms DropTail
$ns duplex-link $n(58) $n(107) 1.5Mb 590ms DropTail
$ns duplex-link $n(58) $n(104) 1.5Mb 370ms DropTail
$ns duplex-link $n(58) $n(103) 1.5Mb 230ms DropTail
$ns duplex-link $n(58) $n(100) 1.5Mb 740ms DropTail
$ns duplex-link $n(58) $n(95) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "1940..."; flush stdout }
$ns duplex-link $n(58) $n(70) 1.5Mb 280ms DropTail
$ns duplex-link $n(58) $n(69) 1.5Mb 350ms DropTail
$ns duplex-link $n(58) $n(65) 1.5Mb 680ms DropTail
$ns duplex-link $n(59) $n(176) 1.5Mb 210ms DropTail
$ns duplex-link $n(59) $n(170) 1.5Mb 490ms DropTail
$ns duplex-link $n(59) $n(169) 1.5Mb 670ms DropTail
$ns duplex-link $n(59) $n(168) 1.5Mb 590ms DropTail
$ns duplex-link $n(59) $n(166) 1.5Mb 720ms DropTail
$ns duplex-link $n(59) $n(158) 1.5Mb 650ms DropTail
$ns duplex-link $n(59) $n(157) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "1950..."; flush stdout }
$ns duplex-link $n(59) $n(156) 1.5Mb 440ms DropTail
$ns duplex-link $n(59) $n(154) 1.5Mb 420ms DropTail
$ns duplex-link $n(59) $n(150) 1.5Mb 390ms DropTail
$ns duplex-link $n(59) $n(147) 1.5Mb 90ms DropTail
$ns duplex-link $n(59) $n(146) 1.5Mb 450ms DropTail
$ns duplex-link $n(59) $n(144) 1.5Mb 680ms DropTail
$ns duplex-link $n(59) $n(142) 1.5Mb 550ms DropTail
$ns duplex-link $n(59) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(59) $n(138) 1.5Mb 340ms DropTail
$ns duplex-link $n(59) $n(131) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1960..."; flush stdout }
$ns duplex-link $n(59) $n(129) 1.5Mb 250ms DropTail
$ns duplex-link $n(59) $n(127) 1.5Mb 370ms DropTail
$ns duplex-link $n(59) $n(124) 1.5Mb 630ms DropTail
$ns duplex-link $n(59) $n(117) 1.5Mb 90ms DropTail
$ns duplex-link $n(59) $n(112) 1.5Mb 190ms DropTail
$ns duplex-link $n(59) $n(110) 1.5Mb 460ms DropTail
$ns duplex-link $n(59) $n(109) 1.5Mb 470ms DropTail
$ns duplex-link $n(59) $n(105) 1.5Mb 440ms DropTail
$ns duplex-link $n(59) $n(101) 1.5Mb 230ms DropTail
$ns duplex-link $n(59) $n(99) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1970..."; flush stdout }
$ns duplex-link $n(59) $n(94) 1.5Mb 190ms DropTail
$ns duplex-link $n(59) $n(93) 1.5Mb 680ms DropTail
$ns duplex-link $n(59) $n(91) 1.5Mb 370ms DropTail
$ns duplex-link $n(59) $n(89) 1.5Mb 250ms DropTail
$ns duplex-link $n(59) $n(87) 1.5Mb 500ms DropTail
$ns duplex-link $n(59) $n(82) 1.5Mb 630ms DropTail
$ns duplex-link $n(59) $n(77) 1.5Mb 580ms DropTail
$ns duplex-link $n(59) $n(75) 1.5Mb 540ms DropTail
$ns duplex-link $n(59) $n(74) 1.5Mb 510ms DropTail
$ns duplex-link $n(60) $n(194) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1980..."; flush stdout }
$ns duplex-link $n(60) $n(183) 1.5Mb 640ms DropTail
$ns duplex-link $n(60) $n(182) 1.5Mb 540ms DropTail
$ns duplex-link $n(60) $n(179) 1.5Mb 570ms DropTail
$ns duplex-link $n(60) $n(173) 1.5Mb 50ms DropTail
$ns duplex-link $n(60) $n(172) 1.5Mb 400ms DropTail
$ns duplex-link $n(60) $n(168) 1.5Mb 720ms DropTail
$ns duplex-link $n(60) $n(167) 1.5Mb 330ms DropTail
$ns duplex-link $n(60) $n(164) 1.5Mb 460ms DropTail
$ns duplex-link $n(60) $n(161) 1.5Mb 770ms DropTail
$ns duplex-link $n(60) $n(160) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "1990..."; flush stdout }
$ns duplex-link $n(60) $n(156) 1.5Mb 550ms DropTail
$ns duplex-link $n(60) $n(154) 1.5Mb 280ms DropTail
$ns duplex-link $n(60) $n(148) 1.5Mb 400ms DropTail
$ns duplex-link $n(60) $n(141) 1.5Mb 720ms DropTail
$ns duplex-link $n(60) $n(139) 1.5Mb 240ms DropTail
$ns duplex-link $n(60) $n(132) 1.5Mb 310ms DropTail
$ns duplex-link $n(60) $n(131) 1.5Mb 340ms DropTail
$ns duplex-link $n(60) $n(130) 1.5Mb 720ms DropTail
$ns duplex-link $n(60) $n(125) 1.5Mb 710ms DropTail
$ns duplex-link $n(60) $n(124) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "2000..."; flush stdout }
$ns duplex-link $n(60) $n(121) 1.5Mb 490ms DropTail
$ns duplex-link $n(60) $n(117) 1.5Mb 80ms DropTail
$ns duplex-link $n(60) $n(112) 1.5Mb 140ms DropTail
$ns duplex-link $n(60) $n(108) 1.5Mb 280ms DropTail
$ns duplex-link $n(60) $n(102) 1.5Mb 230ms DropTail
$ns duplex-link $n(60) $n(99) 1.5Mb 280ms DropTail
$ns duplex-link $n(60) $n(98) 1.5Mb 570ms DropTail
$ns duplex-link $n(60) $n(96) 1.5Mb 310ms DropTail
$ns duplex-link $n(60) $n(81) 1.5Mb 320ms DropTail
$ns duplex-link $n(60) $n(80) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "2010..."; flush stdout }
$ns duplex-link $n(60) $n(75) 1.5Mb 450ms DropTail
$ns duplex-link $n(60) $n(72) 1.5Mb 420ms DropTail
$ns duplex-link $n(60) $n(68) 1.5Mb 630ms DropTail
$ns duplex-link $n(60) $n(62) 1.5Mb 700ms DropTail
$ns duplex-link $n(61) $n(198) 1.5Mb 830ms DropTail
$ns duplex-link $n(61) $n(191) 1.5Mb 510ms DropTail
$ns duplex-link $n(61) $n(186) 1.5Mb 390ms DropTail
$ns duplex-link $n(61) $n(180) 1.5Mb 770ms DropTail
$ns duplex-link $n(61) $n(170) 1.5Mb 160ms DropTail
$ns duplex-link $n(61) $n(169) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "2020..."; flush stdout }
$ns duplex-link $n(61) $n(166) 1.5Mb 520ms DropTail
$ns duplex-link $n(61) $n(150) 1.5Mb 820ms DropTail
$ns duplex-link $n(61) $n(142) 1.5Mb 390ms DropTail
$ns duplex-link $n(61) $n(138) 1.5Mb 530ms DropTail
$ns duplex-link $n(61) $n(137) 1.5Mb 500ms DropTail
$ns duplex-link $n(61) $n(132) 1.5Mb 330ms DropTail
$ns duplex-link $n(61) $n(111) 1.5Mb 340ms DropTail
$ns duplex-link $n(61) $n(97) 1.5Mb 260ms DropTail
$ns duplex-link $n(61) $n(96) 1.5Mb 350ms DropTail
$ns duplex-link $n(61) $n(95) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "2030..."; flush stdout }
$ns duplex-link $n(61) $n(94) 1.5Mb 370ms DropTail
$ns duplex-link $n(61) $n(93) 1.5Mb 120ms DropTail
$ns duplex-link $n(61) $n(68) 1.5Mb 170ms DropTail
$ns duplex-link $n(61) $n(67) 1.5Mb 170ms DropTail
$ns duplex-link $n(61) $n(65) 1.5Mb 620ms DropTail
$ns duplex-link $n(62) $n(184) 1.5Mb 320ms DropTail
$ns duplex-link $n(62) $n(183) 1.5Mb 460ms DropTail
$ns duplex-link $n(62) $n(181) 1.5Mb 950ms DropTail
$ns duplex-link $n(62) $n(177) 1.5Mb 860ms DropTail
$ns duplex-link $n(62) $n(175) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "2040..."; flush stdout }
$ns duplex-link $n(62) $n(173) 1.5Mb 750ms DropTail
$ns duplex-link $n(62) $n(168) 1.5Mb 260ms DropTail
$ns duplex-link $n(62) $n(165) 1.5Mb 270ms DropTail
$ns duplex-link $n(62) $n(164) 1.5Mb 520ms DropTail
$ns duplex-link $n(62) $n(161) 1.5Mb 200ms DropTail
$ns duplex-link $n(62) $n(158) 1.5Mb 120ms DropTail
$ns duplex-link $n(62) $n(155) 1.5Mb 330ms DropTail
$ns duplex-link $n(62) $n(149) 1.5Mb 620ms DropTail
$ns duplex-link $n(62) $n(148) 1.5Mb 360ms DropTail
$ns duplex-link $n(62) $n(145) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "2050..."; flush stdout }
$ns duplex-link $n(62) $n(135) 1.5Mb 130ms DropTail
$ns duplex-link $n(62) $n(133) 1.5Mb 650ms DropTail
$ns duplex-link $n(62) $n(130) 1.5Mb 180ms DropTail
$ns duplex-link $n(62) $n(127) 1.5Mb 500ms DropTail
$ns duplex-link $n(62) $n(121) 1.5Mb 230ms DropTail
$ns duplex-link $n(62) $n(109) 1.5Mb 340ms DropTail
$ns duplex-link $n(62) $n(107) 1.5Mb 610ms DropTail
$ns duplex-link $n(62) $n(91) 1.5Mb 660ms DropTail
$ns duplex-link $n(62) $n(87) 1.5Mb 140ms DropTail
$ns duplex-link $n(62) $n(79) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "2060..."; flush stdout }
$ns duplex-link $n(62) $n(75) 1.5Mb 560ms DropTail
$ns duplex-link $n(62) $n(74) 1.5Mb 420ms DropTail
$ns duplex-link $n(62) $n(66) 1.5Mb 410ms DropTail
$ns duplex-link $n(62) $n(65) 1.5Mb 700ms DropTail
$ns duplex-link $n(63) $n(198) 1.5Mb 1120ms DropTail
$ns duplex-link $n(63) $n(192) 1.5Mb 670ms DropTail
$ns duplex-link $n(63) $n(174) 1.5Mb 970ms DropTail
$ns duplex-link $n(63) $n(170) 1.5Mb 350ms DropTail
$ns duplex-link $n(63) $n(164) 1.5Mb 110ms DropTail
$ns duplex-link $n(63) $n(160) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "2070..."; flush stdout }
$ns duplex-link $n(63) $n(159) 1.5Mb 210ms DropTail
$ns duplex-link $n(63) $n(158) 1.5Mb 650ms DropTail
$ns duplex-link $n(63) $n(156) 1.5Mb 610ms DropTail
$ns duplex-link $n(63) $n(154) 1.5Mb 340ms DropTail
$ns duplex-link $n(63) $n(152) 1.5Mb 470ms DropTail
$ns duplex-link $n(63) $n(150) 1.5Mb 640ms DropTail
$ns duplex-link $n(63) $n(138) 1.5Mb 860ms DropTail
$ns duplex-link $n(63) $n(132) 1.5Mb 520ms DropTail
$ns duplex-link $n(63) $n(131) 1.5Mb 360ms DropTail
$ns duplex-link $n(63) $n(123) 1.5Mb 830ms DropTail
if {$verbose} { puts -nonewline "2080..."; flush stdout }
$ns duplex-link $n(63) $n(121) 1.5Mb 510ms DropTail
$ns duplex-link $n(63) $n(120) 1.5Mb 820ms DropTail
$ns duplex-link $n(63) $n(115) 1.5Mb 750ms DropTail
$ns duplex-link $n(63) $n(114) 1.5Mb 20ms DropTail
$ns duplex-link $n(63) $n(111) 1.5Mb 800ms DropTail
$ns duplex-link $n(63) $n(101) 1.5Mb 720ms DropTail
$ns duplex-link $n(63) $n(98) 1.5Mb 740ms DropTail
$ns duplex-link $n(63) $n(96) 1.5Mb 550ms DropTail
$ns duplex-link $n(63) $n(95) 1.5Mb 610ms DropTail
$ns duplex-link $n(63) $n(87) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "2090..."; flush stdout }
$ns duplex-link $n(63) $n(77) 1.5Mb 410ms DropTail
$ns duplex-link $n(63) $n(76) 1.5Mb 80ms DropTail
$ns duplex-link $n(63) $n(75) 1.5Mb 130ms DropTail
$ns duplex-link $n(63) $n(68) 1.5Mb 350ms DropTail
$ns duplex-link $n(63) $n(67) 1.5Mb 660ms DropTail
$ns duplex-link $n(64) $n(197) 1.5Mb 860ms DropTail
$ns duplex-link $n(64) $n(193) 1.5Mb 980ms DropTail
$ns duplex-link $n(64) $n(192) 1.5Mb 890ms DropTail
$ns duplex-link $n(64) $n(191) 1.5Mb 840ms DropTail
$ns duplex-link $n(64) $n(181) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "2100..."; flush stdout }
$ns duplex-link $n(64) $n(179) 1.5Mb 870ms DropTail
$ns duplex-link $n(64) $n(178) 1.5Mb 400ms DropTail
$ns duplex-link $n(64) $n(175) 1.5Mb 430ms DropTail
$ns duplex-link $n(64) $n(169) 1.5Mb 890ms DropTail
$ns duplex-link $n(64) $n(159) 1.5Mb 860ms DropTail
$ns duplex-link $n(64) $n(157) 1.5Mb 700ms DropTail
$ns duplex-link $n(64) $n(155) 1.5Mb 520ms DropTail
$ns duplex-link $n(64) $n(150) 1.5Mb 480ms DropTail
$ns duplex-link $n(64) $n(143) 1.5Mb 860ms DropTail
$ns duplex-link $n(64) $n(136) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "2110..."; flush stdout }
$ns duplex-link $n(64) $n(133) 1.5Mb 410ms DropTail
$ns duplex-link $n(64) $n(121) 1.5Mb 610ms DropTail
$ns duplex-link $n(64) $n(120) 1.5Mb 280ms DropTail
$ns duplex-link $n(64) $n(117) 1.5Mb 270ms DropTail
$ns duplex-link $n(64) $n(112) 1.5Mb 410ms DropTail
$ns duplex-link $n(64) $n(110) 1.5Mb 590ms DropTail
$ns duplex-link $n(64) $n(107) 1.5Mb 240ms DropTail
$ns duplex-link $n(64) $n(106) 1.5Mb 610ms DropTail
$ns duplex-link $n(64) $n(103) 1.5Mb 950ms DropTail
$ns duplex-link $n(64) $n(100) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "2120..."; flush stdout }
$ns duplex-link $n(64) $n(97) 1.5Mb 600ms DropTail
$ns duplex-link $n(64) $n(93) 1.5Mb 890ms DropTail
$ns duplex-link $n(64) $n(88) 1.5Mb 380ms DropTail
$ns duplex-link $n(64) $n(83) 1.5Mb 600ms DropTail
$ns duplex-link $n(64) $n(82) 1.5Mb 840ms DropTail
$ns duplex-link $n(64) $n(79) 1.5Mb 380ms DropTail
$ns duplex-link $n(64) $n(78) 1.5Mb 910ms DropTail
$ns duplex-link $n(64) $n(76) 1.5Mb 800ms DropTail
$ns duplex-link $n(64) $n(74) 1.5Mb 620ms DropTail
$ns duplex-link $n(64) $n(66) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "2130..."; flush stdout }
$ns duplex-link $n(65) $n(193) 1.5Mb 530ms DropTail
$ns duplex-link $n(65) $n(189) 1.5Mb 260ms DropTail
$ns duplex-link $n(65) $n(186) 1.5Mb 640ms DropTail
$ns duplex-link $n(65) $n(184) 1.5Mb 590ms DropTail
$ns duplex-link $n(65) $n(178) 1.5Mb 310ms DropTail
$ns duplex-link $n(65) $n(177) 1.5Mb 170ms DropTail
$ns duplex-link $n(65) $n(176) 1.5Mb 460ms DropTail
$ns duplex-link $n(65) $n(168) 1.5Mb 760ms DropTail
$ns duplex-link $n(65) $n(164) 1.5Mb 360ms DropTail
$ns duplex-link $n(65) $n(155) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "2140..."; flush stdout }
$ns duplex-link $n(65) $n(149) 1.5Mb 710ms DropTail
$ns duplex-link $n(65) $n(140) 1.5Mb 70ms DropTail
$ns duplex-link $n(65) $n(126) 1.5Mb 550ms DropTail
$ns duplex-link $n(65) $n(125) 1.5Mb 720ms DropTail
$ns duplex-link $n(65) $n(120) 1.5Mb 540ms DropTail
$ns duplex-link $n(65) $n(118) 1.5Mb 640ms DropTail
$ns duplex-link $n(65) $n(116) 1.5Mb 410ms DropTail
$ns duplex-link $n(65) $n(102) 1.5Mb 270ms DropTail
$ns duplex-link $n(65) $n(96) 1.5Mb 370ms DropTail
$ns duplex-link $n(65) $n(86) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "2150..."; flush stdout }
$ns duplex-link $n(65) $n(83) 1.5Mb 130ms DropTail
$ns duplex-link $n(65) $n(79) 1.5Mb 210ms DropTail
$ns duplex-link $n(66) $n(178) 1.5Mb 60ms DropTail
$ns duplex-link $n(66) $n(177) 1.5Mb 490ms DropTail
$ns duplex-link $n(66) $n(176) 1.5Mb 160ms DropTail
$ns duplex-link $n(66) $n(171) 1.5Mb 480ms DropTail
$ns duplex-link $n(66) $n(170) 1.5Mb 280ms DropTail
$ns duplex-link $n(66) $n(169) 1.5Mb 450ms DropTail
$ns duplex-link $n(66) $n(168) 1.5Mb 400ms DropTail
$ns duplex-link $n(66) $n(167) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "2160..."; flush stdout }
$ns duplex-link $n(66) $n(165) 1.5Mb 580ms DropTail
$ns duplex-link $n(66) $n(153) 1.5Mb 540ms DropTail
$ns duplex-link $n(66) $n(140) 1.5Mb 430ms DropTail
$ns duplex-link $n(66) $n(139) 1.5Mb 250ms DropTail
$ns duplex-link $n(66) $n(132) 1.5Mb 10ms DropTail
$ns duplex-link $n(66) $n(131) 1.5Mb 510ms DropTail
$ns duplex-link $n(66) $n(112) 1.5Mb 200ms DropTail
$ns duplex-link $n(66) $n(109) 1.5Mb 290ms DropTail
$ns duplex-link $n(66) $n(108) 1.5Mb 40ms DropTail
$ns duplex-link $n(66) $n(106) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "2170..."; flush stdout }
$ns duplex-link $n(66) $n(103) 1.5Mb 570ms DropTail
$ns duplex-link $n(66) $n(97) 1.5Mb 180ms DropTail
$ns duplex-link $n(66) $n(94) 1.5Mb 40ms DropTail
$ns duplex-link $n(66) $n(82) 1.5Mb 560ms DropTail
$ns duplex-link $n(66) $n(81) 1.5Mb 10ms DropTail
$ns duplex-link $n(66) $n(80) 1.5Mb 240ms DropTail
$ns duplex-link $n(66) $n(74) 1.5Mb 380ms DropTail
$ns duplex-link $n(66) $n(68) 1.5Mb 400ms DropTail
$ns duplex-link $n(67) $n(196) 1.5Mb 390ms DropTail
$ns duplex-link $n(67) $n(193) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "2180..."; flush stdout }
$ns duplex-link $n(67) $n(191) 1.5Mb 670ms DropTail
$ns duplex-link $n(67) $n(190) 1.5Mb 530ms DropTail
$ns duplex-link $n(67) $n(188) 1.5Mb 650ms DropTail
$ns duplex-link $n(67) $n(179) 1.5Mb 640ms DropTail
$ns duplex-link $n(67) $n(175) 1.5Mb 360ms DropTail
$ns duplex-link $n(67) $n(169) 1.5Mb 280ms DropTail
$ns duplex-link $n(67) $n(168) 1.5Mb 90ms DropTail
$ns duplex-link $n(67) $n(166) 1.5Mb 690ms DropTail
$ns duplex-link $n(67) $n(162) 1.5Mb 220ms DropTail
$ns duplex-link $n(67) $n(161) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "2190..."; flush stdout }
$ns duplex-link $n(67) $n(160) 1.5Mb 260ms DropTail
$ns duplex-link $n(67) $n(151) 1.5Mb 620ms DropTail
$ns duplex-link $n(67) $n(145) 1.5Mb 440ms DropTail
$ns duplex-link $n(67) $n(139) 1.5Mb 560ms DropTail
$ns duplex-link $n(67) $n(130) 1.5Mb 50ms DropTail
$ns duplex-link $n(67) $n(128) 1.5Mb 730ms DropTail
$ns duplex-link $n(67) $n(114) 1.5Mb 670ms DropTail
$ns duplex-link $n(67) $n(110) 1.5Mb 170ms DropTail
$ns duplex-link $n(67) $n(107) 1.5Mb 530ms DropTail
$ns duplex-link $n(67) $n(96) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "2200..."; flush stdout }
$ns duplex-link $n(67) $n(94) 1.5Mb 380ms DropTail
$ns duplex-link $n(67) $n(92) 1.5Mb 550ms DropTail
$ns duplex-link $n(67) $n(85) 1.5Mb 250ms DropTail
$ns duplex-link $n(67) $n(81) 1.5Mb 350ms DropTail
$ns duplex-link $n(67) $n(79) 1.5Mb 510ms DropTail
$ns duplex-link $n(67) $n(77) 1.5Mb 270ms DropTail
$ns duplex-link $n(67) $n(75) 1.5Mb 650ms DropTail
$ns duplex-link $n(67) $n(72) 1.5Mb 430ms DropTail
$ns duplex-link $n(67) $n(70) 1.5Mb 430ms DropTail
$ns duplex-link $n(68) $n(198) 1.5Mb 960ms DropTail
if {$verbose} { puts -nonewline "2210..."; flush stdout }
$ns duplex-link $n(68) $n(194) 1.5Mb 840ms DropTail
$ns duplex-link $n(68) $n(190) 1.5Mb 800ms DropTail
$ns duplex-link $n(68) $n(182) 1.5Mb 250ms DropTail
$ns duplex-link $n(68) $n(160) 1.5Mb 140ms DropTail
$ns duplex-link $n(68) $n(159) 1.5Mb 140ms DropTail
$ns duplex-link $n(68) $n(155) 1.5Mb 390ms DropTail
$ns duplex-link $n(68) $n(154) 1.5Mb 540ms DropTail
$ns duplex-link $n(68) $n(146) 1.5Mb 220ms DropTail
$ns duplex-link $n(68) $n(145) 1.5Mb 100ms DropTail
$ns duplex-link $n(68) $n(144) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "2220..."; flush stdout }
$ns duplex-link $n(68) $n(135) 1.5Mb 290ms DropTail
$ns duplex-link $n(68) $n(134) 1.5Mb 380ms DropTail
$ns duplex-link $n(68) $n(130) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(128) 1.5Mb 810ms DropTail
$ns duplex-link $n(68) $n(125) 1.5Mb 220ms DropTail
$ns duplex-link $n(68) $n(107) 1.5Mb 600ms DropTail
$ns duplex-link $n(68) $n(95) 1.5Mb 330ms DropTail
$ns duplex-link $n(68) $n(93) 1.5Mb 170ms DropTail
$ns duplex-link $n(68) $n(89) 1.5Mb 850ms DropTail
$ns duplex-link $n(68) $n(85) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "2230..."; flush stdout }
$ns duplex-link $n(68) $n(77) 1.5Mb 70ms DropTail
$ns duplex-link $n(68) $n(73) 1.5Mb 530ms DropTail
$ns duplex-link $n(69) $n(196) 1.5Mb 360ms DropTail
$ns duplex-link $n(69) $n(189) 1.5Mb 510ms DropTail
$ns duplex-link $n(69) $n(168) 1.5Mb 430ms DropTail
$ns duplex-link $n(69) $n(165) 1.5Mb 580ms DropTail
$ns duplex-link $n(69) $n(161) 1.5Mb 460ms DropTail
$ns duplex-link $n(69) $n(153) 1.5Mb 590ms DropTail
$ns duplex-link $n(69) $n(150) 1.5Mb 530ms DropTail
$ns duplex-link $n(69) $n(148) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "2240..."; flush stdout }
$ns duplex-link $n(69) $n(147) 1.5Mb 290ms DropTail
$ns duplex-link $n(69) $n(145) 1.5Mb 330ms DropTail
$ns duplex-link $n(69) $n(138) 1.5Mb 440ms DropTail
$ns duplex-link $n(69) $n(136) 1.5Mb 300ms DropTail
$ns duplex-link $n(69) $n(135) 1.5Mb 340ms DropTail
$ns duplex-link $n(69) $n(134) 1.5Mb 480ms DropTail
$ns duplex-link $n(69) $n(131) 1.5Mb 440ms DropTail
$ns duplex-link $n(69) $n(126) 1.5Mb 370ms DropTail
$ns duplex-link $n(69) $n(122) 1.5Mb 330ms DropTail
$ns duplex-link $n(69) $n(117) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "2250..."; flush stdout }
$ns duplex-link $n(69) $n(113) 1.5Mb 450ms DropTail
$ns duplex-link $n(69) $n(108) 1.5Mb 90ms DropTail
$ns duplex-link $n(69) $n(106) 1.5Mb 110ms DropTail
$ns duplex-link $n(69) $n(105) 1.5Mb 420ms DropTail
$ns duplex-link $n(69) $n(104) 1.5Mb 40ms DropTail
$ns duplex-link $n(69) $n(98) 1.5Mb 360ms DropTail
$ns duplex-link $n(69) $n(95) 1.5Mb 250ms DropTail
$ns duplex-link $n(69) $n(85) 1.5Mb 150ms DropTail
$ns duplex-link $n(69) $n(84) 1.5Mb 400ms DropTail
$ns duplex-link $n(69) $n(78) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2260..."; flush stdout }
$ns duplex-link $n(69) $n(76) 1.5Mb 330ms DropTail
$ns duplex-link $n(69) $n(75) 1.5Mb 340ms DropTail
$ns duplex-link $n(69) $n(73) 1.5Mb 280ms DropTail
$ns duplex-link $n(69) $n(71) 1.5Mb 170ms DropTail
$ns duplex-link $n(70) $n(199) 1.5Mb 370ms DropTail
$ns duplex-link $n(70) $n(197) 1.5Mb 220ms DropTail
$ns duplex-link $n(70) $n(193) 1.5Mb 430ms DropTail
$ns duplex-link $n(70) $n(190) 1.5Mb 850ms DropTail
$ns duplex-link $n(70) $n(188) 1.5Mb 770ms DropTail
$ns duplex-link $n(70) $n(184) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "2270..."; flush stdout }
$ns duplex-link $n(70) $n(179) 1.5Mb 230ms DropTail
$ns duplex-link $n(70) $n(178) 1.5Mb 450ms DropTail
$ns duplex-link $n(70) $n(173) 1.5Mb 660ms DropTail
$ns duplex-link $n(70) $n(169) 1.5Mb 210ms DropTail
$ns duplex-link $n(70) $n(154) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(152) 1.5Mb 450ms DropTail
$ns duplex-link $n(70) $n(141) 1.5Mb 490ms DropTail
$ns duplex-link $n(70) $n(139) 1.5Mb 660ms DropTail
$ns duplex-link $n(70) $n(134) 1.5Mb 290ms DropTail
$ns duplex-link $n(70) $n(129) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "2280..."; flush stdout }
$ns duplex-link $n(70) $n(128) 1.5Mb 810ms DropTail
$ns duplex-link $n(70) $n(126) 1.5Mb 90ms DropTail
$ns duplex-link $n(70) $n(122) 1.5Mb 620ms DropTail
$ns duplex-link $n(70) $n(116) 1.5Mb 960ms DropTail
$ns duplex-link $n(70) $n(115) 1.5Mb 540ms DropTail
$ns duplex-link $n(70) $n(113) 1.5Mb 670ms DropTail
$ns duplex-link $n(70) $n(110) 1.5Mb 530ms DropTail
$ns duplex-link $n(70) $n(106) 1.5Mb 240ms DropTail
$ns duplex-link $n(70) $n(101) 1.5Mb 760ms DropTail
$ns duplex-link $n(70) $n(99) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "2290..."; flush stdout }
$ns duplex-link $n(70) $n(91) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(79) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(75) 1.5Mb 310ms DropTail
$ns duplex-link $n(71) $n(193) 1.5Mb 420ms DropTail
$ns duplex-link $n(71) $n(192) 1.5Mb 600ms DropTail
$ns duplex-link $n(71) $n(185) 1.5Mb 390ms DropTail
$ns duplex-link $n(71) $n(184) 1.5Mb 460ms DropTail
$ns duplex-link $n(71) $n(178) 1.5Mb 240ms DropTail
$ns duplex-link $n(71) $n(174) 1.5Mb 680ms DropTail
$ns duplex-link $n(71) $n(171) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "2300..."; flush stdout }
$ns duplex-link $n(71) $n(168) 1.5Mb 600ms DropTail
$ns duplex-link $n(71) $n(162) 1.5Mb 310ms DropTail
$ns duplex-link $n(71) $n(161) 1.5Mb 610ms DropTail
$ns duplex-link $n(71) $n(157) 1.5Mb 450ms DropTail
$ns duplex-link $n(71) $n(154) 1.5Mb 200ms DropTail
$ns duplex-link $n(71) $n(147) 1.5Mb 380ms DropTail
$ns duplex-link $n(71) $n(146) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(141) 1.5Mb 590ms DropTail
$ns duplex-link $n(71) $n(139) 1.5Mb 410ms DropTail
$ns duplex-link $n(71) $n(138) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "2310..."; flush stdout }
$ns duplex-link $n(71) $n(133) 1.5Mb 670ms DropTail
$ns duplex-link $n(71) $n(132) 1.5Mb 250ms DropTail
$ns duplex-link $n(71) $n(131) 1.5Mb 280ms DropTail
$ns duplex-link $n(71) $n(127) 1.5Mb 560ms DropTail
$ns duplex-link $n(71) $n(121) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(113) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(112) 1.5Mb 170ms DropTail
$ns duplex-link $n(71) $n(109) 1.5Mb 170ms DropTail
$ns duplex-link $n(71) $n(108) 1.5Mb 220ms DropTail
$ns duplex-link $n(71) $n(103) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "2320..."; flush stdout }
$ns duplex-link $n(71) $n(102) 1.5Mb 190ms DropTail
$ns duplex-link $n(71) $n(101) 1.5Mb 440ms DropTail
$ns duplex-link $n(71) $n(87) 1.5Mb 370ms DropTail
$ns duplex-link $n(71) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(71) $n(79) 1.5Mb 210ms DropTail
$ns duplex-link $n(71) $n(78) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(74) 1.5Mb 630ms DropTail
$ns duplex-link $n(72) $n(196) 1.5Mb 520ms DropTail
$ns duplex-link $n(72) $n(193) 1.5Mb 430ms DropTail
$ns duplex-link $n(72) $n(190) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "2330..."; flush stdout }
$ns duplex-link $n(72) $n(175) 1.5Mb 550ms DropTail
$ns duplex-link $n(72) $n(170) 1.5Mb 130ms DropTail
$ns duplex-link $n(72) $n(160) 1.5Mb 180ms DropTail
$ns duplex-link $n(72) $n(159) 1.5Mb 190ms DropTail
$ns duplex-link $n(72) $n(156) 1.5Mb 360ms DropTail
$ns duplex-link $n(72) $n(151) 1.5Mb 390ms DropTail
$ns duplex-link $n(72) $n(149) 1.5Mb 670ms DropTail
$ns duplex-link $n(72) $n(143) 1.5Mb 260ms DropTail
$ns duplex-link $n(72) $n(138) 1.5Mb 590ms DropTail
$ns duplex-link $n(72) $n(136) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "2340..."; flush stdout }
$ns duplex-link $n(72) $n(135) 1.5Mb 380ms DropTail
$ns duplex-link $n(72) $n(128) 1.5Mb 640ms DropTail
$ns duplex-link $n(72) $n(127) 1.5Mb 550ms DropTail
$ns duplex-link $n(72) $n(123) 1.5Mb 600ms DropTail
$ns duplex-link $n(72) $n(112) 1.5Mb 280ms DropTail
$ns duplex-link $n(72) $n(109) 1.5Mb 30ms DropTail
$ns duplex-link $n(72) $n(102) 1.5Mb 250ms DropTail
$ns duplex-link $n(72) $n(90) 1.5Mb 490ms DropTail
$ns duplex-link $n(72) $n(81) 1.5Mb 280ms DropTail
$ns duplex-link $n(72) $n(80) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "2350..."; flush stdout }
$ns duplex-link $n(73) $n(193) 1.5Mb 490ms DropTail
$ns duplex-link $n(73) $n(182) 1.5Mb 390ms DropTail
$ns duplex-link $n(73) $n(180) 1.5Mb 560ms DropTail
$ns duplex-link $n(73) $n(179) 1.5Mb 410ms DropTail
$ns duplex-link $n(73) $n(176) 1.5Mb 440ms DropTail
$ns duplex-link $n(73) $n(173) 1.5Mb 210ms DropTail
$ns duplex-link $n(73) $n(167) 1.5Mb 230ms DropTail
$ns duplex-link $n(73) $n(159) 1.5Mb 470ms DropTail
$ns duplex-link $n(73) $n(158) 1.5Mb 700ms DropTail
$ns duplex-link $n(73) $n(155) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "2360..."; flush stdout }
$ns duplex-link $n(73) $n(148) 1.5Mb 410ms DropTail
$ns duplex-link $n(73) $n(142) 1.5Mb 740ms DropTail
$ns duplex-link $n(73) $n(136) 1.5Mb 570ms DropTail
$ns duplex-link $n(73) $n(132) 1.5Mb 310ms DropTail
$ns duplex-link $n(73) $n(130) 1.5Mb 690ms DropTail
$ns duplex-link $n(73) $n(121) 1.5Mb 460ms DropTail
$ns duplex-link $n(73) $n(120) 1.5Mb 530ms DropTail
$ns duplex-link $n(73) $n(116) 1.5Mb 480ms DropTail
$ns duplex-link $n(73) $n(112) 1.5Mb 130ms DropTail
$ns duplex-link $n(73) $n(110) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "2370..."; flush stdout }
$ns duplex-link $n(73) $n(109) 1.5Mb 340ms DropTail
$ns duplex-link $n(73) $n(103) 1.5Mb 840ms DropTail
$ns duplex-link $n(73) $n(102) 1.5Mb 230ms DropTail
$ns duplex-link $n(73) $n(95) 1.5Mb 530ms DropTail
$ns duplex-link $n(73) $n(88) 1.5Mb 260ms DropTail
$ns duplex-link $n(73) $n(82) 1.5Mb 350ms DropTail
$ns duplex-link $n(73) $n(75) 1.5Mb 290ms DropTail
$ns duplex-link $n(74) $n(194) 1.5Mb 610ms DropTail
$ns duplex-link $n(74) $n(192) 1.5Mb 380ms DropTail
$ns duplex-link $n(74) $n(187) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "2380..."; flush stdout }
$ns duplex-link $n(74) $n(186) 1.5Mb 110ms DropTail
$ns duplex-link $n(74) $n(176) 1.5Mb 300ms DropTail
$ns duplex-link $n(74) $n(172) 1.5Mb 570ms DropTail
$ns duplex-link $n(74) $n(171) 1.5Mb 360ms DropTail
$ns duplex-link $n(74) $n(170) 1.5Mb 490ms DropTail
$ns duplex-link $n(74) $n(166) 1.5Mb 870ms DropTail
$ns duplex-link $n(74) $n(165) 1.5Mb 370ms DropTail
$ns duplex-link $n(74) $n(161) 1.5Mb 280ms DropTail
$ns duplex-link $n(74) $n(157) 1.5Mb 280ms DropTail
$ns duplex-link $n(74) $n(156) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "2390..."; flush stdout }
$ns duplex-link $n(74) $n(155) 1.5Mb 230ms DropTail
$ns duplex-link $n(74) $n(145) 1.5Mb 640ms DropTail
$ns duplex-link $n(74) $n(143) 1.5Mb 830ms DropTail
$ns duplex-link $n(74) $n(142) 1.5Mb 40ms DropTail
$ns duplex-link $n(74) $n(139) 1.5Mb 480ms DropTail
$ns duplex-link $n(74) $n(133) 1.5Mb 270ms DropTail
$ns duplex-link $n(74) $n(129) 1.5Mb 410ms DropTail
$ns duplex-link $n(74) $n(121) 1.5Mb 320ms DropTail
$ns duplex-link $n(74) $n(112) 1.5Mb 580ms DropTail
$ns duplex-link $n(74) $n(101) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "2400..."; flush stdout }
$ns duplex-link $n(74) $n(96) 1.5Mb 370ms DropTail
$ns duplex-link $n(74) $n(87) 1.5Mb 380ms DropTail
$ns duplex-link $n(74) $n(84) 1.5Mb 420ms DropTail
$ns duplex-link $n(74) $n(79) 1.5Mb 530ms DropTail
$ns duplex-link $n(74) $n(75) 1.5Mb 790ms DropTail
$ns duplex-link $n(75) $n(199) 1.5Mb 230ms DropTail
$ns duplex-link $n(75) $n(168) 1.5Mb 730ms DropTail
$ns duplex-link $n(75) $n(162) 1.5Mb 450ms DropTail
$ns duplex-link $n(75) $n(153) 1.5Mb 710ms DropTail
$ns duplex-link $n(75) $n(151) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "2410..."; flush stdout }
$ns duplex-link $n(75) $n(149) 1.5Mb 860ms DropTail
$ns duplex-link $n(75) $n(141) 1.5Mb 720ms DropTail
$ns duplex-link $n(75) $n(136) 1.5Mb 620ms DropTail
$ns duplex-link $n(75) $n(117) 1.5Mb 500ms DropTail
$ns duplex-link $n(75) $n(109) 1.5Mb 230ms DropTail
$ns duplex-link $n(75) $n(108) 1.5Mb 420ms DropTail
$ns duplex-link $n(75) $n(101) 1.5Mb 590ms DropTail
$ns duplex-link $n(75) $n(94) 1.5Mb 470ms DropTail
$ns duplex-link $n(75) $n(88) 1.5Mb 440ms DropTail
$ns duplex-link $n(75) $n(81) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "2420..."; flush stdout }
$ns duplex-link $n(75) $n(79) 1.5Mb 400ms DropTail
$ns duplex-link $n(76) $n(198) 1.5Mb 1030ms DropTail
$ns duplex-link $n(76) $n(197) 1.5Mb 50ms DropTail
$ns duplex-link $n(76) $n(196) 1.5Mb 690ms DropTail
$ns duplex-link $n(76) $n(184) 1.5Mb 590ms DropTail
$ns duplex-link $n(76) $n(181) 1.5Mb 840ms DropTail
$ns duplex-link $n(76) $n(174) 1.5Mb 890ms DropTail
$ns duplex-link $n(76) $n(172) 1.5Mb 850ms DropTail
$ns duplex-link $n(76) $n(171) 1.5Mb 620ms DropTail
$ns duplex-link $n(76) $n(170) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "2430..."; flush stdout }
$ns duplex-link $n(76) $n(167) 1.5Mb 440ms DropTail
$ns duplex-link $n(76) $n(163) 1.5Mb 470ms DropTail
$ns duplex-link $n(76) $n(159) 1.5Mb 180ms DropTail
$ns duplex-link $n(76) $n(152) 1.5Mb 390ms DropTail
$ns duplex-link $n(76) $n(145) 1.5Mb 210ms DropTail
$ns duplex-link $n(76) $n(142) 1.5Mb 770ms DropTail
$ns duplex-link $n(76) $n(134) 1.5Mb 150ms DropTail
$ns duplex-link $n(76) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(76) $n(128) 1.5Mb 760ms DropTail
$ns duplex-link $n(76) $n(124) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "2440..."; flush stdout }
$ns duplex-link $n(76) $n(119) 1.5Mb 1030ms DropTail
$ns duplex-link $n(76) $n(117) 1.5Mb 540ms DropTail
$ns duplex-link $n(76) $n(113) 1.5Mb 520ms DropTail
$ns duplex-link $n(76) $n(110) 1.5Mb 660ms DropTail
$ns duplex-link $n(76) $n(93) 1.5Mb 480ms DropTail
$ns duplex-link $n(76) $n(89) 1.5Mb 750ms DropTail
$ns duplex-link $n(76) $n(85) 1.5Mb 470ms DropTail
$ns duplex-link $n(77) $n(186) 1.5Mb 480ms DropTail
$ns duplex-link $n(77) $n(183) 1.5Mb 520ms DropTail
$ns duplex-link $n(77) $n(178) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "2450..."; flush stdout }
$ns duplex-link $n(77) $n(171) 1.5Mb 270ms DropTail
$ns duplex-link $n(77) $n(166) 1.5Mb 420ms DropTail
$ns duplex-link $n(77) $n(160) 1.5Mb 90ms DropTail
$ns duplex-link $n(77) $n(156) 1.5Mb 270ms DropTail
$ns duplex-link $n(77) $n(155) 1.5Mb 330ms DropTail
$ns duplex-link $n(77) $n(154) 1.5Mb 570ms DropTail
$ns duplex-link $n(77) $n(153) 1.5Mb 880ms DropTail
$ns duplex-link $n(77) $n(152) 1.5Mb 460ms DropTail
$ns duplex-link $n(77) $n(151) 1.5Mb 580ms DropTail
$ns duplex-link $n(77) $n(150) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "2460..."; flush stdout }
$ns duplex-link $n(77) $n(141) 1.5Mb 340ms DropTail
$ns duplex-link $n(77) $n(131) 1.5Mb 630ms DropTail
$ns duplex-link $n(77) $n(124) 1.5Mb 130ms DropTail
$ns duplex-link $n(77) $n(122) 1.5Mb 620ms DropTail
$ns duplex-link $n(77) $n(119) 1.5Mb 890ms DropTail
$ns duplex-link $n(77) $n(117) 1.5Mb 600ms DropTail
$ns duplex-link $n(77) $n(116) 1.5Mb 1000ms DropTail
$ns duplex-link $n(77) $n(115) 1.5Mb 400ms DropTail
$ns duplex-link $n(77) $n(99) 1.5Mb 710ms DropTail
$ns duplex-link $n(77) $n(94) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "2470..."; flush stdout }
$ns duplex-link $n(77) $n(90) 1.5Mb 570ms DropTail
$ns duplex-link $n(77) $n(86) 1.5Mb 300ms DropTail
$ns duplex-link $n(77) $n(82) 1.5Mb 540ms DropTail
$ns duplex-link $n(78) $n(195) 1.5Mb 40ms DropTail
$ns duplex-link $n(78) $n(192) 1.5Mb 720ms DropTail
$ns duplex-link $n(78) $n(191) 1.5Mb 70ms DropTail
$ns duplex-link $n(78) $n(179) 1.5Mb 80ms DropTail
$ns duplex-link $n(78) $n(177) 1.5Mb 640ms DropTail
$ns duplex-link $n(78) $n(172) 1.5Mb 960ms DropTail
$ns duplex-link $n(78) $n(169) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "2480..."; flush stdout }
$ns duplex-link $n(78) $n(160) 1.5Mb 450ms DropTail
$ns duplex-link $n(78) $n(158) 1.5Mb 700ms DropTail
$ns duplex-link $n(78) $n(157) 1.5Mb 640ms DropTail
$ns duplex-link $n(78) $n(141) 1.5Mb 780ms DropTail
$ns duplex-link $n(78) $n(140) 1.5Mb 530ms DropTail
$ns duplex-link $n(78) $n(136) 1.5Mb 710ms DropTail
$ns duplex-link $n(78) $n(132) 1.5Mb 560ms DropTail
$ns duplex-link $n(78) $n(123) 1.5Mb 860ms DropTail
$ns duplex-link $n(78) $n(120) 1.5Mb 860ms DropTail
$ns duplex-link $n(78) $n(117) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "2490..."; flush stdout }
$ns duplex-link $n(78) $n(113) 1.5Mb 580ms DropTail
$ns duplex-link $n(78) $n(112) 1.5Mb 500ms DropTail
$ns duplex-link $n(78) $n(110) 1.5Mb 790ms DropTail
$ns duplex-link $n(78) $n(107) 1.5Mb 700ms DropTail
$ns duplex-link $n(78) $n(106) 1.5Mb 360ms DropTail
$ns duplex-link $n(78) $n(103) 1.5Mb 810ms DropTail
$ns duplex-link $n(78) $n(97) 1.5Mb 400ms DropTail
$ns duplex-link $n(78) $n(93) 1.5Mb 570ms DropTail
$ns duplex-link $n(78) $n(92) 1.5Mb 1040ms DropTail
$ns duplex-link $n(78) $n(91) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "2500..."; flush stdout }
$ns duplex-link $n(78) $n(89) 1.5Mb 840ms DropTail
$ns duplex-link $n(78) $n(88) 1.5Mb 570ms DropTail
$ns duplex-link $n(78) $n(87) 1.5Mb 530ms DropTail
$ns duplex-link $n(78) $n(83) 1.5Mb 390ms DropTail
$ns duplex-link $n(78) $n(81) 1.5Mb 580ms DropTail
$ns duplex-link $n(79) $n(198) 1.5Mb 620ms DropTail
$ns duplex-link $n(79) $n(197) 1.5Mb 480ms DropTail
$ns duplex-link $n(79) $n(194) 1.5Mb 380ms DropTail
$ns duplex-link $n(79) $n(192) 1.5Mb 640ms DropTail
$ns duplex-link $n(79) $n(188) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "2510..."; flush stdout }
$ns duplex-link $n(79) $n(187) 1.5Mb 280ms DropTail
$ns duplex-link $n(79) $n(186) 1.5Mb 430ms DropTail
$ns duplex-link $n(79) $n(179) 1.5Mb 500ms DropTail
$ns duplex-link $n(79) $n(178) 1.5Mb 100ms DropTail
$ns duplex-link $n(79) $n(174) 1.5Mb 490ms DropTail
$ns duplex-link $n(79) $n(158) 1.5Mb 590ms DropTail
$ns duplex-link $n(79) $n(151) 1.5Mb 110ms DropTail
$ns duplex-link $n(79) $n(143) 1.5Mb 490ms DropTail
$ns duplex-link $n(79) $n(139) 1.5Mb 210ms DropTail
$ns duplex-link $n(79) $n(138) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "2520..."; flush stdout }
$ns duplex-link $n(79) $n(135) 1.5Mb 500ms DropTail
$ns duplex-link $n(79) $n(126) 1.5Mb 510ms DropTail
$ns duplex-link $n(79) $n(121) 1.5Mb 330ms DropTail
$ns duplex-link $n(79) $n(117) 1.5Mb 130ms DropTail
$ns duplex-link $n(79) $n(114) 1.5Mb 530ms DropTail
$ns duplex-link $n(79) $n(113) 1.5Mb 300ms DropTail
$ns duplex-link $n(79) $n(107) 1.5Mb 160ms DropTail
$ns duplex-link $n(79) $n(106) 1.5Mb 240ms DropTail
$ns duplex-link $n(79) $n(105) 1.5Mb 470ms DropTail
$ns duplex-link $n(79) $n(104) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "2530..."; flush stdout }
$ns duplex-link $n(79) $n(103) 1.5Mb 720ms DropTail
$ns duplex-link $n(79) $n(99) 1.5Mb 370ms DropTail
$ns duplex-link $n(79) $n(97) 1.5Mb 250ms DropTail
$ns duplex-link $n(79) $n(96) 1.5Mb 160ms DropTail
$ns duplex-link $n(79) $n(94) 1.5Mb 150ms DropTail
$ns duplex-link $n(79) $n(93) 1.5Mb 580ms DropTail
$ns duplex-link $n(79) $n(92) 1.5Mb 540ms DropTail
$ns duplex-link $n(79) $n(85) 1.5Mb 270ms DropTail
$ns duplex-link $n(80) $n(195) 1.5Mb 730ms DropTail
$ns duplex-link $n(80) $n(194) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "2540..."; flush stdout }
$ns duplex-link $n(80) $n(183) 1.5Mb 400ms DropTail
$ns duplex-link $n(80) $n(181) 1.5Mb 330ms DropTail
$ns duplex-link $n(80) $n(178) 1.5Mb 220ms DropTail
$ns duplex-link $n(80) $n(173) 1.5Mb 290ms DropTail
$ns duplex-link $n(80) $n(169) 1.5Mb 680ms DropTail
$ns duplex-link $n(80) $n(168) 1.5Mb 540ms DropTail
$ns duplex-link $n(80) $n(164) 1.5Mb 630ms DropTail
$ns duplex-link $n(80) $n(161) 1.5Mb 620ms DropTail
$ns duplex-link $n(80) $n(157) 1.5Mb 490ms DropTail
$ns duplex-link $n(80) $n(149) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "2550..."; flush stdout }
$ns duplex-link $n(80) $n(140) 1.5Mb 440ms DropTail
$ns duplex-link $n(80) $n(136) 1.5Mb 400ms DropTail
$ns duplex-link $n(80) $n(133) 1.5Mb 300ms DropTail
$ns duplex-link $n(80) $n(116) 1.5Mb 580ms DropTail
$ns duplex-link $n(80) $n(111) 1.5Mb 470ms DropTail
$ns duplex-link $n(80) $n(110) 1.5Mb 400ms DropTail
$ns duplex-link $n(80) $n(101) 1.5Mb 320ms DropTail
$ns duplex-link $n(80) $n(100) 1.5Mb 420ms DropTail
$ns duplex-link $n(80) $n(94) 1.5Mb 200ms DropTail
$ns duplex-link $n(80) $n(88) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "2560..."; flush stdout }
$ns duplex-link $n(80) $n(87) 1.5Mb 500ms DropTail
$ns duplex-link $n(80) $n(84) 1.5Mb 660ms DropTail
$ns duplex-link $n(81) $n(173) 1.5Mb 360ms DropTail
$ns duplex-link $n(81) $n(167) 1.5Mb 560ms DropTail
$ns duplex-link $n(81) $n(164) 1.5Mb 440ms DropTail
$ns duplex-link $n(81) $n(156) 1.5Mb 230ms DropTail
$ns duplex-link $n(81) $n(151) 1.5Mb 280ms DropTail
$ns duplex-link $n(81) $n(150) 1.5Mb 550ms DropTail
$ns duplex-link $n(81) $n(149) 1.5Mb 400ms DropTail
$ns duplex-link $n(81) $n(146) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "2570..."; flush stdout }
$ns duplex-link $n(81) $n(145) 1.5Mb 430ms DropTail
$ns duplex-link $n(81) $n(140) 1.5Mb 440ms DropTail
$ns duplex-link $n(81) $n(137) 1.5Mb 290ms DropTail
$ns duplex-link $n(81) $n(130) 1.5Mb 400ms DropTail
$ns duplex-link $n(81) $n(128) 1.5Mb 420ms DropTail
$ns duplex-link $n(81) $n(117) 1.5Mb 280ms DropTail
$ns duplex-link $n(81) $n(114) 1.5Mb 550ms DropTail
$ns duplex-link $n(81) $n(106) 1.5Mb 230ms DropTail
$ns duplex-link $n(81) $n(103) 1.5Mb 560ms DropTail
$ns duplex-link $n(81) $n(101) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "2580..."; flush stdout }
$ns duplex-link $n(81) $n(96) 1.5Mb 20ms DropTail
$ns duplex-link $n(81) $n(92) 1.5Mb 460ms DropTail
$ns duplex-link $n(81) $n(90) 1.5Mb 220ms DropTail
$ns duplex-link $n(82) $n(197) 1.5Mb 190ms DropTail
$ns duplex-link $n(82) $n(194) 1.5Mb 850ms DropTail
$ns duplex-link $n(82) $n(191) 1.5Mb 130ms DropTail
$ns duplex-link $n(82) $n(188) 1.5Mb 790ms DropTail
$ns duplex-link $n(82) $n(187) 1.5Mb 230ms DropTail
$ns duplex-link $n(82) $n(182) 1.5Mb 240ms DropTail
$ns duplex-link $n(82) $n(181) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "2590..."; flush stdout }
$ns duplex-link $n(82) $n(176) 1.5Mb 720ms DropTail
$ns duplex-link $n(82) $n(173) 1.5Mb 550ms DropTail
$ns duplex-link $n(82) $n(172) 1.5Mb 900ms DropTail
$ns duplex-link $n(82) $n(169) 1.5Mb 620ms DropTail
$ns duplex-link $n(82) $n(163) 1.5Mb 560ms DropTail
$ns duplex-link $n(82) $n(159) 1.5Mb 360ms DropTail
$ns duplex-link $n(82) $n(154) 1.5Mb 240ms DropTail
$ns duplex-link $n(82) $n(153) 1.5Mb 750ms DropTail
$ns duplex-link $n(82) $n(149) 1.5Mb 970ms DropTail
$ns duplex-link $n(82) $n(148) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "2600..."; flush stdout }
$ns duplex-link $n(82) $n(145) 1.5Mb 400ms DropTail
$ns duplex-link $n(82) $n(143) 1.5Mb 150ms DropTail
$ns duplex-link $n(82) $n(133) 1.5Mb 970ms DropTail
$ns duplex-link $n(82) $n(118) 1.5Mb 820ms DropTail
$ns duplex-link $n(82) $n(113) 1.5Mb 470ms DropTail
$ns duplex-link $n(82) $n(112) 1.5Mb 450ms DropTail
$ns duplex-link $n(82) $n(107) 1.5Mb 650ms DropTail
$ns duplex-link $n(82) $n(104) 1.5Mb 490ms DropTail
$ns duplex-link $n(82) $n(100) 1.5Mb 430ms DropTail
$ns duplex-link $n(82) $n(93) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "2610..."; flush stdout }
$ns duplex-link $n(82) $n(91) 1.5Mb 290ms DropTail
$ns duplex-link $n(82) $n(83) 1.5Mb 270ms DropTail
$ns duplex-link $n(83) $n(196) 1.5Mb 660ms DropTail
$ns duplex-link $n(83) $n(193) 1.5Mb 410ms DropTail
$ns duplex-link $n(83) $n(189) 1.5Mb 370ms DropTail
$ns duplex-link $n(83) $n(187) 1.5Mb 230ms DropTail
$ns duplex-link $n(83) $n(185) 1.5Mb 430ms DropTail
$ns duplex-link $n(83) $n(182) 1.5Mb 400ms DropTail
$ns duplex-link $n(83) $n(178) 1.5Mb 400ms DropTail
$ns duplex-link $n(83) $n(177) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "2620..."; flush stdout }
$ns duplex-link $n(83) $n(174) 1.5Mb 800ms DropTail
$ns duplex-link $n(83) $n(161) 1.5Mb 850ms DropTail
$ns duplex-link $n(83) $n(160) 1.5Mb 540ms DropTail
$ns duplex-link $n(83) $n(158) 1.5Mb 800ms DropTail
$ns duplex-link $n(83) $n(152) 1.5Mb 280ms DropTail
$ns duplex-link $n(83) $n(151) 1.5Mb 290ms DropTail
$ns duplex-link $n(83) $n(147) 1.5Mb 490ms DropTail
$ns duplex-link $n(83) $n(145) 1.5Mb 530ms DropTail
$ns duplex-link $n(83) $n(144) 1.5Mb 450ms DropTail
$ns duplex-link $n(83) $n(142) 1.5Mb 860ms DropTail
if {$verbose} { puts -nonewline "2630..."; flush stdout }
$ns duplex-link $n(83) $n(133) 1.5Mb 820ms DropTail
$ns duplex-link $n(83) $n(127) 1.5Mb 740ms DropTail
$ns duplex-link $n(83) $n(122) 1.5Mb 340ms DropTail
$ns duplex-link $n(83) $n(120) 1.5Mb 660ms DropTail
$ns duplex-link $n(83) $n(118) 1.5Mb 730ms DropTail
$ns duplex-link $n(83) $n(96) 1.5Mb 460ms DropTail
$ns duplex-link $n(83) $n(95) 1.5Mb 650ms DropTail
$ns duplex-link $n(84) $n(199) 1.5Mb 680ms DropTail
$ns duplex-link $n(84) $n(195) 1.5Mb 590ms DropTail
$ns duplex-link $n(84) $n(190) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "2640..."; flush stdout }
$ns duplex-link $n(84) $n(183) 1.5Mb 470ms DropTail
$ns duplex-link $n(84) $n(180) 1.5Mb 870ms DropTail
$ns duplex-link $n(84) $n(164) 1.5Mb 560ms DropTail
$ns duplex-link $n(84) $n(160) 1.5Mb 220ms DropTail
$ns duplex-link $n(84) $n(157) 1.5Mb 180ms DropTail
$ns duplex-link $n(84) $n(156) 1.5Mb 260ms DropTail
$ns duplex-link $n(84) $n(154) 1.5Mb 720ms DropTail
$ns duplex-link $n(84) $n(145) 1.5Mb 320ms DropTail
$ns duplex-link $n(84) $n(133) 1.5Mb 660ms DropTail
$ns duplex-link $n(84) $n(128) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "2650..."; flush stdout }
$ns duplex-link $n(84) $n(126) 1.5Mb 400ms DropTail
$ns duplex-link $n(84) $n(119) 1.5Mb 890ms DropTail
$ns duplex-link $n(84) $n(113) 1.5Mb 850ms DropTail
$ns duplex-link $n(84) $n(108) 1.5Mb 460ms DropTail
$ns duplex-link $n(84) $n(97) 1.5Mb 370ms DropTail
$ns duplex-link $n(84) $n(93) 1.5Mb 60ms DropTail
$ns duplex-link $n(84) $n(92) 1.5Mb 730ms DropTail
$ns duplex-link $n(84) $n(90) 1.5Mb 620ms DropTail
$ns duplex-link $n(84) $n(86) 1.5Mb 450ms DropTail
$ns duplex-link $n(85) $n(191) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "2660..."; flush stdout }
$ns duplex-link $n(85) $n(179) 1.5Mb 520ms DropTail
$ns duplex-link $n(85) $n(178) 1.5Mb 170ms DropTail
$ns duplex-link $n(85) $n(176) 1.5Mb 190ms DropTail
$ns duplex-link $n(85) $n(175) 1.5Mb 280ms DropTail
$ns duplex-link $n(85) $n(174) 1.5Mb 460ms DropTail
$ns duplex-link $n(85) $n(173) 1.5Mb 460ms DropTail
$ns duplex-link $n(85) $n(160) 1.5Mb 210ms DropTail
$ns duplex-link $n(85) $n(159) 1.5Mb 420ms DropTail
$ns duplex-link $n(85) $n(155) 1.5Mb 70ms DropTail
$ns duplex-link $n(85) $n(154) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "2670..."; flush stdout }
$ns duplex-link $n(85) $n(139) 1.5Mb 340ms DropTail
$ns duplex-link $n(85) $n(137) 1.5Mb 290ms DropTail
$ns duplex-link $n(85) $n(128) 1.5Mb 510ms DropTail
$ns duplex-link $n(85) $n(107) 1.5Mb 300ms DropTail
$ns duplex-link $n(85) $n(103) 1.5Mb 460ms DropTail
$ns duplex-link $n(85) $n(101) 1.5Mb 540ms DropTail
$ns duplex-link $n(85) $n(100) 1.5Mb 510ms DropTail
$ns duplex-link $n(85) $n(99) 1.5Mb 610ms DropTail
$ns duplex-link $n(85) $n(96) 1.5Mb 110ms DropTail
$ns duplex-link $n(85) $n(91) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "2680..."; flush stdout }
$ns duplex-link $n(86) $n(194) 1.5Mb 910ms DropTail
$ns duplex-link $n(86) $n(190) 1.5Mb 960ms DropTail
$ns duplex-link $n(86) $n(188) 1.5Mb 840ms DropTail
$ns duplex-link $n(86) $n(186) 1.5Mb 730ms DropTail
$ns duplex-link $n(86) $n(185) 1.5Mb 730ms DropTail
$ns duplex-link $n(86) $n(181) 1.5Mb 960ms DropTail
$ns duplex-link $n(86) $n(176) 1.5Mb 670ms DropTail
$ns duplex-link $n(86) $n(168) 1.5Mb 660ms DropTail
$ns duplex-link $n(86) $n(162) 1.5Mb 430ms DropTail
$ns duplex-link $n(86) $n(160) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "2690..."; flush stdout }
$ns duplex-link $n(86) $n(154) 1.5Mb 440ms DropTail
$ns duplex-link $n(86) $n(152) 1.5Mb 500ms DropTail
$ns duplex-link $n(86) $n(148) 1.5Mb 530ms DropTail
$ns duplex-link $n(86) $n(129) 1.5Mb 460ms DropTail
$ns duplex-link $n(86) $n(126) 1.5Mb 50ms DropTail
$ns duplex-link $n(86) $n(125) 1.5Mb 460ms DropTail
$ns duplex-link $n(86) $n(111) 1.5Mb 730ms DropTail
$ns duplex-link $n(86) $n(95) 1.5Mb 530ms DropTail
$ns duplex-link $n(87) $n(196) 1.5Mb 420ms DropTail
$ns duplex-link $n(87) $n(195) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "2700..."; flush stdout }
$ns duplex-link $n(87) $n(186) 1.5Mb 360ms DropTail
$ns duplex-link $n(87) $n(183) 1.5Mb 400ms DropTail
$ns duplex-link $n(87) $n(170) 1.5Mb 130ms DropTail
$ns duplex-link $n(87) $n(166) 1.5Mb 510ms DropTail
$ns duplex-link $n(87) $n(163) 1.5Mb 370ms DropTail
$ns duplex-link $n(87) $n(150) 1.5Mb 760ms DropTail
$ns duplex-link $n(87) $n(142) 1.5Mb 380ms DropTail
$ns duplex-link $n(87) $n(136) 1.5Mb 210ms DropTail
$ns duplex-link $n(87) $n(128) 1.5Mb 690ms DropTail
$ns duplex-link $n(87) $n(125) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "2710..."; flush stdout }
$ns duplex-link $n(87) $n(118) 1.5Mb 310ms DropTail
$ns duplex-link $n(87) $n(112) 1.5Mb 430ms DropTail
$ns duplex-link $n(87) $n(100) 1.5Mb 620ms DropTail
$ns duplex-link $n(87) $n(97) 1.5Mb 210ms DropTail
$ns duplex-link $n(87) $n(89) 1.5Mb 740ms DropTail
$ns duplex-link $n(88) $n(188) 1.5Mb 300ms DropTail
$ns duplex-link $n(88) $n(186) 1.5Mb 350ms DropTail
$ns duplex-link $n(88) $n(177) 1.5Mb 400ms DropTail
$ns duplex-link $n(88) $n(175) 1.5Mb 340ms DropTail
$ns duplex-link $n(88) $n(173) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "2720..."; flush stdout }
$ns duplex-link $n(88) $n(159) 1.5Mb 480ms DropTail
$ns duplex-link $n(88) $n(153) 1.5Mb 460ms DropTail
$ns duplex-link $n(88) $n(152) 1.5Mb 110ms DropTail
$ns duplex-link $n(88) $n(145) 1.5Mb 480ms DropTail
$ns duplex-link $n(88) $n(142) 1.5Mb 480ms DropTail
$ns duplex-link $n(88) $n(141) 1.5Mb 490ms DropTail
$ns duplex-link $n(88) $n(138) 1.5Mb 350ms DropTail
$ns duplex-link $n(88) $n(137) 1.5Mb 330ms DropTail
$ns duplex-link $n(88) $n(127) 1.5Mb 340ms DropTail
$ns duplex-link $n(88) $n(119) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "2730..."; flush stdout }
$ns duplex-link $n(88) $n(111) 1.5Mb 450ms DropTail
$ns duplex-link $n(88) $n(108) 1.5Mb 60ms DropTail
$ns duplex-link $n(88) $n(101) 1.5Mb 350ms DropTail
$ns duplex-link $n(88) $n(100) 1.5Mb 330ms DropTail
$ns duplex-link $n(88) $n(98) 1.5Mb 350ms DropTail
$ns duplex-link $n(88) $n(92) 1.5Mb 480ms DropTail
$ns duplex-link $n(89) $n(189) 1.5Mb 150ms DropTail
$ns duplex-link $n(89) $n(186) 1.5Mb 620ms DropTail
$ns duplex-link $n(89) $n(177) 1.5Mb 280ms DropTail
$ns duplex-link $n(89) $n(176) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "2740..."; flush stdout }
$ns duplex-link $n(89) $n(171) 1.5Mb 940ms DropTail
$ns duplex-link $n(89) $n(170) 1.5Mb 730ms DropTail
$ns duplex-link $n(89) $n(163) 1.5Mb 370ms DropTail
$ns duplex-link $n(89) $n(159) 1.5Mb 840ms DropTail
$ns duplex-link $n(89) $n(156) 1.5Mb 690ms DropTail
$ns duplex-link $n(89) $n(151) 1.5Mb 260ms DropTail
$ns duplex-link $n(89) $n(134) 1.5Mb 890ms DropTail
$ns duplex-link $n(89) $n(133) 1.5Mb 550ms DropTail
$ns duplex-link $n(89) $n(130) 1.5Mb 850ms DropTail
$ns duplex-link $n(89) $n(123) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "2750..."; flush stdout }
$ns duplex-link $n(89) $n(115) 1.5Mb 710ms DropTail
$ns duplex-link $n(89) $n(102) 1.5Mb 420ms DropTail
$ns duplex-link $n(89) $n(100) 1.5Mb 340ms DropTail
$ns duplex-link $n(89) $n(93) 1.5Mb 920ms DropTail
$ns duplex-link $n(90) $n(197) 1.5Mb 710ms DropTail
$ns duplex-link $n(90) $n(191) 1.5Mb 710ms DropTail
$ns duplex-link $n(90) $n(182) 1.5Mb 670ms DropTail
$ns duplex-link $n(90) $n(175) 1.5Mb 210ms DropTail
$ns duplex-link $n(90) $n(174) 1.5Mb 240ms DropTail
$ns duplex-link $n(90) $n(171) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "2760..."; flush stdout }
$ns duplex-link $n(90) $n(165) 1.5Mb 690ms DropTail
$ns duplex-link $n(90) $n(159) 1.5Mb 670ms DropTail
$ns duplex-link $n(90) $n(148) 1.5Mb 240ms DropTail
$ns duplex-link $n(90) $n(147) 1.5Mb 70ms DropTail
$ns duplex-link $n(90) $n(146) 1.5Mb 420ms DropTail
$ns duplex-link $n(90) $n(138) 1.5Mb 180ms DropTail
$ns duplex-link $n(90) $n(120) 1.5Mb 90ms DropTail
$ns duplex-link $n(90) $n(116) 1.5Mb 640ms DropTail
$ns duplex-link $n(90) $n(112) 1.5Mb 310ms DropTail
$ns duplex-link $n(90) $n(98) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "2770..."; flush stdout }
$ns duplex-link $n(90) $n(97) 1.5Mb 410ms DropTail
$ns duplex-link $n(90) $n(94) 1.5Mb 190ms DropTail
$ns duplex-link $n(91) $n(199) 1.5Mb 450ms DropTail
$ns duplex-link $n(91) $n(198) 1.5Mb 860ms DropTail
$ns duplex-link $n(91) $n(189) 1.5Mb 360ms DropTail
$ns duplex-link $n(91) $n(186) 1.5Mb 670ms DropTail
$ns duplex-link $n(91) $n(184) 1.5Mb 600ms DropTail
$ns duplex-link $n(91) $n(175) 1.5Mb 660ms DropTail
$ns duplex-link $n(91) $n(173) 1.5Mb 270ms DropTail
$ns duplex-link $n(91) $n(166) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "2780..."; flush stdout }
$ns duplex-link $n(91) $n(162) 1.5Mb 470ms DropTail
$ns duplex-link $n(91) $n(154) 1.5Mb 60ms DropTail
$ns duplex-link $n(91) $n(142) 1.5Mb 790ms DropTail
$ns duplex-link $n(91) $n(139) 1.5Mb 440ms DropTail
$ns duplex-link $n(91) $n(137) 1.5Mb 650ms DropTail
$ns duplex-link $n(91) $n(133) 1.5Mb 750ms DropTail
$ns duplex-link $n(91) $n(120) 1.5Mb 600ms DropTail
$ns duplex-link $n(91) $n(115) 1.5Mb 690ms DropTail
$ns duplex-link $n(91) $n(114) 1.5Mb 390ms DropTail
$ns duplex-link $n(91) $n(106) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "2790..."; flush stdout }
$ns duplex-link $n(92) $n(198) 1.5Mb 180ms DropTail
$ns duplex-link $n(92) $n(189) 1.5Mb 670ms DropTail
$ns duplex-link $n(92) $n(179) 1.5Mb 980ms DropTail
$ns duplex-link $n(92) $n(177) 1.5Mb 760ms DropTail
$ns duplex-link $n(92) $n(176) 1.5Mb 310ms DropTail
$ns duplex-link $n(92) $n(159) 1.5Mb 890ms DropTail
$ns duplex-link $n(92) $n(157) 1.5Mb 550ms DropTail
$ns duplex-link $n(92) $n(156) 1.5Mb 480ms DropTail
$ns duplex-link $n(92) $n(154) 1.5Mb 850ms DropTail
$ns duplex-link $n(92) $n(151) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "2800..."; flush stdout }
$ns duplex-link $n(92) $n(150) 1.5Mb 820ms DropTail
$ns duplex-link $n(92) $n(144) 1.5Mb 1000ms DropTail
$ns duplex-link $n(92) $n(140) 1.5Mb 770ms DropTail
$ns duplex-link $n(92) $n(126) 1.5Mb 930ms DropTail
$ns duplex-link $n(92) $n(125) 1.5Mb 700ms DropTail
$ns duplex-link $n(92) $n(122) 1.5Mb 540ms DropTail
$ns duplex-link $n(92) $n(119) 1.5Mb 160ms DropTail
$ns duplex-link $n(92) $n(113) 1.5Mb 770ms DropTail
$ns duplex-link $n(92) $n(108) 1.5Mb 500ms DropTail
$ns duplex-link $n(92) $n(107) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "2810..."; flush stdout }
$ns duplex-link $n(93) $n(199) 1.5Mb 630ms DropTail
$ns duplex-link $n(93) $n(195) 1.5Mb 550ms DropTail
$ns duplex-link $n(93) $n(192) 1.5Mb 160ms DropTail
$ns duplex-link $n(93) $n(190) 1.5Mb 760ms DropTail
$ns duplex-link $n(93) $n(184) 1.5Mb 370ms DropTail
$ns duplex-link $n(93) $n(172) 1.5Mb 880ms DropTail
$ns duplex-link $n(93) $n(159) 1.5Mb 310ms DropTail
$ns duplex-link $n(93) $n(146) 1.5Mb 230ms DropTail
$ns duplex-link $n(93) $n(145) 1.5Mb 270ms DropTail
$ns duplex-link $n(93) $n(140) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "2820..."; flush stdout }
$ns duplex-link $n(93) $n(127) 1.5Mb 560ms DropTail
$ns duplex-link $n(93) $n(122) 1.5Mb 720ms DropTail
$ns duplex-link $n(93) $n(120) 1.5Mb 670ms DropTail
$ns duplex-link $n(93) $n(118) 1.5Mb 430ms DropTail
$ns duplex-link $n(93) $n(114) 1.5Mb 520ms DropTail
$ns duplex-link $n(93) $n(112) 1.5Mb 590ms DropTail
$ns duplex-link $n(93) $n(111) 1.5Mb 420ms DropTail
$ns duplex-link $n(93) $n(109) 1.5Mb 340ms DropTail
$ns duplex-link $n(93) $n(107) 1.5Mb 660ms DropTail
$ns duplex-link $n(93) $n(101) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "2830..."; flush stdout }
$ns duplex-link $n(93) $n(99) 1.5Mb 840ms DropTail
$ns duplex-link $n(93) $n(98) 1.5Mb 420ms DropTail
$ns duplex-link $n(94) $n(198) 1.5Mb 560ms DropTail
$ns duplex-link $n(94) $n(195) 1.5Mb 560ms DropTail
$ns duplex-link $n(94) $n(192) 1.5Mb 520ms DropTail
$ns duplex-link $n(94) $n(190) 1.5Mb 450ms DropTail
$ns duplex-link $n(94) $n(189) 1.5Mb 450ms DropTail
$ns duplex-link $n(94) $n(185) 1.5Mb 250ms DropTail
$ns duplex-link $n(94) $n(181) 1.5Mb 500ms DropTail
$ns duplex-link $n(94) $n(173) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "2840..."; flush stdout }
$ns duplex-link $n(94) $n(169) 1.5Mb 490ms DropTail
$ns duplex-link $n(94) $n(161) 1.5Mb 480ms DropTail
$ns duplex-link $n(94) $n(150) 1.5Mb 520ms DropTail
$ns duplex-link $n(94) $n(143) 1.5Mb 540ms DropTail
$ns duplex-link $n(94) $n(128) 1.5Mb 380ms DropTail
$ns duplex-link $n(94) $n(118) 1.5Mb 290ms DropTail
$ns duplex-link $n(94) $n(115) 1.5Mb 330ms DropTail
$ns duplex-link $n(94) $n(106) 1.5Mb 250ms DropTail
$ns duplex-link $n(94) $n(105) 1.5Mb 330ms DropTail
$ns duplex-link $n(94) $n(104) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "2850..."; flush stdout }
$ns duplex-link $n(94) $n(99) 1.5Mb 510ms DropTail
$ns duplex-link $n(94) $n(98) 1.5Mb 290ms DropTail
$ns duplex-link $n(94) $n(95) 1.5Mb 250ms DropTail
$ns duplex-link $n(95) $n(199) 1.5Mb 730ms DropTail
$ns duplex-link $n(95) $n(192) 1.5Mb 270ms DropTail
$ns duplex-link $n(95) $n(188) 1.5Mb 530ms DropTail
$ns duplex-link $n(95) $n(184) 1.5Mb 80ms DropTail
$ns duplex-link $n(95) $n(177) 1.5Mb 710ms DropTail
$ns duplex-link $n(95) $n(173) 1.5Mb 580ms DropTail
$ns duplex-link $n(95) $n(172) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "2860..."; flush stdout }
$ns duplex-link $n(95) $n(171) 1.5Mb 260ms DropTail
$ns duplex-link $n(95) $n(166) 1.5Mb 640ms DropTail
$ns duplex-link $n(95) $n(160) 1.5Mb 210ms DropTail
$ns duplex-link $n(95) $n(154) 1.5Mb 620ms DropTail
$ns duplex-link $n(95) $n(153) 1.5Mb 760ms DropTail
$ns duplex-link $n(95) $n(147) 1.5Mb 370ms DropTail
$ns duplex-link $n(95) $n(144) 1.5Mb 580ms DropTail
$ns duplex-link $n(95) $n(143) 1.5Mb 600ms DropTail
$ns duplex-link $n(95) $n(139) 1.5Mb 440ms DropTail
$ns duplex-link $n(95) $n(131) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "2870..."; flush stdout }
$ns duplex-link $n(95) $n(126) 1.5Mb 490ms DropTail
$ns duplex-link $n(95) $n(125) 1.5Mb 230ms DropTail
$ns duplex-link $n(95) $n(121) 1.5Mb 90ms DropTail
$ns duplex-link $n(95) $n(120) 1.5Mb 380ms DropTail
$ns duplex-link $n(95) $n(116) 1.5Mb 920ms DropTail
$ns duplex-link $n(95) $n(113) 1.5Mb 680ms DropTail
$ns duplex-link $n(95) $n(111) 1.5Mb 200ms DropTail
$ns duplex-link $n(95) $n(110) 1.5Mb 140ms DropTail
$ns duplex-link $n(95) $n(102) 1.5Mb 310ms DropTail
$ns duplex-link $n(96) $n(194) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "2880..."; flush stdout }
$ns duplex-link $n(96) $n(193) 1.5Mb 690ms DropTail
$ns duplex-link $n(96) $n(191) 1.5Mb 520ms DropTail
$ns duplex-link $n(96) $n(190) 1.5Mb 450ms DropTail
$ns duplex-link $n(96) $n(179) 1.5Mb 530ms DropTail
$ns duplex-link $n(96) $n(176) 1.5Mb 140ms DropTail
$ns duplex-link $n(96) $n(163) 1.5Mb 90ms DropTail
$ns duplex-link $n(96) $n(162) 1.5Mb 190ms DropTail
$ns duplex-link $n(96) $n(160) 1.5Mb 290ms DropTail
$ns duplex-link $n(96) $n(157) 1.5Mb 300ms DropTail
$ns duplex-link $n(96) $n(156) 1.5Mb 240ms DropTail
if {$verbose} { puts -nonewline "2890..."; flush stdout }
$ns duplex-link $n(96) $n(153) 1.5Mb 530ms DropTail
$ns duplex-link $n(96) $n(151) 1.5Mb 270ms DropTail
$ns duplex-link $n(96) $n(149) 1.5Mb 390ms DropTail
$ns duplex-link $n(96) $n(145) 1.5Mb 450ms DropTail
$ns duplex-link $n(96) $n(142) 1.5Mb 410ms DropTail
$ns duplex-link $n(96) $n(136) 1.5Mb 260ms DropTail
$ns duplex-link $n(96) $n(128) 1.5Mb 400ms DropTail
$ns duplex-link $n(96) $n(120) 1.5Mb 270ms DropTail
$ns duplex-link $n(96) $n(119) 1.5Mb 570ms DropTail
$ns duplex-link $n(96) $n(105) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "2900..."; flush stdout }
$ns duplex-link $n(96) $n(102) 1.5Mb 100ms DropTail
$ns duplex-link $n(96) $n(101) 1.5Mb 430ms DropTail
$ns duplex-link $n(97) $n(195) 1.5Mb 360ms DropTail
$ns duplex-link $n(97) $n(190) 1.5Mb 640ms DropTail
$ns duplex-link $n(97) $n(189) 1.5Mb 570ms DropTail
$ns duplex-link $n(97) $n(180) 1.5Mb 640ms DropTail
$ns duplex-link $n(97) $n(167) 1.5Mb 510ms DropTail
$ns duplex-link $n(97) $n(166) 1.5Mb 410ms DropTail
$ns duplex-link $n(97) $n(163) 1.5Mb 240ms DropTail
$ns duplex-link $n(97) $n(162) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "2910..."; flush stdout }
$ns duplex-link $n(97) $n(158) 1.5Mb 400ms DropTail
$ns duplex-link $n(97) $n(156) 1.5Mb 280ms DropTail
$ns duplex-link $n(97) $n(141) 1.5Mb 440ms DropTail
$ns duplex-link $n(97) $n(140) 1.5Mb 440ms DropTail
$ns duplex-link $n(97) $n(125) 1.5Mb 350ms DropTail
$ns duplex-link $n(97) $n(121) 1.5Mb 180ms DropTail
$ns duplex-link $n(97) $n(120) 1.5Mb 480ms DropTail
$ns duplex-link $n(97) $n(113) 1.5Mb 480ms DropTail
$ns duplex-link $n(97) $n(109) 1.5Mb 110ms DropTail
$ns duplex-link $n(97) $n(104) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "2920..."; flush stdout }
$ns duplex-link $n(97) $n(102) 1.5Mb 180ms DropTail
$ns duplex-link $n(97) $n(99) 1.5Mb 490ms DropTail
$ns duplex-link $n(98) $n(197) 1.5Mb 700ms DropTail
$ns duplex-link $n(98) $n(187) 1.5Mb 580ms DropTail
$ns duplex-link $n(98) $n(167) 1.5Mb 830ms DropTail
$ns duplex-link $n(98) $n(165) 1.5Mb 390ms DropTail
$ns duplex-link $n(98) $n(159) 1.5Mb 590ms DropTail
$ns duplex-link $n(98) $n(158) 1.5Mb 310ms DropTail
$ns duplex-link $n(98) $n(157) 1.5Mb 210ms DropTail
$ns duplex-link $n(98) $n(143) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "2930..."; flush stdout }
$ns duplex-link $n(98) $n(140) 1.5Mb 700ms DropTail
$ns duplex-link $n(98) $n(139) 1.5Mb 410ms DropTail
$ns duplex-link $n(98) $n(127) 1.5Mb 140ms DropTail
$ns duplex-link $n(98) $n(124) 1.5Mb 360ms DropTail
$ns duplex-link $n(98) $n(123) 1.5Mb 470ms DropTail
$ns duplex-link $n(98) $n(122) 1.5Mb 520ms DropTail
$ns duplex-link $n(98) $n(118) 1.5Mb 10ms DropTail
$ns duplex-link $n(98) $n(113) 1.5Mb 730ms DropTail
$ns duplex-link $n(98) $n(111) 1.5Mb 100ms DropTail
$ns duplex-link $n(98) $n(110) 1.5Mb 30ms DropTail
if {$verbose} { puts -nonewline "2940..."; flush stdout }
$ns duplex-link $n(98) $n(109) 1.5Mb 480ms DropTail
$ns duplex-link $n(98) $n(103) 1.5Mb 400ms DropTail
$ns duplex-link $n(99) $n(195) 1.5Mb 460ms DropTail
$ns duplex-link $n(99) $n(187) 1.5Mb 340ms DropTail
$ns duplex-link $n(99) $n(185) 1.5Mb 430ms DropTail
$ns duplex-link $n(99) $n(172) 1.5Mb 670ms DropTail
$ns duplex-link $n(99) $n(163) 1.5Mb 450ms DropTail
$ns duplex-link $n(99) $n(162) 1.5Mb 630ms DropTail
$ns duplex-link $n(99) $n(157) 1.5Mb 770ms DropTail
$ns duplex-link $n(99) $n(146) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "2950..."; flush stdout }
$ns duplex-link $n(99) $n(144) 1.5Mb 550ms DropTail
$ns duplex-link $n(99) $n(141) 1.5Mb 910ms DropTail
$ns duplex-link $n(99) $n(136) 1.5Mb 770ms DropTail
$ns duplex-link $n(99) $n(135) 1.5Mb 810ms DropTail
$ns duplex-link $n(99) $n(134) 1.5Mb 540ms DropTail
$ns duplex-link $n(99) $n(130) 1.5Mb 890ms DropTail
$ns duplex-link $n(99) $n(125) 1.5Mb 840ms DropTail
$ns duplex-link $n(99) $n(120) 1.5Mb 690ms DropTail
$ns duplex-link $n(99) $n(113) 1.5Mb 140ms DropTail
$ns duplex-link $n(99) $n(108) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "2960..."; flush stdout }
$ns duplex-link $n(99) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(99) $n(100) 1.5Mb 140ms DropTail
$ns duplex-link $n(100) $n(198) 1.5Mb 790ms DropTail
$ns duplex-link $n(100) $n(196) 1.5Mb 580ms DropTail
$ns duplex-link $n(100) $n(182) 1.5Mb 510ms DropTail
$ns duplex-link $n(100) $n(179) 1.5Mb 520ms DropTail
$ns duplex-link $n(100) $n(175) 1.5Mb 650ms DropTail
$ns duplex-link $n(100) $n(167) 1.5Mb 190ms DropTail
$ns duplex-link $n(100) $n(161) 1.5Mb 850ms DropTail
$ns duplex-link $n(100) $n(160) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "2970..."; flush stdout }
$ns duplex-link $n(100) $n(158) 1.5Mb 810ms DropTail
$ns duplex-link $n(100) $n(156) 1.5Mb 640ms DropTail
$ns duplex-link $n(100) $n(155) 1.5Mb 570ms DropTail
$ns duplex-link $n(100) $n(149) 1.5Mb 730ms DropTail
$ns duplex-link $n(100) $n(146) 1.5Mb 580ms DropTail
$ns duplex-link $n(100) $n(145) 1.5Mb 610ms DropTail
$ns duplex-link $n(100) $n(132) 1.5Mb 400ms DropTail
$ns duplex-link $n(100) $n(131) 1.5Mb 220ms DropTail
$ns duplex-link $n(100) $n(126) 1.5Mb 600ms DropTail
$ns duplex-link $n(100) $n(123) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "2980..."; flush stdout }
$ns duplex-link $n(100) $n(117) 1.5Mb 220ms DropTail
$ns duplex-link $n(100) $n(115) 1.5Mb 730ms DropTail
$ns duplex-link $n(100) $n(114) 1.5Mb 540ms DropTail
$ns duplex-link $n(100) $n(113) 1.5Mb 60ms DropTail
$ns duplex-link $n(100) $n(112) 1.5Mb 210ms DropTail
$ns duplex-link $n(100) $n(107) 1.5Mb 340ms DropTail
$ns duplex-link $n(100) $n(104) 1.5Mb 380ms DropTail
$ns duplex-link $n(101) $n(197) 1.5Mb 700ms DropTail
$ns duplex-link $n(101) $n(187) 1.5Mb 500ms DropTail
$ns duplex-link $n(101) $n(186) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "2990..."; flush stdout }
$ns duplex-link $n(101) $n(179) 1.5Mb 710ms DropTail
$ns duplex-link $n(101) $n(177) 1.5Mb 160ms DropTail
$ns duplex-link $n(101) $n(173) 1.5Mb 100ms DropTail
$ns duplex-link $n(101) $n(164) 1.5Mb 610ms DropTail
$ns duplex-link $n(101) $n(150) 1.5Mb 220ms DropTail
$ns duplex-link $n(101) $n(149) 1.5Mb 630ms DropTail
$ns duplex-link $n(101) $n(144) 1.5Mb 760ms DropTail
$ns duplex-link $n(101) $n(136) 1.5Mb 670ms DropTail
$ns duplex-link $n(101) $n(135) 1.5Mb 770ms DropTail
$ns duplex-link $n(101) $n(120) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "3000..."; flush stdout }
$ns duplex-link $n(101) $n(112) 1.5Mb 290ms DropTail
$ns duplex-link $n(101) $n(103) 1.5Mb 1000ms DropTail
$ns duplex-link $n(101) $n(102) 1.5Mb 370ms DropTail
$ns duplex-link $n(102) $n(194) 1.5Mb 430ms DropTail
$ns duplex-link $n(102) $n(191) 1.5Mb 450ms DropTail
$ns duplex-link $n(102) $n(190) 1.5Mb 530ms DropTail
$ns duplex-link $n(102) $n(189) 1.5Mb 410ms DropTail
$ns duplex-link $n(102) $n(182) 1.5Mb 420ms DropTail
$ns duplex-link $n(102) $n(178) 1.5Mb 40ms DropTail
$ns duplex-link $n(102) $n(174) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "3010..."; flush stdout }
$ns duplex-link $n(102) $n(172) 1.5Mb 460ms DropTail
$ns duplex-link $n(102) $n(159) 1.5Mb 440ms DropTail
$ns duplex-link $n(102) $n(158) 1.5Mb 510ms DropTail
$ns duplex-link $n(102) $n(156) 1.5Mb 320ms DropTail
$ns duplex-link $n(102) $n(154) 1.5Mb 340ms DropTail
$ns duplex-link $n(102) $n(151) 1.5Mb 190ms DropTail
$ns duplex-link $n(102) $n(145) 1.5Mb 430ms DropTail
$ns duplex-link $n(102) $n(143) 1.5Mb 470ms DropTail
$ns duplex-link $n(102) $n(134) 1.5Mb 550ms DropTail
$ns duplex-link $n(102) $n(128) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "3020..."; flush stdout }
$ns duplex-link $n(102) $n(126) 1.5Mb 470ms DropTail
$ns duplex-link $n(102) $n(123) 1.5Mb 350ms DropTail
$ns duplex-link $n(102) $n(121) 1.5Mb 250ms DropTail
$ns duplex-link $n(102) $n(120) 1.5Mb 340ms DropTail
$ns duplex-link $n(102) $n(110) 1.5Mb 390ms DropTail
$ns duplex-link $n(102) $n(103) 1.5Mb 640ms DropTail
$ns duplex-link $n(103) $n(192) 1.5Mb 90ms DropTail
$ns duplex-link $n(103) $n(188) 1.5Mb 870ms DropTail
$ns duplex-link $n(103) $n(184) 1.5Mb 380ms DropTail
$ns duplex-link $n(103) $n(183) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "3030..."; flush stdout }
$ns duplex-link $n(103) $n(182) 1.5Mb 660ms DropTail
$ns duplex-link $n(103) $n(172) 1.5Mb 930ms DropTail
$ns duplex-link $n(103) $n(168) 1.5Mb 220ms DropTail
$ns duplex-link $n(103) $n(166) 1.5Mb 760ms DropTail
$ns duplex-link $n(103) $n(164) 1.5Mb 750ms DropTail
$ns duplex-link $n(103) $n(152) 1.5Mb 720ms DropTail
$ns duplex-link $n(103) $n(148) 1.5Mb 490ms DropTail
$ns duplex-link $n(103) $n(147) 1.5Mb 710ms DropTail
$ns duplex-link $n(103) $n(143) 1.5Mb 760ms DropTail
$ns duplex-link $n(103) $n(135) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "3040..."; flush stdout }
$ns duplex-link $n(103) $n(134) 1.5Mb 790ms DropTail
$ns duplex-link $n(103) $n(123) 1.5Mb 860ms DropTail
$ns duplex-link $n(103) $n(117) 1.5Mb 840ms DropTail
$ns duplex-link $n(103) $n(113) 1.5Mb 1000ms DropTail
$ns duplex-link $n(103) $n(112) 1.5Mb 750ms DropTail
$ns duplex-link $n(103) $n(109) 1.5Mb 560ms DropTail
$ns duplex-link $n(103) $n(105) 1.5Mb 460ms DropTail
$ns duplex-link $n(104) $n(196) 1.5Mb 330ms DropTail
$ns duplex-link $n(104) $n(195) 1.5Mb 450ms DropTail
$ns duplex-link $n(104) $n(193) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "3050..."; flush stdout }
$ns duplex-link $n(104) $n(185) 1.5Mb 320ms DropTail
$ns duplex-link $n(104) $n(178) 1.5Mb 90ms DropTail
$ns duplex-link $n(104) $n(175) 1.5Mb 380ms DropTail
$ns duplex-link $n(104) $n(174) 1.5Mb 520ms DropTail
$ns duplex-link $n(104) $n(173) 1.5Mb 350ms DropTail
$ns duplex-link $n(104) $n(172) 1.5Mb 510ms DropTail
$ns duplex-link $n(104) $n(169) 1.5Mb 420ms DropTail
$ns duplex-link $n(104) $n(168) 1.5Mb 440ms DropTail
$ns duplex-link $n(104) $n(164) 1.5Mb 360ms DropTail
$ns duplex-link $n(104) $n(163) 1.5Mb 130ms DropTail
if {$verbose} { puts -nonewline "3060..."; flush stdout }
$ns duplex-link $n(104) $n(162) 1.5Mb 160ms DropTail
$ns duplex-link $n(104) $n(149) 1.5Mb 490ms DropTail
$ns duplex-link $n(104) $n(146) 1.5Mb 210ms DropTail
$ns duplex-link $n(104) $n(130) 1.5Mb 420ms DropTail
$ns duplex-link $n(104) $n(127) 1.5Mb 380ms DropTail
$ns duplex-link $n(104) $n(126) 1.5Mb 410ms DropTail
$ns duplex-link $n(104) $n(125) 1.5Mb 410ms DropTail
$ns duplex-link $n(104) $n(123) 1.5Mb 420ms DropTail
$ns duplex-link $n(104) $n(110) 1.5Mb 350ms DropTail
$ns duplex-link $n(105) $n(198) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "3070..."; flush stdout }
$ns duplex-link $n(105) $n(195) 1.5Mb 830ms DropTail
$ns duplex-link $n(105) $n(194) 1.5Mb 530ms DropTail
$ns duplex-link $n(105) $n(191) 1.5Mb 800ms DropTail
$ns duplex-link $n(105) $n(186) 1.5Mb 40ms DropTail
$ns duplex-link $n(105) $n(184) 1.5Mb 160ms DropTail
$ns duplex-link $n(105) $n(175) 1.5Mb 110ms DropTail
$ns duplex-link $n(105) $n(174) 1.5Mb 320ms DropTail
$ns duplex-link $n(105) $n(172) 1.5Mb 490ms DropTail
$ns duplex-link $n(105) $n(171) 1.5Mb 410ms DropTail
$ns duplex-link $n(105) $n(165) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "3080..."; flush stdout }
$ns duplex-link $n(105) $n(156) 1.5Mb 230ms DropTail
$ns duplex-link $n(105) $n(154) 1.5Mb 760ms DropTail
$ns duplex-link $n(105) $n(148) 1.5Mb 260ms DropTail
$ns duplex-link $n(105) $n(130) 1.5Mb 310ms DropTail
$ns duplex-link $n(105) $n(124) 1.5Mb 440ms DropTail
$ns duplex-link $n(105) $n(111) 1.5Mb 130ms DropTail
$ns duplex-link $n(105) $n(107) 1.5Mb 400ms DropTail
$ns duplex-link $n(105) $n(106) 1.5Mb 520ms DropTail
$ns duplex-link $n(106) $n(184) 1.5Mb 380ms DropTail
$ns duplex-link $n(106) $n(183) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "3090..."; flush stdout }
$ns duplex-link $n(106) $n(169) 1.5Mb 370ms DropTail
$ns duplex-link $n(106) $n(166) 1.5Mb 370ms DropTail
$ns duplex-link $n(106) $n(165) 1.5Mb 620ms DropTail
$ns duplex-link $n(106) $n(155) 1.5Mb 320ms DropTail
$ns duplex-link $n(106) $n(151) 1.5Mb 340ms DropTail
$ns duplex-link $n(106) $n(149) 1.5Mb 620ms DropTail
$ns duplex-link $n(106) $n(144) 1.5Mb 320ms DropTail
$ns duplex-link $n(106) $n(139) 1.5Mb 430ms DropTail
$ns duplex-link $n(106) $n(134) 1.5Mb 370ms DropTail
$ns duplex-link $n(106) $n(130) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "3100..."; flush stdout }
$ns duplex-link $n(106) $n(121) 1.5Mb 240ms DropTail
$ns duplex-link $n(106) $n(110) 1.5Mb 450ms DropTail
$ns duplex-link $n(106) $n(109) 1.5Mb 90ms DropTail
$ns duplex-link $n(106) $n(108) 1.5Mb 190ms DropTail
$ns duplex-link $n(107) $n(198) 1.5Mb 470ms DropTail
$ns duplex-link $n(107) $n(196) 1.5Mb 250ms DropTail
$ns duplex-link $n(107) $n(190) 1.5Mb 420ms DropTail
$ns duplex-link $n(107) $n(189) 1.5Mb 320ms DropTail
$ns duplex-link $n(107) $n(187) 1.5Mb 440ms DropTail
$ns duplex-link $n(107) $n(185) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "3110..."; flush stdout }
$ns duplex-link $n(107) $n(180) 1.5Mb 280ms DropTail
$ns duplex-link $n(107) $n(172) 1.5Mb 270ms DropTail
$ns duplex-link $n(107) $n(170) 1.5Mb 480ms DropTail
$ns duplex-link $n(107) $n(160) 1.5Mb 470ms DropTail
$ns duplex-link $n(107) $n(159) 1.5Mb 620ms DropTail
$ns duplex-link $n(107) $n(158) 1.5Mb 620ms DropTail
$ns duplex-link $n(107) $n(144) 1.5Mb 680ms DropTail
$ns duplex-link $n(107) $n(139) 1.5Mb 50ms DropTail
$ns duplex-link $n(107) $n(136) 1.5Mb 410ms DropTail
$ns duplex-link $n(107) $n(130) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "3120..."; flush stdout }
$ns duplex-link $n(107) $n(127) 1.5Mb 330ms DropTail
$ns duplex-link $n(107) $n(117) 1.5Mb 130ms DropTail
$ns duplex-link $n(108) $n(199) 1.5Mb 630ms DropTail
$ns duplex-link $n(108) $n(197) 1.5Mb 470ms DropTail
$ns duplex-link $n(108) $n(189) 1.5Mb 460ms DropTail
$ns duplex-link $n(108) $n(186) 1.5Mb 330ms DropTail
$ns duplex-link $n(108) $n(185) 1.5Mb 280ms DropTail
$ns duplex-link $n(108) $n(184) 1.5Mb 270ms DropTail
$ns duplex-link $n(108) $n(182) 1.5Mb 420ms DropTail
$ns duplex-link $n(108) $n(180) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "3130..."; flush stdout }
$ns duplex-link $n(108) $n(178) 1.5Mb 40ms DropTail
$ns duplex-link $n(108) $n(177) 1.5Mb 450ms DropTail
$ns duplex-link $n(108) $n(175) 1.5Mb 340ms DropTail
$ns duplex-link $n(108) $n(173) 1.5Mb 330ms DropTail
$ns duplex-link $n(108) $n(172) 1.5Mb 460ms DropTail
$ns duplex-link $n(108) $n(170) 1.5Mb 280ms DropTail
$ns duplex-link $n(108) $n(162) 1.5Mb 190ms DropTail
$ns duplex-link $n(108) $n(161) 1.5Mb 480ms DropTail
$ns duplex-link $n(108) $n(159) 1.5Mb 430ms DropTail
$ns duplex-link $n(108) $n(157) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "3140..."; flush stdout }
$ns duplex-link $n(108) $n(156) 1.5Mb 270ms DropTail
$ns duplex-link $n(108) $n(154) 1.5Mb 390ms DropTail
$ns duplex-link $n(108) $n(131) 1.5Mb 470ms DropTail
$ns duplex-link $n(108) $n(130) 1.5Mb 430ms DropTail
$ns duplex-link $n(108) $n(126) 1.5Mb 460ms DropTail
$ns duplex-link $n(108) $n(124) 1.5Mb 420ms DropTail
$ns duplex-link $n(108) $n(123) 1.5Mb 360ms DropTail
$ns duplex-link $n(108) $n(117) 1.5Mb 250ms DropTail
$ns duplex-link $n(108) $n(116) 1.5Mb 670ms DropTail
$ns duplex-link $n(108) $n(113) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "3150..."; flush stdout }
$ns duplex-link $n(109) $n(194) 1.5Mb 700ms DropTail
$ns duplex-link $n(109) $n(192) 1.5Mb 460ms DropTail
$ns duplex-link $n(109) $n(185) 1.5Mb 520ms DropTail
$ns duplex-link $n(109) $n(182) 1.5Mb 160ms DropTail
$ns duplex-link $n(109) $n(177) 1.5Mb 570ms DropTail
$ns duplex-link $n(109) $n(169) 1.5Mb 310ms DropTail
$ns duplex-link $n(109) $n(167) 1.5Mb 510ms DropTail
$ns duplex-link $n(109) $n(162) 1.5Mb 230ms DropTail
$ns duplex-link $n(109) $n(156) 1.5Mb 360ms DropTail
$ns duplex-link $n(109) $n(151) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "3160..."; flush stdout }
$ns duplex-link $n(109) $n(150) 1.5Mb 600ms DropTail
$ns duplex-link $n(109) $n(145) 1.5Mb 160ms DropTail
$ns duplex-link $n(109) $n(138) 1.5Mb 610ms DropTail
$ns duplex-link $n(109) $n(134) 1.5Mb 320ms DropTail
$ns duplex-link $n(109) $n(126) 1.5Mb 190ms DropTail
$ns duplex-link $n(109) $n(120) 1.5Mb 590ms DropTail
$ns duplex-link $n(109) $n(119) 1.5Mb 880ms DropTail
$ns duplex-link $n(109) $n(116) 1.5Mb 810ms DropTail
$ns duplex-link $n(109) $n(115) 1.5Mb 490ms DropTail
$ns duplex-link $n(109) $n(114) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "3170..."; flush stdout }
$ns duplex-link $n(109) $n(111) 1.5Mb 550ms DropTail
$ns duplex-link $n(110) $n(199) 1.5Mb 870ms DropTail
$ns duplex-link $n(110) $n(191) 1.5Mb 730ms DropTail
$ns duplex-link $n(110) $n(185) 1.5Mb 520ms DropTail
$ns duplex-link $n(110) $n(183) 1.5Mb 120ms DropTail
$ns duplex-link $n(110) $n(170) 1.5Mb 400ms DropTail
$ns duplex-link $n(110) $n(168) 1.5Mb 150ms DropTail
$ns duplex-link $n(110) $n(152) 1.5Mb 470ms DropTail
$ns duplex-link $n(110) $n(150) 1.5Mb 820ms DropTail
$ns duplex-link $n(110) $n(146) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "3180..."; flush stdout }
$ns duplex-link $n(110) $n(144) 1.5Mb 720ms DropTail
$ns duplex-link $n(110) $n(118) 1.5Mb 40ms DropTail
$ns duplex-link $n(111) $n(191) 1.5Mb 800ms DropTail
$ns duplex-link $n(111) $n(190) 1.5Mb 370ms DropTail
$ns duplex-link $n(111) $n(189) 1.5Mb 820ms DropTail
$ns duplex-link $n(111) $n(187) 1.5Mb 660ms DropTail
$ns duplex-link $n(111) $n(181) 1.5Mb 790ms DropTail
$ns duplex-link $n(111) $n(171) 1.5Mb 300ms DropTail
$ns duplex-link $n(111) $n(160) 1.5Mb 410ms DropTail
$ns duplex-link $n(111) $n(159) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "3190..."; flush stdout }
$ns duplex-link $n(111) $n(136) 1.5Mb 140ms DropTail
$ns duplex-link $n(111) $n(135) 1.5Mb 230ms DropTail
$ns duplex-link $n(111) $n(128) 1.5Mb 670ms DropTail
$ns duplex-link $n(111) $n(127) 1.5Mb 210ms DropTail
$ns duplex-link $n(111) $n(123) 1.5Mb 570ms DropTail
$ns duplex-link $n(111) $n(121) 1.5Mb 290ms DropTail
$ns duplex-link $n(111) $n(117) 1.5Mb 610ms DropTail
$ns duplex-link $n(111) $n(112) 1.5Mb 580ms DropTail
$ns duplex-link $n(112) $n(194) 1.5Mb 420ms DropTail
$ns duplex-link $n(112) $n(192) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "3200..."; flush stdout }
$ns duplex-link $n(112) $n(184) 1.5Mb 430ms DropTail
$ns duplex-link $n(112) $n(182) 1.5Mb 420ms DropTail
$ns duplex-link $n(112) $n(174) 1.5Mb 540ms DropTail
$ns duplex-link $n(112) $n(167) 1.5Mb 360ms DropTail
$ns duplex-link $n(112) $n(166) 1.5Mb 540ms DropTail
$ns duplex-link $n(112) $n(164) 1.5Mb 360ms DropTail
$ns duplex-link $n(112) $n(163) 1.5Mb 130ms DropTail
$ns duplex-link $n(112) $n(141) 1.5Mb 600ms DropTail
$ns duplex-link $n(112) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(113) $n(198) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "3210..."; flush stdout }
$ns duplex-link $n(113) $n(191) 1.5Mb 520ms DropTail
$ns duplex-link $n(113) $n(185) 1.5Mb 310ms DropTail
$ns duplex-link $n(113) $n(177) 1.5Mb 60ms DropTail
$ns duplex-link $n(113) $n(172) 1.5Mb 530ms DropTail
$ns duplex-link $n(113) $n(166) 1.5Mb 650ms DropTail
$ns duplex-link $n(113) $n(157) 1.5Mb 730ms DropTail
$ns duplex-link $n(113) $n(150) 1.5Mb 80ms DropTail
$ns duplex-link $n(113) $n(147) 1.5Mb 420ms DropTail
$ns duplex-link $n(113) $n(144) 1.5Mb 630ms DropTail
$ns duplex-link $n(113) $n(140) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "3220..."; flush stdout }
$ns duplex-link $n(113) $n(134) 1.5Mb 630ms DropTail
$ns duplex-link $n(113) $n(129) 1.5Mb 450ms DropTail
$ns duplex-link $n(113) $n(125) 1.5Mb 830ms DropTail
$ns duplex-link $n(113) $n(121) 1.5Mb 620ms DropTail
$ns duplex-link $n(114) $n(190) 1.5Mb 1010ms DropTail
$ns duplex-link $n(114) $n(187) 1.5Mb 250ms DropTail
$ns duplex-link $n(114) $n(179) 1.5Mb 40ms DropTail
$ns duplex-link $n(114) $n(178) 1.5Mb 540ms DropTail
$ns duplex-link $n(114) $n(166) 1.5Mb 60ms DropTail
$ns duplex-link $n(114) $n(162) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "3230..."; flush stdout }
$ns duplex-link $n(114) $n(153) 1.5Mb 850ms DropTail
$ns duplex-link $n(114) $n(151) 1.5Mb 590ms DropTail
$ns duplex-link $n(114) $n(146) 1.5Mb 490ms DropTail
$ns duplex-link $n(114) $n(142) 1.5Mb 860ms DropTail
$ns duplex-link $n(114) $n(132) 1.5Mb 530ms DropTail
$ns duplex-link $n(114) $n(120) 1.5Mb 840ms DropTail
$ns duplex-link $n(114) $n(115) 1.5Mb 760ms DropTail
$ns duplex-link $n(115) $n(183) 1.5Mb 130ms DropTail
$ns duplex-link $n(115) $n(181) 1.5Mb 750ms DropTail
$ns duplex-link $n(115) $n(173) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "3240..."; flush stdout }
$ns duplex-link $n(115) $n(172) 1.5Mb 590ms DropTail
$ns duplex-link $n(115) $n(168) 1.5Mb 130ms DropTail
$ns duplex-link $n(115) $n(156) 1.5Mb 130ms DropTail
$ns duplex-link $n(115) $n(150) 1.5Mb 850ms DropTail
$ns duplex-link $n(115) $n(132) 1.5Mb 330ms DropTail
$ns duplex-link $n(115) $n(127) 1.5Mb 190ms DropTail
$ns duplex-link $n(115) $n(120) 1.5Mb 350ms DropTail
$ns duplex-link $n(115) $n(116) 1.5Mb 980ms DropTail
$ns duplex-link $n(116) $n(190) 1.5Mb 880ms DropTail
$ns duplex-link $n(116) $n(186) 1.5Mb 900ms DropTail
if {$verbose} { puts -nonewline "3250..."; flush stdout }
$ns duplex-link $n(116) $n(182) 1.5Mb 870ms DropTail
$ns duplex-link $n(116) $n(181) 1.5Mb 330ms DropTail
$ns duplex-link $n(116) $n(177) 1.5Mb 240ms DropTail
$ns duplex-link $n(116) $n(172) 1.5Mb 550ms DropTail
$ns duplex-link $n(116) $n(166) 1.5Mb 950ms DropTail
$ns duplex-link $n(116) $n(164) 1.5Mb 760ms DropTail
$ns duplex-link $n(116) $n(154) 1.5Mb 520ms DropTail
$ns duplex-link $n(116) $n(153) 1.5Mb 200ms DropTail
$ns duplex-link $n(116) $n(149) 1.5Mb 890ms DropTail
$ns duplex-link $n(116) $n(140) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "3260..."; flush stdout }
$ns duplex-link $n(116) $n(139) 1.5Mb 530ms DropTail
$ns duplex-link $n(116) $n(121) 1.5Mb 870ms DropTail
$ns duplex-link $n(116) $n(120) 1.5Mb 710ms DropTail
$ns duplex-link $n(117) $n(198) 1.5Mb 570ms DropTail
$ns duplex-link $n(117) $n(194) 1.5Mb 270ms DropTail
$ns duplex-link $n(117) $n(193) 1.5Mb 710ms DropTail
$ns duplex-link $n(117) $n(188) 1.5Mb 220ms DropTail
$ns duplex-link $n(117) $n(187) 1.5Mb 390ms DropTail
$ns duplex-link $n(117) $n(179) 1.5Mb 610ms DropTail
$ns duplex-link $n(117) $n(178) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "3270..."; flush stdout }
$ns duplex-link $n(117) $n(174) 1.5Mb 460ms DropTail
$ns duplex-link $n(117) $n(169) 1.5Mb 700ms DropTail
$ns duplex-link $n(117) $n(165) 1.5Mb 850ms DropTail
$ns duplex-link $n(117) $n(160) 1.5Mb 510ms DropTail
$ns duplex-link $n(117) $n(152) 1.5Mb 160ms DropTail
$ns duplex-link $n(117) $n(149) 1.5Mb 520ms DropTail
$ns duplex-link $n(117) $n(143) 1.5Mb 600ms DropTail
$ns duplex-link $n(117) $n(139) 1.5Mb 160ms DropTail
$ns duplex-link $n(117) $n(135) 1.5Mb 610ms DropTail
$ns duplex-link $n(117) $n(131) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "3280..."; flush stdout }
$ns duplex-link $n(117) $n(129) 1.5Mb 290ms DropTail
$ns duplex-link $n(118) $n(192) 1.5Mb 370ms DropTail
$ns duplex-link $n(118) $n(188) 1.5Mb 480ms DropTail
$ns duplex-link $n(118) $n(187) 1.5Mb 590ms DropTail
$ns duplex-link $n(118) $n(184) 1.5Mb 80ms DropTail
$ns duplex-link $n(118) $n(181) 1.5Mb 690ms DropTail
$ns duplex-link $n(118) $n(173) 1.5Mb 600ms DropTail
$ns duplex-link $n(118) $n(171) 1.5Mb 350ms DropTail
$ns duplex-link $n(118) $n(168) 1.5Mb 190ms DropTail
$ns duplex-link $n(118) $n(161) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "3290..."; flush stdout }
$ns duplex-link $n(118) $n(159) 1.5Mb 600ms DropTail
$ns duplex-link $n(118) $n(144) 1.5Mb 730ms DropTail
$ns duplex-link $n(118) $n(134) 1.5Mb 800ms DropTail
$ns duplex-link $n(118) $n(122) 1.5Mb 520ms DropTail
$ns duplex-link $n(118) $n(120) 1.5Mb 280ms DropTail
$ns duplex-link $n(118) $n(119) 1.5Mb 500ms DropTail
$ns duplex-link $n(119) $n(195) 1.5Mb 1120ms DropTail
$ns duplex-link $n(119) $n(191) 1.5Mb 1090ms DropTail
$ns duplex-link $n(119) $n(190) 1.5Mb 180ms DropTail
$ns duplex-link $n(119) $n(185) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "3300..."; flush stdout }
$ns duplex-link $n(119) $n(181) 1.5Mb 520ms DropTail
$ns duplex-link $n(119) $n(177) 1.5Mb 800ms DropTail
$ns duplex-link $n(119) $n(175) 1.5Mb 350ms DropTail
$ns duplex-link $n(119) $n(171) 1.5Mb 840ms DropTail
$ns duplex-link $n(119) $n(164) 1.5Mb 1020ms DropTail
$ns duplex-link $n(119) $n(154) 1.5Mb 930ms DropTail
$ns duplex-link $n(119) $n(153) 1.5Mb 650ms DropTail
$ns duplex-link $n(119) $n(152) 1.5Mb 680ms DropTail
$ns duplex-link $n(119) $n(151) 1.5Mb 640ms DropTail
$ns duplex-link $n(119) $n(140) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "3310..."; flush stdout }
$ns duplex-link $n(119) $n(129) 1.5Mb 640ms DropTail
$ns duplex-link $n(119) $n(121) 1.5Mb 690ms DropTail
$ns duplex-link $n(120) $n(198) 1.5Mb 300ms DropTail
$ns duplex-link $n(120) $n(197) 1.5Mb 790ms DropTail
$ns duplex-link $n(120) $n(192) 1.5Mb 640ms DropTail
$ns duplex-link $n(120) $n(191) 1.5Mb 790ms DropTail
$ns duplex-link $n(120) $n(173) 1.5Mb 430ms DropTail
$ns duplex-link $n(120) $n(171) 1.5Mb 620ms DropTail
$ns duplex-link $n(120) $n(167) 1.5Mb 740ms DropTail
$ns duplex-link $n(120) $n(163) 1.5Mb 280ms DropTail
if {$verbose} { puts -nonewline "3320..."; flush stdout }
$ns duplex-link $n(120) $n(159) 1.5Mb 730ms DropTail
$ns duplex-link $n(120) $n(156) 1.5Mb 380ms DropTail
$ns duplex-link $n(120) $n(138) 1.5Mb 100ms DropTail
$ns duplex-link $n(120) $n(135) 1.5Mb 500ms DropTail
$ns duplex-link $n(120) $n(131) 1.5Mb 730ms DropTail
$ns duplex-link $n(120) $n(130) 1.5Mb 530ms DropTail
$ns duplex-link $n(120) $n(126) 1.5Mb 770ms DropTail
$ns duplex-link $n(121) $n(195) 1.5Mb 530ms DropTail
$ns duplex-link $n(121) $n(194) 1.5Mb 610ms DropTail
$ns duplex-link $n(121) $n(188) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "3330..."; flush stdout }
$ns duplex-link $n(121) $n(178) 1.5Mb 240ms DropTail
$ns duplex-link $n(121) $n(172) 1.5Mb 610ms DropTail
$ns duplex-link $n(121) $n(162) 1.5Mb 30ms DropTail
$ns duplex-link $n(121) $n(157) 1.5Mb 120ms DropTail
$ns duplex-link $n(121) $n(153) 1.5Mb 730ms DropTail
$ns duplex-link $n(121) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(121) $n(124) 1.5Mb 220ms DropTail
$ns duplex-link $n(122) $n(194) 1.5Mb 270ms DropTail
$ns duplex-link $n(122) $n(192) 1.5Mb 770ms DropTail
$ns duplex-link $n(122) $n(188) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "3340..."; flush stdout }
$ns duplex-link $n(122) $n(184) 1.5Mb 490ms DropTail
$ns duplex-link $n(122) $n(181) 1.5Mb 290ms DropTail
$ns duplex-link $n(122) $n(180) 1.5Mb 330ms DropTail
$ns duplex-link $n(122) $n(174) 1.5Mb 470ms DropTail
$ns duplex-link $n(122) $n(161) 1.5Mb 740ms DropTail
$ns duplex-link $n(122) $n(147) 1.5Mb 190ms DropTail
$ns duplex-link $n(122) $n(146) 1.5Mb 500ms DropTail
$ns duplex-link $n(122) $n(133) 1.5Mb 510ms DropTail
$ns duplex-link $n(122) $n(128) 1.5Mb 210ms DropTail
$ns duplex-link $n(122) $n(126) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "3350..."; flush stdout }
$ns duplex-link $n(122) $n(124) 1.5Mb 680ms DropTail
$ns duplex-link $n(123) $n(199) 1.5Mb 940ms DropTail
$ns duplex-link $n(123) $n(193) 1.5Mb 940ms DropTail
$ns duplex-link $n(123) $n(173) 1.5Mb 300ms DropTail
$ns duplex-link $n(123) $n(171) 1.5Mb 790ms DropTail
$ns duplex-link $n(123) $n(162) 1.5Mb 520ms DropTail
$ns duplex-link $n(123) $n(160) 1.5Mb 630ms DropTail
$ns duplex-link $n(123) $n(155) 1.5Mb 430ms DropTail
$ns duplex-link $n(123) $n(154) 1.5Mb 590ms DropTail
$ns duplex-link $n(123) $n(148) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "3360..."; flush stdout }
$ns duplex-link $n(123) $n(145) 1.5Mb 780ms DropTail
$ns duplex-link $n(123) $n(144) 1.5Mb 850ms DropTail
$ns duplex-link $n(123) $n(142) 1.5Mb 570ms DropTail
$ns duplex-link $n(123) $n(140) 1.5Mb 460ms DropTail
$ns duplex-link $n(123) $n(139) 1.5Mb 110ms DropTail
$ns duplex-link $n(123) $n(133) 1.5Mb 340ms DropTail
$ns duplex-link $n(123) $n(131) 1.5Mb 650ms DropTail
$ns duplex-link $n(124) $n(195) 1.5Mb 560ms DropTail
$ns duplex-link $n(124) $n(191) 1.5Mb 550ms DropTail
$ns duplex-link $n(124) $n(184) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "3370..."; flush stdout }
$ns duplex-link $n(124) $n(183) 1.5Mb 450ms DropTail
$ns duplex-link $n(124) $n(180) 1.5Mb 840ms DropTail
$ns duplex-link $n(124) $n(177) 1.5Mb 850ms DropTail
$ns duplex-link $n(124) $n(176) 1.5Mb 490ms DropTail
$ns duplex-link $n(124) $n(157) 1.5Mb 150ms DropTail
$ns duplex-link $n(124) $n(148) 1.5Mb 350ms DropTail
$ns duplex-link $n(124) $n(145) 1.5Mb 290ms DropTail
$ns duplex-link $n(125) $n(195) 1.5Mb 590ms DropTail
$ns duplex-link $n(125) $n(191) 1.5Mb 580ms DropTail
$ns duplex-link $n(125) $n(188) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "3380..."; flush stdout }
$ns duplex-link $n(125) $n(156) 1.5Mb 230ms DropTail
$ns duplex-link $n(125) $n(155) 1.5Mb 320ms DropTail
$ns duplex-link $n(125) $n(154) 1.5Mb 710ms DropTail
$ns duplex-link $n(125) $n(151) 1.5Mb 670ms DropTail
$ns duplex-link $n(125) $n(150) 1.5Mb 910ms DropTail
$ns duplex-link $n(125) $n(142) 1.5Mb 390ms DropTail
$ns duplex-link $n(125) $n(140) 1.5Mb 790ms DropTail
$ns duplex-link $n(125) $n(135) 1.5Mb 110ms DropTail
$ns duplex-link $n(125) $n(134) 1.5Mb 600ms DropTail
$ns duplex-link $n(125) $n(133) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "3390..."; flush stdout }
$ns duplex-link $n(126) $n(191) 1.5Mb 210ms DropTail
$ns duplex-link $n(126) $n(189) 1.5Mb 800ms DropTail
$ns duplex-link $n(126) $n(187) 1.5Mb 280ms DropTail
$ns duplex-link $n(126) $n(185) 1.5Mb 710ms DropTail
$ns duplex-link $n(126) $n(177) 1.5Mb 720ms DropTail
$ns duplex-link $n(126) $n(175) 1.5Mb 740ms DropTail
$ns duplex-link $n(126) $n(165) 1.5Mb 640ms DropTail
$ns duplex-link $n(126) $n(164) 1.5Mb 220ms DropTail
$ns duplex-link $n(126) $n(156) 1.5Mb 490ms DropTail
$ns duplex-link $n(126) $n(152) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "3400..."; flush stdout }
$ns duplex-link $n(126) $n(146) 1.5Mb 360ms DropTail
$ns duplex-link $n(126) $n(145) 1.5Mb 80ms DropTail
$ns duplex-link $n(126) $n(135) 1.5Mb 460ms DropTail
$ns duplex-link $n(127) $n(199) 1.5Mb 950ms DropTail
$ns duplex-link $n(127) $n(198) 1.5Mb 380ms DropTail
$ns duplex-link $n(127) $n(194) 1.5Mb 450ms DropTail
$ns duplex-link $n(127) $n(192) 1.5Mb 500ms DropTail
$ns duplex-link $n(127) $n(191) 1.5Mb 800ms DropTail
$ns duplex-link $n(127) $n(186) 1.5Mb 70ms DropTail
$ns duplex-link $n(127) $n(183) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "3410..."; flush stdout }
$ns duplex-link $n(127) $n(179) 1.5Mb 790ms DropTail
$ns duplex-link $n(127) $n(175) 1.5Mb 20ms DropTail
$ns duplex-link $n(127) $n(171) 1.5Mb 480ms DropTail
$ns duplex-link $n(127) $n(170) 1.5Mb 500ms DropTail
$ns duplex-link $n(127) $n(162) 1.5Mb 350ms DropTail
$ns duplex-link $n(127) $n(160) 1.5Mb 470ms DropTail
$ns duplex-link $n(127) $n(156) 1.5Mb 270ms DropTail
$ns duplex-link $n(127) $n(154) 1.5Mb 720ms DropTail
$ns duplex-link $n(127) $n(144) 1.5Mb 810ms DropTail
$ns duplex-link $n(127) $n(140) 1.5Mb 680ms DropTail
if {$verbose} { puts -nonewline "3420..."; flush stdout }
$ns duplex-link $n(127) $n(130) 1.5Mb 380ms DropTail
$ns duplex-link $n(128) $n(196) 1.5Mb 380ms DropTail
$ns duplex-link $n(128) $n(191) 1.5Mb 790ms DropTail
$ns duplex-link $n(128) $n(190) 1.5Mb 470ms DropTail
$ns duplex-link $n(128) $n(183) 1.5Mb 590ms DropTail
$ns duplex-link $n(128) $n(180) 1.5Mb 140ms DropTail
$ns duplex-link $n(128) $n(173) 1.5Mb 250ms DropTail
$ns duplex-link $n(128) $n(171) 1.5Mb 870ms DropTail
$ns duplex-link $n(128) $n(167) 1.5Mb 590ms DropTail
$ns duplex-link $n(128) $n(165) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "3430..."; flush stdout }
$ns duplex-link $n(128) $n(162) 1.5Mb 590ms DropTail
$ns duplex-link $n(128) $n(160) 1.5Mb 690ms DropTail
$ns duplex-link $n(128) $n(158) 1.5Mb 830ms DropTail
$ns duplex-link $n(128) $n(156) 1.5Mb 610ms DropTail
$ns duplex-link $n(128) $n(147) 1.5Mb 240ms DropTail
$ns duplex-link $n(128) $n(146) 1.5Mb 640ms DropTail
$ns duplex-link $n(128) $n(143) 1.5Mb 820ms DropTail
$ns duplex-link $n(128) $n(140) 1.5Mb 410ms DropTail
$ns duplex-link $n(129) $n(198) 1.5Mb 640ms DropTail
$ns duplex-link $n(129) $n(195) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "3440..."; flush stdout }
$ns duplex-link $n(129) $n(193) 1.5Mb 630ms DropTail
$ns duplex-link $n(129) $n(190) 1.5Mb 520ms DropTail
$ns duplex-link $n(129) $n(185) 1.5Mb 320ms DropTail
$ns duplex-link $n(129) $n(179) 1.5Mb 460ms DropTail
$ns duplex-link $n(129) $n(177) 1.5Mb 480ms DropTail
$ns duplex-link $n(129) $n(175) 1.5Mb 340ms DropTail
$ns duplex-link $n(129) $n(164) 1.5Mb 390ms DropTail
$ns duplex-link $n(129) $n(160) 1.5Mb 230ms DropTail
$ns duplex-link $n(129) $n(152) 1.5Mb 170ms DropTail
$ns duplex-link $n(129) $n(146) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "3450..."; flush stdout }
$ns duplex-link $n(129) $n(144) 1.5Mb 480ms DropTail
$ns duplex-link $n(129) $n(142) 1.5Mb 440ms DropTail
$ns duplex-link $n(129) $n(135) 1.5Mb 330ms DropTail
$ns duplex-link $n(130) $n(195) 1.5Mb 700ms DropTail
$ns duplex-link $n(130) $n(175) 1.5Mb 400ms DropTail
$ns duplex-link $n(130) $n(173) 1.5Mb 760ms DropTail
$ns duplex-link $n(130) $n(172) 1.5Mb 760ms DropTail
$ns duplex-link $n(130) $n(171) 1.5Mb 100ms DropTail
$ns duplex-link $n(130) $n(166) 1.5Mb 700ms DropTail
$ns duplex-link $n(130) $n(164) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "3460..."; flush stdout }
$ns duplex-link $n(130) $n(162) 1.5Mb 260ms DropTail
$ns duplex-link $n(130) $n(161) 1.5Mb 50ms DropTail
$ns duplex-link $n(130) $n(160) 1.5Mb 290ms DropTail
$ns duplex-link $n(130) $n(159) 1.5Mb 490ms DropTail
$ns duplex-link $n(130) $n(156) 1.5Mb 170ms DropTail
$ns duplex-link $n(130) $n(150) 1.5Mb 930ms DropTail
$ns duplex-link $n(130) $n(145) 1.5Mb 450ms DropTail
$ns duplex-link $n(130) $n(144) 1.5Mb 650ms DropTail
$ns duplex-link $n(130) $n(138) 1.5Mb 470ms DropTail
$ns duplex-link $n(130) $n(132) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "3470..."; flush stdout }
$ns duplex-link $n(131) $n(198) 1.5Mb 990ms DropTail
$ns duplex-link $n(131) $n(196) 1.5Mb 730ms DropTail
$ns duplex-link $n(131) $n(195) 1.5Mb 340ms DropTail
$ns duplex-link $n(131) $n(194) 1.5Mb 680ms DropTail
$ns duplex-link $n(131) $n(188) 1.5Mb 630ms DropTail
$ns duplex-link $n(131) $n(169) 1.5Mb 730ms DropTail
$ns duplex-link $n(131) $n(167) 1.5Mb 100ms DropTail
$ns duplex-link $n(131) $n(166) 1.5Mb 440ms DropTail
$ns duplex-link $n(131) $n(164) 1.5Mb 280ms DropTail
$ns duplex-link $n(131) $n(162) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "3480..."; flush stdout }
$ns duplex-link $n(131) $n(152) 1.5Mb 350ms DropTail
$ns duplex-link $n(131) $n(144) 1.5Mb 430ms DropTail
$ns duplex-link $n(131) $n(143) 1.5Mb 350ms DropTail
$ns duplex-link $n(131) $n(136) 1.5Mb 740ms DropTail
$ns duplex-link $n(131) $n(134) 1.5Mb 410ms DropTail
$ns duplex-link $n(132) $n(199) 1.5Mb 640ms DropTail
$ns duplex-link $n(132) $n(187) 1.5Mb 320ms DropTail
$ns duplex-link $n(132) $n(186) 1.5Mb 300ms DropTail
$ns duplex-link $n(132) $n(183) 1.5Mb 380ms DropTail
$ns duplex-link $n(132) $n(182) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "3490..."; flush stdout }
$ns duplex-link $n(132) $n(178) 1.5Mb 60ms DropTail
$ns duplex-link $n(132) $n(174) 1.5Mb 460ms DropTail
$ns duplex-link $n(132) $n(169) 1.5Mb 440ms DropTail
$ns duplex-link $n(132) $n(160) 1.5Mb 260ms DropTail
$ns duplex-link $n(132) $n(154) 1.5Mb 420ms DropTail
$ns duplex-link $n(132) $n(150) 1.5Mb 530ms DropTail
$ns duplex-link $n(132) $n(146) 1.5Mb 220ms DropTail
$ns duplex-link $n(132) $n(142) 1.5Mb 420ms DropTail
$ns duplex-link $n(132) $n(141) 1.5Mb 410ms DropTail
$ns duplex-link $n(132) $n(138) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "3500..."; flush stdout }
$ns duplex-link $n(132) $n(135) 1.5Mb 340ms DropTail
$ns duplex-link $n(133) $n(198) 1.5Mb 240ms DropTail
$ns duplex-link $n(133) $n(195) 1.5Mb 940ms DropTail
$ns duplex-link $n(133) $n(183) 1.5Mb 220ms DropTail
$ns duplex-link $n(133) $n(180) 1.5Mb 350ms DropTail
$ns duplex-link $n(133) $n(175) 1.5Mb 130ms DropTail
$ns duplex-link $n(133) $n(155) 1.5Mb 350ms DropTail
$ns duplex-link $n(133) $n(148) 1.5Mb 380ms DropTail
$ns duplex-link $n(133) $n(144) 1.5Mb 940ms DropTail
$ns duplex-link $n(133) $n(138) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "3510..."; flush stdout }
$ns duplex-link $n(134) $n(196) 1.5Mb 840ms DropTail
$ns duplex-link $n(134) $n(193) 1.5Mb 150ms DropTail
$ns duplex-link $n(134) $n(191) 1.5Mb 110ms DropTail
$ns duplex-link $n(134) $n(188) 1.5Mb 890ms DropTail
$ns duplex-link $n(134) $n(181) 1.5Mb 970ms DropTail
$ns duplex-link $n(134) $n(178) 1.5Mb 590ms DropTail
$ns duplex-link $n(134) $n(166) 1.5Mb 40ms DropTail
$ns duplex-link $n(134) $n(165) 1.5Mb 840ms DropTail
$ns duplex-link $n(134) $n(164) 1.5Mb 180ms DropTail
$ns duplex-link $n(134) $n(161) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "3520..."; flush stdout }
$ns duplex-link $n(134) $n(156) 1.5Mb 670ms DropTail
$ns duplex-link $n(134) $n(151) 1.5Mb 630ms DropTail
$ns duplex-link $n(135) $n(195) 1.5Mb 630ms DropTail
$ns duplex-link $n(135) $n(194) 1.5Mb 740ms DropTail
$ns duplex-link $n(135) $n(190) 1.5Mb 570ms DropTail
$ns duplex-link $n(135) $n(182) 1.5Mb 510ms DropTail
$ns duplex-link $n(135) $n(175) 1.5Mb 390ms DropTail
$ns duplex-link $n(135) $n(171) 1.5Mb 140ms DropTail
$ns duplex-link $n(135) $n(170) 1.5Mb 260ms DropTail
$ns duplex-link $n(135) $n(158) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "3530..."; flush stdout }
$ns duplex-link $n(135) $n(155) 1.5Mb 220ms DropTail
$ns duplex-link $n(135) $n(152) 1.5Mb 500ms DropTail
$ns duplex-link $n(135) $n(149) 1.5Mb 490ms DropTail
$ns duplex-link $n(135) $n(140) 1.5Mb 740ms DropTail
$ns duplex-link $n(136) $n(198) 1.5Mb 610ms DropTail
$ns duplex-link $n(136) $n(197) 1.5Mb 620ms DropTail
$ns duplex-link $n(136) $n(194) 1.5Mb 600ms DropTail
$ns duplex-link $n(136) $n(193) 1.5Mb 830ms DropTail
$ns duplex-link $n(136) $n(191) 1.5Mb 650ms DropTail
$ns duplex-link $n(136) $n(189) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "3540..."; flush stdout }
$ns duplex-link $n(136) $n(185) 1.5Mb 510ms DropTail
$ns duplex-link $n(136) $n(181) 1.5Mb 730ms DropTail
$ns duplex-link $n(136) $n(179) 1.5Mb 640ms DropTail
$ns duplex-link $n(136) $n(172) 1.5Mb 590ms DropTail
$ns duplex-link $n(136) $n(163) 1.5Mb 350ms DropTail
$ns duplex-link $n(136) $n(157) 1.5Mb 120ms DropTail
$ns duplex-link $n(136) $n(155) 1.5Mb 100ms DropTail
$ns duplex-link $n(136) $n(147) 1.5Mb 370ms DropTail
$ns duplex-link $n(136) $n(146) 1.5Mb 180ms DropTail
$ns duplex-link $n(136) $n(143) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "3550..."; flush stdout }
$ns duplex-link $n(136) $n(140) 1.5Mb 680ms DropTail
$ns duplex-link $n(137) $n(197) 1.5Mb 790ms DropTail
$ns duplex-link $n(137) $n(196) 1.5Mb 50ms DropTail
$ns duplex-link $n(137) $n(191) 1.5Mb 810ms DropTail
$ns duplex-link $n(137) $n(189) 1.5Mb 600ms DropTail
$ns duplex-link $n(137) $n(187) 1.5Mb 630ms DropTail
$ns duplex-link $n(137) $n(185) 1.5Mb 370ms DropTail
$ns duplex-link $n(137) $n(183) 1.5Mb 180ms DropTail
$ns duplex-link $n(137) $n(182) 1.5Mb 740ms DropTail
$ns duplex-link $n(137) $n(177) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "3560..."; flush stdout }
$ns duplex-link $n(137) $n(174) 1.5Mb 180ms DropTail
$ns duplex-link $n(137) $n(172) 1.5Mb 340ms DropTail
$ns duplex-link $n(137) $n(165) 1.5Mb 590ms DropTail
$ns duplex-link $n(137) $n(162) 1.5Mb 380ms DropTail
$ns duplex-link $n(137) $n(160) 1.5Mb 500ms DropTail
$ns duplex-link $n(137) $n(153) 1.5Mb 610ms DropTail
$ns duplex-link $n(137) $n(152) 1.5Mb 440ms DropTail
$ns duplex-link $n(137) $n(150) 1.5Mb 730ms DropTail
$ns duplex-link $n(137) $n(146) 1.5Mb 420ms DropTail
$ns duplex-link $n(137) $n(141) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "3570..."; flush stdout }
$ns duplex-link $n(137) $n(140) 1.5Mb 650ms DropTail
$ns duplex-link $n(138) $n(192) 1.5Mb 590ms DropTail
$ns duplex-link $n(138) $n(185) 1.5Mb 380ms DropTail
$ns duplex-link $n(138) $n(182) 1.5Mb 770ms DropTail
$ns duplex-link $n(138) $n(171) 1.5Mb 570ms DropTail
$ns duplex-link $n(138) $n(170) 1.5Mb 570ms DropTail
$ns duplex-link $n(138) $n(166) 1.5Mb 910ms DropTail
$ns duplex-link $n(138) $n(160) 1.5Mb 530ms DropTail
$ns duplex-link $n(138) $n(157) 1.5Mb 430ms DropTail
$ns duplex-link $n(138) $n(144) 1.5Mb 860ms DropTail
if {$verbose} { puts -nonewline "3580..."; flush stdout }
$ns duplex-link $n(138) $n(141) 1.5Mb 440ms DropTail
$ns duplex-link $n(139) $n(191) 1.5Mb 680ms DropTail
$ns duplex-link $n(139) $n(190) 1.5Mb 390ms DropTail
$ns duplex-link $n(139) $n(189) 1.5Mb 320ms DropTail
$ns duplex-link $n(139) $n(184) 1.5Mb 400ms DropTail
$ns duplex-link $n(139) $n(182) 1.5Mb 650ms DropTail
$ns duplex-link $n(139) $n(173) 1.5Mb 240ms DropTail
$ns duplex-link $n(139) $n(171) 1.5Mb 700ms DropTail
$ns duplex-link $n(139) $n(169) 1.5Mb 700ms DropTail
$ns duplex-link $n(139) $n(168) 1.5Mb 580ms DropTail
if {$verbose} { puts -nonewline "3590..."; flush stdout }
$ns duplex-link $n(139) $n(165) 1.5Mb 780ms DropTail
$ns duplex-link $n(139) $n(160) 1.5Mb 520ms DropTail
$ns duplex-link $n(139) $n(158) 1.5Mb 660ms DropTail
$ns duplex-link $n(139) $n(157) 1.5Mb 510ms DropTail
$ns duplex-link $n(139) $n(156) 1.5Mb 440ms DropTail
$ns duplex-link $n(139) $n(155) 1.5Mb 340ms DropTail
$ns duplex-link $n(139) $n(151) 1.5Mb 210ms DropTail
$ns duplex-link $n(140) $n(196) 1.5Mb 600ms DropTail
$ns duplex-link $n(140) $n(194) 1.5Mb 480ms DropTail
$ns duplex-link $n(140) $n(182) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "3600..."; flush stdout }
$ns duplex-link $n(140) $n(178) 1.5Mb 370ms DropTail
$ns duplex-link $n(140) $n(177) 1.5Mb 110ms DropTail
$ns duplex-link $n(140) $n(176) 1.5Mb 510ms DropTail
$ns duplex-link $n(140) $n(174) 1.5Mb 700ms DropTail
$ns duplex-link $n(140) $n(171) 1.5Mb 870ms DropTail
$ns duplex-link $n(140) $n(167) 1.5Mb 170ms DropTail
$ns duplex-link $n(140) $n(161) 1.5Mb 870ms DropTail
$ns duplex-link $n(140) $n(154) 1.5Mb 180ms DropTail
$ns duplex-link $n(140) $n(153) 1.5Mb 330ms DropTail
$ns duplex-link $n(140) $n(149) 1.5Mb 750ms DropTail
if {$verbose} { puts -nonewline "3610..."; flush stdout }
$ns duplex-link $n(140) $n(142) 1.5Mb 830ms DropTail
$ns duplex-link $n(140) $n(141) 1.5Mb 830ms DropTail
$ns duplex-link $n(141) $n(192) 1.5Mb 170ms DropTail
$ns duplex-link $n(141) $n(174) 1.5Mb 580ms DropTail
$ns duplex-link $n(141) $n(172) 1.5Mb 740ms DropTail
$ns duplex-link $n(141) $n(168) 1.5Mb 30ms DropTail
$ns duplex-link $n(141) $n(167) 1.5Mb 940ms DropTail
$ns duplex-link $n(141) $n(163) 1.5Mb 510ms DropTail
$ns duplex-link $n(141) $n(158) 1.5Mb 130ms DropTail
$ns duplex-link $n(141) $n(150) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "3620..."; flush stdout }
$ns duplex-link $n(141) $n(147) 1.5Mb 530ms DropTail
$ns duplex-link $n(142) $n(194) 1.5Mb 650ms DropTail
$ns duplex-link $n(142) $n(193) 1.5Mb 1020ms DropTail
$ns duplex-link $n(142) $n(188) 1.5Mb 590ms DropTail
$ns duplex-link $n(142) $n(184) 1.5Mb 190ms DropTail
$ns duplex-link $n(142) $n(181) 1.5Mb 800ms DropTail
$ns duplex-link $n(142) $n(180) 1.5Mb 620ms DropTail
$ns duplex-link $n(142) $n(178) 1.5Mb 470ms DropTail
$ns duplex-link $n(142) $n(175) 1.5Mb 230ms DropTail
$ns duplex-link $n(142) $n(162) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "3630..."; flush stdout }
$ns duplex-link $n(142) $n(158) 1.5Mb 320ms DropTail
$ns duplex-link $n(142) $n(156) 1.5Mb 240ms DropTail
$ns duplex-link $n(142) $n(155) 1.5Mb 260ms DropTail
$ns duplex-link $n(142) $n(150) 1.5Mb 930ms DropTail
$ns duplex-link $n(142) $n(147) 1.5Mb 470ms DropTail
$ns duplex-link $n(143) $n(187) 1.5Mb 210ms DropTail
$ns duplex-link $n(143) $n(184) 1.5Mb 660ms DropTail
$ns duplex-link $n(143) $n(181) 1.5Mb 890ms DropTail
$ns duplex-link $n(143) $n(170) 1.5Mb 350ms DropTail
$ns duplex-link $n(143) $n(167) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "3640..."; flush stdout }
$ns duplex-link $n(143) $n(157) 1.5Mb 580ms DropTail
$ns duplex-link $n(143) $n(155) 1.5Mb 610ms DropTail
$ns duplex-link $n(143) $n(150) 1.5Mb 620ms DropTail
$ns duplex-link $n(143) $n(147) 1.5Mb 670ms DropTail
$ns duplex-link $n(143) $n(144) 1.5Mb 90ms DropTail
$ns duplex-link $n(144) $n(191) 1.5Mb 120ms DropTail
$ns duplex-link $n(144) $n(190) 1.5Mb 1000ms DropTail
$ns duplex-link $n(144) $n(189) 1.5Mb 780ms DropTail
$ns duplex-link $n(144) $n(186) 1.5Mb 770ms DropTail
$ns duplex-link $n(144) $n(185) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "3650..."; flush stdout }
$ns duplex-link $n(144) $n(180) 1.5Mb 960ms DropTail
$ns duplex-link $n(144) $n(174) 1.5Mb 980ms DropTail
$ns duplex-link $n(144) $n(164) 1.5Mb 160ms DropTail
$ns duplex-link $n(144) $n(160) 1.5Mb 370ms DropTail
$ns duplex-link $n(144) $n(157) 1.5Mb 560ms DropTail
$ns duplex-link $n(144) $n(150) 1.5Mb 690ms DropTail
$ns duplex-link $n(144) $n(148) 1.5Mb 570ms DropTail
$ns duplex-link $n(144) $n(147) 1.5Mb 700ms DropTail
$ns duplex-link $n(144) $n(145) 1.5Mb 200ms DropTail
$ns duplex-link $n(145) $n(192) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "3660..."; flush stdout }
$ns duplex-link $n(145) $n(185) 1.5Mb 680ms DropTail
$ns duplex-link $n(145) $n(179) 1.5Mb 220ms DropTail
$ns duplex-link $n(145) $n(176) 1.5Mb 580ms DropTail
$ns duplex-link $n(145) $n(174) 1.5Mb 860ms DropTail
$ns duplex-link $n(145) $n(173) 1.5Mb 660ms DropTail
$ns duplex-link $n(145) $n(171) 1.5Mb 430ms DropTail
$ns duplex-link $n(145) $n(163) 1.5Mb 490ms DropTail
$ns duplex-link $n(145) $n(159) 1.5Mb 40ms DropTail
$ns duplex-link $n(145) $n(155) 1.5Mb 460ms DropTail
$ns duplex-link $n(145) $n(154) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "3670..."; flush stdout }
$ns duplex-link $n(145) $n(153) 1.5Mb 880ms DropTail
$ns duplex-link $n(145) $n(150) 1.5Mb 750ms DropTail
$ns duplex-link $n(146) $n(197) 1.5Mb 450ms DropTail
$ns duplex-link $n(146) $n(196) 1.5Mb 380ms DropTail
$ns duplex-link $n(146) $n(194) 1.5Mb 660ms DropTail
$ns duplex-link $n(146) $n(191) 1.5Mb 480ms DropTail
$ns duplex-link $n(146) $n(190) 1.5Mb 580ms DropTail
$ns duplex-link $n(146) $n(189) 1.5Mb 700ms DropTail
$ns duplex-link $n(146) $n(185) 1.5Mb 520ms DropTail
$ns duplex-link $n(146) $n(180) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "3680..."; flush stdout }
$ns duplex-link $n(146) $n(179) 1.5Mb 460ms DropTail
$ns duplex-link $n(146) $n(172) 1.5Mb 660ms DropTail
$ns duplex-link $n(146) $n(168) 1.5Mb 270ms DropTail
$ns duplex-link $n(146) $n(163) 1.5Mb 320ms DropTail
$ns duplex-link $n(146) $n(162) 1.5Mb 50ms DropTail
$ns duplex-link $n(146) $n(161) 1.5Mb 280ms DropTail
$ns duplex-link $n(146) $n(156) 1.5Mb 130ms DropTail
$ns duplex-link $n(146) $n(155) 1.5Mb 170ms DropTail
$ns duplex-link $n(146) $n(150) 1.5Mb 720ms DropTail
$ns duplex-link $n(146) $n(148) 1.5Mb 180ms DropTail
if {$verbose} { puts -nonewline "3690..."; flush stdout }
$ns duplex-link $n(147) $n(198) 1.5Mb 440ms DropTail
$ns duplex-link $n(147) $n(197) 1.5Mb 650ms DropTail
$ns duplex-link $n(147) $n(196) 1.5Mb 190ms DropTail
$ns duplex-link $n(147) $n(172) 1.5Mb 260ms DropTail
$ns duplex-link $n(147) $n(166) 1.5Mb 750ms DropTail
$ns duplex-link $n(147) $n(162) 1.5Mb 350ms DropTail
$ns duplex-link $n(147) $n(157) 1.5Mb 450ms DropTail
$ns duplex-link $n(147) $n(152) 1.5Mb 230ms DropTail
$ns duplex-link $n(147) $n(150) 1.5Mb 490ms DropTail
$ns duplex-link $n(148) $n(186) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "3700..."; flush stdout }
$ns duplex-link $n(148) $n(182) 1.5Mb 480ms DropTail
$ns duplex-link $n(148) $n(181) 1.5Mb 590ms DropTail
$ns duplex-link $n(148) $n(178) 1.5Mb 150ms DropTail
$ns duplex-link $n(148) $n(173) 1.5Mb 430ms DropTail
$ns duplex-link $n(148) $n(172) 1.5Mb 480ms DropTail
$ns duplex-link $n(148) $n(162) 1.5Mb 130ms DropTail
$ns duplex-link $n(148) $n(160) 1.5Mb 250ms DropTail
$ns duplex-link $n(148) $n(159) 1.5Mb 450ms DropTail
$ns duplex-link $n(149) $n(198) 1.5Mb 280ms DropTail
$ns duplex-link $n(149) $n(194) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "3710..."; flush stdout }
$ns duplex-link $n(149) $n(193) 1.5Mb 1080ms DropTail
$ns duplex-link $n(149) $n(189) 1.5Mb 690ms DropTail
$ns duplex-link $n(149) $n(183) 1.5Mb 180ms DropTail
$ns duplex-link $n(149) $n(177) 1.5Mb 760ms DropTail
$ns duplex-link $n(149) $n(176) 1.5Mb 260ms DropTail
$ns duplex-link $n(149) $n(174) 1.5Mb 160ms DropTail
$ns duplex-link $n(149) $n(167) 1.5Mb 910ms DropTail
$ns duplex-link $n(149) $n(162) 1.5Mb 470ms DropTail
$ns duplex-link $n(149) $n(156) 1.5Mb 380ms DropTail
$ns duplex-link $n(149) $n(152) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "3720..."; flush stdout }
$ns duplex-link $n(149) $n(151) 1.5Mb 560ms DropTail
$ns duplex-link $n(150) $n(199) 1.5Mb 700ms DropTail
$ns duplex-link $n(150) $n(197) 1.5Mb 630ms DropTail
$ns duplex-link $n(150) $n(189) 1.5Mb 180ms DropTail
$ns duplex-link $n(150) $n(188) 1.5Mb 470ms DropTail
$ns duplex-link $n(150) $n(187) 1.5Mb 460ms DropTail
$ns duplex-link $n(150) $n(184) 1.5Mb 760ms DropTail
$ns duplex-link $n(150) $n(180) 1.5Mb 560ms DropTail
$ns duplex-link $n(150) $n(176) 1.5Mb 600ms DropTail
$ns duplex-link $n(150) $n(170) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "3730..."; flush stdout }
$ns duplex-link $n(150) $n(168) 1.5Mb 940ms DropTail
$ns duplex-link $n(150) $n(166) 1.5Mb 720ms DropTail
$ns duplex-link $n(150) $n(152) 1.5Mb 370ms DropTail
$ns duplex-link $n(151) $n(197) 1.5Mb 550ms DropTail
$ns duplex-link $n(151) $n(194) 1.5Mb 330ms DropTail
$ns duplex-link $n(151) $n(184) 1.5Mb 490ms DropTail
$ns duplex-link $n(151) $n(178) 1.5Mb 210ms DropTail
$ns duplex-link $n(151) $n(177) 1.5Mb 220ms DropTail
$ns duplex-link $n(151) $n(176) 1.5Mb 320ms DropTail
$ns duplex-link $n(151) $n(174) 1.5Mb 510ms DropTail
if {$verbose} { puts -nonewline "3740..."; flush stdout }
$ns duplex-link $n(151) $n(169) 1.5Mb 680ms DropTail
$ns duplex-link $n(151) $n(167) 1.5Mb 360ms DropTail
$ns duplex-link $n(151) $n(166) 1.5Mb 640ms DropTail
$ns duplex-link $n(151) $n(163) 1.5Mb 170ms DropTail
$ns duplex-link $n(151) $n(162) 1.5Mb 430ms DropTail
$ns duplex-link $n(151) $n(156) 1.5Mb 510ms DropTail
$ns duplex-link $n(151) $n(152) 1.5Mb 130ms DropTail
$ns duplex-link $n(152) $n(175) 1.5Mb 450ms DropTail
$ns duplex-link $n(152) $n(171) 1.5Mb 630ms DropTail
$ns duplex-link $n(152) $n(166) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "3750..."; flush stdout }
$ns duplex-link $n(152) $n(164) 1.5Mb 360ms DropTail
$ns duplex-link $n(152) $n(157) 1.5Mb 450ms DropTail
$ns duplex-link $n(152) $n(156) 1.5Mb 410ms DropTail
$ns duplex-link $n(152) $n(154) 1.5Mb 270ms DropTail
$ns duplex-link $n(153) $n(186) 1.5Mb 720ms DropTail
$ns duplex-link $n(153) $n(185) 1.5Mb 260ms DropTail
$ns duplex-link $n(153) $n(184) 1.5Mb 740ms DropTail
$ns duplex-link $n(153) $n(180) 1.5Mb 340ms DropTail
$ns duplex-link $n(153) $n(178) 1.5Mb 480ms DropTail
$ns duplex-link $n(153) $n(176) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "3760..."; flush stdout }
$ns duplex-link $n(153) $n(167) 1.5Mb 480ms DropTail
$ns duplex-link $n(153) $n(159) 1.5Mb 880ms DropTail
$ns duplex-link $n(153) $n(157) 1.5Mb 830ms DropTail
$ns duplex-link $n(154) $n(193) 1.5Mb 380ms DropTail
$ns duplex-link $n(154) $n(192) 1.5Mb 800ms DropTail
$ns duplex-link $n(154) $n(188) 1.5Mb 570ms DropTail
$ns duplex-link $n(154) $n(185) 1.5Mb 440ms DropTail
$ns duplex-link $n(154) $n(184) 1.5Mb 650ms DropTail
$ns duplex-link $n(154) $n(175) 1.5Mb 720ms DropTail
$ns duplex-link $n(154) $n(172) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "3770..."; flush stdout }
$ns duplex-link $n(154) $n(170) 1.5Mb 460ms DropTail
$ns duplex-link $n(154) $n(166) 1.5Mb 420ms DropTail
$ns duplex-link $n(154) $n(163) 1.5Mb 390ms DropTail
$ns duplex-link $n(154) $n(158) 1.5Mb 770ms DropTail
$ns duplex-link $n(154) $n(157) 1.5Mb 650ms DropTail
$ns duplex-link $n(155) $n(197) 1.5Mb 580ms DropTail
$ns duplex-link $n(155) $n(196) 1.5Mb 210ms DropTail
$ns duplex-link $n(155) $n(185) 1.5Mb 410ms DropTail
$ns duplex-link $n(155) $n(184) 1.5Mb 70ms DropTail
$ns duplex-link $n(155) $n(182) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "3780..."; flush stdout }
$ns duplex-link $n(155) $n(174) 1.5Mb 420ms DropTail
$ns duplex-link $n(155) $n(173) 1.5Mb 500ms DropTail
$ns duplex-link $n(155) $n(167) 1.5Mb 710ms DropTail
$ns duplex-link $n(155) $n(166) 1.5Mb 660ms DropTail
$ns duplex-link $n(155) $n(165) 1.5Mb 440ms DropTail
$ns duplex-link $n(155) $n(162) 1.5Mb 140ms DropTail
$ns duplex-link $n(155) $n(156) 1.5Mb 100ms DropTail
$ns duplex-link $n(156) $n(197) 1.5Mb 570ms DropTail
$ns duplex-link $n(156) $n(194) 1.5Mb 620ms DropTail
$ns duplex-link $n(156) $n(193) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "3790..."; flush stdout }
$ns duplex-link $n(156) $n(192) 1.5Mb 270ms DropTail
$ns duplex-link $n(156) $n(185) 1.5Mb 510ms DropTail
$ns duplex-link $n(156) $n(181) 1.5Mb 740ms DropTail
$ns duplex-link $n(156) $n(179) 1.5Mb 590ms DropTail
$ns duplex-link $n(156) $n(174) 1.5Mb 500ms DropTail
$ns duplex-link $n(156) $n(172) 1.5Mb 600ms DropTail
$ns duplex-link $n(156) $n(161) 1.5Mb 220ms DropTail
$ns duplex-link $n(157) $n(193) 1.5Mb 760ms DropTail
$ns duplex-link $n(157) $n(191) 1.5Mb 590ms DropTail
$ns duplex-link $n(157) $n(190) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "3800..."; flush stdout }
$ns duplex-link $n(157) $n(183) 1.5Mb 310ms DropTail
$ns duplex-link $n(157) $n(179) 1.5Mb 560ms DropTail
$ns duplex-link $n(157) $n(170) 1.5Mb 240ms DropTail
$ns duplex-link $n(157) $n(169) 1.5Mb 240ms DropTail
$ns duplex-link $n(157) $n(167) 1.5Mb 790ms DropTail
$ns duplex-link $n(158) $n(194) 1.5Mb 830ms DropTail
$ns duplex-link $n(158) $n(191) 1.5Mb 660ms DropTail
$ns duplex-link $n(158) $n(184) 1.5Mb 270ms DropTail
$ns duplex-link $n(158) $n(180) 1.5Mb 830ms DropTail
$ns duplex-link $n(158) $n(178) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "3810..."; flush stdout }
$ns duplex-link $n(158) $n(176) 1.5Mb 490ms DropTail
$ns duplex-link $n(158) $n(164) 1.5Mb 630ms DropTail
$ns duplex-link $n(158) $n(163) 1.5Mb 530ms DropTail
$ns duplex-link $n(158) $n(161) 1.5Mb 80ms DropTail
$ns duplex-link $n(159) $n(197) 1.5Mb 180ms DropTail
$ns duplex-link $n(159) $n(195) 1.5Mb 240ms DropTail
$ns duplex-link $n(159) $n(183) 1.5Mb 700ms DropTail
$ns duplex-link $n(159) $n(181) 1.5Mb 920ms DropTail
$ns duplex-link $n(159) $n(175) 1.5Mb 700ms DropTail
$ns duplex-link $n(159) $n(161) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "3820..."; flush stdout }
$ns duplex-link $n(160) $n(199) 1.5Mb 530ms DropTail
$ns duplex-link $n(160) $n(196) 1.5Mb 460ms DropTail
$ns duplex-link $n(160) $n(193) 1.5Mb 570ms DropTail
$ns duplex-link $n(160) $n(183) 1.5Mb 470ms DropTail
$ns duplex-link $n(160) $n(178) 1.5Mb 320ms DropTail
$ns duplex-link $n(160) $n(173) 1.5Mb 580ms DropTail
$ns duplex-link $n(160) $n(170) 1.5Mb 50ms DropTail
$ns duplex-link $n(161) $n(199) 1.5Mb 840ms DropTail
$ns duplex-link $n(161) $n(192) 1.5Mb 100ms DropTail
$ns duplex-link $n(161) $n(191) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "3830..."; flush stdout }
$ns duplex-link $n(161) $n(190) 1.5Mb 590ms DropTail
$ns duplex-link $n(161) $n(188) 1.5Mb 750ms DropTail
$ns duplex-link $n(161) $n(182) 1.5Mb 620ms DropTail
$ns duplex-link $n(161) $n(176) 1.5Mb 480ms DropTail
$ns duplex-link $n(161) $n(171) 1.5Mb 80ms DropTail
$ns duplex-link $n(161) $n(168) 1.5Mb 100ms DropTail
$ns duplex-link $n(161) $n(164) 1.5Mb 690ms DropTail
$ns duplex-link $n(162) $n(196) 1.5Mb 340ms DropTail
$ns duplex-link $n(162) $n(189) 1.5Mb 640ms DropTail
$ns duplex-link $n(162) $n(188) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "3840..."; flush stdout }
$ns duplex-link $n(162) $n(167) 1.5Mb 650ms DropTail
$ns duplex-link $n(162) $n(166) 1.5Mb 530ms DropTail
$ns duplex-link $n(163) $n(194) 1.5Mb 360ms DropTail
$ns duplex-link $n(163) $n(189) 1.5Mb 380ms DropTail
$ns duplex-link $n(163) $n(186) 1.5Mb 350ms DropTail
$ns duplex-link $n(163) $n(185) 1.5Mb 200ms DropTail
$ns duplex-link $n(163) $n(175) 1.5Mb 330ms DropTail
$ns duplex-link $n(163) $n(173) 1.5Mb 260ms DropTail
$ns duplex-link $n(163) $n(170) 1.5Mb 360ms DropTail
$ns duplex-link $n(163) $n(167) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "3850..."; flush stdout }
$ns duplex-link $n(163) $n(166) 1.5Mb 620ms DropTail
$ns duplex-link $n(164) $n(196) 1.5Mb 690ms DropTail
$ns duplex-link $n(164) $n(192) 1.5Mb 650ms DropTail
$ns duplex-link $n(164) $n(191) 1.5Mb 70ms DropTail
$ns duplex-link $n(164) $n(189) 1.5Mb 620ms DropTail
$ns duplex-link $n(164) $n(187) 1.5Mb 120ms DropTail
$ns duplex-link $n(164) $n(183) 1.5Mb 780ms DropTail
$ns duplex-link $n(164) $n(177) 1.5Mb 520ms DropTail
$ns duplex-link $n(164) $n(176) 1.5Mb 600ms DropTail
$ns duplex-link $n(164) $n(175) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "3860..."; flush stdout }
$ns duplex-link $n(164) $n(174) 1.5Mb 870ms DropTail
$ns duplex-link $n(164) $n(171) 1.5Mb 660ms DropTail
$ns duplex-link $n(164) $n(166) 1.5Mb 190ms DropTail
$ns duplex-link $n(165) $n(197) 1.5Mb 770ms DropTail
$ns duplex-link $n(165) $n(195) 1.5Mb 830ms DropTail
$ns duplex-link $n(165) $n(187) 1.5Mb 760ms DropTail
$ns duplex-link $n(165) $n(178) 1.5Mb 640ms DropTail
$ns duplex-link $n(165) $n(174) 1.5Mb 760ms DropTail
$ns duplex-link $n(165) $n(167) 1.5Mb 1080ms DropTail
$ns duplex-link $n(166) $n(195) 1.5Mb 100ms DropTail
if {$verbose} { puts -nonewline "3870..."; flush stdout }
$ns duplex-link $n(166) $n(194) 1.5Mb 960ms DropTail
$ns duplex-link $n(166) $n(185) 1.5Mb 770ms DropTail
$ns duplex-link $n(166) $n(171) 1.5Mb 680ms DropTail
$ns duplex-link $n(166) $n(168) 1.5Mb 770ms DropTail
$ns duplex-link $n(167) $n(197) 1.5Mb 470ms DropTail
$ns duplex-link $n(167) $n(194) 1.5Mb 650ms DropTail
$ns duplex-link $n(167) $n(189) 1.5Mb 380ms DropTail
$ns duplex-link $n(167) $n(188) 1.5Mb 620ms DropTail
$ns duplex-link $n(167) $n(175) 1.5Mb 820ms DropTail
$ns duplex-link $n(167) $n(173) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "3880..."; flush stdout }
$ns duplex-link $n(168) $n(197) 1.5Mb 710ms DropTail
$ns duplex-link $n(168) $n(196) 1.5Mb 380ms DropTail
$ns duplex-link $n(168) $n(193) 1.5Mb 920ms DropTail
$ns duplex-link $n(168) $n(188) 1.5Mb 670ms DropTail
$ns duplex-link $n(168) $n(186) 1.5Mb 250ms DropTail
$ns duplex-link $n(168) $n(180) 1.5Mb 720ms DropTail
$ns duplex-link $n(168) $n(179) 1.5Mb 720ms DropTail
$ns duplex-link $n(168) $n(178) 1.5Mb 470ms DropTail
$ns duplex-link $n(168) $n(177) 1.5Mb 890ms DropTail
$ns duplex-link $n(168) $n(176) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "3890..."; flush stdout }
$ns duplex-link $n(168) $n(170) 1.5Mb 400ms DropTail
$ns duplex-link $n(169) $n(191) 1.5Mb 490ms DropTail
$ns duplex-link $n(169) $n(188) 1.5Mb 810ms DropTail
$ns duplex-link $n(169) $n(187) 1.5Mb 470ms DropTail
$ns duplex-link $n(169) $n(186) 1.5Mb 520ms DropTail
$ns duplex-link $n(169) $n(184) 1.5Mb 390ms DropTail
$ns duplex-link $n(169) $n(181) 1.5Mb 980ms DropTail
$ns duplex-link $n(169) $n(180) 1.5Mb 900ms DropTail
$ns duplex-link $n(169) $n(177) 1.5Mb 860ms DropTail
$ns duplex-link $n(169) $n(171) 1.5Mb 220ms DropTail
if {$verbose} { puts -nonewline "3900..."; flush stdout }
$ns duplex-link $n(169) $n(170) 1.5Mb 210ms DropTail
$ns duplex-link $n(170) $n(199) 1.5Mb 480ms DropTail
$ns duplex-link $n(170) $n(197) 1.5Mb 310ms DropTail
$ns duplex-link $n(170) $n(192) 1.5Mb 350ms DropTail
$ns duplex-link $n(170) $n(190) 1.5Mb 700ms DropTail
$ns duplex-link $n(170) $n(188) 1.5Mb 640ms DropTail
$ns duplex-link $n(170) $n(182) 1.5Mb 250ms DropTail
$ns duplex-link $n(170) $n(180) 1.5Mb 750ms DropTail
$ns duplex-link $n(170) $n(178) 1.5Mb 320ms DropTail
$ns duplex-link $n(170) $n(176) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "3910..."; flush stdout }
$ns duplex-link $n(170) $n(175) 1.5Mb 510ms DropTail
$ns duplex-link $n(170) $n(173) 1.5Mb 560ms DropTail
$ns duplex-link $n(171) $n(195) 1.5Mb 700ms DropTail
$ns duplex-link $n(171) $n(188) 1.5Mb 790ms DropTail
$ns duplex-link $n(171) $n(186) 1.5Mb 410ms DropTail
$ns duplex-link $n(171) $n(175) 1.5Mb 500ms DropTail
$ns duplex-link $n(171) $n(172) 1.5Mb 850ms DropTail
$ns duplex-link $n(172) $n(198) 1.5Mb 270ms DropTail
$ns duplex-link $n(172) $n(197) 1.5Mb 900ms DropTail
$ns duplex-link $n(172) $n(188) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "3920..."; flush stdout }
$ns duplex-link $n(172) $n(183) 1.5Mb 520ms DropTail
$ns duplex-link $n(172) $n(181) 1.5Mb 230ms DropTail
$ns duplex-link $n(172) $n(178) 1.5Mb 420ms DropTail
$ns duplex-link $n(172) $n(177) 1.5Mb 510ms DropTail
$ns duplex-link $n(173) $n(199) 1.5Mb 720ms DropTail
$ns duplex-link $n(173) $n(195) 1.5Mb 610ms DropTail
$ns duplex-link $n(173) $n(192) 1.5Mb 840ms DropTail
$ns duplex-link $n(173) $n(187) 1.5Mb 400ms DropTail
$ns duplex-link $n(173) $n(186) 1.5Mb 590ms DropTail
$ns duplex-link $n(173) $n(182) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "3930..."; flush stdout }
$ns duplex-link $n(174) $n(197) 1.5Mb 940ms DropTail
$ns duplex-link $n(174) $n(195) 1.5Mb 970ms DropTail
$ns duplex-link $n(174) $n(192) 1.5Mb 740ms DropTail
$ns duplex-link $n(174) $n(183) 1.5Mb 340ms DropTail
$ns duplex-link $n(174) $n(182) 1.5Mb 890ms DropTail
$ns duplex-link $n(174) $n(181) 1.5Mb 460ms DropTail
$ns duplex-link $n(175) $n(186) 1.5Mb 90ms DropTail
$ns duplex-link $n(175) $n(182) 1.5Mb 730ms DropTail
$ns duplex-link $n(175) $n(181) 1.5Mb 570ms DropTail
$ns duplex-link $n(175) $n(177) 1.5Mb 690ms DropTail
if {$verbose} { puts -nonewline "3940..."; flush stdout }
$ns duplex-link $n(176) $n(189) 1.5Mb 490ms DropTail
$ns duplex-link $n(176) $n(188) 1.5Mb 270ms DropTail
$ns duplex-link $n(176) $n(186) 1.5Mb 200ms DropTail
$ns duplex-link $n(176) $n(182) 1.5Mb 610ms DropTail
$ns duplex-link $n(176) $n(180) 1.5Mb 350ms DropTail
$ns duplex-link $n(177) $n(197) 1.5Mb 620ms DropTail
$ns duplex-link $n(177) $n(194) 1.5Mb 430ms DropTail
$ns duplex-link $n(177) $n(192) 1.5Mb 960ms DropTail
$ns duplex-link $n(177) $n(187) 1.5Mb 440ms DropTail
$ns duplex-link $n(177) $n(184) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "3950..."; flush stdout }
$ns duplex-link $n(177) $n(183) 1.5Mb 810ms DropTail
$ns duplex-link $n(177) $n(179) 1.5Mb 630ms DropTail
$ns duplex-link $n(177) $n(178) 1.5Mb 420ms DropTail
$ns duplex-link $n(178) $n(197) 1.5Mb 490ms DropTail
$ns duplex-link $n(178) $n(191) 1.5Mb 500ms DropTail
$ns duplex-link $n(179) $n(196) 1.5Mb 760ms DropTail
$ns duplex-link $n(179) $n(183) 1.5Mb 820ms DropTail
$ns duplex-link $n(179) $n(181) 1.5Mb 900ms DropTail
$ns duplex-link $n(180) $n(188) 1.5Mb 120ms DropTail
$ns duplex-link $n(181) $n(195) 1.5Mb 890ms DropTail
if {$verbose} { puts -nonewline "3960..."; flush stdout }
$ns duplex-link $n(181) $n(194) 1.5Mb 160ms DropTail
$ns duplex-link $n(181) $n(193) 1.5Mb 980ms DropTail
$ns duplex-link $n(181) $n(192) 1.5Mb 1010ms DropTail
$ns duplex-link $n(181) $n(190) 1.5Mb 570ms DropTail
$ns duplex-link $n(182) $n(190) 1.5Mb 910ms DropTail
$ns duplex-link $n(182) $n(188) 1.5Mb 760ms DropTail
$ns duplex-link $n(182) $n(187) 1.5Mb 190ms DropTail
$ns duplex-link $n(182) $n(186) 1.5Mb 690ms DropTail
$ns duplex-link $n(183) $n(199) 1.5Mb 980ms DropTail
$ns duplex-link $n(183) $n(198) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "3970..."; flush stdout }
$ns duplex-link $n(183) $n(192) 1.5Mb 430ms DropTail
$ns duplex-link $n(184) $n(199) 1.5Mb 800ms DropTail
$ns duplex-link $n(184) $n(191) 1.5Mb 660ms DropTail
$ns duplex-link $n(185) $n(199) 1.5Mb 810ms DropTail
$ns duplex-link $n(185) $n(198) 1.5Mb 490ms DropTail
$ns duplex-link $n(185) $n(197) 1.5Mb 670ms DropTail
$ns duplex-link $n(185) $n(195) 1.5Mb 680ms DropTail
$ns duplex-link $n(185) $n(192) 1.5Mb 770ms DropTail
$ns duplex-link $n(185) $n(190) 1.5Mb 480ms DropTail
$ns duplex-link $n(186) $n(199) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "3980..."; flush stdout }
$ns duplex-link $n(186) $n(190) 1.5Mb 260ms DropTail
$ns duplex-link $n(187) $n(196) 1.5Mb 580ms DropTail
$ns duplex-link $n(187) $n(193) 1.5Mb 350ms DropTail
$ns duplex-link $n(188) $n(189) 1.5Mb 310ms DropTail
$ns duplex-link $n(189) $n(192) 1.5Mb 970ms DropTail
$ns duplex-link $n(190) $n(198) 1.5Mb 200ms DropTail
$ns duplex-link $n(190) $n(197) 1.5Mb 960ms DropTail
$ns duplex-link $n(193) $n(199) 1.5Mb 80ms DropTail
$ns duplex-link $n(193) $n(197) 1.5Mb 210ms DropTail
$ns duplex-link $n(193) $n(196) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "3990..."; flush stdout }
$ns duplex-link $n(194) $n(196) 1.5Mb 360ms DropTail
$ns duplex-link $n(195) $n(197) 1.5Mb 60ms DropTail
$ns duplex-link $n(198) $n(199) 1.5Mb 1240ms DropTail
if {$verbose} { puts ""}

set mproto CtrMcast
set mrthandle [$ns mrtproto $mproto {}]
$ns at 0 "$mrthandle switch-treetype $g"

if {$verbose} {puts "starting"}
set rcvr18 [new Agent/Null]
$ns attach-agent $n(18) $rcvr18
$ns at 1 "$n(18) join-group $rcvr18 $g"
set rcvr187 [new Agent/Null]
$ns attach-agent $n(187) $rcvr187
$ns at 2 "$n(187) join-group $rcvr187 $g"
set rcvr91 [new Agent/Null]
$ns attach-agent $n(91) $rcvr91
$ns at 3 "$n(91) join-group $rcvr91 $g"
set rcvr23 [new Agent/Null]
$ns attach-agent $n(23) $rcvr23
$ns at 4 "$n(23) join-group $rcvr23 $g"
set rcvr117 [new Agent/Null]
$ns attach-agent $n(117) $rcvr117
$ns at 5 "$n(117) join-group $rcvr117 $g"
set rcvr165 [new Agent/Null]
$ns attach-agent $n(165) $rcvr165
$ns at 6 "$n(165) join-group $rcvr165 $g"
set rcvr114 [new Agent/Null]
$ns attach-agent $n(114) $rcvr114
$ns at 7 "$n(114) join-group $rcvr114 $g"
set rcvr197 [new Agent/Null]
$ns attach-agent $n(197) $rcvr197
$ns at 8 "$n(197) join-group $rcvr197 $g"
set rcvr119 [new Agent/Null]
$ns attach-agent $n(119) $rcvr119
$ns at 9 "$n(119) join-group $rcvr119 $g"
set rcvr166 [new Agent/Null]
$ns attach-agent $n(166) $rcvr166
$ns at 10 "$n(166) join-group $rcvr166 $g"

set sender [new Agent/CBR]
$sender set dst_ $g
$sender set class_ 2
$ns attach-agent $n(2) $sender

$ns at 0 "$sender start"

# START ns
$ns at 10.99 "[$ns clearMemTrace]"
$ns at 11 "exit 0"
$ns run

