# Maintained by: Polly Huang Tue Feb  2 14:34:54 PST 1999
# Creating 3 multicast sessions over a partial mbone topology (1996)

source shuttle.tcl
set mcastConnection 3

set ns [new Simulator]
$ns multicast

# set colors for nam
for {set i 0} {$i < 10} {incr i} {
    set color [expr $i % 6]
    if {$color == 0} {
        $ns color $i blue
    } elseif {$color == 1} {
        $ns color $i red
    } elseif {$color == 2} {
        $ns color $i green
    } elseif {$color == 3} {
        $ns color $i yellow
    } elseif {$color == 4} {
        $ns color $i brown
    } elseif {$color == 5} {
        $ns color $i black
    }
}

# config output files
set f [open shuttle-mcast.out w]
$ns trace-all $f
set nf [open shuttle-mcast.nam w]
$ns namtrace-all $nf

# creating mbone shuttle session topology 
# generated from 1996 trace
puts "This simulation will take a long time..."
Node expandaddr
create-topology

# mcast config
set mproto CtrMcast
set mrthandle [$ns mrtproto $mproto {}]

# create mcast sessions
for {set i 0} {$i < $mcastConnection} {incr i} {
    # groups config
    set g($i) [expr [Node allocaddr]]
    if {$mrthandle != ""} {
	$ns at 0.01 "$mrthandle switch-treetype $g($i)"
    }    

    # source config
    set udp($i) [new Agent/UDP]
    $ns attach-agent $n($i) $udp($i)
    set cbr($i) [new Application/Traffic/CBR]
    $cbr($i) attach-agent $udp($i)
    $udp($i) set dst_ $g($i)
    $udp($i) set fid_ $i
    $ns at [expr $i + 1] "$cbr($i) start"

    # member config
    set member1 [expr [expr $num_node - $i] - 1]
    set member2 [expr [expr $num_node / 2 ] - $i]
    set rcvr($i:$member1) [new Agent/Null]
    set rcvr($i:$member2) [new Agent/Null]
    $ns attach-agent $n($member1) $rcvr($i:$member1)
    $ns attach-agent $n($member2) $rcvr($i:$member2)
    $ns at 0.5 "$n($member1) join-group  $rcvr($i:$member1) $g($i)"
    $ns at 0.5 "$n($member2) join-group  $rcvr($i:$member2) $g($i)"
}

proc finish {} {
    global ns f nf
    $ns flush-trace
    close $f
    close $nf

    exec nam shuttle-mcast.nam
    exit
}

$ns at 13.0 "finish"
$ns run
