%define name    normalize
%define version 0.7.3
%define release 1
%define prefix  /usr

Summary: A tool for adjusting the volume of audio files to a standard level.
Name:    %{name}
Version: %{version}
Release: %{release}
Prefix:  %{prefix}
Copyright: GPL
Group: Applications/Sound
Source: http://www.cs.columbia.edu/~cvaill/normalize/normalize-0.7.3.tar.gz
BuildRoot: /var/tmp/%{name}-buildroot

%description
normalize is a tool for adjusting the volume of audio files to a
standard level.  This is useful for things like creating mixed CD's
and mp3 collections, where different recording levels on different
albums can cause the volume to vary greatly from song to song.

%package        xmms
Summary:        Normalize - XMMS plugin to apply volume adjustments
Group:          Applications/Multimedia
Requires:       %{name} = %{version}
Requires:       xmms >= 1.0.0
Requires:       gtk+ >= 1.2.2
BuildPrereq:    xmms-devel
BuildPrereq:    gtk+-devel >= 1.2.2

%description    xmms
Plugin for XMMS to honor volume adjustments (RVA2 frames) in ID3 tags

%prep
%setup

%build
./configure --prefix=%{prefix} --enable-xmms --with-mad --without-audiofile
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
mkdir -p $RPM_BUILD_ROOT
strip -x xmms-rva/.libs/librva.so
make install-strip DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README COPYING
%{prefix}/bin/normalize
%{prefix}/bin/normalize-mp3
%{prefix}/bin/normalize-ogg
%{prefix}/man/man1/normalize.1.gz
%{prefix}/man/man1/normalize-mp3.1.gz
%{prefix}/share/locale/en_GB/LC_MESSAGES/normalize.mo
%{prefix}/share/locale/fr/LC_MESSAGES/normalize.mo

%files xmms
%defattr(-,root,root)
%{prefix}/lib/xmms/Effect/librva.la
%{prefix}/lib/xmms/Effect/librva.so
