.\"
.\" %nmhwarning%
.\" $Id: mhn.man,v 1.2 2000/03/14 02:29:26 danh Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH MHN %manext1% MH.6.8 [%nmhversion%]
.SH NAME
mhn \- display/list/store/cache MIME messages
.SH SYNOPSIS
.in +.5i
.ti -.5i
mhn \%[+folder] \%[msgs] \%[\-file file]
.br
\%[\-part number]... \%[\-type content]...
.br
\%[\-show] \%[\-noshow]
\%[\-list] \%[-nolist]
.br
\%[\-store] \%[\-nostore]
\%[\-cache] \%[\-nocache]
.br
\%[\-headers] \%[\-noheaders]
\%[\-realsize] \%[\-norealsize]
.br
\%[\-serialonly] \%[\-noserialonly]
\%[\-form formfile]
.br
\%[\-pause] \%[\-nopause]
\%[\-auto] \%[\-noauto]
.br
\%[\-rcache policy] \%[\-wcache policy]
\%[\-check] \%[\-nocheck]
.br
\%[\-verbose] \%[\-noverbose]
\%[\-version]
\%[\-help]

.ti .5i
mhn \-build\ file
.br
\%[\-ebcdicsafe] \%[\-noebcdicsafe]
.br
\%[\-rfc934mode] \%[\-norfc934mode]
.in -.5i

.SH DESCRIPTION
MHN SHOULD BE CONSIDERED DEPRECATED.  IT IS RETAINED FOR THE PURPOSE
OF BACKWARD COMPATIBILITY, BUT EVERYONE SHOULD MIGRATE TO USING THE
COMMANDS MHSHOW, MHSTORE, AND MHLIST.  CHECK THE INDIVIDUAL MAN PAGES
FOR DETAILS.

The \fImhn\fR command allows you to display, list, store, or cache the
contents of a MIME (multi-media) messages.

\fImhn\fR manipulates multi-media messages as specified in RFC\-2045
thru RFC\-2049.  Currently \fImhn\fR only supports encodings in message
bodies, and does not support the encoding of message headers as specified
in RFC\-2047.

The switches `\-list', `\-show', `\-store', and `-cache' direct
the operation of \fImhn\fR.  Only one of these switches may be used
at a time.  These switches are used to operate on the content of
each of the named messages.  By using the `\-part' and `\-type'
switches, you may limit the scope of the given operation to particular
subparts (of a multipart content) and/or particular content types.

The switch `\-build' is used to construct a MIME message.  It is
for backward compatibility and instructs \fImhn\fR to execute the
\fImhbuild\fR command.  It is preferred that you use the \fImhbuild\fR
command directly.  See the \fImhbuild\fR(1) man page for details.

The option `\-file\ file' directs \fImhn\fR to use the specified file as
the source message, rather than a message from a folder.  If you specify
this file as \*(lq-\*(rq, then \fImhn\fR will accept the source message
on the standard input.  Note that the file, or input from standard input
should be a validly formatted message, just like any other \fInmh\fR
message.  It should \fBNOT\fR be in mail drop format (to convert a file in
mail drop format to a folder of \fInmh\fR messages, see \fIinc\fR\0(1)).

A part specification consists of a series of numbers separated by dots.
For example, in a multipart content containing three parts, these
would be named as 1, 2, and 3, respectively.  If part 2 was also a
multipart content containing two parts, these would be named as 2.1 and
2.2, respectively.  Note that the `\-part' switch is effective for only
messages containing a multipart content.  If a message has some other
kind of content, or if the part is itself another multipart content, the
`\-part' switch will not prevent the content from being acted upon.

A content specification consists of a content type and a subtype.
The initial list of \*(lqstandard\*(rq content types and subtypes can
be found in RFC\-2046.
.ne 18
A list of commonly used contents is briefly reproduced here:
.sp
.nf
.in +.5i
.ta \w'application  'u
Type	Subtypes
----	--------
text	plain, enriched
multipart	mixed, alternative, digest, parallel
message	rfc822, partial, external-body
application	octet-stream, postscript
image	jpeg, gif, png
audio	basic
video	mpeg
.re
.in -.5i
.fi
.sp
A legal MIME message must contain a subtype specification.
.PP
To specify a content, regardless of its subtype, just use the
name of the content, e.g., \*(lqaudio\*(rq.  To specify a specific
subtype, separate the two with a slash, e.g., \*(lqaudio/basic\*(rq.
Note that regardless of the values given to the `\-type' switch, a
multipart content (of any subtype listed above) is always acted upon.
Further note that if the `\-type' switch is used, and it is desirable to
act on a message/external-body content, then the `\-type' switch must
be used twice: once for message/external-body and once for the content
externally referenced.

.Uh "Checking the Contents"
The `\-check' switch tells \fImhn\fR to check each content for an
integrity checksum.  If a content has such a checksum (specified as a
Content-MD5 header field), then \fImhn\fR will attempt to verify the
integrity of the content.

.Uh "Listing the Contents"
The `\-list' switch tells \fImhn\fR to list the table of contents
associated with the named messages.

The `\-headers' switch indicates that
a one-line banner should be displayed above the listing.  The `\-realsize'
switch tells \fImhn\fR to evaluate the \*(lqnative\*(rq (decoded) format
of each content prior to listing.  This provides an accurate count at
the expense of a small delay.  If the `\-verbose' switch is present, then
the listing will show any \*(lqextra\*(rq information that is present in
the message, such as comments in the Content-Type header.

.Uh "Showing the Contents"
The `\-show' switch tells \fImhn\fR to display the contents of the named
messages.

The headers of each message are displayed with the \fImhlproc\fR
(usually \fImhl\fR), using the standard format file \fImhl.headers\fR.
You may specify an alternate format file with the `\-form formfile'
switch.  If the format file \fImhl.null\fR is specified, then the display
of the message headers is suppressed.

Next, the contents are extracted from the message and are stored in
a temporary file.  Usually, the name of the temporary file the
word "mhn" followed by a string of characters.  Occasionally,
the method used to display a content (described next), requires that
the file end in a specific suffix.  For example, the \fIsoffice\fR
command (part of the StarOffice package) can be used to display
MicroSoft Word content, but it uses the suffix to determine how to display
the file.  If no suffix is present, the file is not correctly loaded.
Similarily, older versions of the \fIgs\fR command append a ".ps" suffix to
the filename if one was missing.  As a result, these cannot be used to read
the default temporary file.

To get around this, your profile can contain lines of the form:
.sp
.in +.5i
mhn-suffix-<type>/<subtype>: <suffix>
.in -.5i
.sp
or
.sp
.in +.5i
mhn-suffix-<type>: <suffix>
.in -.5i
.sp
to specify a suffix which can be automatically added to the temporary
file created for a specific content type.  For example, the following
lines might appear in your profile:
.sp
.nf
.in +.5i
mhn-suffix-text: .txt
mhn-suffix-application/msword: .doc
mhn-suffix-application/PostScript: .ps
.in -.5i
.fi
.sp
to automatically append a suffix to the temporary files.

The method used to display the different contents in the messages bodies
will be determined by a \*(lqdisplay string\*(rq.  To find the display
string, \fImhn\fR will first search your profile for an entry of the form:
.sp
.in +.5i
mhn-show-<type>/<subtype>
.in -.5i
.sp
to determine the display string.  If this isn't found, \fImhn\fR
will search for an entry of the form:
.sp
.in +.5i
mhn-show-<type>
.in -.5i
.sp
to determine the display string.

If a display string is found, any escapes (given below) will be expanded.
The result will be executed under \fB/bin/sh\fR, with the standard input
set to the content.
.ne 16
The display string may contain the following escapes:
.sp
.nf
.in +.5i
.ta \w'%F  'u
%a	Insert parameters from Content-Type field
%e	exclusive execution
%f	Insert filename containing content
%F	%e, %f, and stdin is terminal not content
%l	display listing prior to displaying content
%p	%l, and ask for confirmation
%s	Insert content subtype
%d	Insert content description
%%	Insert the character %
.re
.in -.5i
.fi
.sp
.ne 10
For those display strings containing the e- or F-escape, \fImhn\fR will
execute at most one of these at any given time.  Although the F-escape
expands to be the filename containing the content, the e-escape has no
expansion as far as the shell is concerned.

When the p-escape prompts for confirmation, typing INTR (usually
control-C) will tell \fImhn\fR not to display that content.  The p-escape
can be disabled by specifying the switch `\-nopause'.  Further, when
\fImhn\fR is display a content, typing QUIT (usually control-\\) will
tell \fImhn\fR to wrap things up immediately.

Note that if the content being displayed is multipart, but not one of
the subtypes listed above, then the f- and F-escapes expand to multiple
filenames, one for each subordinate content.  Further, stdin is not
redirected from the terminal to the content.

If a display string is not found, \fImhn\fR has several default values:
.sp
.nf
.in +.5i
mhn-show-text/plain: %pmoreproc '%F'
mhn-show-message/rfc822: %pshow -file '%F'
.in -.5i
.fi
.sp
If a subtype of type text doesn't have a profile entry, it will be
treated as text/plain.

\fImhn\fR has default methods for handling multipart messages of subtype
mixed, alternative, parallel, and digest.  Any unknown subtype of type
multipart (without a profile entry), will be treated as multipart/mixed.

If none of these apply, then \fImhn\fR will check to see if the message
has an application/octet-stream content with parameter \*(lqtype=tar\*(rq.
If so, \fImhn\fR will use an appropriate command.  If not, \fImhn\fR
will complain.

.ne 10
Example entries might be:
.sp
.nf
.in +.5i
mhn-show-audio/basic: raw2audio 2>/dev/null | play
mhn-show-image: xv '%f'
mhn-show-application/PostScript: lpr -Pps
.in -.5i
.fi
.sp
Note that when using the f- or F-escape, it's a good idea to use
single-quotes around the escape.  This prevents misinterpretation by
the shell of any funny characters that might be present in the filename.

Finally, \fImhn\fR will process each message serially\0--\0it won't start
showing the next message until all the commands executed to display the
current message have terminated.  In the case of a multipart content
(of any subtype listed above), the content contains advice indicating if
the parts should be displayed serially or in parallel.  Because this may
cause confusion, particularly on uni-window displays, the `\-serialonly'
switch can be given to tell \fImhn\fR to never display parts in parallel.

.Uh "Showing Alternate Character Sets"
Because a content of type text might be in a non-ASCII character
set, when \fImhn\fR encounters a \*(lqcharset\*(rq parameter for
this content, it checks if your terminal can display this character
set natively.  \fIMhn\fR checks this by examining the the environment
variable MM_CHARSET.  If the value of this environment variable is equal
to the value of the charset parameter, then \fImhn\fR assumes it can
display this content without any additional setup.  If this environment
variable is not set, \fImhn\fR will assume a value of \*(lqUS-ASCII\*(rq.
If the character set cannot be displayed natively, then \fImhn\fR will
look for an entry of the form:
.sp
.in +.5i
mhn-charset-<charset>
.in -.5i
.sp
which should contain a command creating an environment to render
the character set.  This command string should containing a single
\*(lq%s\*(rq, which will be filled-in with the command to display the
content.

Example entries might be:
.sp
.in +.5i
mhn-charset-iso-8859-1: xterm -fn '-*-*-medium-r-normal-*-*-120-*-*-c-*-iso8859-*' -e %s
.in -.5i
or
.in +.5i
mhn-charset-iso-8859-1: '%s'
.in -.5i
.sp
The first example tells \fImhn\fR to start \fIxterm\fR and load the
appropriate character set for that message content.  The second example
tells \fImhn\fR that your pager (or other program handling that content
type) can handle that character set, and that no special processing is
needed beforehand.
.sp
Note that many pagers strip off the high-order bit or have problems
displaying text with the high-order bit set.  However, the pager
\fIless\fR has support for single-octet character sets.  The source
to \fIless\fR is available on many ftp sites carrying free software.
In order to view messages sent in the ISO-8859-1 character set using
\fIless\fR,
.ne 9
put these lines in your \&.login file:
.sp
.nf
.in +.5i
setenv LESSCHARSET latin1
setenv LESS "-f"
.in -.5i
.fi
.sp
The first line tells \fIless\fR to use the ISO-8859-1 definition for
determining whether a character is \*(lqnormal\*(rq, \*(lqcontrol\*(lq,
or \*(lqbinary\*(rq.  The second line tells \fIless\fR not to warn you
if it encounters a file that has non-ASCII characters.  Then, simply
set the \fBmoreproc\fR profile entry to \fIless\fR, and it will get
called automatically.  (To handle other single-octet character sets,
look at the \fIless\fR\0(1) manual entry for information about the
\fBLESSCHARDEF\fR environment variable.)

.Uh "Storing the Contents"
The `\-store' switch tells \fImhn\fR to store the contents of the
named messages in \*(lqnative\*(rq (decoded) format.  Two things must
be determined: the directory to store the content, and the filenames.
Files are written in the directory given by the \fBnmh-storage\fR
profile entry,
.ne 6
e.g.,
.sp
.in +.5i
nmh-storage: /tmp
.in -.5i
.sp
If this entry isn't present,
the current working directory is used.

If the `\-auto' switch is given, then \fImhn\fR will check if the
message contains information indicating the filename that should be
used to store the content.  This information should be specified as the
attribute \*(lqname=filename\*(rq in the Content-Type header for the
content you are storing.  For security reasons, this filename will be
ignored if it begins with the character '/', '.', '|', or '!', or if it
contains the character '%'.  For the sake of security, this switch is
not the default, and it is recommended that you do NOT put the `\-auto'
switch in your \&.mh\(ruprofile file.

If the `\-auto' switch is not given (or is being ignored for
security reasons) then \fImhn\fR will look in the user's profile for
a \*(lqformatting string\*(rq to determine how the different contents
should be stored.  First, \fImhn\fR will look for an entry of the form:
.sp
.in +.5i
mhn-store-<type>/<subtype>
.in -.5i
.sp
to determine the formatting string.  If this isn't found, \fImhn\fR will
look for an entry of the form:
.sp
.in +.5i
mhn-store-<type>
.in -.5i
.sp
to determine the formatting string.

If the formatting string starts with a \*(lq+\*(rq character, then
content is stored in the named folder.  A formatting string consisting
solely of a \*(lq+\*(rq character is interpreted to be the current folder.

If the formatting string consists solely of a \*(lq-\*(rq character,
then the content is sent to the standard output.

If the formatting string starts with a '|', then the display string will
represent a command for \fImhn\fR to execute which should ultimately
store the content.  The content will be passed to the standard input of
the command.  Before the command is executed, \fImhn\fR will change to
the appropriate directory, and any escapes (given below) in the display
string will be expanded.

Otherwise the formatting string will represent a pathname in which to
store the content.  If the formatting string starts with a '/', then the
content will be stored in the full path given, else the file name will
be relative to the value of \fBnmh-storage\fR or the current working
directory.  Any escapes (given below) will be expanded, except for the
a-escape.

A command or pathname formatting string may contain the following escapes.
If the content isn't part of a multipart (of any subtype listed above)
content, the p-escapes are ignored.
.sp
.nf
.in +.5i
.ta \w'%P  'u
%a	Parameters from Content-type  (only valid with command)
%m	Insert message number
%P	Insert part number with leading dot
%p	Insert part number without leading dot
%t	Insert content type
%s	Insert content subtype
%%	Insert character %
.re
.in -.5i
.fi
.sp
If no formatting string is found, \fImhn\fR will check to see if the
content is application/octet-stream with parameter \*(lqtype=tar\*(rq.
If so, \fImhn\fR will choose an appropriate filename.  If the content
is not application/octet-stream, then \fImhn\fR will check to see if the
content is a message.  If so, \fImhn\fR will use the value \*(lq+\*(rq.
As a last resort, \fImhn\fR will use the value \*(lq%m%P.%s\*(rq.

.ne 10
Example profile entries might be:
.sp
.nf
.in +.5i
mhn-store-text: %m%P.txt
mhn-store-text: +inbox
mhn-store-message/partial: +
mhn-store-audio/basic: | raw2audio -e ulaw -s 8000 -c 1 > %m%P.au
mhn-store-image/jpeg: %m%P.jpg
mhn-store-application/PostScript: %m%P.ps
.in -.5i
.fi
.sp
.Uh "Reassembling Messages of Type message/partial"
When asked to store a content containing a partial message, \fImhn\fR
will try to locate all of the portions and combine them accordingly.
The default is to store the combined parts as a new message in the
current folder, although this can be changed using formatting
strings as discussed above.  Thus, if someone has sent you a message
in several parts (such as the output from \fIsendfiles\fR), you can
easily reassemble them all into a single message in the following
fashion:
.sp
.nf
.in +.5i
% mhn -list 5-8
 msg part  type/subtype             size description
   5       message/partial           47K part 1 of 4
   6       message/partial           47K part 2 of 4
   7       message/partial           47K part 3 of 4
   8       message/partial           18K part 4 of 4
% mhn -store 5-8
reassembling partials 5,6,7,8 to folder inbox as message 9
% mhn -list -verbose 9
 msg part  type/subtype             size description
   9       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             conversions=compress
.in -.5i
.fi
.sp
This will store exactly one message, containing the sum of the
parts.  It doesn't matter whether the partials are specified in
order, since \fImhn\fR will sort the partials, so that they are
combined in the correct order.  But if \fImhn\fR can not locate
every partial necessary to reassemble the message, it will not
store anything.

.Uh "External Access"
For contents of type message/external-body,
.ne 12
\fImhn\fR supports these access-types:
.sp
.nf
.in +.5i
afs
anon-ftp
ftp
local-file
mail-server
.in -.5i
.fi
.sp
For the \*(lqanon-ftp\*(rq and \*(lqftp\*(rq access types,
\fImhn\fR will look for the \fBnmh-access-ftp\fR
profile entry,
.ne 6
e.g.,
.sp
.in +.5i
nmh-access-ftp: myftp.sh
.in -.5i
.sp
to determine the pathname of a program to perform the FTP retrieval.
.ne 14
This program is invoked with these arguments:
.sp
.nf
.in +.5i
domain name of FTP-site
username
password
remote directory
remote filename
local filename
\*(lqascii\*(rq or \*(lqbinary\*(rq
.in -.5i
.fi
.sp
The program should terminate with an exit status of zero if the
retrieval is successful, and a non-zero exit status otherwise.

If this entry is not provided, then \fImhn\fR will use a simple
built-in FTP client to perform the retrieval.

.Uh "The Content Cache"
When \fImhn\fR encounters an external content containing a
\*(lqContent-ID:\*(rq field, and if the content allows caching, then
depending on the caching behavior of \fImhn\fR, the content might be
read from or written to a cache.

The caching behavior of \fImhn\fR is controlled with the `\-rcache'
and `\-wcache' switches, which define the policy for reading from,
and writing to, the cache, respectively.  One of four policies may be
specified: \*(lqpublic\*(rq, indicating that \fImhn\fR should make use
of a publically-accessible content cache; \*(lqprivate\*(rq, indicating
that \fImhn\fR should make use of the user's private content cache;
\*(lqnever\*(rq, indicating that \fImhn\fR should never make use of
caching; and, \*(lqask\*(rq, indicating that \fImhn\fR should ask
the user.

There are two directories where contents may be cached: the profile entry
\fBnmh-cache\fR names a directory containing world-readable contents, and,
the profile entry \fBnmh-private-cache\fR names a directory containing
private contents.  The former should be an absolute (rooted) directory
name.
.ne 6
For example,
.sp
.in +.5i
nmh-cache: /tmp
.in -.5i
.sp
might be used if you didn't care that the cache got wiped after each
reboot of the system.  The latter is interpreted relative to the user's
nmh directory, if not rooted,
.ne 6
e.g.,
.sp
.in +.5i
nmh-private-cache: .cache
.in -.5i
.sp
(which is the default value).

.Uh "Caching the Contents"
When you encounter a content of type message/external-body with access
type \*(lqmail-server\*(rq, \fImhn\fR will ask you if may send a message
to a mail-server requesting the content,
.ne 14
e.g.,
.sp
.nf
.in +.5i
% show 1
Retrieve content by asking mail-server@...

SEND file

? yes
mhn: request sent
.in -.5i
.fi
.sp
Regardless of your decision,
\fImhn\fR can't perform any other processing on the content.

However, if \fImhn\fR is allowed to request the content, then when it
arrives, there should be a top-level \*(lqContent-ID:\*(rq field which
corresponds to the value in the original message/external-body content.
You should now use the `-cache' switch to tell \fImhn\fR to enter the
arriving content into the content cache,
.ne 8
e.g.,
.sp
.nf
.in +.5i
% mhn -cache 2
caching message 2 as file ...
.in -.5i
.fi
.sp
You can then re-process the original message/external-body content, and
\*(lqthe right thing should happen\*(rq,
.ne 8
e.g.,
.sp
.nf
.in +.5i
% show 1
\0...
.in -.5i
.fi

.Uh "User Environment"
Because the display environment in which \fImhn\fR operates may vary for
different machines, \fImhn\fR will look for the environment variable
\fB$MHN\fR.  If present, this specifies the name of an additional
user profile which should be read.  Hence, when a user logs in on a
particular display device, this environment variable should be set to
refer to a file containing definitions useful for the given display device.
Normally, only entries that deal with the methods to display different
content type and subtypes
.sp
.in +.5i
mhn-show-<type>/<subtype>
.br
mhn-show-<type>
.in -.5i
.sp
need be present in this additional profile.
Finally,
\fImhn\fR will attempt to consult one other additional user profile,
.ne 6
e.g.,
.sp
.in +.5i
%etcdir%/mhn.defaults
.in -.5i
.sp
which is created automatically during nmh installation.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
^$MHN~^Additional profile entries
^%etcdir%/mhn.defaults~^System default MIME profile entries
^%etcdir%/mhl.headers~^The headers template
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^mhlproc:~^Default program to display message headers
.Ps
^nmh-access-ftp:~^Program to retrieve contents via FTP
.Ps
^nmh-cache~^Public directory to store cached external contents
.Ps
^nmh-private-cache~^Personal directory to store cached external contents
.Ps
^mhn-charset-<charset>~^Template for environment to render character sets
.Ps
^mhn-show-<type>*~^Template for displaying contents
.Ps
^nmh-storage~^Directory to store contents
.Ps
^mhn-store-<type>*~^Template for storing contents
.Ps
^moreproc:~^Default program to display text/plain content
.Sa
mhbuild(1), mhl(1), sendfiles(1)
.br
RFC\-934:
.br
   \fIProposed Standard for Message Encapsulation\fR,
.br
RFC\-2045:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part One:
.br
   Format of Internet Message Bodies\fR,
.br
RFC\-2046:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Two:
.br
   Media Types\fR,
.br
RFC\-2047:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Three:
.br
   Message Header Extensions for Non-ASCII Text\fR,
.br
RFC\-2048:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Four:
.br
   Registration Procedures\fR,
.br
RFC\-2049:
.br
   \fIMultipurpose Internet Mail Extensions (MIME) Part Five:
.br
   Conformance Criteria and Examples\fR.
.De
`+folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-noauto'
.Ds
`\-nocache'
.Ds
`\-nocheck'
.Ds
`\-form mhl.headers'
.Ds
`\-headers'
.Ds
`\-pause'
.Ds
`\-rcache ask'
.Ds
`\-realsize'
.Ds
`\-noserialonly'
.Ds
`\-show'
.Ds
`\-noverbose'
.Ds
`\-wcache ask'
.Co
If a folder is given, it will become the current folder.  The last
message selected will become the current message.
.Bu
Partial messages contained within a multipart content are not reassembled
with the `\-store' switch.
.En
