#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
#include "newsfetch.h"

extern int errno;
extern FILE *rcfp, *rctmpfp;
extern char lockfile[100];

int create_directory(char *);

void getHomedir(char *homedir)
{
struct passwd *userinfo;

		userinfo=getpwuid(getuid());
		if(userinfo != NULL)
       			strcpy(homedir,userinfo->pw_dir);
		else
       		{
        		perror("getpwname");
        		exit(1);
        	}

}
void defaultRcFiles(char *homedir, char *rcfile, char *copyCmd)
{
struct passwd *userinfo;
char rctmpfile[100];


	if(rcfile[0] == '\0')
	{	

       			strcpy(rcfile,homedir);
        		strcat(rcfile,"/");
        		strcat(rcfile,NEWSFETCHRC);
	}
	sprintf(rctmpfile,"%s.tmp",rcfile);
	sprintf(copyCmd, "cp %s %s.old;cp %s %s\n",rcfile,rcfile,rctmpfile,rcfile);
	if((rcfp=fopen(rcfile,"r"))==NULL)
        {
                fprintf(stderr,"Can not open file %s...aborting\n",rcfile);
                exitNow(1);
        }

	if((rctmpfp=fopen(rctmpfile,"w+"))==NULL)
        {
                fprintf(stderr,"Can not create file %s ...aborting\n",rctmpfile);
                exitNow(1);
        }

}

generateProcmailrc(char *homedir, char *rcfile, char *dirname, char *pipe_command)
{
FILE *fp, *fp1, *fp2;
char *tmp, buf[200], group[180], filterfile[100], procmailrcfile[100];
int i,j;
char *title="

############### Generated by  Newsfetch ##############################
# New version of Newsfetch is available from                         #
#                                                                    #
#        http://ulf.wep.net/newsfetch.html                           #
# Feedback and Comments to Yusuf Motiwala <yusuf@scientist.com>      #
######################################################################

";								     

       	strcpy(filterfile,homedir);
       	strcat(filterfile,"/");
       	strcat(filterfile, PROCMAIL_TMPL);
	
	if((fp1=fopen(filterfile,"r"))==NULL)
        {
       		strcpy(filterfile,homedir);
       		strcat(filterfile,"/");
       		strcat(filterfile, ".procmailrc");
		if((fp1=fopen(filterfile,"r"))==NULL)
        	{
                fprintf(stderr,"can not open file %s/%s or %s\n",homedir, PROCMAIL_TMPL, filterfile);
		exitNow(-1);
		}
        }
	
	if((fp=fopen(rcfile,"r"))==NULL)
        {
                fprintf(stderr,"can not open file %s\n",rcfile);
                exitNow(-1);
        }
       	strcpy(procmailrcfile, homedir);
       	strcat(procmailrcfile, "/");
       	strcat(procmailrcfile, PROCMAIL_RC);
	strcat(pipe_command, procmailrcfile);

	if((fp2=fopen(procmailrcfile,"w+"))==NULL)
        {
                fprintf(stderr,"Can not create file %s \n",procmailrcfile);
                exitNow(-1);
        }

	tmp = fgets(buf, 199, fp1);
	while(tmp != NULL)
		{
		fprintf(fp2, "%s", buf);
		tmp = fgets(buf, 199, fp1);
		}
	fclose(fp1);

	fprintf(fp2, "%s\n", title);

	tmp = fgets(buf, 199, fp);
	while(tmp != NULL)
	{
	for(i =0; buf[i] == 0x20 ; i++)
                ;
        if(buf[i] == '#')
		for(i++; buf[i] == 0x20 ; i++);
        if(buf[i] != '\n')
		{
		sscanf(&buf[i],"%s %d %d", group, &i, &j);
		fprintf(fp2, "\n:0\n* ^Newsfetch:.*%s\n%s/%s\n", group, dirname[0] == '\0'?".":dirname, group);
		}
	tmp = fgets(buf, 199, fp);
        }
	fclose(fp);
	fflush(fp2);
	fclose(fp2);
}

int createDirectory(char *dirname)
{
struct stat dirstat;
int i;

	if(stat(dirname, &dirstat) == 0)
		{
		if(!S_ISDIR(dirstat.st_mode)) 
			{
			fprintf(stderr,"%s is not a directory\n",dirname);
			return(0);
			}
		if((access(dirname, W_OK)) < 0) 
			{
			perror(dirname);
			return(0);
			}
		}
	else
		{
		if(errno == ENOENT)
			{
			if(mkdir(dirname, (S_IRUSR | S_IWUSR | S_IXUSR)) < 0) 
				{
                        	perror(dirname);
				return(0);
				}
			}
		else
			{
			perror(dirname);
			return(0);
			}

                }
return(1);
}

makeCommand(char *src, char *search, char *replace, char *dest)
{
char *tmp, *tmp1;

tmp1 = src;
dest[0] = '\0';

	while(1)
	{
        tmp= (char *)strstr(tmp1, search);
        if(tmp != NULL)
                {
		strncat(dest, tmp1, tmp-tmp1);
		strcat(dest, replace);
		tmp1 = tmp+strlen(search);
                }
	else
		{
		strcat(dest, tmp1);
		return;
		}
	}
}


