#include <stdio.h>
#include <unistd.h>
#include "newsfetch.h"	

int get_commandline(int argc, char *argv[], char *dirname, char *rcname,
		int *cleanup, int *wait_after_articles, int *wait_for_time,
		int *command_flag, char *execute_command,
		int *pipe_flag, char *pipe_command, int *only_list, 
		int *procmailrc, int *timeout)
{
extern char *optarg;
extern int optind, opterr, optopt, news_target;

int c,i, tmp;
char *multi_spPyY="You can only specify one of the -s, -y, -Y, -p or -P option";

while (1)
	{

/* Options (not all supported) 

-d dirname to store news file
-s print news to stdout
-f alternative rc file
-v| -V -> Print version and exit
-c -> Do not update configuration file after downloading articles
-w -> Wait for T sec  after downloading of N articles
-t -> time
-T -> timeout
-x -> execute command after each group fetching
-p -> pipe each article 
-P -> pipe group
-y -> pipe to procmail
-Y -> pipe each article
*/
         c = Getopt(argc, argv, "w:t:T:d:f:U:N:x:p:P:Y:yslVvchH-");
         if (c == EOF)
         	break;

         switch (c)
         	{
            case ':':
         		fprintf (stderr, "Missing parameter %s",optarg);
              		break;

            case 'd':
		i = strlen(optarg);	
	      if(i < 100)
		{
		if(optarg[0] == '.')
			{
		/* Required for odd behavior of procmail*/
	      		strcat(dirname,"/");
	      		strcat(dirname,optarg);
			}
		else
	      		strcpy(dirname,optarg);
		i = strlen(dirname);	
		if(dirname[i-1] == '/')
			dirname[i-1] = '\0';
		if(!createDirectory(dirname))
			exit(1);
		}
	      else
		{
		fprintf(stderr,"Dirname too long\n");	
		exit(1);
		}
              break;

            case 'f':
	      strcpy(rcname,optarg);
              break;

            case 'c':
		*cleanup = 0;
              break;

            case 'l':
		*only_list = 1;
              return(1);

	    case 's':
		if(news_target)
			{
			fprintf(stderr,"%s\n",multi_spPyY);
			exit(1);
			}      
		news_target = 2;
		break;

            case 'p':
		if(news_target)
			{
			fprintf(stderr,"%s\n",multi_spPyY);
			exit(1);
			}      
		news_target = 3;
	      	strcpy(pipe_command, optarg);
              break;

            case 'P':
		if(news_target)
			{
			fprintf(stderr,"%s\n",multi_spPyY);
			exit(1);
			}      
		news_target = 4;
	      	strcpy(pipe_command, optarg);
              break;

            case 'y':
		if(news_target)
			{
			fprintf(stderr,"%s\n",multi_spPyY);
			exit(1);
			}      
		news_target = 3;
		*procmailrc = 1;
	      	strcpy(pipe_command, PROCMAIL_COMMAND);
              break;

            case 'Y':
		if(news_target)
			{
			fprintf(stderr,"%s\n",multi_spPyY);
			exit(1);
			}      
		news_target = 3;
		*procmailrc = 1;
	      	strcpy(pipe_command, optarg);
	      	strcat(pipe_command, " ");
              break;

	    case 'v':
	    case 'V':
		exit(1);

	    case 'h':
	    case 'H':
		opt_help(argv[0]);
		return(1);  /* unreachable*/

            case 'w':
	      tmp = atoi(optarg);
	      if(tmp == 0)
		{
		fprintf(stderr,"Argument to -w should be valid number\n");
		exit(-1);
		}	
	      else
		(*wait_after_articles) = tmp;	
              break;
            
            case 't':
	      tmp = atoi(optarg);
	      if(tmp == 0)
		{
		fprintf(stderr, "Argument to -t should be valid number\n");
		exit(-1);
		}	
		(*wait_for_time) = tmp;	
              break;

            case 'T':
		/* not checking optarg */
		(*timeout) = atoi(optarg);
              break;

            case 'x':
	      *command_flag=1;	
	      strcpy(execute_command,optarg);
              break;

            case '?':
	      exit(-1);	
            
            case '-':
		opt_help(argv[0]);
		exit(1);
	     return(-1);		

            default:
	     return(-1);		
            }
           }

         return(1);
       }

opt_help(char *prog_name)
{

char *options=
"	[-clsyvV] [-d dirname] [-f rcfile] [-t N] 
	[-T timeout] [-w M ] [-pPY filter] [-x command]
";	
		fprintf(stderr,"Usage: %s nntp_server [options]\n", prog_name);
		fprintf(stderr,"Options:\n%s\n",options);
		exit(1);
}

