 
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

extern int h_errno;

int ConnectServer(char *serverName, int port, int exitFlag)
{

int s,c, one=1;
struct sockaddr_in sa;
struct hostent *hp;
struct in_addr saddr;

if(serverName == NULL)
	if(exitFlag)
		return(-1);
	else
		exitNow(-1);

if(isdigit(*serverName))
	{
	saddr.s_addr = inet_addr(serverName);
	if(saddr.s_addr > 0)
        	hp = gethostbyaddr((char *)&saddr,sizeof(struct in_addr),AF_INET);
	else
		hp=gethostbyname(serverName);

	if(hp == NULL)
		{
                herror("Severname");
		if(exitFlag)
                	return(-1);
		else
			exitNow(-1);
                }

	}
else
	if((hp=gethostbyname(serverName))==NULL)
		{
		herror("gethostbyname");
		if(exitFlag)
                	return(-1);
		else
			exitNow(-1);
		}
fprintf(stderr,"Trying to connect %s...",serverName);
fflush(stderr);
bcopy((char *) hp->h_addr, (char *)&sa.sin_addr,hp->h_length);
sa.sin_family=hp->h_addrtype;

sa.sin_port=htons(port);

if((s=socket(hp->h_addrtype, SOCK_STREAM, 0)) < 0 )
	{
	fprintf(stderr,"\n");
	perror("socket");
		if(exitFlag)
                	return(-1);
		else
			exitNow(-1);
	}
	
if(connect(s, (struct sockaddr *) &sa, sizeof sa) < 0)
	{
	fprintf(stderr,"\n");
	perror("connect");
	if(exitFlag)
               	return(-1);
	else
		exitNow(-1);
	}
	fprintf(stderr,"Connected\n");

	if((setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, &one, sizeof(int)))<0)
        {
        	perror("Error Setting Socket Option");
        }

fflush(stderr);
return(s);
}

void createFd(int socketId, FILE **sfp)
{

if((sfp[0]=fdopen(socketId,"w")) == NULL)
                {
                perror("fdopen");
                close(socketId);
                exitNow(1);
                }

if((sfp[1]=fdopen(socketId,"r")) == NULL)
                {
                perror("fdopen");
                close(socketId);
                exitNow(1);
                }
}

#ifdef SUN
herror(char *error)
{
	fprintf(stderr, "%s : error\n", error);
}
#endif
