/*

Copyright (C) 2004 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <nd.h>
#include <nd_packet.h>
#include <nd_dialog.h>
#include <nd_gui.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "nd_ta.h"

void
nd_ta_on_text_browse_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_ta_browse_input();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
nd_ta_on_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_ta_run();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
nd_ta_on_cancel_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *toplevel = gtk_widget_get_toplevel(GTK_WIDGET(button));
  
  D_ASSERT_PTR(toplevel);
  gtk_widget_hide(toplevel);
  
  return;
  TOUCH(user_data); 
}


void
nd_ta_on_save_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_ta_save();

  return;
  TOUCH(button);
  TOUCH(user_data);
}

void
nd_ta_on_text_in_entry_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(editable));
  GtkWidget *w;
  
  ND_GTK_GET(w, dialog, "text_in_radiobutton");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
  
  ND_GTK_GET(w, dialog, "ok_button");
  gtk_widget_set_sensitive(w, TRUE);
  
  return;
  TOUCH(user_data);
}


void
nd_ta_on_trace_list_selection_changed  (GtkList         *list,
                                        gpointer         user_data)
{
  GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(list));
  GtkWidget *w;
  
  ND_GTK_GET(w, dialog, "trace_in_radiobutton");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
  
  ND_GTK_GET(w, dialog, "ok_button");
  gtk_widget_set_sensitive(w, (list->selection != NULL));
  return;
  TOUCH(user_data);
}


void
nd_ta_on_text_in_radiobutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *dialog = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
  GtkWidget *w;

  if (gtk_toggle_button_get_active(togglebutton))
    {
      ND_GTK_GET(w, dialog, "ok_button");
      gtk_widget_set_sensitive(w, TRUE);
    }

  return;
  TOUCH(user_data);
}


void
nd_ta_on_dir_browse_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_ta_browse_output();

  return;
  TOUCH(button);
  TOUCH(user_data);
}

