/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_icmp_callbacks_h
#define __nd_icmp_callbacks_h

#include <nd.h>

/* Button callbacks */

void    nd_icmp_type_cb(LND_Packet  *packet,
			guchar      *header,
			guchar      *data);

void    nd_icmp_code_cb(LND_Packet  *packet,
			guchar      *header,
			guchar      *data);

void    nd_icmp_cksum_cb(LND_Packet  *packet,
			 guchar      *header,
			 guchar      *data);

void    nd_icmp_id_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_icmp_seq_cb(LND_Packet  *packet,
		       guchar      *header,
		       guchar      *data);

void    nd_icmp_ip_cb(LND_Packet  *packet,
		      guchar      *header,
		      guchar      *data);

void    nd_icmp_ts_orig_cb(LND_Packet  *packet,
			   guchar      *header,
			   guchar      *data);

void    nd_icmp_ts_recv_cb(LND_Packet  *packet,
			   guchar      *header,
			   guchar      *data);

void    nd_icmp_ts_trans_cb(LND_Packet  *packet,
			    guchar      *header,
			    guchar      *data);

void    nd_icmp_error_cb(LND_Packet  *packet,
			 guchar      *header,
			 guchar      *data);

void    nd_icmp_adv_num_addr_cb(LND_Packet  *packet,
				guchar      *header,
				guchar      *data);

void    nd_icmp_adv_addr_entry_cb(LND_Packet  *packet,
				  guchar      *header,
				  guchar      *data);

void    nd_icmp_adv_lifetime_cb(LND_Packet  *packet,
				guchar      *header,
				guchar      *data);

void    nd_icmp_adv_ip_cb(LND_Packet  *packet,
			  guchar      *header,
			  guchar      *data);

void    nd_icmp_adv_pref_cb(LND_Packet  *packet,
			    guchar      *header,
			    guchar      *data);

/* Header field menu item callbacks */

void    nd_icmp_type_value_cb(LND_Packet  *packet,
			      guchar      *header,
			      int          value);

void    nd_icmp_type_custom_cb(LND_Packet  *packet,
			       guchar      *header,
			       int          value);

void    nd_icmp_code_value_cb(LND_Packet  *packet,
			      guchar      *header,
			      int          value);

void    nd_icmp_code_custom_cb(LND_Packet  *packet,
			       guchar      *header,
			       int          value);

/* ICMP menu callbacks */

void    nd_icmp_cksum_fix_cb(LND_Packet  *packet,
			     guchar      *header,
			     int          value);


#endif
