/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd.h>
#include <nd_gui.h>
#include <nd_packet.h>
#include <nd_dialog.h>

#include <nd_snap.h>
#include <nd_snap_callbacks.h>


void   
nd_snap_dsap_cb(LND_Packet  *packet,
		guchar      *header,
		guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct lnd_snap_header *sh;

  sh = (struct lnd_snap_header *) header;
  cb_data = nd_proto_cb_data_new(nd_snap_get(), data, data-header, TRUE);
  
  nd_dialog_number(_("Enter 8-bit DSAP:"),
		   ND_BASE_HEX,
		   sh->dsap, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet, cb_data);
}


void   
nd_snap_ssap_cb(LND_Packet  *packet,
		guchar      *header,
		guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct lnd_snap_header *sh;

  sh = (struct lnd_snap_header *) header;
  cb_data = nd_proto_cb_data_new(nd_snap_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter 8-bit SSAP:"),
		   ND_BASE_HEX,
		   sh->ssap, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet, cb_data);
}


void   
nd_snap_ctrl_cb(LND_Packet  *packet,
		guchar      *header,
		guchar      *data)
{
  ND_ProtoCallbackData *cb_data;
  struct lnd_snap_header *sh;

  sh = (struct lnd_snap_header *) header;
  cb_data = nd_proto_cb_data_new(nd_snap_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter 8-bit control code:"),
		   ND_BASE_HEX,
		   sh->ctrl, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet, &cb_data);
}


static void
snap_oui_ok_cb(LND_Packet *packet, void *user_data, guint value)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct lnd_snap_header *sh;
  guchar               *val;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_snap_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      sh = (struct lnd_snap_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_snap_get(), nesting);
      if (!sh)
	continue;

      val = (guchar *) &value;
      
#ifdef WORDS_BIGENDIAN
      sh->oui[0] = val[0];
      sh->oui[1] = val[1];
      sh->oui[2] = val[2];
#else
      sh->oui[0] = val[2];
      sh->oui[1] = val[1];
      sh->oui[2] = val[0];
#endif

      libnd_packet_modified(libnd_pit_get(&pit));
    }
}


void   
nd_snap_oui_cb(LND_Packet  *packet,
	       guchar      *header,
	       guchar      *data)
{
  guint32 value;
  struct  lnd_snap_header *sh;

  sh = (struct lnd_snap_header *) header;

#ifdef WORDS_BIGENDIAN
  value = (sh->oui[2] << 16) | (sh->oui[1] << 8) | (sh->oui[0]);
#else
  value = (sh->oui[0] << 16) | (sh->oui[1] << 8) | (sh->oui[2]);
#endif

  nd_dialog_number(_("Enter 24-bit OUI code:"),
		   ND_BASE_HEX,
		   value, (1<<24) - 1,
		   snap_oui_ok_cb,
		   NULL,
		   packet, data);
}


/* The callback that gets called when the user has clicked
   one of the predefined Ethernet protocol values: */
void    
nd_snap_proto_value_cb(LND_Packet  *packet,
		       guchar      *header,
		       int          value)
{
  LND_Trace            *trace;
  LND_PacketIterator    pit;
  int                   nesting;
  struct lnd_snap_header *sh;

  if (! (trace = libnd_packet_get_trace(packet)))
    return;

  nesting = libnd_packet_get_proto_nesting(packet, nd_snap_get(), header);
  if (nesting < 0)
    return;

  for (libnd_pit_init(&pit, trace); libnd_pit_get(&pit); libnd_pit_next(&pit))
    {
      sh = (struct lnd_snap_header *) libnd_packet_get_data(libnd_pit_get(&pit), nd_snap_get(), nesting);
      if (!sh)
	continue;
      
      sh->proto = htons(value);
      libnd_packet_update(libnd_pit_get(&pit), nd_snap_get(), nesting);
      libnd_packet_modified(libnd_pit_get(&pit));
    }
}


/* The callback that gets called when the user selected "Custom"
   from the SNAP protocol type menu: */
void    
nd_snap_proto_custom_cb(LND_Packet  *packet,
			guchar      *header,
			int          value)
{
  struct lnd_snap_header   *sh;
  
  sh = (struct lnd_snap_header *) header;
  nd_dialog_number(_("Enter protocol number:"),
		   ND_BASE_DEC,
		   ntohs(sh->proto),
		   65535,
		   (ND_NumberCallback) nd_snap_proto_value_cb,
		   NULL,
		   packet, header);

  return;
  TOUCH(value);
}


/* The callback that gets called when the user clicks the button
   for the Ethernet protocol type in the table. Pops up the menu. */
void
nd_snap_proto_cb(LND_Packet  *packet,
		 guchar      *header,
		 guchar      *data)
{
  static GtkWidget *menu = NULL;

  if (!menu)
    menu = nd_gui_create_menu(snap_menu_type_data);

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
      
  return;
  TOUCH(header);
  TOUCH(packet);
  TOUCH(data);
}
