/*
 * Copyright (c) 1990,1991 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#  ifndef _ATALK_ENDIAN_H_
#define _ATALK_ENDIAN_H_

#ifdef _IBMR2
#include <sys/machine.h>
#endif _IBMR2

#ifdef linux
#include <bytesex.h>
#define BYTE_ORDER	__BYTE_ORDER
#include <asm/byteorder.h>
#endif linux

#ifdef __svr4__
#include <sys/byteorder.h>
#endif __svr4__

# ifndef BYTE_ORDER
#define LITTLE_ENDIAN	1234
#define BIG_ENDIAN	4321
#define PDP_ENDIAN	3412

#ifdef sun
#ifdef i386
#define BYTE_ORDER	LITTLE_ENDIAN
#else i386
#define BYTE_ORDER	BIG_ENDIAN
#endif i386
#else
#ifdef MIPSEB
#define BYTE_ORDER	BIG_ENDIAN
#else
#ifdef MIPSEL
#define BYTE_ORDER	LITTLE_ENDIAN
#else
Like, what is your byte order, man?
#endif MIPSEL
#endif MIPSEB
#endif sun
# endif BYTE_ORDER

# ifndef ntohl
# if defined( sun ) || defined( ultrix ) || defined( _IBMR2 )
#if BYTE_ORDER == BIG_ENDIAN
#define ntohl(x)	(x)
#define ntohs(x)	(x)
#define htonl(x)	(x)
#define htons(x)	(x)

#else
#if defined( mips ) && defined( KERNEL )
#define	ntohl(x)	nuxi_l(x)
#define	ntohs(x)	nuxi_s(x)
#define	htonl(x)	nuxi_l(x)
#define	htons(x)	nuxi_s(x)

#else mips KERNEL

#if !( defined( sun ) && defined( i386 ))
unsigned short	ntohs(), htons();
unsigned long	ntohl(), htonl();
#endif sun i386

#endif mips KERNEL
#endif BYTE_ORDER
# endif sun ultrix _IBMR2
# endif ntohl
#  endif _ATALK_ENDIAN_H_
