/*
 * Copyright (c) 1990,1997 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/time.h>
#include <strings.h>
#include <netdb.h>

#include <netatalk/endian.h>
#include <netatalk/at.h>
#include <atalk/compat.h>
#include <atalk/nbp.h>
#include <atalk/ddp.h>

#include  "nbp_conf.h"

extern int errno;

nbp_lookup( obj, type, zone, nn, nncnt )
    char		*obj, *type, *zone;
    struct nbpnve	*nn;
    int			nncnt;
{
    struct sockaddr_at	addr, from;
    struct timeval	tv, tv_begin, tv_end;
    fd_set		fds;
    struct nbpnve	nve;
    struct nbphdr	nh;
    struct nbptuple	nt;
    struct servent	*se;
    char		*data;
    int			s, namelen, cnt, tries, sc, cc, i, c;

    if (( s = socket( AF_APPLETALK, SOCK_DGRAM, 0 )) < 0 ) {
	return( -1 );
    }

    bzero( &addr, sizeof( struct sockaddr_at ));
#ifdef BSD4_4
    addr.sat_len = sizeof( struct sockaddr_at );
#endif BSD4_4
    addr.sat_family = AF_APPLETALK;
    addr.sat_addr.s_net = ATADDR_ANYNET;
    addr.sat_addr.s_node = ATADDR_ANYNODE;
    addr.sat_port = ATADDR_ANYPORT;
    if ( bind( s, (struct sockaddr *)&addr,
	      sizeof( struct sockaddr_at )) < 0 ) {
	return( -1 );
    }

    namelen = sizeof( struct sockaddr_at );
    if ( getsockname( s, (struct sockaddr *)&addr, &namelen ) < 0 ) {
	return( -1 );
    }

    data = nbp_send;
    *data++ = DDPTYPE_NBP;
    nh.nh_op = NBPOP_BRRQ;
    nh.nh_cnt = 1;
    nh.nh_id = 0;
    bcopy( &nh, data, SZ_NBPHDR );
    data += SZ_NBPHDR;

    nt.nt_net = addr.sat_addr.s_net;
    nt.nt_node = addr.sat_addr.s_node;
    nt.nt_port = addr.sat_port;
    bcopy( &nt, data, SZ_NBPTUPLE);
    data += SZ_NBPTUPLE;

    if ( obj ) {
	if (( cc = strlen( obj )) > NBPSTRLEN ) return( -1 );
	*data++ = cc;
	bcopy( obj, data, cc );
	data += cc;
    } else {
	*data++ = 0;
    }

    if ( type ) {
	if (( cc = strlen( type )) > NBPSTRLEN ) return( -1 );
	*data++ = cc;
	bcopy( type, data, cc );
	data += cc;
    } else {
	*data++ = 0;
    }

    if ( zone ) {
	if (( cc = strlen( zone )) > NBPSTRLEN ) return( -1 );
	*data++ = cc;
	bcopy( zone, data, cc );
	data += cc;
    } else {
	*data++ = 0;
    }

    bzero( &addr, sizeof( struct sockaddr_at ));
#ifdef BSD4_4
    addr.sat_len = sizeof( struct sockaddr_at );
#endif BSD4_4
    addr.sat_family = AF_APPLETALK;
    addr.sat_addr.s_net = ATADDR_ANYNET;
    addr.sat_addr.s_node = ATADDR_ANYNODE;
    if ( nbp_port == 0 ) {
	if (( se = getservbyname( "nbp", "ddp" )) == NULL ) {
	    nbp_port = 2;
	} else {
	    nbp_port = ntohs( se->s_port );
	}
    }
    addr.sat_port = nbp_port;

    cnt = 0;
    tries = 3;
    sc = data - nbp_send;
    while ( tries > 0 ) {
	if ( sendto( s, nbp_send, sc, 0, (struct sockaddr *)&addr,
		sizeof( struct sockaddr_at )) < 0 ) {
	    return( -1 );
	}
	tv.tv_sec = 2L;
	tv.tv_usec = 0;

	for (;;) {
	    FD_ZERO( &fds );
	    FD_SET( s, &fds );
	    if ( gettimeofday( &tv_begin, NULL ) < 0 ) {
		return( -1 );
	    }
	    if (( c = select( s + 1, &fds, NULL, NULL, &tv )) < 0 ) {
		return( -1 );
	    }
	    if ( c == 0 || FD_ISSET( s, &fds ) == 0 ) {
		break;
	    }
	    if ( gettimeofday( &tv_end, NULL ) < 0 ) {
		return( -1 );
	    }
	    if ( tv_begin.tv_usec > tv_end.tv_sec ) {
		tv_end.tv_usec += 1000000;
		tv_end.tv_sec -= 1;
	    }
	    if (( tv.tv_usec -= ( tv_end.tv_usec - tv_begin.tv_usec )) < 0 ) {
		tv.tv_usec += 1000000;
		tv.tv_sec -= 1;
	    }
	    if (( tv.tv_sec -= ( tv_end.tv_sec - tv_begin.tv_sec )) < 0 ) {
		break;
	    }

	    namelen = sizeof( struct sockaddr_at );
	    if (( cc = recvfrom( s, nbp_recv, sizeof( nbp_recv ), 0,
		    (struct sockaddr *)&from, &namelen )) < 0 ) {
		return( -1 );
	    }

	    data = nbp_recv;
	    if ( *data++ != DDPTYPE_NBP ) {
		continue;
	    }
	    cc--;

	    bcopy( data, &nh, SZ_NBPHDR );
	    data += SZ_NBPHDR;
	    if ( nh.nh_op != NBPOP_LKUPREPLY ) {
		continue;
	    }
	    cc -= SZ_NBPHDR;

	    while (( i = nbp_parse( data, &nve, cc )) >= 0 ) {
		data += cc - i;
		cc = i;
		/*
		 * Check to see if nve is already in nn. If not,
		 * put it in, and increment cnt.
		 */
		for ( i = 0; i < cnt; i++ ) {
		    if ( nbp_match( &nve, &nn[ i ],
			    NBPMATCH_NOZONE|NBPMATCH_NOGLOB )) {
			break;
		    }
		}
		if ( i == cnt ) {
		    nn[ cnt++ ] = nve;
		}
		if ( cnt == nncnt ) {
		    tries = 0;
		    break;
		}
	    }
	    if ( cnt == nncnt ) {
		tries = 0;
		break;
	    }
	}
	tries--;
    }

    close( s );
    errno = 0;
    return( cnt );
}
