/*
 * Copyright (c) 1997 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/*
 * This code should only be linked in if on Solaris *and* we're building
 * for AFS.  It's not currently #ifdef AFS.
 */

int	sigvec_dummy;

# if defined( sun ) && defined( __svr4__ )

#define _POSIX_SOURCE

/* #include <signal.h> */
#include <sys/param.h>
#include </usr/ucbinclude/sys/signal.h>

void    (*sv_handler)();        /* signal handler */
int     sv_mask;                /* signal mask to apply */
int     sv_flags;               /* see signal options below */

sigvec( sig, nvec, ovec )
    int			sig;
    struct sigvec	*nvec, *ovec;
{
    struct sigaction	nsa, osa;
    int			rc;

    /* NULL nvec possible? */

    nsa.sa_flags = nvec->sv_flags;
    nsa.sa_handler = nvec->sv_handler;
    bcopy( &nvec->sv_mask, &nsa.sa_mask, sizeof( nvec->sv_mask ));

    rc = sigaction( sig, &nsa, &osa );

    if ( ovec != NULL ) {
	ovec->sv_flags = osa.sa_flags;
	ovec->sv_handler = osa.sa_handler;
	bcopy( &osa.sa_mask, &ovec->sv_mask, sizeof( ovec->sv_mask ));
    }

    return( rc );
}

sigsetmask( mask )
    int	mask;
{
    sigset_t	set, oset;
    int		omask;

    bzero( &set, sizeof( sigset_t ));
    bcopy( &mask, &set, sizeof( mask ));
    if ( sigprocmask( SIG_SETMASK, &set, &oset ) < 0 ) {
	return( 0 );
    }
    bcopy( &oset, &omask, sizeof( mask ));
    return( omask );
}
# endif sun __svr4__
