/*
 * Copyright (c) 1990,1997 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <netatalk/at.h>
#include <atalk/atp.h>
#include <atalk/asp.h>

asp_close( asp )
    ASP		asp;
{
    struct atp_block	atpb;
    struct iovec	iov[ 1 ];
    char		data[ 4 ];
    int			err = 0;

    bzero( data, sizeof( data ));
    atpb.atp_saddr = &asp->asp_sat;
    iov[ 0 ].iov_base = data;
    iov[ 0 ].iov_len = sizeof( data );
    atpb.atp_sresiov = iov;
    atpb.atp_sresiovcnt = 1;

    if ( atp_sresp( asp->asp_atp, &atpb ) < 0 ) {
	err = -1;;
    }
    if ( atp_close( asp->asp_atp ) < 0 ) {
	err = -1;
    }
    free( asp );
    return( err );
}
