#TRUSTED 95da24195efa0ac874ad25434901e35dbff026bd527710cc4e0d9751c54dcd32284795c78be4ccc5b68e271e49aedcf3f8eaef3a482bdbf118814363e01667ca3a59ca8062949c234aa6fb6786c474d64ec400990b43dcfa11aaa87fd8dad0daea946e4d6fd1313025bf7609c28ce3050c10641bdb79eb4a67e5515f89ecad2181c3be18f0e39dbcfa8a48583ca931a2e7a725ba8b44f672ce303fc797e1d98d236fdd90f9cf05297a4505e0dacd52bd8da3d3b2291b5acbb6f93eaf09b5f269ac39bc2af93fc74d9d9b7391e02eee6deda0c2634f2c709da60dec43760a9e4d3700aa9abbcce38aa1204049ff549b177c0c28702e45fc8080e124ae15553e667d0a53e04027864c2ca3a5948069c3c4efa66bb1a66110acf315e2ea14e5c64a7f6da606529050ed785db5510f9a5ea0473f08adfa85567f9d3c8f3c3ae6c525ddab78fc31e73873f011054c16b514893f1ee7cb965a724649713fd02785d93474b96e8d82c73f21bdee96445f1e2230995a81867a547b8cd87f7f44403c8a6099af16a2013c52af52bba9060a6d89b2e6c5c9fda416d19379de4d3fdd1590573fde43e0f2f5858d75296893802273599240ed18ff7a0bf87ed980e0f747eb762aa50e34049b522c68ce5e3a5b909abf0bc75392cdec9c4253c89428df8ee7e773e754218a8d658bd575e6fe52be8caad7b9f338870c9bfaac7bf2fd90f85772
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread")) exit(0);
if ( ! find_in_path("nikto.pl") ) exit(0);


if(description)
{
 script_id(14260);
 script_version ("1.5");
 name["english"] = "Nikto (NASL wrapper)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs nikto(1) to find CGI.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find CGI with Nikto";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencies("find_service.nes", "httpver.nasl", "logins.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);

# script_add_preference(name:"Force scan all possible CGI directories",
#                       type:"checkbox", value:"no");
 script_add_preference(name:"Force full (generic) scan", 
                      type:"checkbox", value:"no");
 exit(0);
}

#

if (! defined_func("pread"))
{
  set_kb_item(name: "/tmp/UnableToRun/14254", value: TRUE);
  display("Script #14254 (nikto_wrapper) cannot run\n");
  exit(0);
}

user = get_kb_item("http/login");
pass = get_kb_item("http/login");
ids = get_kb_item("/Settings/Whisker/NIDS");

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

# Nikto will generate many false positives if the web server is broken
no404 = get_kb_item("www/no404/" + port);
if ( no404 ) exit(0);

i = 0;
argv[i++] = "nikto.pl";

httpver = get_kb_item("http/"+port);
if (httpver == "11")
{
  argv[i++] = "-vhost";
  argv[i++] = get_host_name();
}

argv[i++] = "-h"; argv[i++] = get_host_ip();
argv[i++] = "-p"; argv[i++] = port;

encaps = get_port_transport(port);
if (encaps > 1) argv[i++] = "-ssl";

#p = script_get_preference("Force scan all possible CGI directories");
#if ("yes" >< p) argv[i++] = "-allcgi";
p = script_get_preference("Force full (generic) scan");
if ("yes" >< p) argv[i++] = "-gener";

if (idx && idx != "X")
{
  argv[i++] = "-evasion";
  argv[i++] = ids[0];
}

if (user)
{
  if (pass)
    s = strcat(user, ':', pass);
  else
    s = user;
  argv[i++] = "-id";
  argv[i++] = s;
}

r = pread(cmd: "nikto.pl", argv: argv, cd: 1);
if (! r) exit(0);	# error

report = 'Here is the Nikto report:\n';
foreach l (split(r))
{
  display(j ++, "\n");
  l = ereg_replace(string: l, pattern: '^[ \t]+', replace: '');
  if (l[0] == '+' || l[0] == '-' || ! match(pattern: "ERROR*", string: l))
    report += l;
}

security_note(port: port, data: report);
