#TRUSTED 4be1af29c901cd55f69a2f1558f9fc688b887649c31050ca943402ba8092dc4b09a85c0fcb5e2c5993a0b6e2c93df691f6ac0ffe777b22d089e720219cf7427d0f8470de1130190c8ad5a0a5405695df17f8a42c594daa7d2711dc9706be33e9277f801d13d81e5fd1a72c80c6e12b46328967103440f168539e9910e9c0d45a5e7ddd678f1ff998c80ac603273a70a31fe10906c52e3c3f365745e8db3482aec45e4ed7b7a087cb8c750d62753cbc215d7bd7fd29aebe559274fd5c74c9429a34e8716a3d89a7449b8236e2db689a17498422e04129614ac7434d112337563880573b98aa5df8092bb3d78b6aeb394cc940bf1b568feccfc4522b2cb50a84afd2d09a5666802fa715daeddf546674493c068ee18c44ec5fb51bad77a468a76e5a2e3da1f20e6eeb8b68f8d59dc0420b2b83751552efcaec5942ef69f0bb8dccd1135bbe01d14eb4c31dd6fc3838cf52f243212303881338b3e469d03bbc6cd629ddb951e753bb8038d2a854cd353400c32536ddb21c909f57e0738c7318ca10b9ed94bb98c887def7f3f839e8174d002af32923f8a11975b0e2e8f546eb3313880305c0910d618de9397b1aa85705f94c5e9e92f29d92cf9c1a094aef0d6f9b77f68253d58a62ab60a1f98affec46a44c457ffec7b52cd8bf4906a1a48a1df79b22586f6dfb604c37148301b0ccdbdb19e41480256bb7f7f7c47c32723b0fdb
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if ( ! defined_func("script_get_preference_file_location")) exit(0);
if ( ! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15887);
 script_version ("1.2");
 name["english"] = "Hydra: Socks5";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Socks5 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Socks5 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/socks5", 1080);
 script_dependencies("hydra_options.nasl", "find_service.nes", "socks.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/socks5");
if (! port) port = 1080;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "socks5";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/socks5/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the Socks5 server:\n' + report);
