#TRUSTED 2ad060bbb88c25960598a349c44c0307163c1a7513615a1d08e228f6a992c52be29d77375f1a7fade5249bb469816baf4dfe76c6da3a54abfa06789ba2c55bfa3bd801011a1893483d8e1ed267e98bd1c265dc970c1714f2fe43fe6f7e9638d81688b37e0250f1870eb5ef3aff54e5ec4cd48cf3654503a61242694d08ab00a755a6cca0ac4cc5ebe4eeec74bf0c5c8d7835b0675fcf26ca60fe6010d607940729f045f338fff22bd4fc7645ce99bdf320ea4c96d08dab61782c065d21928596fa5727e346275a7b11e28e78a463e31ab36cbf2f75893b9a0999d1dc8fe2a2b4a61c5b4841ba986b477d647db2b29a8bb92a80175461bb9cda8e32a08a3dcc4c3c5bdff1f985b3f9ffbf8beecf39f18f3e1ef930292d6ae5a431a476f31ecd330e130baee3496c69050e60a99485b70205c111c3644b598604d4d6495da59a6d21ca4f1b9dc64b0778081072db06967d9a3ffe490d4eea5957ee465b35b6effb284d7a8fba05fdc1e402827092d4ec44477eb8947e6658d0c07164321ad2e55b4a93d95c97f199820151bb0eebea0f4bb20f46990d6bb3e073938cd7effc188fe62f3acd0e049d9cfafd2cec3b9996ef4fdcd893f10643cb9cf17c3bba59b23037cb8afad7d948625fa403353a791f89b817ebf2f6f3805a88998be7e1ded6e2cdf6956d1e3610ba7a0aaae171f47d34acaf77706c7d1691f6e559bd06b44237
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15885);
 script_version ("1.2");
 name["english"] = "Hydra: SMTP AUTH";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SMTP AUTH accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SMTP AUTH authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/smtp", 25);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "find_service_3digits.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/smtp");
if (! port) port = 25;
if (! get_port_state(port)) exit(0);
# NB: Hydra will exit if SMTP AUTH is not enabled

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "smtp-auth";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/smtp-auth/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SMTP accounts:\n' + report);
