#TRUSTED 32c060112e03090654678fb22e748a69b0cca54f877c28f26684074195eb5874a97d956e711533fb767bcd9e5e9b089f803f3a2f2b8413974c886703295a979f4d564cd6f95ce8c7d318f16b445cb097e670c44ec040c8667b059f59fe526258585828b4d4edcfd5c233d944bed00db464aea41ca1a6caa2a69666347e0fb17b362f90906b0367be1074336c40fca395bf8aa8a41871be66cdf0431137de492dc00c9ad2683764d116dd9862a75fa34e6de0410dc4ae51d61ba010c4a94ea45dcc9b02b24f5a19be56500e45b590b6cae38fca2d053269ed90be9e16c682c545b7ab1f27851b9941c6ab9ccb75b142bdd94a03e8e46a4a97f2bc0b53a358c28d467b1f908a6ea41da36e080ec1a9b1a8e43cd884e276929cde30694693e70faf28a516e6168e7e56a77c85aa851f356f2f9cbd7ae6f6777133b2c679a0064db09520ac698a5eed85fa6d614612d3c79758cb4cc7b1b00397649842420712d8237faab78a96df40c4e37a5edbc5d0498845a097c88e87f577e39314f96186a27d523220af82a453817c291d59393aeb28f8593e8c284b48b08e4ab8f787eb50abf3d917a9a8bffebbd4b94398ce2c4a2a30db83a5f29c6508c50f856717a0652ce366418bf802796ceaea37c7b82dc1e513731e27da6d9358c849895df08163c8949655b806232a9bb04edd79bcefe518069daff2ccb6842ce4c4cf6e2ae55918
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15883);
 script_version ("1.2");
 name["english"] = "Hydra: SAP R3";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SAP R3 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SAP R3 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_add_preference(name: "Client ID (between 0 and 99) : ", type: "entry", value: "");
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/sap-r3", 3299);
 script_dependencies("hydra_options.nasl", "find_service.nes", "external_svc_ident.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/sap-r3");
if (! port) port = 3299;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

id = script_get_preference("Client ID (between 0 and 99) : ");
if (! id) exit(0);
id = int(id);
if (id < 0 || id > 99) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "sapr3";
argv[i++] = id;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/sapr3/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SAP R3 accounts:\n' + report);
