# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200503-09.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(17275);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200503-09");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200503-09
(xv: Filename handling vulnerability)


    Tavis Ormandy of the Gentoo Linux Security Audit Team identified a
    flaw in the handling of image filenames by xv.
  
Impact

    Successful exploitation would require a victim to process a
    specially crafted image with a malformed filename, potentially
    resulting in the execution of arbitrary code.
  
Workaround

    There is no known workaround at this time.
  

Solution: 
    All xv users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-gfx/xv-3.10a-r10"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200503-09] xv: Filename handling vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'xv: Filename handling vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-gfx/xv", unaffected: make_list("ge 3.10a-r10"), vulnerable: make_list("lt 3.10a-r10")
)) { security_warning(0); exit(0); }
