# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200503-08.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(17274);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200503-08");
 script_cve_id("CAN-2005-0605");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200503-08
(OpenMotif, LessTif: New libXpm buffer overflows)


    Chris Gilbert discovered potentially exploitable buffer overflow
    cases in libXpm that weren\'t fixed in previous libXpm security
    advisories.
  
Impact

    A carefully-crafted XPM file could crash applications making use
    of the OpenMotif or LessTif toolkits, potentially allowing the
    execution of arbitrary code with the privileges of the user running the
    application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2005-0605


Solution: 
    All OpenMotif users should upgrade to an unaffected version:
    # emerge --sync
    # emerge --ask --oneshot --verbose x11-libs/openmotif
    All LessTif users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/lesstif-0.94.0-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200503-08] OpenMotif, LessTif: New libXpm buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenMotif, LessTif: New libXpm buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-libs/openmotif", unaffected: make_list("ge 2.2.3-r3", "rge 2.1.30-r9"), vulnerable: make_list("lt 2.2.3-r3")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "x11-libs/lesstif", unaffected: make_list("ge 0.94.0-r2"), vulnerable: make_list("lt 0.94.0-r2")
)) { security_warning(0); exit(0); }
