# This script was automatically generated from the dsa-552
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Marcus Meissner discovered a heap overflow error in imlib2, an imaging
library for X and X11 and the successor of imlib, that may be utilised
by an attacker to execute arbitrary code on the victims machine.
For the stable distribution (woody) this problem has been fixed in
version 1.0.5-2woody1.
For the unstable distribution (sid) this problem has been fixed in
version 1.1.0-12.4.
We recommend that you upgrade your imlib2 packages.


Solution : http://www.debian.org/security/2004/dsa-552
Risk factor : High';

if (description) {
 script_id(15389);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "552");
 script_cve_id("CAN-2004-0802");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2004 Michel Arboi");
 script_name(english: "[DSA552] DSA-552-1 imlib2");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-552-1 imlib2");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libimlib2', release: '3.0', reference: '1.0.5-2woody1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libimlib2 is vulnerable in Debian 3.0.\nUpgrade to libimlib2_1.0.5-2woody1\n');
}
if (deb_check(prefix: 'libimlib2-dev', release: '3.0', reference: '1.0.5-2woody1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libimlib2-dev is vulnerable in Debian 3.0.\nUpgrade to libimlib2-dev_1.0.5-2woody1\n');
}
if (deb_check(prefix: 'imlib2', release: '3.2', reference: '1.1.0-12.4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package imlib2 is vulnerable in Debian sid.\nUpgrade to imlib2_1.1.0-12.4\n');
}
if (deb_check(prefix: 'imlib2', release: '3.0', reference: '1.0.5-2woody1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package imlib2 is vulnerable in Debian woody.\nUpgrade to imlib2_1.0.5-2woody1\n');
}
if (w) { security_hole(port: 0, data: desc); }
