/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000 Mark Grimes <obecian@packetninja.net>
 *
 * nemesis-rip.c (RIP Packet Injector)
 *
 */

#include "nemesis-rip.h"

int
main(int argc, char **argv)
{
   int             opt, i;
   char           *file = NULL;
   static int      fd = -1;
   char            buff[512];
   extern char    *optarg;
   extern int      opterr;

   got_link = 0;
   got_options = 0;
   got_payload = 0;

   verbose = 0;

   if (argc < 2)
      usage(argv[0]);

   defaults();

   opterr = 0;
   while ((opt = getopt(argc, argv, "S:D:x:y:F:d:H:M:h:V:c:r:R:a:i:k:m:I:T:t:O:P:v")) != EOF) {
      switch (opt) {
      case 'v':
	 verbose = 1;
	 putchar('\n');
	 puts(TITLE " " VERSION);
	 puts(CODERS);
	 putchar('\n');
	 break;
      case 'S':
	 if (!(source = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid source IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("[IP]  %s > ", optarg);
	 break;
      case 'D':
	 if (!(dest = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("%s\n", optarg);
	 break;
      case 'F':
	 frag = atoi(optarg);
	 break;
      case 'd':
	 device = optarg;
	 got_link = 1;
	 break;
      case 'H':
	 if (got_link) {
	    sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
		   &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
		   &enet_tmp[5]);
      for (i=0; i<6; i++)
      	enet_src[i] = (u_char) enet_tmp[i];
	 }
	 break;
      case 'M':
	 if (got_link) {
	    sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
		   &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
		   &enet_tmp[5]);
      for (i=0; i<6; i++)
      	enet_dst[i] = (u_char) enet_dst[i]; 
	 }
	 break;
      case 'i':
	 if (!(addr = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid RIP IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("[RIP IP] %s\n", optarg);
	 break;
      case 'r':
	 rd = atoi(optarg);
	 break;
      case 'a':
	 af = atoi(optarg);
	 break;
      case 'R':
	 rt = atoi(optarg);
	 break;
      case 'k':
	 mask = strtoul(optarg, NULL, 0);
	 break;
      case 'h':
	 next_hop = strtoul(optarg, NULL, 0);
      case 'm':
	 metric = strtoul(optarg, NULL, 0);
      case 'x':
	 sport = atoi(optarg);
	 break;
      case 'y':
	 dport = atoi(optarg);
	 break;
      case 'I':
	 id = atoi(optarg);
	 break;
      case 'T':
	 ttl = atoi(optarg);
	 break;
      case 't':
	 tos = strtoul(optarg, NULL, 0);
	 break;
      case 'c':
	 cmd = strtoul(optarg, NULL, 0);
	 break;
      case 'V':
	 ver = strtoul(optarg, NULL, 0);
	 break;
      case 'P':
	 file = optarg;
	 got_payload = 1;
	 if ((fd = open(file, O_RDONLY)) < 0) {
	    (void) fprintf(stderr, "%s: open: ", argv[0]);
	    perror(file);
	    exit(-1);
	 }
	 break;
      case 'O':
	 got_options = 1;
	 (u_char) * options = strtoul(optarg, NULL, 0);
	 break;
      case '?':
	 usage(argv[0]);
	 break;
      }
   }
   argc -= optind;
   argv += optind;

   if (source == 0 || dest == 0) {
      printf("Source and/or Destination Address Missing.\n");
      exit(1);
   }
   if (verbose) {
      if (got_link) {
	 printf("[MAC]  ");
      if (enet_src[0] == NULL) {
        e = libnet_get_hwaddr(l2, device, errbuf);
        for (i=0; i<6; i++)
          enet_src[i] = e->ether_addr_octet[i];
        if (!e) {   
          fprintf(stderr, "cannot retrieve hardware address of %s: %s\n", device, errbuf);
          exit(1);
        }
      }
	 printf("%02X:%02X:%02X:%02X:%02X:%02X > %02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], enet_src[2], enet_src[3], enet_src[4], enet_src[5], enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3], enet_dst[4], enet_dst[5]);
      }
      printf("[Ports] %d > %d\n", sport, dport);

      printf("[RIP Command] %d\n", cmd);
      printf("[RIP Version] %d\n", ver);
      printf("[RIP Route Domain] %d\n", rd);
      printf("[RIP Address Family] %d\n", af);
      printf("[RIP Route Tag] %d\n", rt);
      printf("[RIP Network Mask] 0x%lx\n", mask);
      printf("[RIP Next Hop] %lu\n", next_hop);
      printf("[RIP Metric] %ld\n", metric);

      printf("[IP ID] %d\n", id);
      printf("[IP TTL] %d\n", ttl);
      printf("[IP TOS] 0x%x\n", tos);
      printf("[IP Frag] 0x%x\n", frag);
      printf("[IP Options] %s\n\n", options);
   }
   if (got_payload) {
      payload = buff;
      while ((nbytes = read(fd, buff, sizeof(buff))) != 0) {
	 payload_s += nbytes;
	 if (verbose) {
	    hexdump(payload, payload_s);
	    if (buildrip() != -1) {
	       if (verbose)
		  printf("\nRIP Packet Injected\n");
	    } else {
	       if (verbose)
		  printf("\nRIP Injection Failure\n");
	    }
	 }
      }
      close(fd);
      exit(0);
   }
   if (buildrip() != -1) {
      if (verbose)
	 printf("\nRIP Packet Injected\n");
   } else {
      if (verbose)
	 printf("\nRIP Injection Failure\n");
   }
   close(fd);
   exit(0);
}

void 
hexdump(char *buf, int len)
{
   int             i, j, ptr, pad = PADDING, counter;
   ptr = 0;
   counter = 0;
   for (i = 0; i < len; i++) {
      counter++;
      printf("%02X ", (u_char) buf[i]);
      if ((i == (len - 1)) && (counter < pad))
	 while (counter++ < pad)
	    printf("   ");
      if (((i + 1) % pad == 0) || (i == (len - 1))) {
	 counter = 0;
	 for (j = ptr; j <= i; j++) {
	    if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
	       printf("%c", buf[j]);
	    } else {
	       putchar('.');
	    }
	 }
	 ptr = i + 1;
	 putchar('\n');
      }
   }
   putchar('\n');
}

void
usage(char *arg)
{
   putchar('\n');
   puts(TITLE " " VERSION);
   puts(CODERS);
   putchar('\n');

   printf("RIP usage:\n  %s [-v] [options]\n\n", arg);
   printf("RIP options: \n"
	  "  -c <RIP Command>\n"
	  "  -V <RIP Version>\n"
	  "  -r <RIP Route Domain>\n"
	  "  -a <RIP Address Family>\n"
	  "  -R <RIP Route Tag>\n"
	  "  -k <RIP Network Address Mask>\n"
	  "  -h <RIP Next Hop>\n"
	  "  -m <RIP metric>\n"
	  "  -P <Payload File (Binary or ASCII)>\n"
	  "  (-v VERBOSE - packet struct to stdout)\n\n");
   printf("UDP options:\n"
	  "  [-x <Source Port>]\n"
	  "  [-y <Destination Port>]\n\n");
   printf("IP options: \n"
	  "  -S <Source IP Address>\n"
	  "  -D <Destination IP Address>\n"
	  "  -I <IP ID>\n"
	  "  -T <IP TTL>\n"
	  "  -t <IP tos>\n"
	  "  -F <IP frag>\n"
	  "  -o <IP Options>\n\n");
   printf("Data Link Options: \n"
	  "  -d <Ethernet Device>\n"
	  "  -H <Source MAC Address>\n"
	  "  -M <Destination MAC Address>\n\n");
   printf("You must define a Source, Destination and Protocol Options.\n");
   exit(1);
}

void
defaults()
{
   enet_src[0] = 0x02;
   enet_src[1] = 0x0f;
   enet_src[2] = 0x0a;
   enet_src[3] = 0x0d;
   enet_src[4] = 0x0e;
   enet_src[5] = 0x0d;

   enet_dst[0] = 0x0d;
   enet_dst[1] = 0x0e;
   enet_dst[2] = 0x0a;
   enet_dst[3] = 0x0d;
   enet_dst[4] = 0x00;
   enet_dst[5] = 0x01;

   rd = 0;
   rt = 0;
   af = 2;
   mask = 0x00000000;
   next_hop = 0;
   metric = 1;
   sport = 520;
   dport = 520;
   id = 0;
   tos = IPTOS_LOWDELAY | IPTOS_THROUGHPUT;
   ttl = 254;
   payload = NULL;
   payload_s = 0;
   *options = NULL;
   option_s = 0;
   frag = IP_DF;
}
