/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000 Mark Grimes <obecian@packetninja.net>
 *
 * nemesis-ospf.c (OSPF Packet Injector)
 *
 */

#include "nemesis-ospf.h"

int
main(int argc, char **argv)
{
   int             opt, i;
   char           *file = NULL;
   static int      fd = -1;
   char            buff[512];
   extern char    *optarg;
   extern int      opterr;

   got_link = 0;
   got_options = 0;
   got_payload = 0;

   if (argc < 2)
      usage(argv[0]);

   defaults();

   opterr = 0;
   while ((opt = getopt(argc, argv, "S:D:r:s:d:F:H:M:L:R:A:f:g:G:N:n:i:l:o:O:P:m:x:B:y:k:I:T:t:z:u:p:v")) != EOF) {
      switch (opt) {
      case 'v':
	 verbose = 1;
	 putchar('\n');
	 puts(TITLE " " VERSION);
	 puts(CODERS);
	 putchar('\n');
	 break;
      case 'S':
	 if (!(source = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid source IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("[IP]  %s > ", optarg);
	 break;
      case 'D':
	 if (!(dest = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("%s\n", optarg);
	 break;
      case 'p':
	 switch (*optarg) {
	 case 'H':
	    ospftype = 0;
	    break;
	 case 'D':
	    ospftype = 1;
	    break;
	 case 'L':
	    ospftype = 2;
	    break;
	 case 'U':
	    ospftype = 3;
	    break;
	 case 'R':
	    ospftype = 4;
	    break;
	 case 'N':
	    ospftype = 5;
	    break;
	 case 'M':
	    ospftype = 6;
	    break;
	 case 'A':
	    ospftype = 7;
	    break;
	 }
      case 'F':
	 frag = atoi(optarg);
	 break;
      case 'd':
	 got_link = 1;
	 device = optarg;
	 break;
      case 'H':
	 if (got_link) {
	    sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
		   &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
		   &enet_tmp[5]);
      for (i=0; i<6; i++)
      	enet_src[i] = (u_char) enet_tmp[i];
	 }
	 break;
      case 'M':
	 if (got_link) {
	    sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
		   &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
		   &enet_tmp[5]);
      for (i=0; i<6; i++)
      	enet_dst[i] = (u_char) enet_dst[i]; 
	 }
	 break;
      case 'L':
	 rtrid = atoi(optarg);
	 break;
      case 'u':
	 num = atoi(optarg);
	 break;
      case 'z':
	 mtusize = atoi(optarg);
	 break;
      case 'm':
	 metric = atoi(optarg);
	 break;
      case 'x':
	 exchange = strtoul(optarg, NULL, 0);
	 break;
      case 'B':
	 bcastnum = atoi(optarg);
	 break;
      case 'y':
	 rtrtype = strtoul(optarg, NULL, 0);
	 break;
      case 'k':
	 rtrdata = atoi(optarg);
	 break;
      case 's':
	 seqnum = atoi(optarg);
	 break;
      case 'I':
	 id = atoi(optarg);
	 break;
      case 'T':
	 ttl = atoi(optarg);
	 break;
      case 't':
	 tos = strtoul(optarg, NULL, 0);
	 break;
      case 'n':
	 mask = strtoul(optarg, NULL, 0);
	 break;
      case 'P':
	 file = optarg;
	 got_payload = 1;
	 if ((fd = open(file, O_RDONLY)) < 0) {
	    (void) fprintf(stderr, "%s: open: ", argv[0]);
	    perror(file);
	    exit(-1);
	 }
	 break;
      case 'O':
	 ooptions = strtoul(optarg, NULL, 0);
	 break;
      case 'o':
	 (u_char) * options = strtoul(optarg, NULL, 0);
	 break;
      case 'l':
	 interval = atoi(optarg);
	 break;
      case 'f':
	 as_fwd = strtoul(optarg, NULL, 0);
	 break;
      case 'r':
	 if (!(router = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid advertising router address: %s\n", optarg);
	    exit(1);
	 }
	 if (verbose)
	    printf("[Advertising Router IP] %s\n", optarg);
	 break;
      case 'N':
	 if (!(neighbor = libnet_name_resolve(optarg, 0))) {
	    fprintf(stderr, "Invalid neighbor address: %s\n", optarg);
	    exit(1);
	 }
	 break;
      case 'i':
	 dead_int = atoi(optarg);
	 break;
      case 'R':
	 addrid = strtoul(optarg, NULL, 0);
	 break;
      case 'A':
	 addaid = strtoul(optarg, NULL, 0);
	 break;
      case 'g':
	 as_tag = atoi(optarg);
	 break;
      case 'G':
	 ospf_age = atoi(optarg);
	 break;
      case '?':
	 usage(argv[0]);
	 break;
      }
   }
   argc -= optind;
   argv += optind;

   if (source == 0 || dest == 0) {
      printf("Source and/or Destination Address Missing.\n");
      exit(1);
   }
   if (ospftype == -1) {
      printf("OSPF Packet type not supplied.\n");
      exit(1);
   }
   if (verbose) {
      if (got_link) {
	 printf("[MAC]  ");
      if (enet_src[0] == NULL) {
        e = libnet_get_hwaddr(l2, device, errbuf);
        for (i=0; i<6; i++)
          enet_src[i] = e->ether_addr_octet[i];
        if (!e) {   
          fprintf(stderr, "cannot retrieve hardware address of %s: %s\n", device, errbuf);
          exit(1);
        }
      }
	 printf("%02X:%02X:%02X:%02X:%02X:%02X > %02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], enet_src[2], enet_src[3], enet_src[4], enet_src[5], enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3], enet_dst[4], enet_dst[5]);
      }
      printf("[OSPF Options] 0x%x\n", ooptions);
      printf("[Priority] %d\n", priority);
      printf("[Advertising Router ID] 0x%ld\n", addrid);
      printf("[Advertising Area ID] 0x%ld\n", addaid);

      if (ospftype == 1) {
	 printf("[Dead router interval] %d\n", dead_int);
      } else if (ospftype == 2) {
	 printf("[Netmask] %ld\n", mask);
	 printf("[Sequence Number] %d\n", seqnum);
	 printf("[Router Advertisement Age] %d\n", ospf_age);
	 printf("[Link State ID] %d\n", rtrid);
      } else if (ospftype == 3) {
	 printf("[Link State ID]	%d\n", rtrid);
      }
      printf("[IP ID] %d\n", id);
      printf("[IP TTL] %d\n", ttl);
      printf("[IP TOS] 0x%x\n", tos);
      printf("[IP Frag] 0x%x\n", frag);
      printf("[IP Options] %s\n", options);
   }
   if (got_payload) {
      payload = buff;
      while ((nbytes = read(fd, buff, sizeof(buff))) != 0) {
	 payload_s += nbytes;
	 if (verbose) {
	    hexdump(payload, payload_s);
	    if (buildospf() != -1) {
	       if (verbose)
		  printf("\nOSPF Packet Injected\n");
	    } else {
	       if (verbose)
		  printf("\nOSPF Injection Failure\n");
	    }
	 }
      }
      close(fd);
      exit(0);
   }
   if (buildospf() != -1) {
      if (verbose)
	 printf("\nUDP Packet Injected\n");
   } else {
      if (verbose)
	 printf("\nUDP Injection Failure\n");
   }
   close(fd);
   exit(0);
}

void 
hexdump(char *buf, int len)
{
   int             i, j, ptr, pad = PADDING, counter;
   ptr = 0;
   counter = 0;
   for (i = 0; i < len; i++) {
      counter++;
      printf("%02X ", (u_char) buf[i]);
      if ((i == (len - 1)) && (counter < pad))
	 while (counter++ < pad)
	    printf("   ");
      if (((i + 1) % pad == 0) || (i == (len - 1))) {
	 counter = 0;
	 for (j = ptr; j <= i; j++) {
	    if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
	       printf("%c", buf[j]);
	    } else {
	       putchar('.');
	    }
	 }
	 ptr = i + 1;
	 putchar('\n');
      }
   }
   putchar('\n');
}

void
usage(char *arg)
{
   putchar('\n');
   puts(TITLE " " VERSION);
   puts(CODERS);
   putchar('\n');

   printf("OSPF usage:\n  %s [-v] [optlist]\n\n", arg);
   printf("OSPF Packet Types: \n"
	  "  -p <OSPF Protocol>\n"
	  "     -pH HELLO, -pD DBD, -pL LSR, -pU LSU, -pR LSA (router),\n"
	  "     -pN LSA (network), -pM LSA (summary), -pA LSA (AS)\n");
   printf("OSPF HELLO options: \n"
	  "  -N <Neighbor Router Address>\n"
	  "  -i <Dead Router Interval>\n"
	  "  -l <OSPF Interval>\n");
   printf("OSPF DBD options: \n"
	  "  -z <MAX DGRAM Length>\n"
	  "  -x <Exchange Type>\n");
   printf("OSPF LSU options: \n"
	  "  -B <num of LSAs to bcast>\n");
   printf("OSPF LSA related options: \n"
	  "  -L <router id>\n"
	  "  -G <LSA age>\n");
   printf("OSPF LSA_RTR options: \n"
	  "  -u <LSA_RTR num>\n"
	  "  -y <LSA_RTR router type>\n"
	  "  -k <LSA_RTR router data>\n");
   printf("OSPF LSA_AS_EXT options: \n"
	  "  -f <LSA_AS_EXT forward address>\n"
	  "  -g <LSA_AS_EXT tag>\n");
   printf("OSPF options: \n"
	  "  -m <OSPF Metric>\n"
	  "  -s <Sequence Number>\n"
	  "  -r <Advertising Router Address>\n"
	  "  -n <OSPF Netmask>\n"
	  "  -O <OSPF Options>\n"
	  "  -R <OSPF Router id>\n"
	  "  -A <OSPF Area id>\n"
	  "  -P <Payload File (Binary or ASCII)>\n"
	  "  (-v VERBOSE - packet struct to stdout)\n\n");
   printf("IP Options\n"
	  "  -S <Source Address>\n"
	  "  -D <Destination Address>\n"
	  "  -I <IP ID>\n"
	  "  -T <IP TTL>\n"
	  "  -t <IP/OSPF tos>\n"
	  "  -F <IP frag>\n"
	  "  -o <IP Options>\n\n");
   printf("Data Link Options: \n"
	  "  -d <Ethernet Device>\n"
	  "  -H <Source MAC Address>\n"
	  "  -M <Destination MAC Address>\n\n");
   printf("You must define a Source, Destination, Protocol & its dependent"
	  " options.\n\n");
   exit(1);
}

void
defaults()
{
   enet_src[0] = 0x02;
   enet_src[1] = 0x0f;
   enet_src[2] = 0x0a;
   enet_src[3] = 0x0d;
   enet_src[4] = 0x0e;
   enet_src[5] = 0x0d;

   enet_dst[0] = 0x0d;
   enet_dst[1] = 0x0e;
   enet_dst[2] = 0x0a;
   enet_dst[3] = 0x0d;
   enet_dst[4] = 0x00;
   enet_dst[5] = 0x01;


   id = 0;
   tos = IPTOS_LOWDELAY | IPTOS_THROUGHPUT;
   ttl = 254;
   mask = 0xffffff00;
   addrid = 0xff00ff00;
   addaid = 0xd00dd00d;
   rtrid = 42;
   ospf_age = 40;
   ooptions = 0x00;
   priority = 0x00;
   dead_int = 30;
   payload = NULL;
   payload_s = 0;
   *options = NULL;
   option_s = 0;
   interval = 2;
   seqnum = 420;
   frag = IP_DF;
   ospftype = -1;
}
