/*
 * THE NEMESIS PROJECT (c) obecian 1999, 2000
 *
 * nemesis-icmp.c (ICMP Packet Injector)
 *
 */

#include "nemesis-icmp.h"

int
main(int argc, char **argv)
{
	int             opt;
	static int		fd = -1;
	char           *file = NULL;
	char            buff[512];
	extern char    *optarg;
	extern int      opterr;

	got_link = 0;
	got_options = 0;
	got_payload = 0;

	if (argc < 2)
		usage(argv[0]);

	if (geteuid() != 0) {
		printf("user '%s' does not have an euid of 0\n", getlogin());
		exit(1);
	}
	defaults();

	opterr = 0;
	while ((opt = getopt(argc, argv, "S:D:H:M:F:d:I:T:O:t:s:i:c:m:C:G:P:v")) != EOF) {
		switch (opt) {
        case 'v':
            verbose = 1;
            putchar('\n');
            puts(TITLE " " VERSION);
            puts(CODERS);
            putchar('\n');
            break;
		case 'S':
			if (!(source = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid source IP address: %s\n", optarg);
				exit(1);
			}
			if (verbose)
				printf("[IP]  %s > ", optarg);
			break;
		case 'D':
			if (!(dest = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
				exit(1);
			}
			if (verbose)
				printf("%s\n", optarg);
			break;
		case 'F':
			frag = atoi(optarg);
			break;
		case 'd':
			device = optarg;
			got_link = 1;
			break;
		case 'H':
			if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
					&enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
					&enet_tmp[5]);
                enet_src[0] = (u_char) enet_tmp[0];
                enet_src[1] = (u_char) enet_tmp[1];
                enet_src[2] = (u_char) enet_tmp[2];
                enet_src[3] = (u_char) enet_tmp[3];
                enet_src[4] = (u_char) enet_tmp[4];
                enet_src[5] = (u_char) enet_tmp[5];
            }
			break;
		case 'M':
			if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
					&enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
					&enet_tmp[5]);
                enet_dst[0] = (u_char) enet_tmp[0];
                enet_dst[1] = (u_char) enet_tmp[1];
                enet_dst[2] = (u_char) enet_tmp[2];
                enet_dst[3] = (u_char) enet_tmp[3];
                enet_dst[4] = (u_char) enet_tmp[4];
                enet_dst[5] = (u_char) enet_tmp[5];
            }
			break;
		case 'I':
			id = atoi(optarg);
			break;
		case 'T':
			ttl = atoi(optarg);
			break;
		case 't':
			tos = strtoul(optarg, NULL, 0);
			break;
		case 'C':
			switch (*optarg) {
			case 'o':
				otime = atoi(optarg);
				break;
			case 'r':
				rtime = atoi(optarg);
				break;
			case 't':
				ttime = atoi(optarg);
				break;
			}
			break;
		case 'G':
			if (!(gwy = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid gateway IP address: %s\n", optarg);
				exit(1);
			}
			if (verbose)
				printf("Preferred Gateway %s\n", optarg);
			break;
		case 's':
			seq = atoi(optarg);
			break;
		case 'i':
			type = atoi(optarg);
			break;
		case 'c':
			code = atoi(optarg);
			break;
		case 'm':
			mask = strtoul(optarg, NULL, 0);
			break;
    case 'P':
      file = optarg;
      got_payload = 1;
      if ((fd = open(file, O_RDONLY)) < 0) {
        (void) fprintf(stderr, "%s: open: ", argv[0]);
        perror(file);
        exit(-1);
      }
      break;
		case 'O':
			got_options = 1;
			(u_char) * options = strtoul(optarg, NULL, 0);
			break;
		case '?':
			usage(argv[0]);
			break;
		}
	}
    argc -= optind;
    argv += optind;

    if (source == 0 || dest == 0) {
        printf("Source and/or Destination Address Missing.\n");
        exit(1);
    }

	if (verbose) {
		if (got_link)
		{
			printf("[MAC] ");
			printf("%02X:%02X:%02X:%02X:%02X:%02X > %02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], enet_src[2], enet_src[3], enet_src[4], enet_src[5], enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3], enet_dst[4], enet_dst[5]); 
		}

    	switch (type) {
    		case 0:
           		printf("[Type] ECHO REPLY\n");
        	break;
    		case 3:
        	printf("[Type] DESTINATION UNREACHABLE\n");
        	switch (code) {
        		case 0:
              printf("[Code] NETWORK UNREACHABLE\n");
            break;
        		case 1:
        			printf("[Code] HOST UNREACHABLE\n");
        		break;
        		case 2:
              printf("[Code] PROTOCOL UNREACHABLE\n");
            break;
						case 3:
              printf("[Code] PORT UNREACHABLE\n");
						break;
						case 4:
							printf("[Code] FRAGMENTATION NEEDED\n");
						break;
						case 5:
							printf("[Code] SOURCE ROUTE FAILED\n");
						break;
						case 6:
							printf("[Code] DESTINATION NETWORK UNKNOWN\n");
						break;
						case 7:
							printf("[Code] DESTINATION HOST UNKNOWN\n");
						break;
						case 8:
							printf("[Code] SOURCE HOST ISOLATED (obsolete)\n");
						break;
						case 9:
							printf("[Code] DESTINATION NETWORK ADMINISTRATIVELY PROHIBITED\n");
						break;
						case 10:
							printf("[Code] DESTINATION HOST ADMINISTRATIVELY PROHIBITED\n");
						break;
						case 11:
							printf("[Code] NETWORK UNREACHABLE FOR TOS\n");
						break;
						case 12:
							printf("[Code] HOST UNREACHABLE FOR TOS\n");
						break;
						case 13:	/* useful for firewall discovery */
							printf("[Code] COMMUNICATION ADMINISTRATIVELY PROHIBITED BY FILTERING\n");
						break;
						case 14:
							printf("[Code] HOST PRECEDENCE VIOLATION\n");
						break;
						case 15:
							printf("[Code] PRECEDENCE CUTOFF IN EFFECT\n");
						break;
					}
				break;
				case 4:
					printf("[Type] SOURCE QUENCH\n");
				break;
				case 5:
					printf("[Type] REDIRECT\n");
					switch (code) {
						case 0:
							printf("[Code] REDIRECT FOR NETWORK\n");
						break;
						case 1:
							printf("[Code] REDIRECT FOR HOST\n");
						break;
						case 2:
							printf("[Code] REDIRECT FOR TOS AND NETWORK\n");
						break;
						case 3:
							printf("[Code] REDIRECT FOR TOS AND HOST\n");
						break;
					}
				break;
			case 8:
				printf("[Type] ECHO REQUEST\n");
			break;
			case 9:
				printf("[Type] ROUTER ADVERTISEMENT\n");
			break;
			case 10:
				printf("[Type] ROUTER SOLICITATION\n");
			break;
			case 11:
				printf("[Type] TIME EXCEEDED\n");
				switch (code) {
					case 0:
						printf("[Code] TTL = 0 DURING TRANSMIT\n");
					break;
					case 1:
						printf("[Code] TTL = 0 DURING REASSEMBLY\n");
					break;
				}
			break;
			case 12:
				printf("[Type] PARAMETER PROBLEM\n");
				switch (code) {
					case 0:
						printf("[Code] IP HEADER BAD (catchall error)\n");
					break;
					case 1:
						printf("[Code] REQUIRED OPTION MISSING\n");
					break;
				}
			break;
			case 13:
				printf("[Type] TIMESTAMP REQUEST\n");
			break;
			case 14:
				printf("[Type] TIMESTAMP REPLY\n");
			break;
			case 15:
				printf("[Type] INFORMATION REQUEST\n");
			break;
			case 16:
				printf("[Type] INFORMATION REPLY\n");
			break;
			case 17:
				printf("[Type] ADDRESS MASK REQUEST\n");
			break;
			case 18:
				printf("[Type] ADDRESS MASK REPLY\n");
			break;
		}

		printf("[Sequence number] %ld\n", seq);
		if ((type == ICMP_MASKREQ) || (type == ICMP_MASKREPLY))
			printf("Mask: 0x%lx\n", mask);

		printf("[IP ID] %d\n", id);
		printf("[IP TTL] %d\n", ttl);
		printf("[IP TOS] 0x%x\n", tos);
    	printf("[IP Frag] 0x%x\n\n", frag);
	}

    if (got_payload)
    {
        payload = buff;
        while ((nbytes = read(fd, buff, sizeof(buff))) != 0)
        {
					payload_s += nbytes;
          if (verbose)
          {
            hexdump(payload, payload_s);
            if (buildicmp() != -1)
            {
                if (verbose)
                    printf("\nICMP Packet Injected\n");
            }       
            else    
            {
                if (verbose)
                    printf("\nICMP Injection Failure\n");
            }       
          } 
        } 
    close(fd);
    exit(0);  
  } 
    
    if (buildicmp() != -1)
    {
      if (verbose)
        printf("\nICMP Packet Injected\n");
    }       
    else    
    {
      if (verbose)
        printf("\nICMP Injection Failure\n");
    }       
  close(fd);
    exit(0);
}   

void hexdump(char *buf, int len)
{
  int i,j,ptr,pad=PADDING,counter;
  ptr=0; counter=0;
  for (i=0; i<len; i++) {
    counter++;
    printf("%02X ", (u_char)buf[i]);
    if ((i==(len-1)) && (counter < pad))
      while (counter++ < pad)
        printf("   "); 
    if (((i+1)%pad==0) || (i==(len-1))) {
      counter=0;
      for (j=ptr; j<=i; j++) {
        if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
          printf("%c", buf[j]);
        } 
        else {
          putchar('.');
        } 
      } 
      ptr = i+1;
      putchar('\n');
    } 
  } 
  putchar('\n');
} 


void
usage(char *arg)
{
    putchar('\n');
    puts(TITLE " " VERSION);
    puts(CODERS);
    putchar('\n');
    
	printf("ICMP Usage:\n  %s [-v] [options]\n\n", arg);
	printf("ICMP options: \n"
	       "  -i <ICMP Type>\n"
	       "  -c <ICMP Code>\n"
	       "  -s <Sequence Number>\n"
	       "  -m <ICMP Mask>\n"
	       "  -G <Preferred Gateway>\n"
	       "  -Co <Time of Originating request>\n"
	       "  -Cr <Time request was Received>\n"
	       "  -Ct <Time reply was Transmitted>\n"
	       "  -P <Payload File (Binary or ASCII)>\n"
	       "  (-v VERBOSE - packet struct to stdout)\n\n");
	printf("IP options: \n"
	       "  -S <Source IP Address>\n"
	       "  -D <Destination IP Address>\n"
	       "  -I <IP ID>\n"
	       "  -T <IP TTL>\n"
	       "  -t <IP tos>\n"
		   "  -F <IP Frag>\n"
	       "  -O <IP Options>\n\n");
	printf("Data Link Options: \n"
	       "  -d <Ethernet Device>\n"
	       "  -H <Source MAC Address>\n"
	       "  -M <Destination MAC Address>\n\n");

	printf("You must define a Source, Destination, Protocol & its dependent"
	       " options.\n");
	exit(1);
}

void
defaults()
{
	id = 0;
	tos = IPTOS_LOWDELAY | IPTOS_THROUGHPUT;
	ttl = 254;
	seq = 0;
	type = 8;
	code = 0;
	mask = 0xffffff00;
	payload = NULL;
	payload_s = 0;
	*options = NULL;
	option_s = 0;
	frag = IP_DF;
}
