/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000 Mark Grimes <obecian@packetninja.net>
 *
 * nemesis-arp.c (ARP Packet Injector)
 *
 */

#include "nemesis-arp.h"

int
main(int argc, char **argv)
{
	static int		fd = -1;
	int             opt;
	char           *file = NULL;
	char            buff[512];
	extern char    *optarg;
	extern int      opterr;

	got_link = 0;
	got_payload = 0;

	verbose = 0;

	if (argc < 2)
		usage(argv[0]);

	if (geteuid() != 0) {
		printf("user '%s' does not have an euid of 0\n", getlogin());
		exit(-1);
	}
	defaults();

	opterr = 0;
	while ((opt = getopt(argc, argv, "S:D:H:M:d:P:vT")) != EOF) {
		switch (opt) {
		case 'v':
			verbose = 1;
			putchar('\n');
			puts(TITLE " " VERSION);
			puts(CODERS);
			putchar('\n');
			break;
        case 'd':
            device = optarg;
            got_link = 1;
            break; 
        case 'T':
            arptype = 1;
            break;
		case 'S':
			if (!(source = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid source IP address: %s\n", optarg);
				exit(-1);
			}
			if (verbose)
			{
				if (arptype)
					printf("ARP REPLY\n\n");
				else
					printf("ARP REQUEST\n\n");
				printf("[IP]  %s > ", optarg);
			}
			break;
		case 'D':
			if (!(dest = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
				exit(-1);
			}
			if (verbose)
				printf("%s\n", optarg);
			break;
        case 'H':
            if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
                    &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
                    &enet_tmp[5]);
                enet_src[0] = (u_char) enet_tmp[0];
                enet_src[1] = (u_char) enet_tmp[1];
                enet_src[2] = (u_char) enet_tmp[2];
                enet_src[3] = (u_char) enet_tmp[3];
                enet_src[4] = (u_char) enet_tmp[4];
                enet_src[5] = (u_char) enet_tmp[5];
            }
            break;
        case 'M':
            if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
                    &enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
                    &enet_tmp[5]);
                enet_dst[0] = (u_char) enet_tmp[0];
                enet_dst[1] = (u_char) enet_tmp[1];
                enet_dst[2] = (u_char) enet_tmp[2];
                enet_dst[3] = (u_char) enet_tmp[3];
                enet_dst[4] = (u_char) enet_tmp[4];
                enet_dst[5] = (u_char) enet_tmp[5];
            }   
            break;
        case 'P':
            file = optarg;
            got_payload = 1;
            if ((fd = open(file, O_RDONLY)) < 0) {
                (void) fprintf(stderr, "%s: open: ", argv[0]);
                perror(file);
                exit(-1);
            }
            break;
		case '?':
			usage(argv[0]);
			break;
		}
	}
	argc -= optind;
	argv += optind;

    if (source == 0 || dest == 0) {
        printf("Source and/or Destination Address Missing.\n");
        exit(1);
    }

	if (verbose) {
		if (got_link) {
			printf("[MAC] ");
			printf("%02X:%02X:%02X:%02X:%02X:%02X > %02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], enet_src[2], enet_src[3], enet_src[4], enet_src[5], enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3], enet_dst[4], enet_dst[5]);
		}
	}

    if (got_payload)
    {
        payload = buff;
        while ((nbytes = read(fd, buff, sizeof(buff))) != 0)
        {
					payload_s += nbytes;
          if (verbose)
          {
            hexdump(payload, payload_s);
            if (buildarp() != -1)
            {
                if (verbose)
                    printf("\nARP Packet Injected\n");
            }
            else    
            {       
                if (verbose)
                    printf("\nARP Injection Failure\n");
            }
          }     
        }           
    close(fd);      
    exit(0);
  }     
        
    if (buildarp() != -1)
    {
      if (verbose)
        printf("\nARP Packet Injected\n");
    }
    else    
    {   
      if (verbose)
        printf("\nARP Injection Failure\n");
    }
  close(fd);
    exit(0);
}   

void hexdump(char *buf, int len)
{
  int i,j,ptr,pad=PADDING,counter;
  ptr=0; counter=0;
  for (i=0; i<len; i++) {
    counter++;
    printf("%02X ", (u_char)buf[i]);
    if ((i==(len-1)) && (counter < pad))
      while (counter++ < pad)
        printf("   ");
    if (((i+1)%pad==0) || (i==(len-1))) {
      counter=0;
      for (j=ptr; j<=i; j++) {
        if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
          printf("%c", buf[j]);
        }
        else {
          putchar('.');
        }
      }
      ptr = i+1;
      putchar('\n');
    }
  }
  putchar('\n');
}


void
usage(char *arg)
{
    putchar('\n');
    puts(TITLE " " VERSION);
    puts(CODERS);
    putchar('\n');
    
	printf("ARP Usage:\n  %s [-v (verbose)] [optlist]\n\n", arg);
	printf("ARP Options: \n"
	       "  -S <Source IP Address>\n"
	       "  -D <Destination IP Address>\n"
		   "  -T (Enable ARP REPLY packet)\n"
	       "  -P <Payload File>\n\n");
	printf("Data Link Options: \n"
	       "  -d <Ethernet Device>\n"
	       "  -H <Source MAC Address>\n"
	       "  -M <Destination MAC Address>\n\n");
	printf("You must define a Source, Destination, Protocol Options\n");
	exit(-1);
}

void
defaults()
{
	arptype = 0; /* arp request */

	enet_src[0] = 0x22;
	enet_src[1] = 0xff;
	enet_src[2] = 0xaa;
	enet_src[3] = 0xdd;
	enet_src[4] = 0xee;
	enet_src[5] = 0xdd;

	enet_dst[0] = 0xff;
	enet_dst[1] = 0xff;
	enet_dst[2] = 0xff;
	enet_dst[3] = 0xff;
	enet_dst[4] = 0xff;
	enet_dst[5] = 0xff;

	payload = NULL;
	payload_s = 0;
}
