/*
 * $Id: nemesis-dns.c,v 1.2 2000/06/24 18:45:02 obecian Exp $
 *
 * THE NEMESIS PROJECT (c) obecian 1999, 2000
 *
 * nemesis-dns.c (DNS Packet Injector)
 *
 */

#include "nemesis-dns.h"

int
main(int argc, char **argv)
{
	int             opt;
	static int		fd = -1;
	char           *file = NULL;
	char            buff[512];
	extern char    *optarg;
	extern int      opterr;

	got_link = 0;
	got_options = 0;
	got_payload = 0;

	verbose = 0;
	state = 0;

	if (argc < 2)
		usage(argv[0]);

	if (geteuid() != 0) {
        printf("root permissions required\n");
		exit(1);
	}
	defaults();

	opterr = 0;
	while ((opt = getopt(argc, argv, "S:D:x:y:s:d:u:H:f:M:q:w:W:A:i:I:T:t:O:P:vk")) != EOF) {
		switch (opt) {
        case 'v':
            verbose = 1;
            putchar('\n');
            puts(TITLE " " VERSION);
            puts(CODERS);
            putchar('\n');
            break;
		case 'k':
			state = 1;
			break;
		case 'S':
			if (!(source = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid source IP address: %s\n", optarg);
				exit(1);
			}
			if (verbose)
				printf("[IP]  %s > ", optarg);
			break;
		case 'D':
			if (!(dest = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
				exit(1);
			}
			if (verbose)
				printf("%s\n", optarg);
			break;
		case 'x':
			sport = atoi(optarg);
			break;
		case 'y':
			dport = atoi(optarg);
			break;
		case 'd':
			got_link = 1;
			device = optarg;
			break;
		case 'H':
			if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
					&enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
					&enet_tmp[5]);
                enet_src[0] = (u_char) enet_tmp[0];
                enet_src[1] = (u_char) enet_tmp[1];
                enet_src[2] = (u_char) enet_tmp[2];
                enet_src[3] = (u_char) enet_tmp[3];
                enet_src[4] = (u_char) enet_tmp[4];
                enet_src[5] = (u_char) enet_tmp[5];
            }
			break;
		case 'M':
			if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
					&enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
					&enet_tmp[5]);
                enet_dst[0] = (u_char) enet_tmp[0];
                enet_dst[1] = (u_char) enet_tmp[1];
                enet_dst[2] = (u_char) enet_tmp[2];
                enet_dst[3] = (u_char) enet_tmp[3];
                enet_dst[4] = (u_char) enet_tmp[4];
                enet_dst[5] = (u_char) enet_tmp[5];
            }   
			break;
		case 'f':
			switch (*optarg) {
			case 'S':
				fl_opt |= SYN;
				flags |= TH_SYN;
				break;
			case 'A':
				fl_opt |= ACK;
				flags |= TH_ACK;
				break;
			case 'R':
				fl_opt |= RST;
				flags |= TH_RST;
				break;
			case 'P':
				fl_opt |= PSH;
				flags |= TH_PUSH;
				break;
			case 'U':
				fl_opt |= URG;
				flags |= TH_URG;
				break;
			case 'F':
				fl_opt |= FIN;
				flags |= TH_FIN;
				break;
			}
			break;
		case 'w':
			win = atoi(optarg);
			break;
		case 's':
			seq = atoi(optarg);
			break;
		case 'a':
			ack = atoi(optarg);
			break;
		case 'q':
			num_q = atoi(optarg);
			break;
		case 'W':
			num_anws_rr = atoi(optarg);
			break;
		case 'A':
			num_auth_rr = atoi(optarg);
			break;
		case 'i':
			num_addi_rr = atoi(optarg);
			break;
		case 'I':
			id = atoi(optarg);
			break;
		case 'T':
			ttl = atoi(optarg);
			break;
		case 't':
			tos = strtoul(optarg, NULL, 0);
			break;
    case 'P':
      file = optarg;
      got_payload = 1;
      if ((fd = open(file, O_RDONLY)) < 0) {
      	(void) fprintf(stderr, "%s: open: ", argv[0]);
        perror(file);
        exit(-1);
      }
    	break;
		case 'O':
			got_options = 1;
			(u_char) * options = strtoul(optarg, NULL, 0);
			break;
		case '?':
			usage(argv[0]);
			break;
		}
	}
    argc -= optind;
    argv += optind;

	if (source == 0 || dest == 0) {
		printf("Source and/or Destination Address Missing.\n");
		exit(1);
	}

	if (verbose) {
        if (got_link) {
            printf("[MAC]  ");
            printf("%02X:%02X:%02X:%02X:%02X:%02X >
				%02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], 
                enet_src[2], enet_src[3], enet_src[4], enet_src[5],
				enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3],
				enet_dst[4], enet_dst[5]);
        }
		printf("[Ports] %d > %d\n", sport, dport);
		printf("\n[# Questions] %d\n", num_q);
		printf("[# Answer RRs] %d\n", num_anws_rr);
		printf("[# Authority RRs] %d\n", num_auth_rr);
		printf("[# Additional RRs] %d\n\n", num_addi_rr);

		if (state) {
			printf("[Flags]  ");
			if (fl_opt & SYN)
				printf("SYN ");
			if (fl_opt & ACK)
				printf("ACK ");
			if (fl_opt & RST)
				printf("RST ");
			if (fl_opt & PSH)
				printf("PSH ");
			if (fl_opt & URG)
				printf("URG ");
			if (fl_opt & FIN)
				printf("FIN ");
			printf("\n[TCP Urgent Pointer] %d\n", urgp);
			printf("[Window Size] %d\n", win);
			if (fl_opt & ACK)
				printf("[ACK number] %ld\n", ack);
			if (fl_opt & SYN)
				printf("[Sequence number] %ld\n", seq);
		}

		printf("\n[IP ID] %d\n", id);
		printf("[IP TTL] %d\n", ttl);
		printf("[IP TOS] 0x%x\n", tos);
        printf("[IP Frag] 0x%x\n", frag);
		printf("[IP Options] %s\n\n", options);
	}

    if (got_payload)
    {
        payload = buff;
        while ((nbytes = read(fd, buff, sizeof(buff))) != 0)
        {
					payload_s += nbytes;
          if (verbose)
          {
            hexdump(payload, payload_s);
            if (builddns() != -1)
            {
                if (verbose)
                    printf("\nDNS Packet Injected\n");
            }       
            else    
            {
                if (verbose)
                    printf("\nDNS Injection Failure\n");
            }       
          } 
        } 
    close(fd);
    exit(0);  
  } 
    
    if (builddns() != -1)
    {
      if (verbose)
        printf("\nDNS Packet Injected\n");
    }       
    else    
    {
      if (verbose)
        printf("\nDNS Injection Failure\n");
    }       
  close(fd);
    exit(0);
}   

void hexdump(char *buf, int len)
{
  int i,j,ptr,pad=PADDING,counter;
  ptr=0; counter=0;
  for (i=0; i<len; i++) {
    counter++;
    printf("%02X ", (u_char)buf[i]);
    if ((i==(len-1)) && (counter < pad))
      while (counter++ < pad)
        printf("   "); 
    if (((i+1)%pad==0) || (i==(len-1))) {
      counter=0;
      for (j=ptr; j<=i; j++) {
        if ((buf[j] > 0x20) && (buf[j] < 0x7f)) {
          printf("%c", buf[j]);
        } 
        else {
          putchar('.');
        } 
      } 
      ptr = i+1;
      putchar('\n');
    } 
  } 
  putchar('\n');
} 


void
usage(char *arg)
{
    putchar('\n');
    puts(TITLE " " VERSION);
    puts(CODERS);
    putchar('\n');
    
	printf("DNS usage:\n  %s [-v] [options]\n\n", arg);
	printf("DNS options: \n"
	       "  -q <# of Questions>\n"
	       "  -W <# of Answer RRs>\n"
	       "  -A <# of Authority RRs>\n"
	       "  -i <# of Additional RRs>\n"
	       "  -P <Payload File>\n"
	       "  -k (Enable TCP transport)\n"
	       "  (-v VERBOSE - packet struct to stdout)\n\n");
	printf("TCP options (-k): \n"
	       "  [-x <Source Port>]\n"
	       "  [-y <Destination Port>]\n"
	       "  -f <TCP Flag Options>\n"
	       "     -fS SYN, -fA ACK, -fR RST, -fP PSH, -fF FIN, -fU URG\n"
	       "  -w <Window Size>\n"
	       "  -s <SEQ Number>\n"
	       "  -a <ACK Number>\n"
	       "  -u <TCP Urgent Pointer>\n");
	printf("UDP options (no -k): \n"
	       "  [-x <Source Port>]\n"
	       "  [-y <Destination Port>]\n\n");
	printf("IP options: \n"
	       "  -S <Source IP Address>\n"
	       "  -D <Destination IP Address>\n"
	       "  -I <IP ID>\n"
	       "  -T <IP TTL>\n"
	       "  -t <IP tos>\n"
		   "  -F <IP frag>\n"
	       "  -O <IP Options>\n\n");
	printf("Data Link Options: \n"
	       "  -d <Ethernet Device>\n"
	       "  -H <Source MAC Address>\n"
	       "  -M <Destination MAC Address>\n\n");
	printf("You must define a Source, Destination and Protocol Options.\n");
	exit(1);
}

void
defaults()
{
	enet_src[0] = 0x02;
	enet_src[1] = 0x0f;
	enet_src[2] = 0x0a;
	enet_src[3] = 0x0d;
	enet_src[4] = 0x0e;
	enet_src[5] = 0x0d;

	enet_dst[0] = 0x0d;
	enet_dst[1] = 0x0e;
	enet_dst[2] = 0x0a;
	enet_dst[3] = 0x0d;
	enet_dst[4] = 0x00;
	enet_dst[5] = 0x01;

	fl_opt = 0;
	urgp = 2048;
	seq = 420;
	ack = 420;
	win = 512;

	sport = 42069;
	dport = 53;
	id = 420;
	tos = IPTOS_LOWDELAY | IPTOS_THROUGHPUT;
	ttl = 254;
	payload = NULL;
	payload_s = 0;
	*options = NULL;
	option_s = 0;
	frag = IP_DF;
}
