#include <libnecpp.h>
#include <stdio.h>

/*
	Enter the following file into test_nec.c, and compile with
	gcc -o test_nec test_nec.c -L . -lnecpp -lm -lstdc++
*/
#include <libnecpp.h>

int main(int argc, char **argv)
{
	/* 	GW 0 9 0. 0. 2. 0. 0. 7 .1
		GE 1
		FR 0 1 0 30.
		EX 0 5 0 1.
		GN 1
		RP 0 90 1 0000 0 90 1 0 */
	
	nec_context* nec;	
	nec = nec_create();
	
	nec_wire(nec, 0, 9, 0, 0, 2, 0, 0, 7, 0.1, 1, 1);
	nec_geometry_complete(nec, 1, 0);
	nec_gn_card(nec, 1, 0, 0, 0, 0, 0, 0, 0);
	nec_fr_card(nec, 0, 1, 30, 0);
	nec_ex_card(nec, 0, 0, 5, 0, 1.0, 0, 0, 0, 0, 0);
	nec_rp_card(nec, 0, 90, 1, 0500, 0, 90, 1, 0, 0, 0);
	
	printf("Gain: %f dB\n",nec_get_maximum_gain(nec));
	
	nec_delete(nec);
	return 0;
}
